/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.SinglePathClassProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Array;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class JMXClassLoader
extends ClassLoader
implements ClassProviderListener {
    private static TraceComponent tc = Tr.register(JMXClassLoader.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static Hashtable classes = new Hashtable();
    private SinglePathClassProvider spcp = null;
    private ClassLoader parentLdr;

    public JMXClassLoader(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMXClassLoader(String)");
        }
        this.spcp = new SinglePathClassProvider(string);
        if (!this.spcp.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tmx4jTransform.jar not found in path " + string);
            }
            Tr.warning(tc, "Could not find tmx4jTransform.jar in " + string + " - Interoperability to older versions of WebSphere is disabled. Verify that was.install.root is set as a system property.");
            FFDCFilter.processException((Throwable)new FileNotFoundException("Could not find tmx4jTransform.jar in " + string + ". Verify that was.install.root is set as a system property."), "com.ibm.ws.management.connector.interop.JMXTransform", "1", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMXClassLoader(String)");
        }
    }

    public JMXClassLoader(String string, ClassLoader classLoader) {
        super(classLoader);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMXClassLoader(String, ClassLoader)");
        }
        this.parentLdr = classLoader;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parent class loader = " + classLoader);
        }
        this.spcp = new SinglePathClassProvider(string);
        if (!this.spcp.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tmx4jTransform.jar not found in path " + string);
            }
            Tr.warning(tc, "Could not find tmx4jTransform.jar in " + string + " - Interoperability to older versions of WebSphere is disabled");
            FFDCFilter.processException((Throwable)new FileNotFoundException("Could not find tmx4jTransform.jar in " + string), "com.ibm.ws.management.connector.interop.JMXTransform", "1", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMXClassLoader(String, ClassLoader)");
        }
    }

    public void classLoadedFromFile(File file) {
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadOldJMXClass(string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Tr.debug(tc, "JMXClassLoader.findClass, failed thus far to load the class " + string);
            Tr.debug(tc, "JMXClassLoader.findClass, parent class loader is " + this.parentLdr);
            Tr.debug(tc, "JMXClassLoader.findClass, current thread context class loader is " + classLoader);
            classLoader = this.getClass().getClassLoader();
            Tr.debug(tc, "JMXClassLoader.findClass, JMXClassLoader's class loader is " + classLoader);
        }
        return this.findOldJMXClass(string);
    }

    public Class loadOldJMXClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadOldJMXClass " + string);
        }
        if ((clazz = (Class<?>)classes.get(string)) == null) {
            if (string.startsWith("[L")) {
                string = string.substring(2, string.length() - 1);
                clazz = this.loadJMXClass(string);
                Object object = Array.newInstance(clazz, 0);
                clazz = object.getClass();
            } else {
                clazz = this.loadJMXClass(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadOldJMXClass " + clazz);
        }
        return clazz;
    }

    public Class loadJMXClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadJMXClass " + string);
        }
        if ((clazz = (Class<?>)classes.get(string)) == null) {
            byte[] byArray = this.spcp.getClassBytes(string, this);
            if (byArray == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading class " + string + " using ClassLoader delegation");
                }
                final JMXClassLoader jMXClassLoader = this;
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return jMXClassLoader.getParent();
                    }
                });
                try {
                    Tr.debug(tc, "Loading class via " + classLoader);
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExtClassLoader extClassLoader = ExtClassLoader.getInstance();
                    Tr.debug(tc, "CNF  - use current classloader " + extClassLoader);
                    clazz = extClassLoader.loadClass(string);
                }
            } else {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                classes.put(string, clazz);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class " + string + " is loaded with JMXClassLoader ");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJMXClass(" + string + ") " + clazz);
        }
        return clazz;
    }

    public Class findOldJMXClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOldJMXClass " + string);
        }
        if ((clazz = (Class<?>)classes.get(string)) == null) {
            byte[] byArray = this.spcp.getClassBytes(string, this);
            if (byArray == null) {
                final JMXClassLoader jMXClassLoader = this;
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return jMXClassLoader.getParent();
                    }
                });
                try {
                    Tr.debug(tc, "Loading class via " + classLoader);
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExtClassLoader extClassLoader = ExtClassLoader.getInstance();
                    Tr.debug(tc, "CNF  - use current classloader " + extClassLoader);
                    clazz = extClassLoader.loadClass(string);
                }
            } else {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                classes.put(string, clazz);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOldJMXClass " + clazz);
        }
        return clazz;
    }
}

