/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class EARFileAccessor
extends FileAccessor {
    private EARFile earFile;
    private String configLocationURI = null;
    private static final char URI_SEPERATOR = '/';
    private static TraceComponent tc = Tr.register(EARFileAccessor.class, "EARFileAccessor", "com.ibm.ws.management.resources.bundle");

    public EARFileAccessor(EARFile eARFile) {
        this.earFile = eARFile;
        this.configLocationURI = "META-INF/ibmconfig";
        this.configLocationURI = this.configLocationURI.replace(File.separatorChar, '/');
    }

    public File getRootDir() {
        return null;
    }

    public void create(String string, InputStream inputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (" + string + " " + inputStream + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        throw new IOException("create method is not supported");
    }

    public void delete(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (" + string + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete");
        }
        throw new IOException("delete method is not supported");
    }

    public InputStream load(String string) throws IOException {
        String string2 = this.configLocationURI + '/' + string;
        InputStream inputStream = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load (" + string2 + ")");
        }
        inputStream = this.earFile.getInputStream(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
        return inputStream;
    }

    public void save(String string, InputStream inputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save (" + string + " " + inputStream + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
        throw new IOException("save method is not supported");
    }

    public List listFolders(String string) throws IOException {
        String string2 = this.configLocationURI + '/' + string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFolders (" + string2 + ")");
        }
        List<String> list = new ArrayList();
        String string3 = string2;
        EList eList = this.earFile.getFiles();
        if (eList != null) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File[] fileArray = (org.eclipse.jst.j2ee.commonarchivecore.internal.File[])eList.toArray();
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                int n2;
                String string4;
                int n3;
                if (!fileArray[i].getDirectoryURI().startsWith(string2) || (n3 = (string4 = fileArray[i].getURI()).indexOf(n2 = 47, n = string2.length() + 1)) == -1 || list.contains(string4 = string4.substring(0, n3))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding folder = ", string4);
                }
                list.add(string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFolders");
        }
        list = this.adjustPaths(list);
        return list;
    }

    public List listFiles(String string) throws IOException {
        String string2 = this.configLocationURI + '/' + string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + string2 + ")");
        }
        List<String> list = new ArrayList();
        String string3 = string2;
        EList eList = this.earFile.getFiles();
        if (eList != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent = ", string2);
            }
            org.eclipse.jst.j2ee.commonarchivecore.internal.File[] fileArray = (org.eclipse.jst.j2ee.commonarchivecore.internal.File[])eList.toArray();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectoryEntry() || !fileArray[i].getDirectoryURI().equals(string2)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding file = ", fileArray[i].getURI());
                }
                list.add(fileArray[i].getURI());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles");
        }
        list = this.adjustPaths(list);
        return list;
    }

    public boolean exists(String string) throws IOException {
        String string2 = this.configLocationURI + '/' + string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists (" + string2 + ")");
        }
        boolean bl = this.checkExists(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists " + bl);
        }
        return bl;
    }

    public OutputStream getOutputStream(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (" + string + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream");
        }
        throw new IOException("getOutputStream() is not supported");
    }

    public void makeDir(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDir (" + string + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDir");
        }
    }

    private List adjustPaths(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string = string.substring(this.configLocationURI.length() + 1);
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean checkExists(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkExists (" + string + ")");
        }
        ArrayList arrayList = new ArrayList();
        EList eList = this.earFile.getFiles();
        if (eList != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent = ", string);
            }
            org.eclipse.jst.j2ee.commonarchivecore.internal.File[] fileArray = (org.eclipse.jst.j2ee.commonarchivecore.internal.File[])eList.toArray();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getURI().startsWith(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found file = ", fileArray[i].getURI());
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkExists");
        }
        return false;
    }
}

