/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.process.ServiceContext;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateClusterScheduler;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class UpdateClusterTask
extends AbstractTask
implements NotificationListener {
    private static TraceComponent tc = Tr.register(UpdateClusterTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static int SERVER_STOPPED = 1;
    private static int SERVER_FAILED_TO_STOP = 2;
    private static int SERVER_NOT_STARTED = 3;
    private String waitObject = null;
    private String waitTarget = null;
    private static final long WAIT_TIME = 600000L;
    private String waitResult = null;
    private boolean waitStarting = false;
    private int launchTimeout;
    private Map autoSyncMap = new HashMap();

    public UpdateClusterTask() {
        this.waitObject = new String("UpdateClusterTaskWaitObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask() throws AdminException {
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean bl = true;
        try {
            try {
                Object object;
                RepositoryContext repositoryContext;
                Vector vector = this.getTargetServers(((UpdateClusterScheduler)this.scheduler).getAppNames());
                if (vector.size() <= 0) {
                    bl = false;
                    this.sendNotification("ADMA8021I", "InProgress", this.scheduler.getAppName());
                    throw new AdminException("Target server for a given list of applications is not found");
                }
                Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(this.scheduler.getWorkSpace(), vector);
                Enumeration enumeration = hashtable.keys();
                Set set = hashtable.keySet();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    repositoryContext = (RepositoryContext)iterator2.next();
                    object = this.getAutoSyncEnabled(repositoryContext.getName());
                    if (object != null && Boolean.TRUE.equals(object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Disabling Sync for Node: " + repositoryContext.getName());
                        }
                        this.setAutoSyncEnabled(repositoryContext.getName(), Boolean.FALSE);
                    }
                    this.autoSyncMap.put(repositoryContext.getName(), object);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performing cluster update" + hashtable);
                }
                while (enumeration.hasMoreElements()) {
                    String string;
                    int n;
                    repositoryContext = (RepositoryContext)enumeration.nextElement();
                    object = repositoryContext.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node Name: " + (String)object);
                    }
                    Hashtable hashtable2 = this.getServerTypes(repositoryContext);
                    boolean bl2 = this.zosPauseResume(repositoryContext);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "For node " + (String)object + ", zosPauseNodes = " + bl2);
                    }
                    Vector vector2 = (Vector)hashtable.get(repositoryContext);
                    boolean bl3 = false;
                    Vector vector3 = new Vector(vector2);
                    for (n = 0; n < vector2.size(); ++n) {
                        block49: {
                            block51: {
                                int n2;
                                block50: {
                                    String string2;
                                    string = ((RepositoryContext)vector2.elementAt(n)).getName();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "stopping " + string);
                                    }
                                    if ((string2 = (String)hashtable2.get(string)) == null || !string2.equals("APPLICATION_SERVER")) break block49;
                                    this.setClusterMemberEnabled((RepositoryContext)vector2.elementAt(n), repositoryContext, Boolean.FALSE);
                                    if (!bl2) break block50;
                                    n2 = this.pauseServer((RepositoryContext)vector2.elementAt(n), repositoryContext.getName(), string);
                                    if (n2 == SERVER_STOPPED || n2 == SERVER_NOT_STARTED) {
                                        bl3 = true;
                                        if (n2 == SERVER_NOT_STARTED) {
                                            vector3.remove(vector2.elementAt(n));
                                        }
                                        break block51;
                                    } else {
                                        bl3 = false;
                                        vector3.remove(vector2.elementAt(n));
                                    }
                                    break block51;
                                }
                                n2 = this.stopServer(repositoryContext.getName(), string);
                                if (n2 == SERVER_STOPPED || n2 == SERVER_NOT_STARTED) {
                                    bl3 = true;
                                    if (n2 == SERVER_NOT_STARTED) {
                                        vector3.remove(vector2.elementAt(n));
                                    }
                                } else {
                                    bl3 = false;
                                    vector3.remove(vector2.elementAt(n));
                                }
                            }
                            if (bl3) continue;
                            break;
                        }
                        Tr.audit(tc, "Server " + string + " is not an Application Server. This server will not be restarted during application ripple of application" + this.scheduler.getAppName() + ".");
                        vector3.remove(vector2.elementAt(n));
                    }
                    if (!bl3) continue;
                    if (bl2) {
                        Thread.sleep(10000L);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "syncing  " + repositoryContext.getName());
                    }
                    this.sendNotification("ADMA8005I", "NodeSyncInitiated", repositoryContext.getName());
                    if (this.synchNode(repositoryContext.getName())) {
                        this.sendNotification("ADMA8006I", "NodeSyncComplete", repositoryContext.getName());
                    } else {
                        this.sendNotification("ADMA8011I", "NodeSyncFailed", repositoryContext.getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "synced  " + repositoryContext.getName());
                    }
                    this.establishLaunchTimeout();
                    for (n = 0; n < vector3.size(); ++n) {
                        string = ((RepositoryContext)vector3.elementAt(n)).getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "starting " + string);
                        }
                        if (bl2) {
                            this.sendNotification("ADMA8024I", "ServerStarting", string);
                            if (this.resumeServer((RepositoryContext)vector3.elementAt(n), repositoryContext.getName(), string)) {
                                this.sendNotification("ADMA8025I", "ServerStarted", string);
                                this.setClusterMemberEnabled((RepositoryContext)vector3.elementAt(n), repositoryContext, Boolean.TRUE);
                                continue;
                            }
                            bl = false;
                            this.sendNotification("ADMA8027I", "ServerStartFailed", string);
                            continue;
                        }
                        this.sendNotification("ADMA8007I", "ServerStarting", string);
                        if (this.startServer(repositoryContext.getName(), string)) {
                            this.sendNotification("ADMA8008I", "ServerStarted", string);
                            if (!this.applicationsStarted(repositoryContext.getName(), string)) {
                                this.sendNotification("ADMA8020I", "InProgress", string);
                            }
                            this.setClusterMemberEnabled((RepositoryContext)vector3.elementAt(n), repositoryContext, Boolean.TRUE);
                            continue;
                        }
                        bl = false;
                        this.sendNotification("ADMA8010I", "ServerStartFailed", string);
                    }
                    n = 60;
                    try {
                        string = System.getProperty("com.ibm.ws.management.application.clusterupdate.nodedelay");
                        if (string != null) {
                            n = Integer.parseInt(string);
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " invalid delay specified, using default delay of 60 secs");
                        }
                        n = 60;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "waiting for " + new Integer(n) + " secs before rippling the next node");
                    }
                    if (n > 0) {
                        Thread.sleep(n * 1000);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "done wait. Started ripple of next node");
                }
                Object var19_21 = null;
                Set set2 = this.autoSyncMap.entrySet();
                iterator = set2.iterator();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster Update of cluster failed for applicaiton " + this.scheduler.getAppName());
                }
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8014I", new String[]{this.scheduler.getAppName()}));
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
                boolean bl6 = bl = false;
                Object var19_22 = null;
                Set set = this.autoSyncMap.entrySet();
                Iterator iterator4 = set.iterator();
                while (true) {
                    Boolean bl7;
                    if (!iterator4.hasNext()) {
                        return bl6;
                    }
                    Map.Entry entry = iterator4.next();
                    if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl7 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl7)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Re-enabling Sync for Node: " + (String)entry.getKey());
                    }
                    this.setAutoSyncEnabled((String)entry.getKey(), bl7);
                }
            }
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            Set set = this.autoSyncMap.entrySet();
            Iterator iterator3 = set.iterator();
            while (true) {
                Boolean bl4;
                if (!iterator3.hasNext()) {
                    throw throwable;
                }
                Map.Entry entry = iterator3.next();
                if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl4 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl4)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Re-enabling Sync for Node: " + (String)entry.getKey());
                }
                this.setAutoSyncEnabled((String)entry.getKey(), bl4);
            }
        }
        while (iterator.hasNext()) {
            Boolean bl5;
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl5 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl5)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Re-enabling Sync for Node: " + (String)entry.getKey());
            }
            this.setAutoSyncEnabled((String)entry.getKey(), bl5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClusterMemberEnabled(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterMemberEnabled", new Object[]{repositoryContext, repositoryContext2, bl});
        }
        URI uRI = URI.createURI("server.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        Server server = (Server)resource.getContents().get(0);
        String string = server.getClusterName();
        String string2 = repositoryContext.getName();
        String string3 = repositoryContext2.getName();
        ObjectName objectName = this.getClusterObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "ClusterMbean", new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string4 = this.waitObject;
                synchronized (string4) {
                    if (Boolean.TRUE.equals(bl)) {
                        AdminServiceFactory.getAdminService().invoke(objectName, "setAvailable", new Object[]{string2, string3}, new String[]{"java.lang.String", "java.lang.String"});
                    } else {
                        AdminServiceFactory.getAdminService().invoke(objectName, "setUnavailable", new Object[]{string2, string3}, new String[]{"java.lang.String", "java.lang.String"});
                    }
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterMemberEnabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getAutoSyncEnabled(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoSyncEnabled", new Object[]{string});
        }
        Boolean bl = null;
        ObjectName objectName = this.getNodesyncObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "NodeSyncMbean", new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string2 = this.waitObject;
                synchronized (string2) {
                    bl = (Boolean)AdminServiceFactory.getAdminService().invoke(objectName, "getAutoSyncEnabled", new Object[0], new String[0]);
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean setAutoSyncEnabled(String string, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoSyncEnabled", new Object[]{string, bl});
        }
        Boolean bl2 = null;
        ObjectName objectName = this.getNodesyncObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "NodeSyncMbean", new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string2 = this.waitObject;
                synchronized (string2) {
                    AdminServiceFactory.getAdminService().invoke(objectName, "setAutoSyncEnabled", new Object[]{bl}, new String[]{Boolean.class.getName()});
                }
                bl2 = Boolean.TRUE;
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
                bl2 = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", new Object[]{bl});
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopServer(String string, String string2) {
        int n = SERVER_STOPPED;
        ObjectName objectName = this.getNodeagentObjectName(string);
        try {
            ObjectName objectName2 = this.getServerObjectName(string, string2);
            if (objectName2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " appears to be stopped");
                }
                int n2 = SERVER_NOT_STARTED;
                return n2;
            }
            this.sendNotification("ADMA8003I", "ServerStopping", string2);
            String string3 = "UpdateCluster:" + string + ":" + string2;
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("websphere.process.stopped");
            notificationFilterSupport.enableType("websphere.process.failed");
            notificationFilterSupport.enableType("websphere.process.starting");
            notificationFilterSupport.enableType("websphere.process.stopping");
            notificationFilterSupport.enableType("websphere.process.running");
            AdminServiceFactory.getAdminService().addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, (Object)string3);
            String string4 = this.waitObject;
            synchronized (string4) {
                AdminServiceFactory.getAdminService().invoke(objectName2, "stop", new Object[0], new String[0]);
                this.waitTarget = string2;
                this.waitObject.wait(600000L);
                if (this.waitTarget != null) {
                    Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{string2}));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "timed out waiting for server to stop ", new String[]{string2});
                    }
                    n = SERVER_FAILED_TO_STOP;
                }
            }
        }
        catch (Exception exception) {
            Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{string2}));
            n = SERVER_FAILED_TO_STOP;
        }
        finally {
            block25: {
                try {
                    if (objectName != null) {
                        AdminServiceFactory.getAdminService().removeNotificationListener(objectName, this);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block25;
                    Tr.debug(tc, "Failed to remove notification listener");
                }
            }
        }
        Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8004I", new String[]{string2}));
        if (n == SERVER_STOPPED) {
            this.sendNotification("ADMA8004I", "ServerStopped", string2);
        } else {
            this.sendNotification("ADMA8009I", "ServerStopFailed", string2);
        }
        return n;
    }

    private int pauseServer(RepositoryContext repositoryContext, String string, String string2) {
        int n = SERVER_FAILED_TO_STOP;
        URI uRI = URI.createURI("server.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        Server server = (Server)resource.getContents().get(0);
        String string3 = "MODIFY " + server.getShortName() + ",PAUSELISTENERS";
        ObjectName objectName = this.getMVSServericesObjectName(string);
        if (objectName != null) {
            this.sendNotification("ADMA8022I", "ServerStopping", string2);
            try {
                AdminServiceFactory.getAdminService().invoke(objectName, "issueCommand", new Object[]{string3}, new String[]{String.class.getName()});
                n = SERVER_STOPPED;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pauseServer() successfull for node:server " + string + ":" + string2);
                }
                this.sendNotification("ADMA8023I", "ServerStopped", string2);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pauseServer() Exception invoking MVSServices MBean ");
                    exception.printStackTrace();
                    this.sendNotification("ADMA8026I", "ServerStopFailed", string2);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pauseServer() could not find MVSServices MBean ");
            }
            n = SERVER_NOT_STARTED;
        }
        return n;
    }

    private boolean resumeServer(RepositoryContext repositoryContext, String string, String string2) {
        boolean bl;
        block6: {
            bl = false;
            URI uRI = URI.createURI("server.xml");
            Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
            Server server = (Server)resource.getContents().get(0);
            String string3 = "MODIFY " + server.getShortName() + ",RESUMELISTENERS";
            ObjectName objectName = this.getMVSServericesObjectName(string);
            if (objectName != null) {
                try {
                    AdminServiceFactory.getAdminService().invoke(objectName, "issueCommand", new Object[]{string3}, new String[]{String.class.getName()});
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resumeServer() successfull for node:server " + string + ":" + string2);
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resumeServer() Exception invoking MVSServices MBean ");
                        exception.printStackTrace();
                    }
                    break block6;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resumeServer() could not find MVSServices MBean ");
            }
        }
        return bl;
    }

    private boolean zosPauseResume(RepositoryContext repositoryContext) {
        boolean bl;
        block21: {
            Object object;
            Object object2;
            Iterator iterator;
            Object object3;
            Collection collection;
            Object object4;
            ServiceContext serviceContext;
            block20: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "zosPauseResume");
                }
                bl = false;
                serviceContext = null;
                try {
                    object4 = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
                    collection = repositoryContext.findContext((RepositoryContextType)object4);
                    object3 = collection.iterator();
                    while (object3.hasNext()) {
                        iterator = (RepositoryContext)object3.next();
                        object2 = iterator.getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found Repository Context for " + (String)object2);
                        }
                        if (object2 == null || !((String)object2).equalsIgnoreCase("nodeagent")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "NodeAgent Server Repository Context found");
                        }
                        object = iterator.getResourceSet();
                        Resource resource = null;
                        Object var11_13 = null;
                        String string = "server.xml";
                        try {
                            if (!iterator.isExtracted(string)) {
                                iterator.extract(string, false);
                            }
                            resource = object.createResource(URI.createURI(string));
                            resource.load(new HashMap());
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Exception loading NodeAgent server.xml");
                            exception.printStackTrace();
                            continue;
                        }
                        EList eList = resource.getContents();
                        Iterator iterator2 = eList.iterator();
                        while (iterator2.hasNext()) {
                            Object e = iterator2.next();
                            if (!(e instanceof Server)) continue;
                            serviceContext = (Server)e;
                            break;
                        }
                        if (serviceContext == null) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "Exception finding NodeAgent Server object");
                    exception.printStackTrace();
                }
            }
            if (serviceContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to find NodeAgent server.xml");
                }
            } else {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Server object in the NodeAgent server.xml file");
                    }
                    object4 = null;
                    collection = null;
                    object3 = serviceContext.getServices();
                    iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        object4 = (Service)iterator.next();
                        if (!(object4 instanceof AdminService)) continue;
                        collection = object4.getProperties();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Found AdminService properties " + collection);
                        break;
                    }
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        object2 = (Property)iterator.next();
                        object = object2.getName();
                        if (!"com.ibm.websphere.zos.rollout.pauseresume".equals(object) || !"true".equalsIgnoreCase(object2.getValue())) continue;
                        bl = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pause/Resume enabled");
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Exception finding Pause/Resume property");
                    exception.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zosPauseResume");
        }
        return bl;
    }

    private ObjectName getMVSServericesObjectName(String string) {
        try {
            String string2 = "WebSphere:type=MVSServices,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting MVSServices object");
                exception.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startServer(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "UpdateClusterTask.startServer node: " + string + " Server: " + string2);
        }
        ObjectName objectName = this.getNodeagentObjectName(string);
        com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("websphere.process.running");
        notificationFilterSupport.enableType("websphere.process.failed");
        notificationFilterSupport.enableType("websphere.process.starting");
        String string3 = "UpdateCluster:" + string + ":" + string2;
        try {
            this.waitResult = null;
            this.waitTarget = string2;
            this.waitStarting = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startServer adds listener & launches thread... " + string3);
            }
            adminService.addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, (Object)string3);
            LaunchThread launchThread = new LaunchThread(string, string2, this.launchTimeout);
            launchThread.setDaemon(true);
            launchThread.start();
        }
        catch (Exception exception) {
            block33: {
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8010I", new String[]{string2}));
                try {
                    if (objectName != null) {
                        adminService.removeNotificationListener(objectName, this);
                    }
                }
                catch (Exception exception2) {
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug(tc, "Failed to remove notification listener");
                }
            }
            return false;
        }
        boolean bl = false;
        try {
            String string4 = this.waitObject;
            synchronized (string4) {
                if (!this.waitStarting) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wait for STARTING status first....");
                    }
                    this.waitObject.wait();
                }
                if (this.waitResult == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for server to complete START: ", new String[]{string2});
                    }
                    this.waitObject.wait(this.launchTimeout * 1000);
                    if (this.waitTarget != null) {
                        this.waitResult = "LaunchProcess timeout occurred.";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "timed out waiting for server to start ", new String[]{string2});
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while launchThread was waiting" + exception);
            }
            this.waitResult = "Exception occurred while launchThread was waiting.";
            exception.printStackTrace();
        }
        finally {
            block35: {
                try {
                    if (objectName != null) {
                        adminService.removeNotificationListener(objectName, this);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block35;
                    Tr.debug(tc, "Failed to remove notification listener");
                }
            }
        }
        if (this.waitResult != null) {
            if (this.waitResult.equals("websphere.process.running")) {
                bl = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess result: " + this.waitResult);
            }
        }
        if (bl) {
            Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8008I", new String[]{string2}));
        }
        return bl;
    }

    private boolean applicationsStarted(String string, String string2) {
        if (this.scheduler instanceof UpdateClusterScheduler) {
            String[] stringArray = ((UpdateClusterScheduler)this.scheduler).getAppNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.appStarted(string, string2, stringArray[i])) continue;
                return false;
            }
            return true;
        }
        return this.appStarted(string, string2, this.scheduler.getAppName());
    }

    private boolean appStarted(String string, String string2, String string3) {
        String string4 = "WebSphere:type=Application,node=" + string + ",process=" + string2 + ",name=" + string3 + ",*";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appStarted: query = " + string4);
        }
        try {
            ObjectName objectName = new ObjectName(string4);
            int n = 120000;
            for (int i = 10000; i <= n; i += 10000) {
                if (AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator().hasNext()) {
                    return true;
                }
                Thread.sleep(i);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.task.UpdateClusterTask.appStarted", "402", this);
        }
        return false;
    }

    private boolean synchNode(String string) {
        try {
            ObjectName objectName = this.getNodesyncObjectName(string);
            AdminServiceFactory.getAdminService().invoke(objectName, "sync", null, null);
        }
        catch (Exception exception) {
            Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8011I", new String[]{string}));
            return false;
        }
        Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8006I", new String[]{string, this.scheduler.getAppName()}));
        return true;
    }

    private ObjectName getServerObjectName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerObjectName", new Object[]{string, string2});
        }
        String string3 = "WebSphere:type=Server,node=" + string + ",process=" + string2 + ",*";
        try {
            ObjectName objectName = new ObjectName(string3);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerObjectName: return null");
                }
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerObjectName", new Object[]{objectName2});
            }
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerObjectName: return null");
            }
            return null;
        }
    }

    private ObjectName getNodeagentObjectName(String string) {
        try {
            String string2 = "WebSphere:type=NodeAgent,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            return null;
        }
    }

    private ObjectName getClusterObjectName(String string) {
        try {
            String string2 = "WebSphere:type=Cluster,name=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            return null;
        }
    }

    private ObjectName getNodesyncObjectName(String string) {
        try {
            String string2 = "WebSphere:type=NodeSync,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            return null;
        }
    }

    private void sendNotification(String string, String string2, String string3) {
        AppNotification appNotification = this.createNotification(string2, string, new String[]{string3, this.scheduler.getAppName()});
        this.scheduler.propagateTaskEvent(appNotification);
    }

    private Vector getTargetServers(String[] stringArray) throws Exception {
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (repositoryContext == null) continue;
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector2 = new Vector();
            Vector vector3 = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, vector2, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), true);
            if (vector2.size() != 0) {
                this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA8016I", new Object[]{vector2}));
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8016I", new Object[]{vector2}));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target servers are " + vector3);
            }
            for (int j = 0; j < vector3.size(); ++j) {
                if (vector.contains(vector3.get(j))) continue;
                vector.add(vector3.get(j));
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification" + notification + " " + object);
        }
        Properties properties = null;
        if (notification == null) {
            return;
        }
        String string = notification.getType();
        Object object2 = notification.getUserData();
        if ((string.equals("websphere.process.stopped") || string.equals("websphere.process.failed") || string.equals("websphere.process.running") || string.equals("websphere.process.starting")) && object2 != null) {
            properties = (Properties)object2;
            String string2 = properties.getProperty("processName");
            String string3 = this.waitObject;
            synchronized (string3) {
                if (string2.equals(this.waitTarget)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got notification " + string);
                    }
                    if (string.equals("websphere.process.starting")) {
                        this.waitStarting = true;
                    } else {
                        this.waitTarget = null;
                        this.waitResult = string;
                    }
                    this.waitObject.notifyAll();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private Hashtable getServerTypes(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypes");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        URI uRI = URI.createURI("serverindex.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string = serverEntry.getServerName();
            String string2 = serverEntry.getServerType();
            hashtable.put(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTypes");
        }
        return hashtable;
    }

    private void establishLaunchTimeout() {
        Integer n = UpdateClusterScheduler.DEFAULT_LAUNCH_TIMEOUT;
        Object v = this.scheduler.getProperties().get("LAUNCH_TIMEOUT");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "time", v);
        }
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        this.launchTimeout = n;
    }

    private class LaunchThread
    extends Thread {
        String launchNode;
        String launchServer;
        int timeout;

        public LaunchThread(String string, String string2, int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "LaunchThread");
            }
            this.launchNode = string;
            this.launchServer = string2;
            this.timeout = n;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LaunchThread");
            }
        }

        public void run() {
            block6: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                Object object = null;
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    object = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            LaunchThread.this.invokeUpdateCluster();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception invoking launchProcess" + exception);
                    }
                    exception.printStackTrace();
                    return;
                }
                catch (Exception exception) {
                    Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Exception invoking launchProcess" + exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }

        private void invokeUpdateCluster() {
            com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = UpdateClusterTask.this.getNodeagentObjectName(this.launchNode);
            ObjectName objectName2 = UpdateClusterTask.this.getServerObjectName(this.launchNode, this.launchServer);
            Object var4_4 = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initiating launch for " + this.launchNode + "/" + this.launchServer);
                }
                AdminServiceFactory.getAdminService().invoke(objectName, "launchProcess", new Object[]{this.launchServer, new Integer(this.timeout)}, new String[]{"java.lang.String", "java.lang.Integer"});
            }
            catch (Exception exception) {
                Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception invoking launchProcess" + exception);
                }
                return;
            }
        }
    }
}

