/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class MetadataTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(MetadataTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String METADATA_PATTERN = "META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*";
    public static final String THISDIR_PATTERN = "/[^/]*";
    public static final String WHOLEDIR_PATTERN = "/.*";
    public static final String DelModules = "MetadataTask.deletedMods";
    public static final String AddedModules = "MetadataTask.addedMods";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        Archive archive = null;
        try {
            Object object;
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (this.scheduler instanceof InstallScheduler) {
                object = MetadataTask.saveEarConfigDocs(repositoryContext.getPath(), ((InstallScheduler)this.scheduler).getEarFile(false, true), this.getResourceBundle());
                repositoryContext.notifyChanged(0, (List)object);
            } else if (this.scheduler instanceof UpdateScheduler) {
                archive = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, this.scheduler.getWorkSpace(), this.getResourceBundle(), true);
                this.updateDeploymentFromPartialEar(repositoryContext, (EARFile)archive);
                if (ConfigRepoHelper.getAppDeploymentForApp(repositoryContext).isZeroEarCopy()) {
                    repositoryContext.getParent().notifyChanged(2, repositoryContext.getParent().getName());
                }
            }
            object = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent((AppNotification)object);
            if (repositoryContext.isAvailable("META-INF/ibm-application-ha.props")) {
                AppUtils.dbg(tc, "ttt hidden app flag found from MetadataTask");
                object = this.createNotification("Completed", "ADMA5110I", new String[]{this.scheduler.getAppName()});
                this.scheduler.propagateTaskEvent((AppNotification)object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.ConfigureTask.performTask", "134", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
        }
        finally {
            if (archive != null) {
                archive.close();
            }
            this.scheduler.getProperties().remove(DelModules);
            this.scheduler.getProperties().remove(AddedModules);
        }
    }

    private void updateDeploymentFromPartialEar(RepositoryContext repositoryContext, EARFile eARFile) throws Exception {
        int n;
        Object object;
        Object object2;
        String string;
        Object object3;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentFromPartialEar");
        }
        repositoryContext.extract(false);
        String string2 = repositoryContext.getPath() + "/";
        UpdateScheduler updateScheduler = (UpdateScheduler)this.scheduler;
        String string3 = AppUtils.getAppTempExtractDir(updateScheduler);
        List list = (List)this.scheduler.getProperties().get("DeltaDataTask.DelFiles");
        List list2 = (List)this.scheduler.getProperties().get(DelModules);
        List list3 = (List)this.scheduler.getProperties().get(AddedModules);
        AppUtils.dbg(tc, "delFiles: " + list);
        AppUtils.dbg(tc, "delM: " + list2);
        AppUtils.dbg(tc, "addM: " + list3);
        Object object4 = "";
        for (n2 = 0; n2 < list.size(); ++n2) {
            object4 = ((String)object4).equals("") ? (String)list.get(n2) : (String)object4 + "|" + list.get(n2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pattern for remove loose: " + (String)object4);
        }
        if (list2 != null) {
            for (n2 = 0; n2 < list2.size(); n2 += 2) {
                object3 = (String)list2.get(n2);
                string = (String)list2.get(n2 + 1);
                if (!this.hasModule(eARFile, (String)object3)) {
                    object3 = object3 + WHOLEDIR_PATTERN;
                    Object object5 = object4 = ((String)object4).equals("") ? object3 : (String)object4 + "|" + (String)object3;
                }
                if (AppUtils.isEmpty(string)) continue;
                object4 = ((String)object4).equals("") ? string : (String)object4 + "|" + string;
                object4 = (String)object4 + "|ALT-INF/" + list2.get(n2) + WHOLEDIR_PATTERN;
            }
        }
        AppUtils.dbg(tc, "Pattern for remove loose and mod: " + (String)object4);
        if (!AppUtils.isEmpty((String)object4)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object3 = repositoryContext.getFiles().iterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                if (!string.matches((String)object4)) continue;
                arrayList.add(string);
            }
            AppUtils.dbg(tc, "Delete files: " + arrayList);
            if (arrayList.size() > 0) {
                repositoryContext.notifyChanged(2, arrayList);
            }
        }
        String string4 = METADATA_PATTERN;
        object3 = eARFile.getModuleRefs();
        for (int i = 0; i < object3.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)object3.get(i);
            if (moduleRef.getAltDeploymentDescriptor() == null) continue;
            object2 = moduleRef.getAltDeploymentDescriptor().eResource().getURI().toString();
            object = moduleRef.getAltRoot();
            string4 = string4 + "|" + (String)object2 + "|" + (String)object + WHOLEDIR_PATTERN;
        }
        AppUtils.dbg(tc, "Loose add pattern: " + string4);
        EList eList = eARFile.getFiles();
        for (n = 0; n < eList.size(); ++n) {
            object2 = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)eList.get(n);
            if (!object2.getURI().matches(string4) || repositoryContext.isAvailable(object2.getURI()) && !new File(string3 + "/" + object2.getURI()).exists()) continue;
            object = repositoryContext.getPath() + "/" + object2.getURI();
            AppUtils.dbg(tc, "root file to be copied: " + object2.getURI() + " to " + (String)object);
            AppUtils.copyFile(eARFile.getInputStream(object2.getURI()), (String)object);
            if (repositoryContext.isAvailable(object2.getURI())) {
                repositoryContext.notifyChanged(1, object2.getURI());
                continue;
            }
            repositoryContext.notifyChanged(0, object2.getURI());
        }
        object3 = eARFile.getModuleRefs();
        for (n = 0; n < object3.size(); ++n) {
            Object object6;
            List<String> list4;
            boolean bl;
            object2 = (ModuleRef)object3.get(n);
            object = new File(string3 + "/" + object2.getUri());
            boolean bl2 = list3 != null && list3.contains(object2.getUri()) || ((File)object).exists() && ((File)object).isFile();
            boolean bl3 = bl = ((File)object).exists() && ((File)object).isDirectory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mUri: " + object2.getUri() + ", " + bl2 + "," + bl);
            }
            if (bl2) {
                Object object7;
                list4 = new ArrayList();
                String string5 = object2.getUri() + WHOLEDIR_PATTERN;
                object6 = repositoryContext.getFiles().iterator();
                while (object6.hasNext()) {
                    object7 = (String)object6.next();
                    if (!((String)object7).matches(string5)) continue;
                    list4.add((String)object7);
                }
                AppUtils.dbg(tc, "del files for full module add/update: " + list4);
                repositoryContext.notifyChanged(2, list4);
                object7 = new ArrayList();
                MetadataTask.saveArchiveConfigDocs(object2.getModuleFile(), METADATA_PATTERN, string2, object2.getUri(), (List)object7, this.getResourceBundle());
                repositoryContext.notifyChanged(0, (List)object7);
                AppUtils.dbg(tc, "add files for full module add/update: " + object7);
            }
            if (!bl) continue;
            list4 = AppUtils.getURIs(string3 + "/" + object2.getUri());
            for (int i = 0; i < list4.size(); ++i) {
                object6 = (String)list4.get(i);
                if (((String)object6).equals("META-INF/ibm-partialapp-delete.props") || !((String)object6).matches(METADATA_PATTERN)) continue;
                object6 = object2.getUri() + "/" + (String)object6;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loose metadata file: " + (String)object6);
                }
                AppUtils.dbg(tc, "Loose metadata file: " + (String)object6);
                AppUtils.copyFile(new File(string3 + "/" + (String)object6), string2 + (String)object6);
                if (repositoryContext.isAvailable((String)object6)) {
                    repositoryContext.notifyChanged(1, (String)object6);
                    continue;
                }
                repositoryContext.notifyChanged(0, (String)object6);
            }
        }
        if (updateScheduler.getContentType().equals("modulefile") && (n = (int)(this.updateAppDDInDeployment(eARFile, list2, list3, repositoryContext) ? 1 : 0)) != 0) {
            repositoryContext.notifyChanged(1, "META-INF/application.xml");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentFromPartialEar");
        }
    }

    private boolean hasModule(EARFile eARFile, String string) {
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            if (!((ModuleRef)eList.get(i)).getUri().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean updateAppDDInDeployment(EARFile eARFile, List list, List list2, RepositoryContext repositoryContext) throws Exception {
        Archive archive = null;
        boolean bl = false;
        try {
            Module module;
            Object object;
            Object object2;
            int n;
            List<Module> list3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifying app DD for module type");
            }
            archive = ConfigRepoHelper.getEarFileFromDeployment(this.scheduler.getWorkSpace(), repositoryContext);
            if (list != null) {
                list3 = new ArrayList();
                for (n = 0; n < list.size(); n += 2) {
                    object2 = (String)list.get(n);
                    object = (String)list.get(n + 1);
                    if (((String)object).equals("")) {
                        object = null;
                    }
                    module = archive.getModule((String)object2, (String)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "delMod: " + module);
                    }
                    if (module == null) {
                        throw new AdminException("Internal error in module del: no module with " + (String)object2 + ":" + (String)object);
                    }
                    list3.add(module);
                }
                for (n = 0; n < list3.size(); ++n) {
                    archive.getDeploymentDescriptor().getModules().remove(list3.get(n));
                    bl = true;
                }
            }
            if (list2 != null) {
                for (int i = 0; i < list2.size(); i += 2) {
                    String string = (String)list2.get(i);
                    object2 = (String)list2.get(i + 1);
                    if (((String)object2).equals("")) {
                        object2 = null;
                    }
                    if ((object = eARFile.getModule(string, (String)object2)) != null) {
                        module = (Module)EtoolsCopyUtility.createCopy((EObject)object);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "newMod: " + module);
                        }
                    } else {
                        throw new AdminException("Internal error in module add: no module with " + string + ":" + (String)object2);
                    }
                    archive.getDeploymentDescriptor().getModules().add(module);
                    bl = true;
                }
            }
            list3 = eARFile.getDeploymentDescriptor().getSecurityRoles();
            for (n = 0; n < list3.size(); ++n) {
                object2 = (SecurityRole)list3.get(n);
                if (archive.getDeploymentDescriptor().getSecurityRoleNamed(object2.getRoleName()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new role to be added: " + object2.getRoleName());
                    }
                    object = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)object2);
                    archive.getDeploymentDescriptor().getSecurityRoles().add(object);
                    bl = true;
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "role unchanged: " + object2.getRoleName());
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Saving app DD");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(repositoryContext.getPath() + "/META-INF/application.xml");
                archive.getDeploymentDescriptor().eResource().save(fileOutputStream, new HashMap());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, null);
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
        return bl;
    }

    public static List saveEarConfigDocs(String string, EARFile eARFile, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveEarConfigDocs");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        MetadataTask.saveArchiveConfigDocs(eARFile, METADATA_PATTERN, string2, null, linkedList, resourceBundle);
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving docs for: " + moduleRef.getUri());
            }
            MetadataTask.saveArchiveConfigDocs(moduleRef.getModuleFile(), METADATA_PATTERN, string2, moduleRef.getUri(), linkedList, resourceBundle);
            if (moduleRef.getAltDeploymentDescriptor() == null) continue;
            String string3 = moduleRef.getAltDeploymentDescriptor().eResource().getURI().toString();
            InputStream inputStream = eARFile.getInputStream(string3);
            MetadataTask.save2File(inputStream, string2 + string3, resourceBundle);
            inputStream.close();
            linkedList.add(string3);
            String string4 = moduleRef.getAltBindings().eResource().getURI().toString();
            String string5 = string4.substring(0, string4.lastIndexOf(47));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving alt docs from : " + string3 + " and binding: " + string5);
            }
            MetadataTask.saveArchiveConfigDocs(eARFile, string5 + THISDIR_PATTERN, string2, null, linkedList, resourceBundle);
        }
        return linkedList;
    }

    public static void saveArchiveConfigDocs(Archive archive, String string, String string2, String string3, List list, ResourceBundle resourceBundle) throws Exception {
        String string4 = string2;
        if (string3 != null) {
            string4 = string4 + string3 + File.separator;
        }
        EList eList = archive.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)eList.get(i);
            if (file instanceof Container || file.isSetDirectoryEntry() && file.isDirectoryEntry()) continue;
            String string5 = file.getURI();
            if (!(string5 = string5.replace('\\', '/')).matches(string)) continue;
            String string6 = (string3 == null ? "" : string3 + "/") + string5;
            if (list.contains(string6)) continue;
            InputStream inputStream = archive.getInputStream(string5);
            MetadataTask.save2File(inputStream, string4 + string5, resourceBundle);
            inputStream.close();
            AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6016I", new Object[]{string6}));
            list.add(string6);
        }
    }

    static void save2File(InputStream inputStream, String string, ResourceBundle resourceBundle) throws Exception {
        byte[] byArray;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File");
        }
        FileOutputStream fileOutputStream = MetadataTask.getFOStream(string);
        int n2 = inputStream.available();
        while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) >= 1) {
            fileOutputStream.write(byArray, 0, n);
            n2 = inputStream.available();
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6017I", new Object[]{string}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    static void save2File(Resource resource, String string, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File: " + resource);
        }
        FileOutputStream fileOutputStream = MetadataTask.getFOStream(string);
        resource.save(fileOutputStream, new HashMap());
        fileOutputStream.flush();
        fileOutputStream.close();
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6017I", new Object[]{string}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    private static FileOutputStream getFOStream(String string) throws Exception {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        File file = new File(string2);
        FileOutputStream fileOutputStream = null;
        file.getParentFile().mkdirs();
        fileOutputStream = new FileOutputStream(file);
        return fileOutputStream;
    }
}

