/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class StartDeploymentTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(StartDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private AppData _cachedAd;
    private AppData _newAd;
    static /* synthetic */ Class class$java$lang$String;

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        if (!this.appIsDeployedOnNode(appData.getAppName()) || this._isLocal) {
            return true;
        }
        this._cachedAd = appData;
        this._newAd = appData2;
        int n = this._newAd.getRecycleMode();
        int n2 = this._newAd.getOperations();
        if (n == 16) {
            return this.fineGrainUpdate(hashtable);
        }
        if (n == 1) {
            return this.fullAppUpdate(hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private boolean fullAppUpdate(Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fullAppUpdate");
        }
        Vector vector = (Vector)hashtable.get("stoppedlist");
        this.startDeployment("name=" + this._cachedAd.getAppName(), "startApplication", new String[]{this._cachedAd.getAppName()}, vector, (Vector)this._newSIMap.get(this._cachedAd.getAppName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fullAppUpdate");
        }
        return true;
    }

    private boolean fineGrainUpdate(Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fineGrainedUpdate");
        }
        Resource resource = null;
        try {
            int n;
            Object object;
            List list = this._newAd.getModulesToStart();
            List list2 = this._newAd.getModulesToRecycle();
            if (list.size() == 0 && list2.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Start or recycle size is 0: " + list + "---" + list2);
                }
                boolean bl = true;
                return bl;
            }
            resource = AppSyncUtils.getResource(this._repository, this._cachedAd.getDeplURI(), "deployment.xml");
            if (resource == null) {
                Tr.debug(tc, "Could not get deployment resources for " + this._cachedAd.getDeplURI());
                boolean bl = false;
                return bl;
            }
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(resource);
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                Tr.debug(tc, "starting " + string);
                object = this.getServersForModule(string, applicationDeployment);
                this.startDeployment("name=" + string + ",Application=" + this._cachedAd.getAppName(), "_startModule", new String[]{this._cachedAd.getAppName(), string}, this.servers2AppMgrON((Vector)object), (Vector)object);
            }
            Hashtable hashtable2 = (Hashtable)hashtable.get("stoppedlist");
            if (hashtable2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "No stopped table so nothing to recycle");
                }
                boolean bl = true;
                return bl;
            }
            for (n = 0; n < list2.size(); ++n) {
                object = (String)list2.get(n);
                Tr.debug(tc, "recycling " + (String)list2.get(n));
                Vector vector = (Vector)hashtable2.get(object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, (String)object + " was stopped at: " + vector);
                }
                if (vector == null || vector.size() == 0) continue;
                Vector vector2 = this.getServersForModule((String)object, applicationDeployment);
                this.startDeployment("name=" + (String)object + ",Application=" + this._cachedAd.getAppName(), "_startModule", new String[]{this._cachedAd.getAppName(), object}, vector, vector2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fineGrainedUpdate");
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
    }

    private void startDeployment(String string, String string2, String[] stringArray, Vector vector, Vector vector2) {
        if (this._isLocal || vector == null) {
            return;
        }
        if (vector == null || vector.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " was never stopped. So not restarting.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "For depl: " + string + " was stopped by: " + vector + " === and shouldStart: : " + vector2);
        }
        for (int i = 0; i < vector.size(); ++i) {
            ObjectName objectName = (ObjectName)vector.elementAt(i);
            String string3 = objectName.getKeyProperty("process");
            if (!vector2.contains(string3)) continue;
            try {
                String[] stringArray2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting..");
                }
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (stringArray.length == 1) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = (class$java$lang$String == null ? StartDeploymentTask.class$("java.lang.String") : class$java$lang$String).getName();
                } else {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = (class$java$lang$String == null ? StartDeploymentTask.class$("java.lang.String") : class$java$lang$String).getName();
                    stringArray2 = stringArray4;
                    stringArray4[1] = (class$java$lang$String == null ? StartDeploymentTask.class$("java.lang.String") : class$java$lang$String).getName();
                }
                adminService.invoke(objectName, string2, stringArray, stringArray2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Started: " + string + " on " + string3);
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "Unable to start: " + string + " using: " + objectName);
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinThread.startDeployments", "209", this);
            }
        }
    }

    private Vector servers2AppMgrON(Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "servers2AppMgrON");
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            ObjectName objectName = new ObjectName("WebSphere:type=Application,node=" + this._nodeName + ",process=" + vector.elementAt(i) + ",name=" + this._cachedAd.getAppName() + ",*");
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            if (set.size() == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "No app running for: " + objectName);
                continue;
            }
            objectName = new ObjectName("WebSphere:type=ApplicationManager,node=" + this._nodeName + ",process=" + vector.elementAt(i) + ",*");
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (iterator.hasNext()) {
                vector2.add(iterator.next());
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Internal error: No result for: " + objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "servers2AppMgrON: " + vector2);
        }
        return vector2;
    }

    private Vector getServersForModule(String string, ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule: " + string);
        }
        Vector<String> vector = new Vector<String>();
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            if (!moduleDeployment.getUri().equals(string)) continue;
            EList eList2 = moduleDeployment.getTargetMappings();
            for (int j = 0; j < eList2.size(); ++j) {
                DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList2.get(j);
                DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module target:" + deploymentTarget);
                }
                if (deploymentTarget instanceof ServerTarget) {
                    if (!((ServerTarget)deploymentTarget).getNodeName().equals(this._nodeName)) continue;
                    vector.add(((ServerTarget)deploymentTarget).getName());
                    continue;
                }
                if (!(deploymentTarget instanceof ClusteredTarget)) continue;
                Tr.debug(tc, "Handle clusters");
                String string2 = ((ClusteredTarget)deploymentTarget).getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster target: " + string2);
                }
                this.addClusterMembers(string2, vector);
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule: " + vector);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClusterMembers(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClusterMembers: " + string);
        }
        String string2 = "cells/" + this._cellName + "/clusters/" + string + "/cluster.xml";
        Resource resource = null;
        try {
            resource = AppSyncUtils.getResource(this._repository, string2, "cluster.xml");
            if (resource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster res not found for: " + string2);
                }
                return;
            }
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster obj: " + serverCluster);
            }
            EList eList = serverCluster.getMembers();
            for (int i = 0; i < eList.size(); ++i) {
                ClusterMember clusterMember = (ClusterMember)eList.get(i);
                if (!clusterMember.getNodeName().equals(this._nodeName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Need to add " + clusterMember.getMemberName());
                }
                if (vector.contains(clusterMember.getMemberName())) continue;
                vector.add(clusterMember.getMemberName());
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "Unexpected error finding cluster members on the node for " + string + ". The application " + this._cachedAd.getAppName() + " will not be started on some cluster members.");
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClusterMembers: " + vector);
        }
    }
}

