/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.ChangeProcessor;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class AppDataMgr {
    private static TraceComponent tc = Tr.register(AppDataMgr.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    static String CELLNAME_Str_KEY = "CELLNAME_KEY";
    public static String APPNAME_Str_KEY = "APPNAME_KEY";
    static String EAR_EARFile_KEY = "EAR_KEY";
    static String EARURI_Str_KEY = "EARURI_KEY";
    public static final String EAR_EARMODIFIEDTYPE_Str_KEY = "EARMODIFIEDTYPE_KEY";
    public static String DEPL_DEPLURL_Str_KEY = "DEPLURL_KEY";
    static String DEPL_DEPLMODIFIEDTYPE_Str_KEY = "DEPLMODIFIEDTYPE_KEY";
    static String DELTA_DELTList_KEY = "DELTLIST_KEY";
    static String FILE_FILEList_KEY = "FILELIST_KEY";
    static String DEPL_DEPLOYOBJ_ApplicationDeployment_KEY = "OLDDEPLOY_KEY";
    public static String DEPL_CTXIDFORSECURITY_Str_KEY = "CTXIDFORSECURITY_KEY";
    static String DEPL_WARCLPOLICY_Str_KEY = "WARPOLCY_KEY";
    static String DEPL_ZEROBINCPY_boo_KEY = "ZEROBINCPY_KEY";
    static String DEPL_ZEROEARCPY_boo_KEY = "ZEROEARCPY_KEY";
    public static String DEPL_DISTENABLED_boo_KEY = "DIST_KEY";
    public static String BINURL_Str_KEY = "BINURL_KEY";
    public static String FILEPERMISSION_Str_KEY = "filepermission";
    private AppDataImpl _cachedAD;
    private AppDataImpl _newAD;
    private ConfigRepository _repo;
    private String _appName;
    private String _cellName;
    EARFile _earFile;
    private Hashtable _files;
    private Hashtable _deltas;
    String _earURI = null;
    String _deplURI = null;
    String _earChangeType;
    String _deplChangeType;
    Hashtable _props;
    String markerName = null;
    private static Logger logger = null;
    private static String _nodeName = null;
    private static final String CLASSNAME = AppDataMgr.class.getName();
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String SERVS_CONTEXT = "servers/";
    private static final String enableWTOMessage = "com.ibm.websphere.management.application.expand.wto";

    public AppDataMgr(String string, String string2, ConfigRepository configRepository, VariableMap variableMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppDataMgr: appname= " + string + " cellname= " + string2 + " repo= " + configRepository + " varMap = " + variableMap);
        }
        this._repo = configRepository;
        this._appName = string;
        this._cellName = string2;
        this._earChangeType = "DOCSNOCHANGE_KEY";
        this._deplChangeType = "DOCSNOCHANGE_KEY";
        this._earURI = AppSyncUtils.getBinName(string, string2);
        this._deplURI = AppSyncUtils.getDeplURI(string, string2);
        this._files = new Hashtable();
        this._files.put("DOCSADDED_KEY", new ArrayList());
        this._files.put("DOCSREMOVED_KEY", new ArrayList());
        this._files.put("DOCSMODIFIED_KEY", new ArrayList());
        this._deltas = new Hashtable();
        this._deltas.put("DOCSADDED_KEY", new ArrayList());
        this._deltas.put("DOCSREMOVED_KEY", new ArrayList());
        this._cachedAD = new AppDataImpl(null, this._appName);
        this._newAD = new AppDataImpl(null, this._appName);
        this._cachedAD.setSibling(this._newAD);
        this._newAD.setSibling(this._cachedAD);
        if (AdminHelper.getPlatformHelper().isZOS()) {
            logger = Logger.getLogger(CLASSNAME, "com.ibm.ws.management.resources.AppDeploymentMessages");
        }
        if (AdminServiceFactory.getAdminService() != null) {
            _nodeName = AdminServiceFactory.getAdminService().getNodeName();
        }
        this._props = new Hashtable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppDataMgr");
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    public Hashtable getProps() {
        return this._props;
    }

    public void cleanup() {
        block13: {
            String string = (String)this._props.get("expansionFailue");
            this._props.remove("expansionFailue");
            if (this.markerName != null) {
                if (string == null) {
                    boolean bl = new File(this.markerName).delete();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deletedmarker " + this.markerName + " ret=" + bl);
                    }
                } else {
                    if (this.checkExpandErrorsToWTO()) {
                        this.logWTO("cleanup", "ADMA7101E", new Object[]{this._earURI, string, _nodeName});
                    }
                    Tr.audit(tc, "ADMA7101E", new Object[]{this._earURI, string, _nodeName});
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                        AppUtils.copyFile(byteArrayInputStream, this.markerName);
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Could not put error code into marker file " + this.markerName);
                    }
                }
            }
        }
        try {
            ApplicationDeployment applicationDeployment;
            if (this._earFile != null) {
                this._earFile.close();
            }
            ApplicationDeployment applicationDeployment2 = null;
            if (this._newAD != null && (applicationDeployment2 = (ApplicationDeployment)this._newAD.getProperties().remove(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY)) != null) {
                applicationDeployment2.eResource().unload();
            }
            if (this._cachedAD != null && (applicationDeployment = (ApplicationDeployment)this._cachedAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY)) != null && applicationDeployment.eResource() != null && !applicationDeployment.equals(applicationDeployment2)) {
                applicationDeployment.eResource().unload();
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in cleanup: " + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppDataMgr.addAppDocument", "189", this);
        }
    }

    public void addAppDocument(String string, String string2, VariableMap variableMap) {
        if (AppSyncUtils.isPathToDeploymentxml(string, this._cellName)) {
            if (!"DOCSADDED_KEY".equals(string2)) {
                this.updateDeplData(variableMap);
            }
            this._deplChangeType = string2;
            if (AdminServiceFactory.getAdminService() != null && AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
                this.markerName = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), this._appName);
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "marker name = " + this.markerName);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("0".getBytes());
                    AppUtils.copyFile(byteArrayInputStream, this.markerName);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EEE could not create marker file at " + this.markerName);
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.sync.AppDataMgr.addAppDocument", "175", this);
                }
            }
        } else if (AppSyncUtils.isPathToEar(string, this._cellName)) {
            this._earChangeType = string2;
        } else if (AppSyncUtils.isPathToDeltaxml(string)) {
            ((List)this._deltas.get(string2)).add(string);
        } else {
            ((List)this._files.get(string2)).add(string);
        }
    }

    public AppData getCachedAD() {
        if (this._cachedAD._dataTbl == null) {
            return null;
        }
        return this._cachedAD;
    }

    public AppData getNewAD() {
        if (this._newAD._dataTbl == null) {
            return null;
        }
        return this._newAD;
    }

    public void postProcess(VariableMap variableMap, boolean bl, ResourceBundle resourceBundle) {
        this.postProcess(variableMap, null, null, bl, resourceBundle);
    }

    public void postProcess(VariableMap variableMap, Hashtable hashtable, Hashtable hashtable2, boolean bl, ResourceBundle resourceBundle) {
        Object object;
        this.updateDeplData(variableMap);
        if (this._cachedAD._dataTbl == null && this._newAD._dataTbl == null) {
            Tr.warning(tc, "Ready to sync, however the app data objects have not been completely populated.");
        }
        if (hashtable != null && hashtable.get(this._appName) != null || hashtable2 != null && hashtable2.get(this._appName) != null) {
            this.normalizeBinariesURL(variableMap);
        }
        String string = (String)this._repo.getConfig().get("was.repository.root");
        try {
            object = string + '/' + this._earURI;
            if (!new File((String)object).exists() && !new File((String)(object = this._cachedAD.getBinURL())).exists()) {
                object = this._newAD.getBinURL();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear path = " + (String)object);
            }
            if (new File((String)object).exists()) {
                this._earFile = AppInstallHelper.getEarFile((String)object, false, true, resourceBundle);
                this._cachedAD.getProperties().put(EAR_EARFile_KEY, this._earFile);
                this._newAD.getProperties().put(EAR_EARFile_KEY, this._earFile);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to get ear:" + throwable);
            }
            if (bl) {
                throwable.printStackTrace(System.out);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppDataMgr.update", "375", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating chg processor");
        }
        object = new ChangeProcessor(this._earFile, bl, string);
        ((ChangeProcessor)object).init(this._earURI, this._earChangeType, this._deplURI, this._deplChangeType, this._deltas, this._files);
        ApplicationDeployment applicationDeployment = (ApplicationDeployment)this._cachedAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY);
        ApplicationDeployment applicationDeployment2 = (ApplicationDeployment)this._newAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY);
        ((ChangeProcessor)object).processDelta(applicationDeployment, applicationDeployment2, this._cachedAD.getBinURL(), this._newAD.getBinURL());
        this._props.put("filestbl", ((ChangeProcessor)object).getPatialStruct());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "" + object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ear = " + this._earFile);
        }
        this._cachedAD.setChangeProcessor((ChangeProcessor)object);
        this._newAD.setChangeProcessor((ChangeProcessor)object);
    }

    public void processVarChanged(String string, String string2) {
        this._cachedAD.getChangeProcessor().setRecycle(1);
        this._cachedAD.getChangeProcessor().setOp(65536);
        this._cachedAD.getProperties().put(BINURL_Str_KEY, string);
        this._newAD.getProperties().put(BINURL_Str_KEY, string2);
    }

    private void updateDeplData(VariableMap variableMap) {
        Serializable serializable;
        Tr.debug(tc, "updateDeplData:" + variableMap);
        if (!"DOCSREMOVED_KEY".equals(this._deplChangeType)) {
            try {
                serializable = new Hashtable<String, ApplicationDeployment>();
                Resource resource = null;
                resource = AppSyncUtils.getResource(this._repo, this._deplURI, "deployment.xml");
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(resource);
                ((Hashtable)serializable).put(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY, applicationDeployment);
                boolean bl = applicationDeployment.isEnableDistribution();
                boolean bl2 = applicationDeployment.isZeroBinaryCopy();
                boolean bl3 = applicationDeployment.isZeroEarCopy();
                String string = ClassLoaderPolicy.SINGLE_LITERAL.equals(applicationDeployment.getWarClassLoaderPolicy()) ? "1" : "0";
                String string2 = applicationDeployment.getAppContextIDForSecurity();
                String string3 = applicationDeployment.getBinariesURL();
                String string4 = applicationDeployment.getFilePermission();
                if (string4 == null) {
                    string4 = ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755";
                }
                ((Hashtable)serializable).put(FILEPERMISSION_Str_KEY, string4);
                AppUtils.dbg(tc, "filepermission: " + string4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "binaryURL: " + string3 + ", isDistrib: " + bl + ", isZeroBinCpy:" + bl2 + ", isZeroEarCpy:" + bl2 + ", clPolicy:" + string + ", appContextIDForSecurity:" + string2);
                }
                if (string2 != null) {
                    ((Hashtable)serializable).put(DEPL_CTXIDFORSECURITY_Str_KEY, string2);
                }
                ((Hashtable)serializable).put(BINURL_Str_KEY, string3);
                ((Hashtable)serializable).put(DEPL_WARCLPOLICY_Str_KEY, string);
                ((Hashtable)serializable).put(DEPL_DISTENABLED_boo_KEY, new Boolean(bl));
                ((Hashtable)serializable).put(DEPL_ZEROBINCPY_boo_KEY, new Boolean(bl2));
                ((Hashtable)serializable).put(DEPL_ZEROEARCPY_boo_KEY, new Boolean(bl3));
                this._newAD._dataTbl = (Hashtable)serializable;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateDeplData failed: " + exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.sync.AppDataMgr.updateDeplData", "331", this);
            }
        }
        if (this._cachedAD._dataTbl == null && this._newAD._dataTbl != null) {
            this._cachedAD._dataTbl = this._newAD._dataTbl;
        } else if (this._newAD._dataTbl == null && this._cachedAD._dataTbl != null) {
            this._newAD._dataTbl = this._cachedAD._dataTbl;
        } else if (this._newAD._dataTbl == null && this._cachedAD._dataTbl == null) {
            serializable = new AdminException("AppDataMgr _newAD and _cachedAD are both uninitialized.  Neither contain meaninful data for sync.");
            FFDCFilter.processException(serializable, "com.ibm.ws.management.application.sync.AppDataMgr.updateDeplData", "332", this);
        }
    }

    public void normalizeBinariesURL(VariableMap variableMap) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeBinariesURL", variableMap);
        }
        if (this._newAD._dataTbl != null && this._newAD.getBinURL() != null) {
            string = this._newAD.getBinURL();
            string = AppSyncUtils.normalizeBinaryPath(variableMap, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_newAD.binURL: " + string);
            }
            this._newAD.getProperties().put(BINURL_Str_KEY, string);
        }
        if (this._cachedAD._dataTbl != null && this._cachedAD.getBinURL() != null) {
            string = this._cachedAD.getBinURL();
            string = AppSyncUtils.normalizeBinaryPath(variableMap, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_cachedAD.binURL: " + string);
            }
            this._cachedAD.getProperties().put(BINURL_Str_KEY, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeBinariesURL");
        }
    }

    public String toString() {
        return ">>AppDataMgr: \ncachedAD = " + this._cachedAD + "\n" + "newAD = " + this._newAD + "\n" + "earfile: " + this._earFile + "\n" + "files: " + this._files + "\n" + "deltas: " + this._deltas + "\n" + "earURI: " + this._earURI + "\n" + "earChangeType: " + this._earChangeType + "\n" + "deplURI: " + this._deplURI + "\n" + "deplChange: " + this._deplChangeType + "\n" + "<<AppDataMgr \n";
    }

    private void logWTO(String string, String string2, Object[] objectArray) {
        LoggerHelper.addExtension(logger, "handler_preference", "operator");
        logger.logp(WsLevel.INFO, CLASSNAME, string, string2, objectArray);
        LoggerHelper.removeExtension(logger, "handler_preference");
    }

    private boolean checkExpandErrorsToWTO() {
        EList eList;
        Object object;
        Notifier notifier;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkExpandErrorsToWTO");
        }
        boolean bl = false;
        Server server = null;
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "checkExpandErrorsToWTO = " + new Boolean(bl));
            }
            return bl;
        }
        if (AdminServiceFactory.getAdminService() == null || !AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "Not NodeAgent, checkExpandErrorsToWTO = " + new Boolean(bl));
            }
            return bl;
        }
        try {
            object3 = AdminHelper.getInstance().getNodeAgentName(_nodeName);
            object2 = CELLS_CONTEXT + this._cellName + "/" + NODES_CONTEXT + _nodeName + "/" + SERVS_CONTEXT + (String)object3 + "/server.xml";
            notifier = AppSyncUtils.getResource(this._repo, (String)object2, "server.xml");
            object = notifier.getContents();
            for (int i = 0; i < object.size(); ++i) {
                eList = object.get(i);
                if (!(eList instanceof Server)) continue;
                server = (Server)((Object)eList);
                break;
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to find Node Agent Server object for node " + _nodeName);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppDataMgr.updateDeplData", "418", this);
        }
        if (server == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "checkExpandErrorsToWTO = " + new Boolean(bl));
            }
            return bl;
        }
        object3 = server.getComponents();
        if (object3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "Failed to find Server Components, checkExpandErrorsToWTO = " + new Boolean(bl));
            }
            return bl;
        }
        object2 = object3.iterator();
        block3: while (object2.hasNext()) {
            notifier = (Component)object2.next();
            if (!(notifier instanceof NodeAgent)) continue;
            object = (NodeAgent)notifier;
            ConfigSynchronizationService configSynchronizationService = object.getFileSynchronizationService();
            eList = configSynchronizationService.getProperties();
            if (eList == null) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Failed to find FileSynch Server Properties");
                break;
            }
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                String string = property.getName();
                if (!enableWTOMessage.equals(string)) continue;
                if (!"true".equalsIgnoreCase(property.getValue())) break block3;
                bl = true;
                break block3;
            }
            break block3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkExpandErrorsToWTO", "checkExpandErrorsToWTO = " + new Boolean(bl));
        }
        return bl;
    }

    private class AppDataImpl
    implements AppData {
        private Hashtable _dataTbl;
        private String _appName;
        private ChangeProcessor _cp;
        private AppDataImpl _myOnlySibling;
        private EARFile _earFile;

        AppDataImpl(Hashtable hashtable, String string) {
            this._dataTbl = hashtable;
            this._appName = string;
        }

        void setSibling(AppDataImpl appDataImpl) {
            this._myOnlySibling = appDataImpl;
        }

        void setEARFile(EARFile eARFile) {
            this._earFile = eARFile;
        }

        void setChangeProcessor(ChangeProcessor changeProcessor) {
            this._cp = changeProcessor;
        }

        ChangeProcessor getChangeProcessor() {
            return this._cp;
        }

        public Hashtable getProperties() {
            return this._dataTbl;
        }

        public String getAppContextIDForSecurity() {
            return (String)this.fetchData(DEPL_CTXIDFORSECURITY_Str_KEY, true);
        }

        public String getAppName() {
            return this._appName;
        }

        public String getBinURL() {
            return (String)this.fetchData(BINURL_Str_KEY, true);
        }

        public String getDeplURI() {
            return this._cp.getDeploymentURI();
        }

        public EARFile getEAR() {
            return (EARFile)this.fetchData(EAR_EARFile_KEY, true);
        }

        public String getEarURI() {
            return this._cp.getEarURI();
        }

        public String getWarClPolicy() {
            return (String)this.fetchData(DEPL_WARCLPOLICY_Str_KEY, true);
        }

        public boolean isDistEnabled() {
            Boolean bl = (Boolean)this.fetchData(DEPL_DISTENABLED_boo_KEY, true);
            if (bl == null) {
                return true;
            }
            return bl;
        }

        public boolean isZeroBinCpy() {
            Boolean bl = (Boolean)this.fetchData(DEPL_ZEROBINCPY_boo_KEY, true);
            if (bl == null) {
                return false;
            }
            return bl;
        }

        public boolean isZeroEarCpy() {
            Boolean bl = (Boolean)this.fetchData(DEPL_ZEROEARCPY_boo_KEY, true);
            if (bl == null) {
                return false;
            }
            return bl;
        }

        public String getDeploymentURI() {
            return this._cp.getDeploymentURI();
        }

        public String getDeploymentURIChangeType() {
            return this._cp.getDeploymentURIChangeType();
        }

        public String getEarURIChangeType() {
            return this._cp.getEarURIChangeType();
        }

        public List getModulesToRecycle() {
            return this._cp.getModulesToRecycle();
        }

        public List getModulesToStart() {
            return this._cp.getModulesToStart();
        }

        public List getModulesToStop() {
            return this._cp.getModulesToStop();
        }

        public int getOperations() {
            return this._cp.getOperations();
        }

        public Hashtable getPartialUpdateDetails() {
            return this._cp.getPartialUpdateDetails();
        }

        public int getRecycleMode() {
            return this._cp.getRecycleMode();
        }

        Object fetchData(String string, boolean bl) {
            Object var3_3 = null;
            try {
                var3_3 = this._dataTbl.get(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (var3_3 != null) {
                return var3_3;
            }
            if (bl && this._myOnlySibling._dataTbl != null) {
                return this._myOnlySibling.fetchData(string, false);
            }
            return var3_3;
        }

        public String toString() {
            return ">>> - AppData: " + this._appName + ", props=" + this._dataTbl;
        }

        public Hashtable getFileChangesInRepository() {
            return this._cp.getFileChangesInRepository();
        }

        public Hashtable getPartialUpdateModuleDetails() {
            return this._cp.getPartialUpdateModuleDetails();
        }
    }
}

