/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.sync.AppDataMgr;
import com.ibm.ws.management.application.sync.AppSyncEventsTask;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.DefaultAppSyncTaskProvider;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.security.auth.Subject;
import org.eclipse.emf.ecore.resource.Resource;

public class AppBinaryProcessor
implements ConfigRepositoryListener,
NotificationListener {
    private static TraceComponent tc = Tr.register(AppBinaryProcessor.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String DMGR = "dmgr";
    private static final long SYNC_ID = -1L;
    private ConfigRepository _repository;
    private boolean _isLocal;
    private String _cellName = null;
    private int _cellType = -1;
    private String _nodeName = null;
    private String _serverName = null;
    private String _cRoot = null;
    private boolean _isInNodeSync = false;
    private Hashtable _changeTables = null;
    private Object notify = null;
    private Class cls = null;
    private static ResourceBundle _bundle;
    private static AppBinaryProcessor processor;
    private static AppBinThread binThread;
    private boolean notificationSignaled = false;
    static Vector appAddedTasks;
    static Vector appRemovedTasks;
    static Vector appModifiedTasks;

    public static ResourceBundle getBundle() {
        if (_bundle == null) {
            _bundle = AppUtils.getBundle(null);
        }
        return _bundle;
    }

    public static AppBinaryProcessor getAppBinInstance() {
        return processor;
    }

    public void waitForThreadCompletion() {
        if (binThread == null) {
            return;
        }
        AppBinaryProcessor.binThread.waitForThreadCompletion();
    }

    public void notifyWaiter() {
        AppBinaryProcessor.binThread.notifyWaiter();
    }

    public AppBinaryProcessor(Boolean bl, ConfigRepository configRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppBinaryProcessor: " + bl);
        }
        this._isLocal = bl;
        this._repository = configRepository;
        this._cRoot = (String)this._repository.getConfig().get("was.repository.root");
        this._changeTables = new Hashtable();
        NodeSync.addLocalSyncEventListener((NotificationListener)this);
        if (processor != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Other instance exist!");
        }
        processor = this;
        try {
            ExtClassLoader extClassLoader;
            String string = "com.ibm.ws.security.authorize.AppInstallNotify";
            try {
                AppUtils.dbg(tc, "trying loading of class " + string);
                this.cls = Class.forName(string);
                AppUtils.dbg(tc, "class = " + this.cls);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AppUtils.dbg(tc, "ClassNotFoundException expected");
                extClassLoader = ExtClassLoader.getInstance();
                AppUtils.dbg(tc, "ecl = " + extClassLoader);
                if (extClassLoader == null) {
                    throw classNotFoundException;
                }
                this.cls = Class.forName(string, true, ExtClassLoader.getInstance());
                AppUtils.dbg(tc, "after class.forname " + string);
            }
            String string2 = "getInstance";
            extClassLoader = null;
            Object[] objectArray = null;
            Method method2 = this.cls.getMethod(string2, (Class<?>)((Object)extClassLoader));
            this.notify = method2.invoke(null, objectArray);
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMA7012E", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", "178", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppBinaryProcessor");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(final ConfigRepositoryEvent configRepositoryEvent) {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            ClassLoader classLoader2 = ExtClassLoader.getInstance();
                            if (classLoader2 == null) {
                                classLoader2 = this.getClass().getClassLoader();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "setting CCL = " + classLoader2);
                            }
                            Thread.currentThread().setContextClassLoader(classLoader2);
                            AppBinaryProcessor.this._onChangeStart(configRepositoryEvent);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause());
                }
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", "216", this);
                if (privilegedActionException.getCause() == null) break block3;
                privilegedActionException.getCause().printStackTrace();
            }
        }
    }

    private void _onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        Tr.entry(tc, "onChangeStart");
        ChangeTable changeTable = null;
        long l = this._isInNodeSync ? -1L : configRepositoryEvent.getId();
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            try {
                int n;
                boolean bl = false;
                if (this._cellName == null || this._nodeName == null) {
                    this.createNodeInfo(configChangeNotifierArray[i].getUri());
                    bl = true;
                }
                if ((n = AppSyncUtils.shouldProcess(configChangeNotifierArray[i].getUri(), this._cellName, this._nodeName, this._isInNodeSync, this._isLocal)) == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "URI: " + configChangeNotifierArray[i].getUri() + " is not processed by by AppBinaryProcessor");
                    }
                    if (!bl) continue;
                    this._nodeName = null;
                    this._cellName = null;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "process: " + configChangeNotifierArray[i].getUri() + " id=" + l);
                }
                if (changeTable == null && (changeTable = (ChangeTable)this._changeTables.get(new Long(l))) == null) {
                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._serverName, this._repository, this._isLocal);
                    this._changeTables.put(new Long(l), changeTable);
                }
                String string = AppSyncUtils.getSyncEventFromRepoEvent(configChangeNotifierArray[i].getChangeType());
                switch (n) {
                    case 1: {
                        changeTable.handleAppDocument(configChangeNotifierArray[i].getUri(), string);
                        break;
                    }
                    case 3: {
                        changeTable.handleSIDocument(configChangeNotifierArray[i].getUri(), string, this._nodeName);
                        break;
                    }
                    case 2: {
                        changeTable.handleVarDocument(configChangeNotifierArray[i].getUri(), string);
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMA7000W", (Object)new Object[]{throwable});
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.onChangeStart", "266", this);
            }
        }
        if (!this._isInNodeSync) {
            this.printTable("pre", l, (ChangeTable)this._changeTables.get(new Long(l)));
        }
        Tr.exit(tc, "onChangeStart");
    }

    public void onChangeCompletion(final ConfigRepositoryEvent configRepositoryEvent) {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            ClassLoader classLoader2 = ExtClassLoader.getInstance();
                            if (classLoader2 == null) {
                                classLoader2 = this.getClass().getClassLoader();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "setting CCL onChangecompletion = " + classLoader2);
                            }
                            Thread.currentThread().setContextClassLoader(classLoader2);
                            AppBinaryProcessor.this._onChangeCompletion(configRepositoryEvent);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause());
                }
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", "216", this);
                if (privilegedActionException.getCause() == null) break block3;
                privilegedActionException.getCause().printStackTrace();
            }
        }
    }

    public void _onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        boolean bl;
        Tr.entry(tc, "onChangeCompletion");
        boolean bl2 = bl = this._isLocal ? true : "UnManagedProcess".equals(AdminServiceFactory.getAdminService().getProcessType());
        if (!this._isInNodeSync) {
            this.postProcess(this._isInNodeSync ? -1L : configRepositoryEvent.getId(), bl);
        }
        Tr.exit(tc, "onChangeCompletion");
    }

    public void onRepositoryEpochRefresh() {
    }

    public void handleNotification(Notification notification, Object object) {
        Tr.entry(tc, "handleNotification");
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            this._isInNodeSync = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            boolean bl;
            this._isInNodeSync = false;
            this.printTable("pre", -1L, (ChangeTable)this._changeTables.get(new Long(-1L)));
            if (notification.getUserData() != null && Boolean.TRUE.equals(notification.getUserData())) {
                this.postProcess(-1L, this._isLocal);
            }
            if (bl = this.checkForFailedEars()) {
                this.postProcess(-1L, this._isLocal);
            }
        }
        Tr.exit(tc, "handleNotification");
    }

    public boolean checkForFailedEars() {
        boolean bl;
        block14: {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkForFailedEars");
            }
            bl = false;
            String string = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), "");
            String string2 = string.substring(0, n = string.lastIndexOf(46));
            File file = new File(string2);
            String[] stringArray = file.list();
            if (stringArray != null) {
                try {
                    Hashtable hashtable = AppSyncUtils.buildSIMap(this._cellName, this._nodeName, this._repository);
                    if (hashtable == null) {
                        return bl;
                    }
                    Enumeration enumeration = hashtable.keys();
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        boolean bl2 = false;
                        String string3 = null;
                        String string4 = (String)enumeration.nextElement();
                        String string5 = AppSyncUtils.getBinName(string4, this._cellName);
                        try {
                            string3 = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), string4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Marker file to check is = " + string3);
                            }
                            FileInputStream fileInputStream = new FileInputStream(string3);
                            int n2 = fileInputStream.available();
                            fileInputStream.close();
                            if (n2 > 4) {
                                bl = true;
                                ChangeTable changeTable = null;
                                changeTable = (ChangeTable)this._changeTables.get(new Long(-1L));
                                if (changeTable == null) {
                                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._serverName, this._repository, this._isLocal);
                                    this._changeTables.put(new Long(-1L), changeTable);
                                }
                                try {
                                    changeTable.handleAppDocument(AppSyncUtils.getDeplURI(string4, this._cellName), "DOCSADDED_KEY");
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "885", this);
                                }
                                Tr.error(tc, "ADMA7008E", string4 + " application FAILED to expand - will retry ear expansion");
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Still in process of expanding application = " + string4);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Marker file doesn't exist for application " + string5);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Failed to create SI map ex=" + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForFailedEars returns " + bl);
        }
        return bl;
    }

    public void postProcess(long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postProcess: " + l + ", synchronous=: " + bl);
        }
        try {
            AppBinThread appBinThread;
            ChangeTable changeTable = (ChangeTable)this._changeTables.remove(new Long(l));
            if (changeTable == null) {
                if (tc.isEntryEnabled() && changeTable == null) {
                    Tr.exit(tc, "postProcess  table is null or BAD !!!! " + l);
                }
                return;
            }
            changeTable.postProcess(this._nodeName);
            this.printTable("post", l, changeTable);
            binThread = appBinThread = new AppBinThread(this._cellName, this._cellType, this._nodeName, changeTable, this._repository);
            appBinThread.setSecurity(this.notify, this.cls);
            appBinThread.setLocal(this._isLocal);
            if (!bl) {
                Thread thread2 = new Thread(appBinThread);
                ClassLoader classLoader = ExtClassLoader.getInstance();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting context classloader: " + classLoader);
                }
                thread2.setContextClassLoader(classLoader);
                thread2.start();
            } else {
                appBinThread.run();
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "ADMA7007E", new Object[]{throwable, new Long(l)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postProcess: " + l);
        }
    }

    private void createNodeInfo(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeInfo: " + string);
        }
        if (!this._isLocal) {
            this._cellName = AdminServiceFactory.getAdminService().getCellName();
            this._nodeName = AdminServiceFactory.getAdminService().getNodeName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "!_isLocal, _cellName = " + this._cellName + ", _nodeName = " + this._nodeName);
            }
        } else if (this._isInNodeSync) {
            this._cellName = NodeSync.getNodeSync().getCellName();
            this._nodeName = NodeSync.getNodeSync().getNodeName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_isInNodeSync, _cellName = " + this._cellName + ", _nodeName = " + this._nodeName);
            }
        } else {
            if (string.indexOf(CELLS_CONTEXT) == -1) {
                return;
            }
            if (string.indexOf("node-metadata.properties") != -1) {
                return;
            }
            this._cellName = string.substring(string.indexOf(CELLS_CONTEXT) + CELLS_CONTEXT.length());
            if (this._cellName.indexOf(47) <= 0) {
                this._cellName = null;
                return;
            }
            this._cellName = this._cellName.substring(0, this._cellName.indexOf(47));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell: " + this._cellName);
            }
            Resource resource = AppSyncUtils.getResource(this._repository, CELLS_CONTEXT + this._cellName + "/" + "cell.xml", "cell.xml");
            Cell cell = (Cell)resource.getContents().get(0);
            WorkSpace workSpace = ConfigRepoHelper.getWorkSpace(null);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", this._cellName, null, null, workSpace, true);
            this._cellType = cell.getCellType().getValue();
            if (cell.getCellType().getValue() == 1) {
                this._nodeName = AppSyncUtils.getDmgrNodeName(this._repository, this._cellName);
                if (this._nodeName == null) {
                    RepositoryContext repositoryContext2 = AppUtils.findContext("servers", DMGR, null, repositoryContext, workSpace, true);
                    if (repositoryContext2 == null) {
                        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
                        repositoryContext2 = (RepositoryContext)objectArray[0];
                    }
                    this._nodeName = repositoryContext2.getParent().getName();
                }
            } else {
                this._nodeName = AppSyncUtils.getNodeNameFromBaseServer(this._repository, this._cellName);
                Object[] objectArray = AppUtils.getContextArray("nodes", repositoryContext, workSpace);
                RepositoryContext repositoryContext3 = (RepositoryContext)objectArray[0];
                if (this._nodeName == null) {
                    this._nodeName = ((RepositoryContext)objectArray[0]).getName();
                }
                List list = repositoryContext3.getChildren();
                RepositoryContext repositoryContext4 = null;
                if (list.size() > 0) {
                    repositoryContext4 = (RepositoryContext)list.get(0);
                    this._serverName = repositoryContext4.getName();
                }
            }
            ConfigRepoHelper.removeWorkSpace(false, workSpace);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell: " + this._cellName + ", node: " + this._nodeName, " , serverName " + this._serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeInfo");
        }
    }

    private void printTable(String string, long l, ChangeTable changeTable) {
        if (tc.isDebugEnabled()) {
            if (changeTable == null) {
                Tr.debug(tc, "xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx: NULL");
                return;
            }
            Tr.debug(tc, "xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx");
            String string2 = null;
            AppDataMgr appDataMgr = null;
            Enumeration enumeration = changeTable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                appDataMgr = changeTable.getTableEntry(string2);
                Tr.debug(tc, "\n=================================\n" + appDataMgr.toString() + "\n" + "=================================\n");
            }
            Tr.debug(tc, "xxxxENDxxxx id: " + l + " xxxxENDxxxx");
        }
    }

    static /* synthetic */ AppBinThread access$402(AppBinThread appBinThread) {
        binThread = appBinThread;
        return binThread;
    }

    static {
        processor = null;
        binThread = null;
    }

    private class ChangeTable {
        private Hashtable _table = new Hashtable();
        private String cellName;
        private boolean variablexml;
        private VariableMap vMap = null;
        private Hashtable cachedsiMap = null;
        private Hashtable newsiMap = null;
        ConfigRepository repository;
        boolean _isLocal;
        boolean varChanged = false;
        Hashtable varTable = null;
        String cRoot = null;

        ChangeTable(String string, String string2, String string3, ConfigRepository configRepository, boolean bl) {
            this.cellName = string;
            this.repository = configRepository;
            this._isLocal = bl;
            try {
                this.cRoot = (String)configRepository.getConfig().get("was.repository.root");
                this.vMap = AppUtils.createVarMap(this.cRoot, string, string2, string3);
            }
            catch (Exception exception) {
                Tr.warning(tc, "ADMA7016W", (Object)new Object[]{exception, "ChangeTable"});
            }
        }

        public void handleAppDocument(String string, String string2) {
            String string3 = AppSyncUtils.getAppNameFromAppDoc(string, this.cellName);
            AppDataMgr appDataMgr = (AppDataMgr)this._table.get(string3);
            if (appDataMgr == null) {
                appDataMgr = new AppDataMgr(string3, this.cellName, this.repository, this.vMap);
                this._table.put(string3, appDataMgr);
            }
            appDataMgr.addAppDocument(string, string2, this.vMap);
        }

        public void handleSIDocument(String string, String string2, String string3) {
            try {
                this.cachedsiMap = AppSyncUtils.buildSIMap(this.cellName, string3, this.repository);
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "1108", this);
            }
        }

        public void handleVarDocument(String string, String string2) {
            this.varChanged = true;
            this.varTable = this.getBinURLTable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "oldVarTable: " + this.varTable);
            }
        }

        public Hashtable getCachedSIMap() {
            return this.cachedsiMap;
        }

        public Hashtable getNewSIMap() {
            return this.newsiMap;
        }

        public void postProcess(String string) {
            try {
                this.newsiMap = AppSyncUtils.buildSIMap(this.cellName, string, this.repository);
                if (this.cachedsiMap == null) {
                    this.cachedsiMap = this.newsiMap;
                }
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "869", this);
            }
            if (this.varChanged && this.varTable != null) {
                try {
                    this.vMap = AppUtils.createVarMap(this.cRoot, AppBinaryProcessor.this._cellName, AppBinaryProcessor.this._nodeName, AppBinaryProcessor.this._serverName);
                    Hashtable hashtable = this.getBinURLTable();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "newVarTable: " + hashtable);
                    }
                    Hashtable<String, String[]> hashtable2 = new Hashtable<String, String[]>();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        String string3 = (String)enumeration.nextElement();
                        String string4 = (String)this.varTable.get(string3);
                        if (string4 == null || (string2 = (String)hashtable.get(string3)).equals(string4)) continue;
                        hashtable2.put(string3, new String[]{string4, string2});
                        if (this._table.get(string3) != null) continue;
                        try {
                            this.handleAppDocument(AppSyncUtils.getDeplURI(string3, AppBinaryProcessor.this._cellName), "DOCSMODIFIED_KEY");
                        }
                        catch (Throwable throwable) {
                            if (this._isLocal) {
                                throwable.printStackTrace();
                            }
                            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "885", this);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "diffTable: " + hashtable2);
                    }
                    this.varTable = hashtable2;
                }
                catch (Exception exception) {
                    if (this._isLocal) {
                        exception.printStackTrace();
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "861", this);
                }
            }
        }

        public void postProcessVarChanged(AppDataMgr appDataMgr, String string) {
            if (!this.varChanged || this.varTable == null || this.varTable.get(string) == null) {
                return;
            }
            String[] stringArray = (String[])this.varTable.get(string);
            appDataMgr.processVarChanged(stringArray[0], stringArray[1]);
        }

        public VariableMap getVarMap() {
            return this.vMap;
        }

        public Enumeration keys() {
            return this._table.keys();
        }

        public AppDataMgr getTableEntry(String string) {
            return (AppDataMgr)this._table.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hashtable getBinURLTable() {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "getBinURLTable");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                String[] stringArray = this.repository.listResourceNames(AppBinaryProcessor.CELLS_CONTEXT + AppBinaryProcessor.this._cellName + "/applications", 1, Integer.MAX_VALUE, new ResourceNameFilter(){

                    public boolean accept(String string, String string2) {
                        return string.indexOf("/deployments/") != -1 && string2.equals("deployment.xml");
                    }
                });
                for (int i = 0; i < stringArray.length; ++i) {
                    Resource resource = null;
                    try {
                        String string = AppSyncUtils.getAppNameFromDepURI(stringArray[i]);
                        resource = AppSyncUtils.getResource(this.repository, stringArray[i], "deployment.xml");
                        String string2 = ConfigRepoHelper.getAppDeploymentForApp(resource).getBinariesURL();
                        string2 = this.vMap.expand(string2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appname:" + string + ", path: " + string2);
                        }
                        hashtable.put(string, string2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (this._isLocal) {
                            throwable.printStackTrace();
                        }
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "891", this);
                        continue;
                    }
                    finally {
                        if (resource != null) {
                            resource.unload();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "877", this);
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getBinURLTable");
            }
            return hashtable;
        }
    }

    private class AppBinThread
    implements Runnable {
        ConfigRepository _repository;
        String _cellName;
        String _nodeName;
        ResourceBundle _resBundle;
        Subject _subject = null;
        boolean _isLocal;
        ChangeTable _changeTbl;
        Hashtable appStatusTbl = new Hashtable();
        Hashtable appTypeTbl = new Hashtable();
        Object _notify;
        Class _cls;
        AbstractAppSyncTask _task;
        protected int nextTaskNum = 0;
        boolean bSuccess = true;

        public AppBinThread(String string, int n, String string2, ChangeTable changeTable, ConfigRepository configRepository) {
            this._cellName = string;
            this._nodeName = string2;
            this._changeTbl = changeTable;
            this._repository = configRepository;
            this._resBundle = AppBinaryProcessor.getBundle();
            AppSyncUtils.setCellInfo(string, n);
        }

        public void setSecurity(Object object, Class clazz) {
            this._notify = object;
            this._cls = clazz;
        }

        public void setLocal(boolean bl) {
            this._isLocal = bl;
            if (!bl) {
                this._subject = SecurityHelper.getOwnedSubject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block42: {
                block41: {
                    if (AppBinaryProcessor.access$200().isEntryEnabled()) {
                        Tr.entry(AppBinaryProcessor.access$200(), "run");
                    }
                    if (this._subject != null) {
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "Push creds: " + this._subject);
                        }
                        this._subject = SecurityHelper.pushInvocationSubject(this._subject);
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "After push: " + this._subject);
                        }
                    }
                    var1_1 = this._changeTbl.keys();
                    var3_2 = null;
                    var4_3 = null;
                    var5_4 = null;
                    try {
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "Cached SI = " + this._changeTbl.getCachedSIMap());
                        }
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "New SI = " + this._changeTbl.getNewSIMap());
                        }
                        while (var1_1.hasMoreElements()) {
                            block45: {
                                block39: {
                                    block44: {
                                        block38: {
                                            this.nextTaskNum = 0;
                                            var2_5 = (String)var1_1.nextElement();
                                            var4_3 = this._changeTbl.getTableEntry(var2_5);
                                            try {
                                                try {
                                                    var4_3.postProcess(this._changeTbl.getVarMap(), this._changeTbl.getNewSIMap(), this._changeTbl.getCachedSIMap(), this._isLocal, this._resBundle);
                                                    this._changeTbl.postProcessVarChanged(var4_3, var2_5);
                                                    if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                        Tr.debug(AppBinaryProcessor.access$200(), "" + var4_3);
                                                    }
                                                    if (var4_3.getNewAD() == null && var4_3.getCachedAD() == null) {
                                                        var8_8 = null;
                                                        break block38;
                                                    }
                                                    var5_4 = this.getTaskList(var4_3.getNewAD().getOperations());
                                                    this._task = this.getNextTask(var5_4);
                                                    while (this._task != null && this.bSuccess) {
                                                        this._task.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                        this._task.setSecurity(this._subject, this._notify, this._cls);
                                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + this._task);
                                                        this.bSuccess = this._task.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                        if (!this.bSuccess) break;
                                                        this._task = this.getNextTask(var5_4);
                                                    }
                                                    var4_3.getProps().put("syncstatus", new Boolean(this.bSuccess));
                                                    break block39;
                                                }
                                                catch (Throwable var6_6) {
                                                    if (this._isLocal) {
                                                        var6_6.printStackTrace();
                                                    }
                                                    FFDCFilter.processException(var6_6, "com.ibm.ws.management.application.sync.AppBinaryProcessor.run", "1347", this);
                                                    Tr.error(AppBinaryProcessor.access$200(), "Exception from run: " + var6_6);
                                                    var4_3.getProps().put("syncstatus", new Boolean(false));
                                                    var8_8 = null;
                                                    try {
                                                        this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                                        this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                                        var9_9 = new AppSyncEventsTask();
                                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                                        var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                        var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                    }
                                                    catch (Throwable var9_9) {
                                                        if (this._isLocal) {
                                                            var9_9.printStackTrace();
                                                        }
                                                        FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                                    }
                                                    var4_3.cleanup();
                                                    continue;
                                                }
                                            }
                                            catch (Throwable var7_10) {
                                                block43: {
                                                    var8_8 = null;
                                                    ** try [egrp 4[TRYBLOCK] [6 : 623->758)] { 
lbl77:
                                                    // 1 sources

                                                    this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                                    this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                                    var9_9 = new AppSyncEventsTask();
                                                    Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                                    var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                    var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                    break block43;
lbl87:
                                                    // 1 sources

                                                    catch (Throwable var9_9) {
                                                        if (this._isLocal) {
                                                            var9_9.printStackTrace();
                                                        }
                                                        FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                                    }
                                                }
                                                var4_3.cleanup();
                                                throw var7_10;
                                            }
                                        }
                                        ** try [egrp 4[TRYBLOCK] [6 : 623->758)] { 
lbl96:
                                        // 1 sources

                                        this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                        this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                        var9_9 = new AppSyncEventsTask();
                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                        var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                        var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                        break block44;
lbl106:
                                        // 1 sources

                                        catch (Throwable var9_9) {
                                            if (this._isLocal) {
                                                var9_9.printStackTrace();
                                            }
                                            FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                        }
                                    }
                                    var4_3.cleanup();
                                    continue;
                                }
                                var8_8 = null;
                                ** try [egrp 4[TRYBLOCK] [6 : 623->758)] { 
lbl116:
                                // 1 sources

                                this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                var9_9 = new AppSyncEventsTask();
                                Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                break block45;
lbl126:
                                // 1 sources

                                catch (Throwable var9_9) {
                                    if (this._isLocal) {
                                        var9_9.printStackTrace();
                                    }
                                    FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                }
                            }
                            var4_3.cleanup();
                        }
                        if (this._subject == null) break block41;
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "Pop creds: " + this._subject);
                        }
                        SecurityHelper.popInvocationSubject(this._subject);
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "After pop");
                        }
                        this._subject = null;
                    }
                    catch (Throwable var6_7) {
                        FFDCFilter.processException(var6_7, "com.ibm.ws.management.application.sync.AppBinThread.run", "1395", this);
                        if (this._isLocal) {
                            var6_7.printStackTrace();
                        }
                        var11_12 = null;
                        try {
                            var12_16 = new AppSyncEventsTask();
                            var12_16.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                            Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + var12_16);
                            var12_16.performTask(this.appStatusTbl, this.appTypeTbl);
                        }
                        catch (Throwable var12_17) {
                            if (this._isLocal) {
                                var12_17.printStackTrace();
                            }
                            FFDCFilter.processException(var12_17, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                        }
                        break block42;
                    }
                }
                var11_11 = null;
                {
                    catch (Throwable var10_20) {
                        var11_13 = null;
                        ** try [egrp 5[TRYBLOCK] [11 : 911->998)] { 
lbl166:
                        // 1 sources

                        var12_18 = new AppSyncEventsTask();
                        var12_18.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                        Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + var12_18);
                        var12_18.performTask(this.appStatusTbl, this.appTypeTbl);
                        throw var10_20;
lbl172:
                        // 1 sources

                        catch (Throwable var12_19) {
                            if (this._isLocal) {
                                var12_19.printStackTrace();
                            }
                            FFDCFilter.processException(var12_19, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                        }
                        throw var10_20;
                    }
                    ** try [egrp 5[TRYBLOCK] [11 : 911->998)] { 
lbl178:
                    // 1 sources

                    var12_14 = new AppSyncEventsTask();
                    var12_14.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                    Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + var12_14);
                    var12_14.performTask(this.appStatusTbl, this.appTypeTbl);
lbl184:
                    // 1 sources

                    catch (Throwable var12_15) {}
                    if (this._isLocal) {
                        var12_15.printStackTrace();
                    }
                    FFDCFilter.processException(var12_15, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                }
            }
            this.notifyWaiter();
            AppBinaryProcessor.access$402(null);
            if (AppBinaryProcessor.access$200().isEntryEnabled() == false) return;
            Tr.exit(AppBinaryProcessor.access$200(), "run");
        }

        private synchronized void waitForThreadCompletion() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForThreadCompletion");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Entering waitForThreadCompletion notificationSignaled = " + AppBinaryProcessor.this.notificationSignaled);
            }
            if (!AppBinaryProcessor.this.notificationSignaled) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AppBinaryProcessor.this.notificationSignaled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exiting waitForThreadCompletion");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForThreadCompletion");
            }
        }

        private synchronized void notifyWaiter() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyWaiter");
            }
            AppBinaryProcessor.this.notificationSignaled = true;
            this.notify();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyWaiter");
            }
        }

        private Vector getTaskList(int n) throws Exception {
            DefaultAppSyncTaskProvider defaultAppSyncTaskProvider = new DefaultAppSyncTaskProvider();
            if ((n & 1) != 0) {
                Vector vector = new Vector();
                defaultAppSyncTaskProvider.provideAppAddedSyncTasks(vector);
                vector = ExtensionHelper.processAppAddedSyncExtensions(vector);
                return vector;
            }
            if ((n & 0x10) != 0) {
                Vector vector = new Vector();
                defaultAppSyncTaskProvider.provideAppRemovedSyncTasks(vector);
                vector = ExtensionHelper.processAppRemovedSyncExtensions(vector);
                return vector;
            }
            Vector vector = new Vector();
            defaultAppSyncTaskProvider.provideAppModifiedSyncTasks(vector);
            vector = ExtensionHelper.processAppModifiedSyncExtensions(vector);
            return vector;
        }

        private AbstractAppSyncTask getNextTask(Vector vector) throws AdminException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNextTask");
            }
            if (this.nextTaskNum >= vector.size()) {
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextTask");
            }
            return (AbstractAppSyncTask)vector.elementAt(this.nextTaskNum++);
        }
    }
}

