/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanRootImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentController;
import com.ibm.ws.management.application.j2ee.deploy.spi.exceptions.J2EEDeployInvalidModuleException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;

public class DeploymentConfigurationImpl
implements DeploymentConfiguration {
    private static TraceComponent tc = Tr.register(DeploymentConfigurationImpl.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static final String JSR88_ROOT_URI = "WebSphere88RootDepl";
    private static int gCounter = 1;
    ResourceBundle resBundle;
    DeploymentManager dManager = null;
    DeployableObject rootObj = null;
    String _tmpArchive = null;
    J2EEDeploymentController _adController = null;
    Vector _depls = null;
    Vector _uris = null;
    Hashtable _dcRoots = null;

    public static String getTempFileName() {
        return AppUtils.getTempDir() + "j88_" + Long.toHexString(System.currentTimeMillis()) + "_" + gCounter++;
    }

    public DeploymentConfigurationImpl(DeployableObject deployableObject, DeploymentManager deploymentManager) throws InvalidModuleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentConfigurationImpl: " + deployableObject);
        }
        this.rootObj = deployableObject;
        this.dManager = deploymentManager;
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", this.dManager.getCurrentLocale());
        this._depls = new Vector();
        this._uris = new Vector();
        this._dcRoots = new Hashtable();
        this._depls.addElement(this.rootObj);
        this._uris.addElement(JSR88_ROOT_URI);
        DConfigBeanRootImpl dConfigBeanRootImpl = new DConfigBeanRootImpl(this, deployableObject.getDDBeanRoot(), JSR88_ROOT_URI);
        this._dcRoots.put(JSR88_ROOT_URI, dConfigBeanRootImpl);
        if (this.rootObj.getType().equals(ModuleType.EAR)) {
            try {
                J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)this.rootObj;
                String[] stringArray = j2eeApplicationObject.getModuleUris();
                for (int i = 0; i < stringArray.length; ++i) {
                    DeployableObject deployableObject2 = j2eeApplicationObject.getDeployableObject(stringArray[i]);
                    if (deployableObject2 == null) continue;
                    this._depls.addElement(deployableObject2);
                    this._uris.addElement(stringArray[i]);
                }
            }
            catch (Throwable throwable) {
                throw new J2EEDeployInvalidModuleException(throwable.toString(), throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentConfigurationImpl");
        }
    }

    public DeployableObject getDeployableObject() {
        return this.rootObj;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        DConfigBeanRoot dConfigBeanRoot;
        if (!J2EEDeploymentController.isRootDDBean(dDBeanRoot)) {
            return null;
        }
        if (dDBeanRoot.getDeployableObject().getType().equals(ModuleType.RAR) || dDBeanRoot.getDeployableObject().getType().equals(ModuleType.CAR)) {
            return null;
        }
        int n = this._depls.indexOf(dDBeanRoot.getDeployableObject());
        if (n == -1) {
            throw new ConfigurationException(AppUtils.getMessage(this.resBundle, "ADMJ0001", new Object[]{dDBeanRoot}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uri = " + this._uris.elementAt(n));
        }
        if ((dConfigBeanRoot = (DConfigBeanRoot)this._dcRoots.get(this._uris.elementAt(n))) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating DCRoot for DD: " + dDBeanRoot);
            }
            dConfigBeanRoot = new DConfigBeanRootImpl(this, dDBeanRoot, (String)this._uris.elementAt(n));
            this._dcRoots.put(this._uris.elementAt(n), dConfigBeanRoot);
        }
        return dConfigBeanRoot;
    }

    public void removeDConfigBean(DConfigBeanRoot dConfigBeanRoot) throws BeanNotFoundException {
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream inputStream, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        return null;
    }

    public void saveDConfigBean(OutputStream outputStream, DConfigBeanRoot dConfigBeanRoot) throws ConfigurationException {
        DConfigBeanRootImpl dConfigBeanRootImpl = (DConfigBeanRootImpl)dConfigBeanRoot;
        this.save(new DConfigBeanRootImpl[]{dConfigBeanRootImpl}, outputStream);
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        DConfigBeanRootImpl[] dConfigBeanRootImplArray = new DConfigBeanRootImpl[this._dcRoots.size()];
        Iterator iterator = this._dcRoots.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            dConfigBeanRootImplArray[n++] = (DConfigBeanRootImpl)iterator.next();
        }
        this.save(dConfigBeanRootImplArray, outputStream);
    }

    public void save(DConfigBeanRootImpl[] dConfigBeanRootImplArray, OutputStream outputStream) throws ConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save: " + dConfigBeanRootImplArray.length);
        }
        try {
            for (int i = 0; i < dConfigBeanRootImplArray.length; ++i) {
                dConfigBeanRootImplArray[i].saveTaskData();
            }
            this.getController().createDeploymentPlan(outputStream);
            this.doCleanup();
        }
        catch (AppDeploymentException appDeploymentException) {
            throw new ConfigurationException(appDeploymentException.toString());
        }
        catch (InvalidModuleException invalidModuleException) {
            throw new ConfigurationException(invalidModuleException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save");
        }
    }

    public void restore(InputStream inputStream) throws ConfigurationException {
    }

    J2EEDeploymentController getController() throws InvalidModuleException {
        if (this._adController == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating ad controller");
            }
            try {
                Object object;
                this._tmpArchive = DeploymentConfigurationImpl.getTempFileName();
                this.extractArchive(this.rootObj, this._tmpArchive);
                if (!this.rootObj.getType().equals(ModuleType.EAR)) {
                    object = DeploymentConfigurationImpl.getTempFileName();
                    AppInstallHelper.createEarWrapper(this._tmpArchive, (String)object, JSR88_ROOT_URI, "/");
                    AppUtils.deleteDirTree(this._tmpArchive);
                    this._tmpArchive = object;
                }
                object = new Hashtable();
                ((Hashtable)object).put("jsr88", "");
                ((Hashtable)object).put("app.client.locale", this.dManager.getCurrentLocale());
                this._adController = (J2EEDeploymentController)AppManagementFactory.readArchive(this._tmpArchive, (Hashtable)object);
                this._adController.setDConfigurationImpl(this);
            }
            catch (Throwable throwable) {
                throw new J2EEDeployInvalidModuleException(throwable.toString(), throwable);
            }
        }
        return this._adController;
    }

    public Vector getAllTypes() {
        Vector<ModuleType> vector = new Vector<ModuleType>();
        for (int i = 0; i < this._depls.size(); ++i) {
            vector.addElement(((DeployableObject)this._depls.elementAt(i)).getType());
        }
        return vector;
    }

    public String getUriForDeployableObject(DeployableObject deployableObject) {
        return (String)this._uris.elementAt(this._depls.indexOf(deployableObject));
    }

    private void extractArchive(DeployableObject deployableObject, String string) throws Exception {
        Enumeration enumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + deployableObject + " to " + string);
        }
        if ((enumeration = deployableObject.entries()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EEEEEEEE NO entries found!!");
            }
            return;
        }
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            int n;
            String string2 = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "next uri: " + string2);
            }
            if (string2.endsWith("/") || !string2.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*") && !string2.endsWith(".wsdl") && !string2.endsWith(".xsd") && !this._uris.contains(string2) && !string2.endsWith(".xml") && !string2.endsWith(".xmi") && !string2.endsWith(".mf") && !string2.endsWith(".MF")) continue;
            InputStream inputStream = deployableObject.getEntry(string2);
            String string3 = string + File.separator + string2;
            File file = new File(string3);
            file.getParentFile().mkdirs();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting .. " + string2 + " at " + string3);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n2 = inputStream.available();
            while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) >= 1) {
                fileOutputStream.write(byArray, 0, n);
                n2 = inputStream.available();
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            inputStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractArchive");
        }
    }

    protected void finalize() throws Throwable {
        this.doCleanup();
        super.finalize();
    }

    private void doCleanup() {
        if (this._tmpArchive != null) {
            try {
                if (this._adController != null) {
                    this._adController.close(false, false, true);
                }
                AppUtils.deleteDirTree(this._tmpArchive);
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMJ0004W", (Object)new Object[]{throwable, this._tmpArchive});
            }
            this._adController = null;
            this._tmpArchive = null;
        }
    }
}

