/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class StrategyExporter {
    PrintStream out = System.out;
    int indentation = -1;
    EARFile ear = null;

    public StrategyExporter(Preferences preferences, EARFile eARFile) {
        this.ear = eARFile;
        try {
            this.out = new PrintStream(new FileOutputStream(preferences.getExportFile()));
        }
        catch (Throwable throwable) {
            System.err.println("couldnt open export file " + preferences.getExportFile() + " ...  writing to System.out instead ...");
            this.out = System.out;
        }
    }

    public void export() {
        this.out.println("<?xml version=\"1.0\"?>");
        this.out.println("<!DOCTYPE dfltbndngs SYSTEM \"dfltbndngs.dtd\">");
        this.startElement("dfltbndngs", true);
        this.exportGlobalBindings();
        this.exportModuleBindings();
        this.endElement("dfltbndngs", true);
    }

    void exportGlobalBindings() {
        this.startElement("global-bindings", true);
        this.endElement("global-bindings", true);
    }

    void exportModuleBindings() {
        this.startElement("module-bindings", true);
        Iterator iterator = this.ear.getModuleFiles().iterator();
        while (iterator.hasNext()) {
            Archive archive = (Archive)iterator.next();
            if (archive.isEJBJarFile()) {
                this.exportEjbJarFile((EJBJarFile)archive);
                continue;
            }
            if (archive.isWARFile()) {
                this.exportWarFile((WARFile)archive);
                continue;
            }
            if (!archive.isApplicationClientFile()) continue;
            this.exportClientJar((ApplicationClientFile)archive);
        }
        this.endElement("module-bindings", true);
    }

    void exportEjbJarFile(EJBJarFile eJBJarFile) {
        Iterator iterator;
        CMPConnectionFactoryBinding cMPConnectionFactoryBinding;
        this.startElement("ejb-jar-binding", true);
        this.printElement("jar-name", eJBJarFile.getURI());
        EJBJarBinding eJBJarBinding = eJBJarFile.getBindings();
        EJBJar eJBJar = eJBJarFile.getDeploymentDescriptor();
        ResourceRefBinding resourceRefBinding = eJBJarBinding.getDefaultDatasource();
        if (resourceRefBinding != null) {
            this.exportDataSource(resourceRefBinding.getJndiName(), "_user_", "_password_");
        }
        if ((cMPConnectionFactoryBinding = eJBJarBinding.getDefaultCMPConnectionFactory()) != null) {
            this.exportConnectionFactory(cMPConnectionFactoryBinding.getJndiName(), Preferences.RES_AUTH[cMPConnectionFactoryBinding.getResAuth().getValue()]);
        }
        if ((iterator = eJBJar.getEnterpriseBeans().iterator()).hasNext()) {
            this.startElement("ejb-bindings", true);
            while (iterator.hasNext()) {
                try {
                    EObject eObject;
                    Object object;
                    Object object2;
                    Object object3;
                    EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                    EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding(enterpriseBean);
                    this.startElement("ejb-binding", true);
                    this.printElement("ejb-name", enterpriseBean.getName());
                    if (enterpriseBean.isMessageDriven()) {
                        this.printElement("listener-port", ((MessageDrivenBeanBinding)enterpriseBeanBinding).getListenerInputPortName());
                    } else {
                        this.printElement("jndi-name", enterpriseBeanBinding.getJndiName());
                        if (enterpriseBean.isContainerManagedEntity()) {
                            if (eJBJar.isVersion2_0Descriptor() && (object3 = enterpriseBeanBinding.getCmpConnectionFactory()) != null) {
                                this.exportConnectionFactory(object3.getJndiName(), Preferences.RES_AUTH[object3.getResAuth().getValue()]);
                            }
                            if (eJBJar.isVersion1_1Descriptor() && (object3 = enterpriseBeanBinding.getDatasource()) != null) {
                                this.exportDataSource(object3.getJndiName(), "_user_", "_password_");
                            }
                        }
                    }
                    object3 = enterpriseBean.getEjbRefs().iterator();
                    if (object3.hasNext()) {
                        this.startElement("ejb-ref-bindings", true);
                        while (object3.hasNext()) {
                            object2 = (EjbRef)object3.next();
                            object = enterpriseBeanBinding.getEjbRefBinding((EjbRef)object2);
                            this.exportEjbRef(object2.getName(), object.getJndiName());
                        }
                        this.endElement("ejb-ref-bindings", true);
                    }
                    if ((object2 = enterpriseBean.getResourceRefs().iterator()).hasNext()) {
                        this.startElement("resource-ref-bindings", true);
                        while (object2.hasNext()) {
                            object = (ResourceRef)object2.next();
                            eObject = enterpriseBeanBinding.getResRefBinding((ResourceRef)object);
                            this.exportResourceRef(object.getName(), eObject.getJndiName());
                        }
                        this.endElement("resource-ref-bindings", true);
                    }
                    if ((object = enterpriseBean.getResourceEnvRefs().iterator()).hasNext()) {
                        this.startElement("resource-env-ref-bindings", true);
                        while (object.hasNext()) {
                            eObject = (ResourceEnvRef)object.next();
                            ResourceEnvRefBinding resourceEnvRefBinding = enterpriseBeanBinding.getResEnvRefBinding((ResourceEnvRef)eObject);
                            this.exportResourceEnvRef(eObject.getName(), resourceEnvRefBinding.getJndiName());
                        }
                        this.endElement("resource-env-ref-bindings", true);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.StrategyExporter.exportEjbJarFile", "238", this);
                }
                this.endElement("ejb-binding", true);
            }
            this.endElement("ejb-bindings", true);
        }
        this.endElement("ejb-jar-binding", true);
    }

    void exportConnectionFactory(String string, String string2) {
        if (string != null) {
            this.startElement("connection-factory", true);
            this.printElement("jndi-name", string);
            this.printElement("res-auth", string2);
            this.endElement("connection-factory", true);
        }
    }

    void exportDataSource(String string, String string2, String string3) {
        if (string != null) {
            this.startElement("data-source", true);
            this.printElement("jndi-name", string);
            this.printElement("user", string2);
            this.printElement("password", string3);
            this.endElement("data-source", true);
        }
    }

    void exportEjbRef(String string, String string2) {
        this.startElement("ejb-ref-binding", true);
        this.printElement("ejb-ref-name", string);
        this.printElement("jndi-name", string2);
        this.endElement("ejb-ref-binding", true);
    }

    void exportResourceRef(String string, String string2) {
        this.startElement("resource-ref-binding", true);
        this.printElement("resource-ref-name", string);
        this.printElement("jndi-name", string2);
        this.endElement("resource-ref-binding", true);
    }

    void exportResourceEnvRef(String string, String string2) {
        this.startElement("resource-env-ref-binding", true);
        this.printElement("resource-env-ref-name", string);
        this.printElement("jndi-name", string2);
        this.endElement("resource-env-ref-binding", true);
    }

    void exportWarFile(WARFile wARFile) {
        Object object;
        Object object2;
        this.startElement("war-binding", true);
        WebApp webApp = wARFile.getDeploymentDescriptor();
        WebAppBinding webAppBinding = wARFile.getBindings();
        this.printElement("jar-name", wARFile.getURI());
        Iterator iterator = webAppBinding.getEjbRefBindings().iterator();
        if (iterator.hasNext()) {
            this.startElement("ejb-ref-bindings", true);
            while (iterator.hasNext()) {
                object2 = (EjbRefBinding)iterator.next();
                this.exportEjbRef(object2.getBindingEjbRef().getName(), object2.getJndiName());
            }
            this.endElement("ejb-ref-bindings", true);
        }
        if ((object2 = webAppBinding.getResRefBindings().iterator()).hasNext()) {
            this.startElement("resource-ref-bindings", true);
            while (object2.hasNext()) {
                object = (ResourceRefBinding)object2.next();
                this.exportResourceRef(object.getBindingResourceRef().getName(), object.getJndiName());
            }
            this.endElement("resource-ref-bindings", true);
        }
        if ((object = webAppBinding.getResourceEnvRefBindings().iterator()).hasNext()) {
            this.startElement("resource-env-ref-bindings", true);
            while (object.hasNext()) {
                ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)object.next();
                this.exportResourceEnvRef(resourceEnvRefBinding.getBindingResourceEnvRef().getName(), resourceEnvRefBinding.getJndiName());
            }
            this.endElement("resource-env-ref-bindings", true);
        }
        this.endElement("war-binding", true);
    }

    void exportClientJar(ApplicationClientFile applicationClientFile) {
        Object object;
        Object object2;
        this.startElement("java-binding", true);
        ApplicationClient applicationClient = applicationClientFile.getDeploymentDescriptor();
        ApplicationClientBinding applicationClientBinding = applicationClientFile.getBindings();
        this.printElement("jar-name", applicationClientFile.getURI());
        Iterator iterator = applicationClientBinding.getEjbRefs().iterator();
        if (iterator.hasNext()) {
            this.startElement("ejb-ref-bindings", true);
            while (iterator.hasNext()) {
                object2 = (EjbRefBinding)iterator.next();
                this.exportEjbRef(object2.getBindingEjbRef().getName(), object2.getJndiName());
            }
            this.endElement("ejb-ref-bindings", true);
        }
        if ((object2 = applicationClientBinding.getResourceRefs().iterator()).hasNext()) {
            this.startElement("resource-ref-bindings", true);
            while (object2.hasNext()) {
                object = (ResourceRefBinding)object2.next();
                this.exportResourceRef(object.getBindingResourceRef().getName(), object.getJndiName());
            }
            this.endElement("resource-ref-bindings", true);
        }
        if ((object = applicationClientBinding.getResourceEnvRefBindings().iterator()).hasNext()) {
            this.startElement("resource-env-ref-bindings", true);
            while (object.hasNext()) {
                ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)object.next();
                this.exportResourceEnvRef(resourceEnvRefBinding.getBindingResourceEnvRef().getName(), resourceEnvRefBinding.getJndiName());
            }
            this.endElement("resource-env-ref-bindings", true);
        }
        this.endElement("java-binding", true);
    }

    void printElement(String string, String string2) {
        this.startElement(string, false);
        this.out.print(string2);
        this.endElement(string, false);
    }

    void startElement(String string, boolean bl) {
        this.indent(1);
        if (bl) {
            this.out.println("<" + string + ">");
        } else {
            this.out.print("<" + string + ">");
        }
    }

    void endElement(String string, boolean bl) {
        if (bl) {
            this.indent();
        }
        this.out.println("</" + string + ">");
        --this.indentation;
    }

    void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.out.print("  ");
        }
    }

    void indent(int n) {
        this.indentation += n;
        this.indent();
    }

    void indent(int n, boolean bl) {
        this.indentation += n;
        if (bl) {
            this.indent();
        }
    }

    void outdent(int n) {
        this.indentation -= n;
        this.indent();
    }
}

