/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.dfltbndngs.BindingStrategy;
import com.ibm.ws.management.application.dfltbndngs.ConnectionFactoryBinding;
import com.ibm.ws.management.application.dfltbndngs.DOMParser;
import com.ibm.ws.management.application.dfltbndngs.DataSourceBinding;
import com.ibm.ws.management.application.dfltbndngs.DefaultStrategy;
import com.ibm.ws.management.application.dfltbndngs.EjbId;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomizeableStrategy
extends DefaultStrategy {
    static TraceComponent tc = Tr.register(CustomizeableStrategy.class, null, "com.ibm.ws.management.resources.BindEarCmd");
    public static final String CONNFACT = "connection-factory";
    public static final String DATASOURCE = "data-source";
    public static final String EJB_BINDING = "ejb-binding";
    public static final String EJB_BINDINGS = "ejb-bindings";
    public static final String EJB_JAR_BINDING = "ejb-jar-binding";
    public static final String JAR_NAME = "jar-name";
    public static final String EJB_NAME = "ejb-name";
    public static final String GLOBAL_BINDINGS = "global-bindings";
    public static final String JAVA_BINDING = "java-binding";
    public static final String JNDI_NAME = "jndi-name";
    public static final String LISTERNER_PORT = "listener-port";
    public static final String ACTIVATIONSPEC_JNDI_NAME = "activationspec-jndi-name";
    public static final String MODULE_BINDINGS = "module-bindings";
    public static final String PASSWORD = "password";
    public static final String RESAUTH = "res-auth";
    public static final String EJB_REF = "ejb-ref-binding";
    public static final String EJB_REFS = "ejb-ref-bindings";
    public static final String EJB_REF_NAME = "ejb-ref-name";
    public static final String RESOURCE_ENV_REF = "resource-env-ref-binding";
    public static final String RESOURCE_ENV_REFS = "resource-env-ref-bindings";
    public static final String RESOURCE_ENV_REF_NAME = "resource-env-ref-name";
    public static final String RESOURCE_REF = "resource-ref-binding";
    public static final String RESOURCE_REFS = "resource-ref-bindings";
    public static final String RESOURCE_REF_NAME = "resource-ref-name";
    public static final String USER = "user";
    public static final String VIRTUAL_HOST = "virtual-host";
    public static final String WAR_BINDING = "war-binding";
    public static final String MSGDEST_REF = "message-destination-ref-binding";
    public static final String MSGDEST_REFS = "message-destination-ref-bindings";
    public static final String MSGDEST_REF_NAME = "message-destination-ref-name";
    private String _dataSourceJndiName = null;
    private String _ejbJarName = null;
    private String _ejbName = null;
    private String _jndiName = null;
    private String _password = null;
    private String _resourceRefName = null;
    private String _user = null;
    private boolean _verbose = true;
    private boolean _debugMode = false;
    private Hashtable _datasourceMap = new Hashtable();
    private Hashtable _connectionFactoryMap = new Hashtable();
    private Hashtable _ejbRefMap = new Hashtable();
    private Hashtable _resourceRefMap = new Hashtable();
    private Hashtable _resourceEnvRefMap = new Hashtable();
    private Hashtable _ejbBindingMap = new Hashtable();
    private Hashtable _virtualHostMap = new Hashtable();
    private Hashtable _messageDestinationRefMap = new Hashtable();
    private DataSourceBinding _globalDataSourceBinding = null;
    private ConnectionFactoryBinding _globalConnectionFactoryBinding = null;
    private String _globalVirtualHost = null;

    public CustomizeableStrategy() {
    }

    public CustomizeableStrategy(Preferences preferences) {
        super(preferences);
    }

    public String toString() {
        return "CustomizeableStrategy{ prefs=" + this.preferences + ", ... }";
    }

    public void parse(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", new Object[]{"docuri=" + string});
        }
        DOMParser dOMParser = new DOMParser();
        FileInputStream fileInputStream = new FileInputStream(string);
        InputSource inputSource = new InputSource(fileInputStream);
        Document document = dOMParser.parse(inputSource);
        Node node = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            node = nodeList.item(i);
            break;
        }
        this.parseGlobalBindings(dOMParser, node);
        Node node2 = dOMParser.findChild(node, MODULE_BINDINGS);
        this.parseEjbJarBindings(dOMParser, node2);
        this.parseWarBindings(dOMParser, node2);
        this.parseAppClientBindings(dOMParser, node2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parse -  global DS info: " + this._globalDataSourceBinding);
            Tr.debug(tc, "parse - data source map: " + this._datasourceMap.toString());
            Tr.debug(tc, "parse - ejb ref map : " + this._ejbRefMap.toString());
            Tr.debug(tc, "parse - resrce ref map : " + this._resourceRefMap.toString());
            Tr.debug(tc, "parse - EJB bndngs map : " + this._ejbBindingMap.toString());
        }
    }

    void parseGlobalBindings(DOMParser dOMParser, Node node) {
        String string;
        String string2;
        Object object;
        Node node2 = dOMParser.findChild(node, GLOBAL_BINDINGS);
        Node node3 = dOMParser.findChild(node2, DATASOURCE);
        if (node3 != null) {
            object = dOMParser.findValue(JNDI_NAME, node3, false);
            string2 = dOMParser.findValue(USER, node3, false);
            string = dOMParser.findValue(PASSWORD, node3, false);
            this.setDataSourceBinding(null, null, (String)object, string2, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found global datasource", new Object[]{"jndi=" + (String)object, "user=" + string2, "pwd=" + string});
            }
        }
        if ((object = dOMParser.findChild(node2, CONNFACT)) != null) {
            string2 = dOMParser.findValue(JNDI_NAME, (Node)object, false);
            string = dOMParser.findValue(RESAUTH, (Node)object, false);
            this.setConnectionFactoryBinding(null, null, string2, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found global connection factory", new Object[]{this._globalConnectionFactoryBinding});
            }
        }
        if ((string2 = dOMParser.findValue(VIRTUAL_HOST, node2, false)) != null) {
            this.setVirtualHost(null, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found global virtual host", new Object[]{this._globalVirtualHost});
            }
        }
    }

    void parseEjbJarBindings(DOMParser dOMParser, Node node) {
        Iterator iterator = dOMParser.findChildren(node, EJB_JAR_BINDING).iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Iterator iterator2;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Iterator iterator3;
            Object object10;
            Object object11;
            Node node2;
            Node node3 = (Node)iterator.next();
            String string = dOMParser.findValue(JAR_NAME, node3, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found EJB jar binding", new Object[]{"ejbJarName=" + string});
            }
            if ((node2 = dOMParser.findChild(node3, DATASOURCE)) != null) {
                object11 = dOMParser.findValue(JNDI_NAME, node2, false);
                object10 = dOMParser.findValue(USER, node2, false);
                iterator3 = dOMParser.findValue(PASSWORD, node2, false);
                this.setDataSourceBinding(string, null, (String)object11, (String)object10, (String)((Object)iterator3));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parse - found jar level data source", new Object[]{"jndi=" + (String)object11, "user=" + (String)object10, "password=" + iterator3});
                }
            }
            if ((object11 = dOMParser.findChild(node3, CONNFACT)) != null) {
                object10 = dOMParser.findValue(JNDI_NAME, (Node)object11, false);
                iterator3 = dOMParser.findValue(RESAUTH, (Node)object11, false);
                object9 = new ConnectionFactoryBinding((String)object10, (String)((Object)iterator3));
                this.setConnectionFactoryBinding(string, null, (String)object10, (String)((Object)iterator3));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parser - found jar level connection factory", new Object[]{object9});
                }
            }
            if ((object10 = dOMParser.findChild(node3, EJB_BINDINGS)) != null) {
                iterator3 = dOMParser.findChildren((Node)object10, EJB_BINDING).iterator();
                while (iterator3.hasNext()) {
                    Object object12;
                    Object object13;
                    Object object14;
                    Object object15;
                    Object object16;
                    Object object17;
                    object9 = (Node)iterator3.next();
                    object8 = dOMParser.findValue(EJB_NAME, (Node)object9, false);
                    object7 = dOMParser.findValue(JNDI_NAME, (Node)object9, false);
                    object6 = dOMParser.findChild((Node)object9, DATASOURCE);
                    iterator2 = dOMParser.findChild((Node)object9, CONNFACT);
                    object5 = dOMParser.findValue(LISTERNER_PORT, (Node)object9, false);
                    object4 = dOMParser.findValue(ACTIVATIONSPEC_JNDI_NAME, (Node)object9, false);
                    if (object7 != null) {
                        this.setEjbJndiName(string, (String)object8, (String)object7);
                    }
                    if (object5 != null) {
                        this.setListenerPort(string, (String)object8, (String)object5);
                    }
                    if (object4 != null) {
                        this.setActivationSpecJNDIName(string, (String)object8, (String)object4);
                    }
                    if (object6 != null) {
                        object3 = dOMParser.findValue(JNDI_NAME, (Node)object6, false);
                        object2 = dOMParser.findValue(USER, (Node)object6, false);
                        object = dOMParser.findValue(PASSWORD, (Node)object6, false);
                        this.setDataSourceBinding(string, (String)object8, (String)object3, (String)object2, (String)object);
                    }
                    if (iterator2 != null) {
                        object3 = dOMParser.findValue(JNDI_NAME, (Node)((Object)iterator2), false);
                        object2 = dOMParser.findValue(RESAUTH, (Node)((Object)iterator2), false);
                        this.setConnectionFactoryBinding(string, (String)object8, (String)object3, (String)object2);
                    }
                    object3 = dOMParser.findChild((Node)object9, EJB_REFS);
                    object2 = dOMParser.findChildren((Node)object3, EJB_REF).iterator();
                    while (object2.hasNext()) {
                        object = (Node)object2.next();
                        object17 = dOMParser.findValue(EJB_REF_NAME, (Node)object, false);
                        object16 = dOMParser.findValue(JNDI_NAME, (Node)object, false);
                        Tr.debug(tc, "refName: " + (String)object17 + " refJndiName: " + (String)object16);
                        this.setEjbRefBinding(string, (String)object17, (String)object16);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar ejb ref: " + this.getEjbRefMapElement(string, (String)object17, false).toString());
                    }
                    object = dOMParser.findChild((Node)object9, RESOURCE_REFS);
                    object17 = dOMParser.findChildren((Node)object, RESOURCE_REF).iterator();
                    while (object17.hasNext()) {
                        object16 = (Node)object17.next();
                        object15 = dOMParser.findValue(RESOURCE_REF_NAME, (Node)object16, false);
                        object14 = dOMParser.findValue(JNDI_NAME, (Node)object16, false);
                        this.setResourceRefBinding(string, (String)object8, (String)object15, (String)object14);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar resource ref: " + this.getResourceRefMapElement(string, (String)object8, (String)object15, false).toString());
                    }
                    object16 = dOMParser.findChild((Node)object9, RESOURCE_ENV_REFS);
                    object15 = dOMParser.findChildren((Node)object16, RESOURCE_ENV_REF).iterator();
                    while (object15.hasNext()) {
                        object14 = (Node)object15.next();
                        object13 = dOMParser.findValue(RESOURCE_ENV_REF_NAME, (Node)object14, false);
                        object12 = dOMParser.findValue(JNDI_NAME, (Node)object14, false);
                        this.setResourceEnvRefBinding(string, (String)object8, (String)object13, (String)object12);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar resource env ref: " + this.getResourceEnvRefMapElement(string, (String)object8, (String)object13, false).toString());
                    }
                    object14 = dOMParser.findChild((Node)object9, MSGDEST_REFS);
                    object13 = dOMParser.findChildren((Node)object14, MSGDEST_REF).iterator();
                    while (object13.hasNext()) {
                        object12 = (Node)object13.next();
                        String string2 = dOMParser.findValue(MSGDEST_REF_NAME, (Node)object12, false);
                        String string3 = dOMParser.findValue(JNDI_NAME, (Node)object12, false);
                        this.setMessageDestinationRefBinding(string, (String)object8, string2, string3);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar msg dest ref: " + this.getMessageDestinationRefMapElement(string, (String)object8, string2, false).toString());
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "parse - EJB binding info: ", new Object[]{this.getEjbMapElement(string, (String)object8, true).toString()});
                }
            }
            iterator3 = dOMParser.findChild(node3, EJB_REFS);
            object9 = dOMParser.findChildren((Node)((Object)iterator3), EJB_REF).iterator();
            while (object9.hasNext()) {
                object8 = (Node)object9.next();
                object7 = dOMParser.findValue(EJB_REF_NAME, (Node)object8, false);
                object6 = dOMParser.findValue(JNDI_NAME, (Node)object8, false);
                Tr.debug(tc, "refName: " + (String)object7 + " refJndiName: " + (String)object6);
                this.setEjbRefBinding(string, (String)object7, (String)object6);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar ejb ref: " + this.getEjbRefMapElement(string, (String)object7, false).toString());
            }
            object8 = dOMParser.findChild(node3, RESOURCE_REFS);
            object7 = dOMParser.findChildren((Node)object8, RESOURCE_REF).iterator();
            while (object7.hasNext()) {
                object6 = (Node)object7.next();
                iterator2 = dOMParser.findValue(RESOURCE_REF_NAME, (Node)object6, false);
                object5 = dOMParser.findValue(JNDI_NAME, (Node)object6, false);
                this.setResourceRefBinding(string, null, (String)((Object)iterator2), (String)object5);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar resource ref: " + this.getResourceRefMapElement(string, null, (String)((Object)iterator2), false).toString());
            }
            object6 = dOMParser.findChild(node3, RESOURCE_ENV_REFS);
            iterator2 = dOMParser.findChildren((Node)object6, RESOURCE_ENV_REF).iterator();
            while (iterator2.hasNext()) {
                object5 = (Node)iterator2.next();
                object4 = dOMParser.findValue(RESOURCE_ENV_REF_NAME, (Node)object5, false);
                object3 = dOMParser.findValue(JNDI_NAME, (Node)object5, false);
                this.setResourceEnvRefBinding(string, null, (String)object4, (String)object3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar resource env ref: " + this.getResourceEnvRefMapElement(string, null, (String)object4, false).toString());
            }
            object5 = dOMParser.findChild(node3, MSGDEST_REFS);
            object4 = dOMParser.findChildren((Node)object5, MSGDEST_REF).iterator();
            while (object4.hasNext()) {
                object3 = (Node)object4.next();
                object2 = dOMParser.findValue(MSGDEST_REF_NAME, (Node)object3, false);
                object = dOMParser.findValue(JNDI_NAME, (Node)object3, false);
                this.setMessageDestinationRefBinding(string, null, (String)object2, (String)object);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar msg dest ref: " + this.getMessageDestinationRefMapElement(string, null, (String)object2, false).toString());
            }
        }
    }

    void parseWarBindings(DOMParser dOMParser, Node node) {
        Iterator iterator = dOMParser.findChildren(node, WAR_BINDING).iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Node node2;
            String string3;
            Node node3 = (Node)iterator.next();
            String string4 = dOMParser.findValue(JAR_NAME, node3, false);
            Node node4 = dOMParser.findChild(node3, EJB_REFS);
            Node node5 = dOMParser.findChild(node3, RESOURCE_REFS);
            Node node6 = dOMParser.findChild(node3, RESOURCE_ENV_REFS);
            Iterator iterator2 = dOMParser.findChildren(node4, EJB_REF).iterator();
            Iterator iterator3 = dOMParser.findChildren(node5, RESOURCE_REF).iterator();
            Iterator iterator4 = dOMParser.findChildren(node6, RESOURCE_ENV_REF).iterator();
            Node node7 = dOMParser.findChild(node3, MSGDEST_REFS);
            Iterator iterator5 = dOMParser.findChildren(node7, MSGDEST_REF).iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found .war bindings for " + string4);
            }
            if ((string3 = dOMParser.findValue(VIRTUAL_HOST, node3, false)) != null) {
                this.setVirtualHost(string4, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parse - war virtual host: ", string3);
                }
            }
            while (iterator2.hasNext()) {
                node2 = (Node)iterator2.next();
                string2 = dOMParser.findValue(EJB_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                Tr.debug(tc, "refName: " + string2 + " refJndiName: " + string);
                this.setEjbRefBinding(string4, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war ejb ref: " + this.getEjbRefMapElement(string4, string2, false).toString());
            }
            while (iterator3.hasNext()) {
                node2 = (Node)iterator3.next();
                string2 = dOMParser.findValue(RESOURCE_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceRefBinding(string4, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war resource ref info: " + this.getResourceRefMapElement(string4, null, string2, false).toString());
            }
            while (iterator4.hasNext()) {
                node2 = (Node)iterator4.next();
                string2 = dOMParser.findValue(RESOURCE_ENV_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceEnvRefBinding(string4, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war resource env ref: " + this.getResourceEnvRefMapElement(string4, null, string2, false).toString());
            }
            while (iterator5.hasNext()) {
                node2 = (Node)iterator5.next();
                string2 = dOMParser.findValue(MSGDEST_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setMessageDestinationRefBinding(string4, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war msg dest ref: " + this.getMessageDestinationRefMapElement(string4, null, string2, false).toString());
            }
        }
    }

    void parseAppClientBindings(DOMParser dOMParser, Node node) {
        Iterator iterator = dOMParser.findChildren(node, JAVA_BINDING).iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Node node2;
            Node node3 = (Node)iterator.next();
            String string3 = dOMParser.findValue(JAR_NAME, node3, false);
            Node node4 = dOMParser.findChild(node3, EJB_REFS);
            Iterator iterator2 = dOMParser.findChildren(node4, EJB_REF).iterator();
            Node node5 = dOMParser.findChild(node3, RESOURCE_REFS);
            Iterator iterator3 = dOMParser.findChildren(node5, RESOURCE_REF).iterator();
            Node node6 = dOMParser.findChild(node3, RESOURCE_ENV_REFS);
            Iterator iterator4 = dOMParser.findChildren(node6, RESOURCE_ENV_REF).iterator();
            Node node7 = dOMParser.findChild(node3, MSGDEST_REFS);
            Iterator iterator5 = dOMParser.findChildren(node7, MSGDEST_REF).iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found client bindings for " + string3);
            }
            while (iterator2.hasNext()) {
                node2 = (Node)iterator2.next();
                string2 = dOMParser.findValue(EJB_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                Tr.debug(tc, "refName: " + string2 + " refJndiName: " + string);
                this.setEjbRefBinding(string3, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client ejb ref: " + this.getEjbRefMapElement(string3, string2, false).toString());
            }
            while (iterator3.hasNext()) {
                node2 = (Node)iterator3.next();
                string2 = dOMParser.findValue(RESOURCE_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceRefBinding(string3, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client resource ref info: " + this.getResourceRefMapElement(string3, null, string2, false).toString());
            }
            while (iterator4.hasNext()) {
                node2 = (Node)iterator4.next();
                string2 = dOMParser.findValue(RESOURCE_ENV_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setResourceEnvRefBinding(string3, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client resource env ref: " + this.getResourceEnvRefMapElement(string3, null, string2, false).toString());
            }
            while (iterator5.hasNext()) {
                node2 = (Node)iterator5.next();
                string2 = dOMParser.findValue(MSGDEST_REF_NAME, node2, false);
                string = dOMParser.findValue(JNDI_NAME, node2, false);
                this.setMessageDestinationRefBinding(string3, null, string2, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client msg dest ref: " + this.getMessageDestinationRefMapElement(string3, null, string2, false).toString());
            }
        }
    }

    public DataSourceBinding getDefaultDatasourceBindings(String string, DataSourceBinding dataSourceBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        DataSourceBinding dataSourceBinding2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDatasourceBindings", new Object[]{"ejbJar=" + string, "defaults=" + dataSourceBinding});
        }
        if ((dataSourceBinding2 = (DataSourceBinding)this._datasourceMap.get(string)) == null) {
            dataSourceBinding2 = this._globalDataSourceBinding != null ? this._globalDataSourceBinding : super.getDefaultDatasourceBindings(string, dataSourceBinding, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDatasourceBindings", new Object[]{"ejbJar=" + string, "defaults=" + dataSourceBinding, "result=" + dataSourceBinding2});
        }
        return dataSourceBinding2;
    }

    public ConnectionFactoryBinding getDefaultConnectionFactoryBindings(String string, ConnectionFactoryBinding connectionFactoryBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        ConnectionFactoryBinding connectionFactoryBinding2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultConnectionFactoryBindings", new Object[]{"ejbJar=" + string, "defaults=" + connectionFactoryBinding});
        }
        if ((connectionFactoryBinding2 = (ConnectionFactoryBinding)this._connectionFactoryMap.get(string)) == null) {
            connectionFactoryBinding2 = this._globalConnectionFactoryBinding != null ? this._globalConnectionFactoryBinding : super.getDefaultConnectionFactoryBindings(string, connectionFactoryBinding, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultConnectionFactoryBindings", new Object[]{"ejbJar=" + string, "defaults=" + connectionFactoryBinding, "result=" + connectionFactoryBinding2});
        }
        return connectionFactoryBinding2;
    }

    public String getEJBBinding(EjbId ejbId, String string, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBBinding", new Object[]{"ejbInfo=" + ejbId, "default=" + string});
        }
        String string2 = ejbId.getEjbName();
        String string3 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(string2);
        if (ejbBindingMapElement != null && ejbBindingMapElement.jndiName != null) {
            this._ejbNameMap.setProperty(string2, ejbBindingMapElement.jndiName);
            if (ejbId.getHomeInterface() != null) {
                this._ejbHomeMap.setProperty(ejbId.getHomeInterface(), ejbBindingMapElement.jndiName);
            }
            if (ejbId.getLocalInterface() != null) {
                this._ejbHomeMap.setProperty(ejbId.getLocalInterface(), ejbBindingMapElement.jndiName);
            }
            string3 = ejbBindingMapElement.jndiName;
        } else {
            string3 = super.getEJBBinding(ejbId, string, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBBinding", new Object[]{"ejbInfo=" + ejbId, "default=" + string, "result=" + string3});
        }
        return string3;
    }

    public ConnectionFactoryBinding getEJBConnectionFactoryBinding(EjbId ejbId, ConnectionFactoryBinding connectionFactoryBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBConnectionFactoryBinding", new Object[]{"ejbInfo=" + ejbId, "defaults=" + connectionFactoryBinding});
        }
        ConnectionFactoryBinding connectionFactoryBinding2 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(ejbId.getEjbName());
        connectionFactoryBinding2 = ejbBindingMapElement != null && ejbBindingMapElement.connFactInfo != null ? ejbBindingMapElement.connFactInfo : super.getEJBConnectionFactoryBinding(ejbId, connectionFactoryBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBConnectionFactoryBinding", new Object[]{"ejbInfo=" + ejbId, "defaults=" + connectionFactoryBinding, "result=" + connectionFactoryBinding2});
        }
        return connectionFactoryBinding2;
    }

    public DataSourceBinding getEJBDatasourceBinding(EjbId ejbId, DataSourceBinding dataSourceBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBDatasourceBinding", new Object[]{"ejbInfo=" + ejbId, "defaults=" + dataSourceBinding});
        }
        DataSourceBinding dataSourceBinding2 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(ejbId.getEjbName());
        dataSourceBinding2 = ejbBindingMapElement != null && ejbBindingMapElement.dataSourceInfo != null ? new DataSourceBinding(ejbBindingMapElement.dataSourceInfo.jndiName, ejbBindingMapElement.dataSourceInfo.user, ejbBindingMapElement.dataSourceInfo.password) : super.getEJBDatasourceBinding(ejbId, dataSourceBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBDatasourceBinding", new Object[]{"ejbInfo=" + ejbId, "defaults=" + dataSourceBinding, "result=" + dataSourceBinding2});
        }
        return dataSourceBinding2;
    }

    public String getMDBListenerPort(String string, String string2, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMDBListenerPort", new Object[]{"mdbName=" + string, "defaults=" + string2});
        }
        String string3 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(string);
        string3 = ejbBindingMapElement != null && ejbBindingMapElement.listenerPort != null ? ejbBindingMapElement.listenerPort : super.getMDBListenerPort(string, string2, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMDBListenerPort", new Object[]{"mdbName=" + string, "defaults=" + string2, "result=" + string3});
        }
        return string3;
    }

    public String getMDBActivationSpec(String string, String string2, boolean bl, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMDBActivationSpec", new Object[]{"mdbName=" + string, "defaults=" + string2, "bCreate=" + bl});
        }
        String string3 = null;
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(string);
        if (ejbBindingMapElement != null && ejbBindingMapElement.activationSpecJNDIName != null) {
            string3 = ejbBindingMapElement.activationSpecJNDIName;
        } else if (bl) {
            string3 = super.getMDBActivationSpec(string, string2, bl, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMDBActivationSpec", new Object[]{"mdbName=" + string, "defaults=" + string2, "result=" + string3});
        }
        return string3;
    }

    public String getVirtualHost(String string, String string2, BindingStrategy.WarningCollaborator warningCollaborator) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVirtualHost", new Object[]{"virtualHost=" + string});
        }
        if ((string3 = (String)this._virtualHostMap.get(string2)) == null) {
            String string4 = string3 = this._globalVirtualHost != null ? this._globalVirtualHost : super.getVirtualHost(string, string2, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVirtualHost", new Object[]{"virtualHost=" + string3});
        }
        return string3;
    }

    public String getEJBRefBinding(EjbId ejbId, String string, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBRefBinding", new Object[]{"ejbInfo=" + ejbId, "default=" + string});
        }
        String string2 = null;
        EjbRefMapElement ejbRefMapElement = this.getEjbRefMapElement(null, ejbId.getEjbName(), false);
        Tr.debug(tc, "binding: " + ejbRefMapElement);
        string2 = ejbRefMapElement != null && ejbRefMapElement.jndiName != null ? ejbRefMapElement.jndiName : super.getEJBRefBinding(ejbId, string, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBRefBinding", new Object[]{"ejbInfo=" + ejbId, "default=" + string, "result=" + string2});
        }
        return string2;
    }

    public String getResourceRefBinding(String string, String string2, String string3, String string4, String string5, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceRefBinding", new Object[]{"res-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5});
        }
        String string6 = null;
        ResourceRefMapElement resourceRefMapElement = this.getResourceRefMapElement(string3, string4, string, false);
        if (resourceRefMapElement == null && string4 != null) {
            resourceRefMapElement = this.getResourceRefMapElement(string3, null, string, false);
        }
        string6 = resourceRefMapElement != null ? resourceRefMapElement.jndiName : super.getResourceRefBinding(string, string2, string3, string4, string5, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceRefBinding", new Object[]{"res-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5, "result=" + string6});
        }
        return string6;
    }

    public String getResourceEnvRefBinding(String string, String string2, String string3, String string4, String string5, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceEnvRefBinding", new Object[]{"res-env-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5});
        }
        String string6 = null;
        ResourceRefMapElement resourceRefMapElement = this.getResourceEnvRefMapElement(string3, string4, string, false);
        if (resourceRefMapElement == null && string4 != null) {
            resourceRefMapElement = this.getResourceEnvRefMapElement(string3, null, string, false);
        }
        string6 = resourceRefMapElement != null ? resourceRefMapElement.jndiName : super.getResourceEnvRefBinding(string, string2, string3, string4, string5, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceEnvRefBinding", new Object[]{"res-env-ref=" + string, "type=" + string2, "module=" + string3, "default=" + string5, "result=" + string6});
        }
        return string6;
    }

    public String getMessageDestinationRefBinding(String string, String string2, String string3, String string4, String string5, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageDestinationRefBinding", new Object[]{"res-env-ref=" + string, "module=" + string3, "default=" + string5});
        }
        String string6 = null;
        ResourceRefMapElement resourceRefMapElement = this.getMessageDestinationRefMapElement(string3, string4, string, false);
        if (resourceRefMapElement == null && string4 != null) {
            resourceRefMapElement = this.getMessageDestinationRefMapElement(string3, null, string, false);
        }
        string6 = resourceRefMapElement != null ? resourceRefMapElement.jndiName : super.getMessageDestinationRefBinding(string, string2, string3, string4, string5, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageDestinationRefBinding", new Object[]{"res-env-ref=" + string, "module=" + string3, "default=" + string5, "result=" + string6});
        }
        return string6;
    }

    public void setDataSourceBinding(String string, String string2, String string3, String string4, String string5) {
        DataSourceBinding dataSourceBinding = new DataSourceBinding(string3, string4, string5);
        if (string != null) {
            if (string2 != null) {
                this.getEjbMapElement((String)string, (String)string2, (boolean)true).dataSourceInfo = new DataSourceMapElement(string3, string4, string5);
            } else {
                this._datasourceMap.put(string, dataSourceBinding);
            }
        } else {
            this._globalDataSourceBinding = dataSourceBinding;
        }
    }

    public void setConnectionFactoryBinding(String string, String string2, String string3, String string4) {
        ConnectionFactoryBinding connectionFactoryBinding = new ConnectionFactoryBinding(string3, string4);
        if (string != null) {
            if (string2 != null) {
                this.getEjbMapElement((String)string, (String)string2, (boolean)true).connFactInfo = new ConnectionFactoryBinding(string3, string4);
            } else {
                this._connectionFactoryMap.put(string, connectionFactoryBinding);
            }
        } else {
            this._globalConnectionFactoryBinding = connectionFactoryBinding;
        }
    }

    public void setVirtualHost(String string, String string2) {
        if (string != null) {
            this._virtualHostMap.put(string, string2);
        } else {
            this._globalVirtualHost = string2;
        }
    }

    public void setListenerPort(String string, String string2, String string3) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).listenerPort = string3;
    }

    public void setActivationSpecJNDIName(String string, String string2, String string3) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).activationSpecJNDIName = string3;
    }

    public void setEjbJndiName(String string, String string2, String string3) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).jndiName = string3;
    }

    public void setEjbDatasource(String string, String string2, String string3, String string4, String string5) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).dataSourceInfo = new DataSourceMapElement(string3, string4, string5);
    }

    public void setEjbConnectionFactory(String string, String string2, String string3, String string4) {
        this.getEjbMapElement((String)string, (String)string2, (boolean)true).connFactInfo = new ConnectionFactoryBinding(string3, string4);
    }

    public void setEjbRefBinding(String string, String string2, String string3) {
        this.getEjbRefMapElement((String)string, (String)string2, (boolean)true).jndiName = string3;
    }

    public void setResourceRefBinding(String string, String string2, String string3, String string4) {
        this.getResourceRefMapElement((String)string, (String)string2, (String)string3, (boolean)true).jndiName = string4;
    }

    public void setResourceEnvRefBinding(String string, String string2, String string3, String string4) {
        this.getResourceEnvRefMapElement((String)string, (String)string2, (String)string3, (boolean)true).jndiName = string4;
    }

    public void setMessageDestinationRefBinding(String string, String string2, String string3, String string4) {
        this.getMessageDestinationRefMapElement((String)string, (String)string2, (String)string3, (boolean)true).jndiName = string4;
    }

    EjbBindingMapElement getEjbMapElement(String string, String string2, boolean bl) {
        EjbBindingMapElement ejbBindingMapElement = (EjbBindingMapElement)this._ejbBindingMap.get(string2);
        if (ejbBindingMapElement == null && bl) {
            ejbBindingMapElement = new EjbBindingMapElement(null, null, null, null, null);
            this._ejbBindingMap.put(string2, ejbBindingMapElement);
        }
        return ejbBindingMapElement;
    }

    EjbRefMapElement getEjbRefMapElement(String string, String string2, boolean bl) {
        EjbRefMapElement ejbRefMapElement = (EjbRefMapElement)this._ejbRefMap.get(string2);
        if (ejbRefMapElement == null && bl) {
            ejbRefMapElement = new EjbRefMapElement(null);
            this._ejbRefMap.put(string2, ejbRefMapElement);
        }
        return ejbRefMapElement;
    }

    ResourceRefMapElement getResourceRefMapElement(String string, String string2, String string3, boolean bl) {
        String string4 = string + "-" + string2 + "-" + string3;
        ResourceRefMapElement resourceRefMapElement = (ResourceRefMapElement)this._resourceRefMap.get(string4);
        if (resourceRefMapElement == null && bl) {
            resourceRefMapElement = new ResourceRefMapElement(null);
            this._resourceRefMap.put(string4, resourceRefMapElement);
        }
        return resourceRefMapElement;
    }

    ResourceRefMapElement getResourceEnvRefMapElement(String string, String string2, String string3, boolean bl) {
        String string4 = string + "-" + string2 + "-" + string3;
        ResourceRefMapElement resourceRefMapElement = (ResourceRefMapElement)this._resourceEnvRefMap.get(string4);
        if (resourceRefMapElement == null && bl) {
            resourceRefMapElement = new ResourceRefMapElement(null);
            this._resourceEnvRefMap.put(string4, resourceRefMapElement);
        }
        return resourceRefMapElement;
    }

    ResourceRefMapElement getMessageDestinationRefMapElement(String string, String string2, String string3, boolean bl) {
        String string4 = string + "-" + string2 + "-" + string3;
        ResourceRefMapElement resourceRefMapElement = (ResourceRefMapElement)this._messageDestinationRefMap.get(string4);
        if (resourceRefMapElement == null && bl) {
            resourceRefMapElement = new ResourceRefMapElement(null);
            this._messageDestinationRefMap.put(string4, resourceRefMapElement);
        }
        return resourceRefMapElement;
    }

    private class EjbBindingMapElement {
        public String jndiName = null;
        public DataSourceMapElement dataSourceInfo = null;
        public ConnectionFactoryBinding connFactInfo = null;
        public String listenerPort = null;
        public String activationSpecJNDIName = null;

        public EjbBindingMapElement(String string, DataSourceMapElement dataSourceMapElement, ConnectionFactoryBinding connectionFactoryBinding, String string2, String string3) {
            this.jndiName = string;
            this.dataSourceInfo = dataSourceMapElement;
            this.connFactInfo = connectionFactoryBinding;
            this.listenerPort = string2;
            this.activationSpecJNDIName = string3;
        }

        public String toString() {
            return "{" + this.jndiName + "," + (this.dataSourceInfo != null ? this.dataSourceInfo.toString() : "{null}") + "," + this.connFactInfo + "," + this.listenerPort + ", " + this.activationSpecJNDIName + "}";
        }
    }

    private class ResourceRefMapElement {
        public String jndiName = null;

        public ResourceRefMapElement(String string) {
            this.jndiName = string;
        }

        public String toString() {
            return "{" + this.jndiName + "}";
        }
    }

    private class EjbRefMapElement {
        public String jndiName = null;

        public EjbRefMapElement(String string) {
            this.jndiName = string;
        }

        public String toString() {
            return "{" + this.jndiName + "}";
        }
    }

    private class DataSourceMapElement {
        public String jndiName = null;
        public String user = null;
        public String password = null;

        public DataSourceMapElement(String string, String string2, String string3) {
            this.jndiName = string;
            this.user = string2;
            this.password = string3;
        }

        public String toString() {
            return "{" + this.jndiName + "," + this.user + "," + this.password + "}";
        }
    }
}

