/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client.driver;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTaskMessages;
import com.ibm.ws.management.application.AppUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class UninstallApp
implements AppNotification.Listener,
NotificationListener {
    public static final String USEJMX = "usejmx";
    private static final String TRACE_PROP = "com.ibm.ejs.ras.traceString";
    private static final String TRACE_FILE_PROP = "com.ibm.ejs.ras.traceFile";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String TYPE = "conntype";
    public static final String HOST_DEFAULT = "localhost";
    public static final String PORT_DEFAULT = "8880";
    public static final String TYPE_DEFAULT = "SOAP";
    public static final String TIMEOUT = "timeout";
    private static ResourceBundle resBundle;
    public static final int TIMEOUT_DEFAULT = 300;
    private static boolean bOSGIWAIT;
    private static final long MAX_WAIT_TIME = 600000L;
    private final String waitObject = "waitObject";
    private static TraceComponent tc;
    private static Vector lSide;
    private static Vector rSide;
    private Hashtable argOptions;
    private ObjectName on;
    AdminClient soapClient;
    private String appName;
    private AppDeploymentMessages msgs = new AppDeploymentTaskMessages();

    public static void main(String[] stringArray) {
        if (stringArray.length < 1 || stringArray[0].equals("")) {
            UninstallApp.displayHelp();
            System.exit(0);
        }
        UninstallApp.setTrace();
        resBundle = AppUtils.getBundle(null);
        String string = stringArray[0];
        Hashtable hashtable = UninstallApp.parseCmdLine(stringArray);
        UninstallApp.dbg("");
        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6051I"));
        UninstallApp uninstallApp = new UninstallApp(string, hashtable);
        uninstallApp.uninstall();
    }

    public static void osgimain(String[] stringArray) throws Exception {
        bOSGIWAIT = true;
        UninstallApp.main(stringArray);
    }

    private static void setTrace() {
        String string = System.getProperty(TRACE_PROP);
        if (string == null || string.trim().equals("")) {
            return;
        }
        String string2 = "stdout";
        String string3 = System.getProperty(TRACE_FILE_PROP);
        if (string3 != null) {
            string2 = "named file";
        }
        ManagerAdmin.configureClientTrace(string, string2, string3, true, null, false);
    }

    private static void dbg(Object object) {
        System.out.println(object);
    }

    private static void errorAndExit(String string) {
        System.out.println(string);
        System.exit(-1);
    }

    private static void createOptionsText(boolean bl) {
        lSide = new Vector();
        if (!bl) {
            rSide = new Vector();
        }
        lSide.addElement("was.install.root");
        if (!bl) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("config.root");
        if (!bl) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("node.name");
        if (!bl) {
            rSide.addElement("node (default is hostname)");
        }
        lSide.addElement("cell.name");
        if (!bl) {
            rSide.addElement("cell (default is BaseApplicationServerCell)");
        }
        lSide.addElement("server.name");
        if (!bl) {
            rSide.addElement("server (default is server1)");
        }
        lSide.addElement("cluster.name");
        if (!bl) {
            rSide.addElement("cluster");
        }
        lSide.addElement(USEJMX);
        if (!bl) {
            rSide.addElement("(performs installation by calling AppManagementMBean)");
        }
        lSide.addElement(HOST);
        if (!bl) {
            rSide.addElement("host name used for -usejmx option, default is localhost");
        }
        lSide.addElement(PORT);
        if (!bl) {
            rSide.addElement("port num used for -usejmx option, default is 8880");
        }
        lSide.addElement(TYPE);
        if (!bl) {
            rSide.addElement("conntype used for -usejmx option, default is SOAP");
        }
        lSide.addElement(TIMEOUT);
        if (!bl) {
            rSide.addElement("timeout (sec) to wait for JMX events, default is 300, -1 for no timeout");
        }
    }

    private static void displayHelp() {
        UninstallApp.dbg("Usage syntax is: UninstallApp applicationName [[-option.name optionValue]...]");
        UninstallApp.dbg("");
        UninstallApp.dbg("Valid options are:");
        UninstallApp.dbg("==================");
        UninstallApp.createOptionsText(false);
        for (int i = 0; i < lSide.size(); ++i) {
            UninstallApp.dbg("\t-" + lSide.elementAt(i) + " " + rSide.elementAt(i));
        }
        UninstallApp.dbg("");
        UninstallApp.dbg("==================");
        UninstallApp.dbg("");
        UninstallApp.dbg("For example: ");
        UninstallApp.dbg("UninstallApp sampleApp -[usejmx]");
    }

    private static String fixPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (File.separatorChar == '/') {
            string2 = string2.replace('\\', File.separatorChar);
        }
        if (File.separatorChar == '\\') {
            string2 = string2.replace('/', File.separatorChar);
        }
        return string2;
    }

    private static Hashtable parseCmdLine(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseCmdLine");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        UninstallApp.createOptionsText(true);
        for (int i = 1; i < stringArray.length; ++i) {
            String string;
            if (!stringArray[i].startsWith("-")) {
                UninstallApp.errorAndExit("Usage error: expected option name beginning with \"-\"; found " + stringArray[i]);
            }
            if (!lSide.contains(string = stringArray[i].substring(1, stringArray[i].length()))) {
                UninstallApp.errorAndExit("Invalid option: " + string);
            }
            if (string.equals(USEJMX)) {
                hashtable.put(string, new Boolean(true));
                continue;
            }
            String string2 = stringArray[i + 1];
            hashtable.put(string, string2);
            ++i;
        }
        if (hashtable.get(USEJMX) != null) {
            if (hashtable.get(HOST) == null) {
                hashtable.put(HOST, HOST_DEFAULT);
            }
            if (hashtable.get(PORT) == null) {
                hashtable.put(PORT, PORT_DEFAULT);
            }
            if (hashtable.get(TYPE) == null) {
                hashtable.put(TYPE, TYPE_DEFAULT);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseCmdLine");
        }
        return hashtable;
    }

    public UninstallApp(String string, Hashtable hashtable) {
        this.appName = string;
        this.argOptions = hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void uninstall() {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uninstall");
            }
            try {
                this.printOptions(this.argOptions);
                if (this.argOptions.get(USEJMX) == null) {
                    block16: {
                        UninstallApp.dbg("");
                        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6052I"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating local AppManagementImpl");
                        }
                        AppManagement appManagement = AppManagementFactory.createLocalAppManagementImpl();
                        String string = "waitObject";
                        // MONITORENTER : "waitObject"
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Before uninstallApplication");
                        }
                        appManagement.uninstallApplicationLocal(this.appName, this.argOptions, this, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "After uninstallApplication");
                        }
                        try {
                            if (bOSGIWAIT) {
                                "waitObject".wait(600000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (!tc.isDebugEnabled()) break block16;
                            Tr.debug(tc, "Interrupted; time to work.");
                        }
                    }
                    // MONITOREXIT : string
                    break block17;
                }
                Properties properties = new Properties();
                properties.put(HOST, (String)this.argOptions.get(HOST));
                properties.put(PORT, (String)this.argOptions.get(PORT));
                properties.put("type", (String)this.argOptions.get(TYPE));
                this.soapClient = AdminClientFactory.createAdminClient(properties);
                this.on = this.getObjectName(this.soapClient);
                UninstallApp.dbg("App Management object name = " + this.on);
                boolean bl = false;
                try {
                    NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                    notificationFilterSupport.enableType("websphere.admin.appmgmt");
                    this.soapClient.addNotificationListener(this.on, this, (NotificationFilter)notificationFilterSupport, (Object)("Uninstall:" + this.appName));
                    bl = true;
                }
                catch (Throwable throwable) {
                    UninstallApp.dbg("Error: Could not add listener to JMX MBean: " + throwable);
                }
                this.soapClient.invoke(this.on, "uninstallApplication", new Object[]{this.appName, this.argOptions, null}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"});
                UninstallApp.dbg("After invoking uninstallApplication.");
                boolean bl2 = this.waitForTimeout((String)this.argOptions.get(TIMEOUT));
                if (!bl2) break block17;
                UninstallApp.dbg("Operation timed out.");
                if (bl) {
                    this.soapClient.removeNotificationListener(this.on, this);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception is " + exception);
                }
                UninstallApp.errorAndExit(exception.getMessage());
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "uninstall");
    }

    private ObjectName getObjectName(AdminClient adminClient) throws Exception {
        ObjectName objectName;
        int n;
        ObjectName objectName2 = new ObjectName("WebSphere:type=AppManagement,*");
        Iterator iterator = adminClient.queryNames(objectName2, null).iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            ObjectName objectName3 = (ObjectName)vector.elementAt(0);
            UninstallApp.dbg("App Management object name = " + objectName3);
            return objectName3;
        }
        for (n = 0; n < vector.size(); ++n) {
            objectName = (ObjectName)vector.elementAt(n);
            if (!objectName.getKeyProperty("process").equals("dmgr")) continue;
            ObjectName objectName4 = objectName;
            UninstallApp.dbg("App Management object name = " + objectName4);
            return objectName4;
        }
        for (n = 0; n < vector.size(); ++n) {
            objectName = (ObjectName)vector.elementAt(n);
            if (!objectName.getKeyProperty("process").equals(objectName.getKeyProperty("node"))) continue;
            UninstallApp.dbg("App Management object name = " + objectName);
            return objectName;
        }
        ObjectName objectName5 = (ObjectName)vector.elementAt(0);
        UninstallApp.dbg("App Management object name = " + objectName5);
        return objectName5;
    }

    private boolean waitForTimeout(String string) {
        try {
            int n = 300;
            if (string != null) {
                n = new Integer(string);
            }
            if (n == -1) {
                return false;
            }
            int n2 = 5;
            while (n > 0) {
                Thread.sleep(n2 * 1000);
                n -= n2;
                UninstallApp.dbg("..");
            }
            return true;
        }
        catch (Throwable throwable) {
            UninstallApp.dbg("Error in waiting for JMX events.." + throwable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error in waiting for JMX events.. " + throwable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void appEventReceived(AppNotification appNotification) {
        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6053I") + appNotification);
        if (!appNotification.taskStatus.equals("Completed")) {
            if (!appNotification.taskStatus.equals("Failed")) return;
        }
        if (this.soapClient != null) {
            try {
                this.soapClient.removeNotificationListener(this.on, this);
            }
            catch (Throwable throwable) {
                UninstallApp.dbg("Error removing listener: " + throwable);
            }
        }
        if (bOSGIWAIT) {
            String string = "waitObject";
            // MONITORENTER : "waitObject"
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got STATUS_COMPLETED");
            }
            "waitObject".notify();
            // MONITOREXIT : string
        }
        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6009I"));
        if (this.soapClient == null) return;
        System.exit(0);
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification == null) {
            UninstallApp.dbg("!! JMX event Recd: (handback obj= " + object + "): " + "Notification object is null");
            return;
        }
        Object object2 = notification.getUserData();
        UninstallApp.dbg("!! JMX event Recd: (handback obj= " + object + "): " + object2);
        if (object2 instanceof AppNotification) {
            this.appEventReceived((AppNotification)object2);
        }
    }

    private void printOptions(Hashtable hashtable) {
        UninstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            UninstallApp.dbg("");
            UninstallApp.dbg(k + " ----> " + hashtable.get(k));
        }
        UninstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
    }

    static {
        bOSGIWAIT = false;
        tc = Tr.register(UninstallApp.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    }
}

