/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.cdfj2eebridge.CDFBridgeExtensionHelper;
import java.util.Hashtable;
import java.util.Vector;

public class UninstallSchedulerImpl
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register(UninstallSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public UninstallSchedulerImpl(String string, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string, hashtable, appManagement, listener);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UninstallSchedulerImpl");
        }
        this.appTaskName = "UninstallApplication";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UninstallSchedulerImpl");
        }
    }

    protected void setupTasks() throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        Object object2 = null;
        try {
            object = new EditApplication(this.appName, this.properties, null, this.getWorkSpace().getUserName(), this.appManagement);
            object2 = ((EditApplication)object).checkIfAppExists();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App " + this.appName + " exists: " + object2);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.UninstallSchedulerImpl.setupTasks", "80", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in checking app existence: " + this.appName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, throwable.toString());
            }
            if (this.resBundle != null) {
                throw new AdminException(throwable, AppUtils.getMessage(this.resBundle, "ADMA0054E", new Object[]{this.appName}));
            }
            throw new AdminException(throwable);
        }
        if (object2 == null) {
            object = AppUtils.getMessage(this.resBundle, "ADMA5108E", new String[]{this.appName});
            throw new AdminException((String)object);
        }
        boolean bl = this.appName.equals(object2);
        if (bl) {
            boolean bl2 = this.getProperties().get("cluster.name") != null && bl;
            AppUtils.dbg(tc, "isSystemAppCluster = " + bl2);
            if (bl2) {
                Tr.debug(tc, "Detected system app uninstall on cluster - ");
                if (this.getProperties().get("cell.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125E", new String[]{this.appName}));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected system app uninstall: " + this.appName);
                }
                if (this.getProperties().get("cell.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125", new String[]{this.appName}));
                }
                if (this.getProperties().get("node.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0126", new String[]{this.appName}));
                }
            }
            this.getProperties().put("META-INF/ibm-application-sa.props", Boolean.TRUE);
        }
        this.tasks = new Vector();
        new DefaultTaskProvider().provideServerUninstallExtensions(this.tasks, this);
        if (!bl) {
            this.tasks = ExtensionHelper.processServerUninstallExtensions(this.properties, this.tasks, this);
            CDFBridgeExtensionHelper.processServerUninstallExtensions(this.properties, this.tasks, this);
        }
        Tr.debug(tc, "The tasks are: " + this.tasks);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.uninstall";
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, bl ? "ADMA5106I" : "ADMA5107E", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("UninstallApplication", "", bl ? "Completed" : "Failed", "", string);
        return appNotification;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStartEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, "ADMA5017I", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("UninstallApplication", "", "InProgress", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStartEvent");
        }
        return appNotification;
    }

    protected void performCleanup(boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performCleanup");
        }
        if (!bl && !this.amIWorkSpaceOwner) {
            String string = "An uninstall application operation failed and the configuration session could not be restored to its state before the operation was initiated. The configuration session is in an inconsistent state, and changes made in the session should be discarded.";
            if (this.resBundle != null) {
                string = AppUtils.getMessage(this.resBundle, "ADMA0186W");
            }
            AppNotification appNotification = new AppNotification("UninstallApplication", "", "Warning", "", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performCleanup");
        }
    }
}

