/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.J2EEAppDeployment;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentManagerImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.exceptions.J2EEDeployTargetException;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class J2EEAppDeploymentImpl
extends RuntimeCollaborator
implements J2EEAppDeployment {
    public static final String TEMP_EXTRACT_DIR = "Temp extraction dir for multiserver";
    public static final String CONFIG_ROOT = "Config Root for variable map";
    private static TraceComponent tc = Tr.register(J2EEAppDeploymentImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.AppDeploymentMessages");
    private Hashtable _props;
    private static ObjectName objectName;
    private static long seqNum;

    public J2EEAppDeploymentImpl(Hashtable hashtable) {
        this._props = hashtable;
    }

    public Hashtable getGlobalSettings() {
        return this._props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target[] getTargets(Hashtable hashtable, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargets");
        }
        WorkSpace workSpace = null;
        Target[] targetArray = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string);
            Hashtable hashtable2 = this.getServers(workSpace);
            Hashtable hashtable3 = this.getClusters(hashtable2, workSpace);
            targetArray = new Target[hashtable3.size()];
            if (!hashtable3.isEmpty()) {
                Iterator iterator = hashtable3.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    targetArray[n] = (Target)iterator.next();
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.websphere.management.application.AppManagementImpl.getTargets", "1064");
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        }
        finally {
            EditApplication.doFinally(workSpace, string, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargets");
            }
        }
        return targetArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getServers(WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServers");
        }
        Hashtable<String, TargetImpl> hashtable = new Hashtable<String, TargetImpl>();
        try {
            Object object;
            String string = AdminServiceFactory.getAdminService().getCellName();
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
            Object[] objectArray = AppUtils.getContextArray("nodes", repositoryContext, workSpace);
            Vector<RepositoryContext> vector = new Vector<RepositoryContext>();
            for (int i = 0; i < objectArray.length; ++i) {
                object = (RepositoryContext)objectArray[i];
                vector.add((RepositoryContext)object);
            }
            Enumeration enumeration = vector.elements();
            object = ConfigRepoHelper.getServerIndexDocs(workSpace, enumeration);
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server index docs not found!!");
                }
                Hashtable<String, TargetImpl> hashtable2 = hashtable;
                return hashtable2;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                RepositoryContext repositoryContext2 = (RepositoryContext)objectArray[i];
                Resource resource = (Resource)((Hashtable)object).get(repositoryContext2);
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                ServerEntry serverEntry = null;
                Object var15_17 = null;
                for (int j = 0; j < eList.size(); ++j) {
                    serverEntry = (ServerEntry)eList.get(j);
                    if (!serverEntry.getServerType().equals("APPLICATION_SERVER")) continue;
                    TargetImpl targetImpl = new TargetImpl(serverEntry.getServerName(), repositoryContext2.getName(), string, serverEntry.getServerDisplayName(), false);
                    targetImpl.setNode(repositoryContext2.getName());
                    targetImpl.setCell(string);
                    targetImpl.setCluster(false);
                    hashtable.put(serverEntry.getServerName() + "," + repositoryContext2.getName(), targetImpl);
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServers");
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getClusters(Hashtable hashtable, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusters");
        }
        try {
            String string = AdminServiceFactory.getAdminService().getCellName();
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            Collection collection = workSpace.findContext(repositoryMetaData.getContextType("clusters"));
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
            Object[] objectArray = AppUtils.getContextArray("clusters", repositoryContext, workSpace);
            if (collection != null) {
                Iterator iterator = collection.iterator();
                int n = 0;
                String string2 = string + "/clusters/";
                while (iterator.hasNext()) {
                    RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                    n = repositoryContext2.getURI().indexOf(string2);
                    if (n < 0) continue;
                    String string3 = repositoryContext2.getURI().substring(n + string2.length());
                    if (string3.indexOf("/") > 0) {
                        string3 = string3.substring(0, string3.indexOf("/"));
                    }
                    URI uRI = URI.createURI("cluster.xml");
                    Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found for cluster " + repositoryContext2 + " SI doc res: " + resource);
                    }
                    TargetImpl targetImpl = new TargetImpl(string3, null, string, string3, true);
                    hashtable.put(string3, targetImpl);
                    ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
                    EList eList = serverCluster.getMembers();
                    ClusterMember clusterMember = null;
                    Object var19_19 = null;
                    for (int i = 0; i < eList.size(); ++i) {
                        clusterMember = (ClusterMember)eList.get(i);
                        hashtable.remove(clusterMember.getMemberName() + "," + clusterMember.getNodeName());
                    }
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusters");
            }
        }
        return hashtable;
    }

    public TargetModuleID[] getRunningModules(String string, Target[] targetArray, Hashtable hashtable, String string2) throws TargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningModules");
        }
        Vector vector = new Vector();
        Object[] objectArray = null;
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
            String string3 = AdminServiceFactory.getAdminService().getCellName();
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string3, null, null, workSpace, true);
            Vector vector2 = this.getValidTargetList(repositoryContext, workSpace, (Locale)hashtable.get("app.client.locale"), targetArray);
            if (vector2 != null && vector2.size() > 0) {
                for (int i = 0; i < targetArray.length; ++i) {
                    vector = this.getRunningApplications(vector, targetArray[i], workSpace, repositoryContext, string3, hashtable);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "All running: " + vector);
                }
                Vector vector3 = new Vector();
                for (int i = 0; i < vector.size(); ++i) {
                    if (!string.equals(((TargetModuleIDImpl)vector.elementAt(i)).getModuleType())) continue;
                    vector3.add(vector.elementAt(i));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Filtered list: " + vector3);
                }
                objectArray = new TargetModuleID[vector3.size()];
                vector3.copyInto(objectArray);
            }
        }
        catch (TargetException targetException) {
            throw targetException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.AppManagementImpl.getRunningModules", "358", this);
            throw new J2EEDeployTargetException(exception.getMessage(), exception);
        }
        finally {
            EditApplication.doFinally(workSpace, string2, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRunningModules");
            }
        }
        return objectArray;
    }

    private Vector getRunningApplications(Vector vector, Target target, WorkSpace workSpace, RepositoryContext repositoryContext, String string, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningApplications");
        }
        ObjectName objectName = null;
        String string2 = null;
        String string3 = null;
        try {
            Object object;
            if (!((TargetImpl)target).isCluster()) {
                string2 = ((TargetImpl)target).getNode();
                string3 = ((TargetImpl)target).getServerName();
            } else {
                object = this.getFirstClusterMember((TargetImpl)target, workSpace, repositoryContext, string);
                string2 = object.getParent().getName();
                string3 = object.getName();
            }
            object = this.queryObjects("type=Application,node=" + string2 + ",Server=" + string3 + ",*");
            while (object.hasNext()) {
                String string4;
                String string5;
                objectName = (ObjectName)object.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + objectName);
                }
                if ((string5 = this.getModuleTypeFromContext(string4 = objectName.getKeyProperty("name"), workSpace, hashtable)) == null) continue;
                TargetModuleIDImpl targetModuleIDImpl = J2EEAppDeploymentImpl.createTargetMod(string4, string5, target, null);
                targetModuleIDImpl.setStartable(true);
                targetModuleIDImpl.setChildTargetModuleID(this.getRunningChildren(targetModuleIDImpl, objectName, string2, string3));
                vector.add(targetModuleIDImpl);
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "Can not find modules using: " + objectName + " exception is: " + throwable);
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.getRunning", "1292", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningApplications");
        }
        return vector;
    }

    private String getModuleTypeFromContext(String string, WorkSpace workSpace, Hashtable hashtable) {
        String string2 = null;
        try {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext != null) {
                string2 = repositoryContext.isAvailable("META-INF/was.webmodule") ? "WebModule" : (repositoryContext.isAvailable("META-INF/was.ejbmodule") ? "EJBModule" : "Application");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no context for " + string + ", hence system app");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.websphere.management.application.AppManagementImpl.getModuleTypeFromContext", "505");
        }
        return string2;
    }

    private Iterator queryObjects(String string) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName("WebSphere:" + string);
        return AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
    }

    private TargetModuleID[] getRunningChildren(TargetModuleID targetModuleID, ObjectName objectName, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChildren");
        }
        Object[] objectArray = null;
        Vector vector = new Vector();
        String string3 = "*,type=WebModule,node=" + string + ",Server=" + string2 + ",Application=" + objectName.getKeyProperty("name");
        vector = this.queryRunningChildren(vector, string3, targetModuleID, targetModuleID.getTarget());
        string3 = "*,type=EJBModule,node=" + string + ",Server=" + string2 + ",Application=" + objectName.getKeyProperty("name");
        if ((vector = this.queryRunningChildren(vector, string3, targetModuleID, targetModuleID.getTarget())).size() > 0) {
            objectArray = new TargetModuleID[vector.size()];
            vector.copyInto(objectArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChildren");
        }
        return objectArray;
    }

    private Vector queryRunningChildren(Vector vector, String string, TargetModuleID targetModuleID, Target target) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryRunningChildren");
        }
        Iterator iterator = this.queryObjects(string);
        ObjectName objectName = null;
        TargetModuleIDImpl targetModuleIDImpl = null;
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "child module: " + objectName);
            }
            targetModuleIDImpl = J2EEAppDeploymentImpl.createTargetMod(objectName.getKeyProperty("name"), objectName.getKeyProperty("type"), target, targetModuleID);
            vector.add(targetModuleIDImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryRunningChildren");
        }
        return vector;
    }

    public TargetModuleID[] getNonRunningModules(String string, Target[] targetArray, Hashtable hashtable, String string2) throws TargetException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonRunningModules");
        }
        TargetModuleID[] targetModuleIDArray = this.getAvailableModulesOnServers(string, targetArray, hashtable, string2, false);
        Object[] objectArray = null;
        Vector<TargetModuleIDImpl> vector = new Vector<TargetModuleIDImpl>();
        TargetModuleIDImpl targetModuleIDImpl = null;
        WorkSpace workSpace = null;
        try {
            String string3 = AdminServiceFactory.getAdminService().getCellName();
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string3, null, null, workSpace, true);
            ObjectName objectName = null;
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                Set set;
                targetModuleIDImpl = (TargetModuleIDImpl)targetModuleIDArray[i];
                objectName = this.getAppObjectName(workSpace, repositoryContext, string3, targetModuleIDImpl);
                if (objectName == null || !(set = AdminServiceFactory.getAdminService().queryNames(objectName, null)).isEmpty()) continue;
                vector.add(targetModuleIDImpl);
            }
            objectArray = new TargetModuleID[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        finally {
            EditApplication.doFinally(workSpace, string2, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNonRunningModules");
            }
        }
        return objectArray;
    }

    private ObjectName getAppObjectName(WorkSpace workSpace, RepositoryContext repositoryContext, String string, TargetModuleIDImpl targetModuleIDImpl) throws Exception {
        ObjectName objectName = null;
        TargetImpl targetImpl = (TargetImpl)targetModuleIDImpl.getTarget();
        if (targetImpl.isCluster()) {
            RepositoryContext repositoryContext2 = this.getFirstClusterMember(targetImpl, workSpace, repositoryContext, string);
            if (repositoryContext2 != null) {
                objectName = targetModuleIDImpl.getObjectName();
                Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
                hashtable.remove("cluster");
                hashtable.put("Server", repositoryContext2.getName());
                hashtable.put("node", repositoryContext2.getParent().getName());
                objectName = new ObjectName("WebSphere", hashtable);
                objectName = new ObjectName(objectName.getCanonicalName() + ",*");
            }
        } else {
            objectName = targetModuleIDImpl.getObjectName();
        }
        return objectName;
    }

    private ObjectName convertServerAppToClusterApp(ObjectName objectName, TargetImpl targetImpl) throws Exception {
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        hashtable.remove("process");
        hashtable.remove("Server");
        hashtable.remove("node");
        hashtable.put("cluster", targetImpl.getServerName());
        ObjectName objectName2 = new ObjectName("WebSphere", hashtable);
        objectName2 = new ObjectName(objectName2.getCanonicalName() + ",*");
        return objectName2;
    }

    private RepositoryContext getFirstClusterMember(TargetImpl targetImpl, WorkSpace workSpace, RepositoryContext repositoryContext, String string) throws Exception {
        RepositoryContext repositoryContext2 = null;
        RepositoryContext repositoryContext3 = AppUtils.findContext("clusters", targetImpl.getServerName(), string, repositoryContext, workSpace, true);
        if (repositoryContext3 != null) {
            Vector<RepositoryContext> vector = new Vector<RepositoryContext>();
            vector.add(repositoryContext3);
            Vector vector2 = ConfigRepoHelper.getAllServers(workSpace, vector);
            if (vector2 != null) {
                repositoryContext2 = (RepositoryContext)vector2.firstElement();
            }
        }
        return repositoryContext2;
    }

    public TargetModuleID[] getAvailableModules(String string, Target[] targetArray, Hashtable hashtable, String string2) throws TargetException, AdminException {
        return this.getAvailableModulesOnServers(string, targetArray, hashtable, string2, true);
    }

    private TargetModuleID[] getAvailableModulesOnServers(String string, Target[] targetArray, Hashtable hashtable, String string2, boolean bl) throws TargetException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableModules");
        }
        TargetModuleID[] targetModuleIDArray = null;
        Vector<TargetModuleIDImpl> vector = new Vector<TargetModuleIDImpl>();
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
            String string3 = AdminServiceFactory.getAdminService().getCellName();
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string3, null, null, workSpace, true);
            Vector vector2 = this.getValidTargetList(repositoryContext, workSpace, (Locale)hashtable.get("app.client.locale"), targetArray);
            if (vector2 != null && vector2.size() > 0) {
                int n;
                RepositoryContext repositoryContext2 = null;
                RepositoryContext repositoryContext3 = null;
                String string4 = null;
                TargetImpl targetImpl = null;
                Vector vector3 = null;
                Vector<RepositoryContext> vector4 = new Vector<RepositoryContext>();
                Hashtable<RepositoryContext, Target> hashtable2 = new Hashtable<RepositoryContext, Target>();
                Vector<RepositoryContext> vector5 = new Vector<RepositoryContext>();
                for (int i = 0; i < vector2.size(); ++i) {
                    repositoryContext2 = (RepositoryContext)vector2.elementAt(i);
                    if (repositoryContext2.getType().getName().equals("clusters")) {
                        vector4.clear();
                        vector4.add(repositoryContext2);
                        vector3 = ConfigRepoHelper.getAllServers(workSpace, vector4);
                        repositoryContext2 = (RepositoryContext)vector3.firstElement();
                    }
                    if (repositoryContext2 == null) continue;
                    vector5.add(repositoryContext2);
                    hashtable2.put(repositoryContext2, targetArray[i]);
                }
                Hashtable hashtable3 = new Hashtable();
                Vector vector6 = this.getUniqueNodes(vector5);
                RepositoryContext repositoryContext4 = null;
                for (n = 0; n < vector6.size(); ++n) {
                    repositoryContext4 = (RepositoryContext)vector6.elementAt(n);
                    repositoryContext3 = repositoryContext4.getParent();
                    string4 = repositoryContext3.getName();
                    URI uRI = URI.createURI("serverindex.xml");
                    Resource resource = repositoryContext3.getResourceSet().getResource(uRI, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found for node " + repositoryContext3 + " SI doc res: " + resource);
                    }
                    ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                    EList eList = serverIndex.getServerEntries();
                    ServerEntry serverEntry = null;
                    TargetModuleIDImpl targetModuleIDImpl = null;
                    for (int i = 0; i < eList.size(); ++i) {
                        serverEntry = (ServerEntry)eList.get(i);
                        repositoryContext2 = this.isServerIncluded(vector5, serverEntry.getServerName(), string4);
                        if (!serverEntry.getServerType().equals("APPLICATION_SERVER") || repositoryContext2 == null) continue;
                        targetImpl = (TargetImpl)hashtable2.get(repositoryContext2);
                        EList eList2 = serverEntry.getDeployedApplications();
                        for (int j = 0; j < eList2.size(); ++j) {
                            String string5 = (String)eList2.get(j);
                            String string6 = string5.substring(string5.lastIndexOf("/") + 1);
                            String string7 = string5.substring(string5.indexOf("/"));
                            Object var36_39 = null;
                            boolean bl2 = false;
                            String string8 = this.getModuleTypeFromContext(string6, workSpace, hashtable);
                            if (string8 == null || !string.equals(string8)) continue;
                            targetModuleIDImpl = J2EEAppDeploymentImpl.createTargetMod(string6, string8, targetImpl, null);
                            targetModuleIDImpl.setChildTargetModuleID(this.getAvailableChildren(string6, targetModuleIDImpl, hashtable, workSpace.getUserName()));
                            targetModuleIDImpl.setStartable(this.isStartable(targetModuleIDImpl));
                            vector.add(targetModuleIDImpl);
                        }
                    }
                }
                if (vector.size() > 0) {
                    targetModuleIDArray = new TargetModuleID[vector.size()];
                    for (n = 0; n < vector.size(); ++n) {
                        targetModuleIDArray[n] = (TargetModuleID)vector.elementAt(n);
                    }
                } else {
                    targetModuleIDArray = new TargetModuleID[]{};
                }
            }
        }
        catch (TargetException targetException) {
            throw targetException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.websphere.management.application.AppManagementImpl.getAvailableModules", "784");
            throw new AdminException(exception);
        }
        finally {
            EditApplication.doFinally(workSpace, string2, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAvailableModules");
            }
        }
        return targetModuleIDArray;
    }

    private Vector getUniqueNodes(Vector vector) {
        Hashtable<String, RepositoryContext> hashtable = new Hashtable<String, RepositoryContext>();
        RepositoryContext repositoryContext = null;
        for (int i = 0; i < vector.size(); ++i) {
            repositoryContext = (RepositoryContext)vector.elementAt(i);
            hashtable.put(repositoryContext.getParent().getName(), repositoryContext);
        }
        Vector vector2 = new Vector();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector2.add(enumeration.nextElement());
        }
        return vector2;
    }

    private RepositoryContext isServerIncluded(Vector vector, String string, String string2) {
        RepositoryContext repositoryContext = null;
        for (int i = 0; i < vector.size(); ++i) {
            repositoryContext = (RepositoryContext)vector.elementAt(i);
            if (!repositoryContext.getName().equals(string) || !repositoryContext.getParent().getName().equals(string2)) continue;
            return repositoryContext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableChildren(String string, TargetModuleID targetModuleID, Hashtable hashtable, String string2) throws TargetException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableChildren");
        }
        Vector vector = new Vector();
        TargetModuleID[] targetModuleIDArray = null;
        try {
            EditApplication editApplication = new EditApplication(string, hashtable, null, string2, null);
            AppDeploymentTask appDeploymentTask = editApplication.listModules();
            String[][] stringArray = appDeploymentTask.getTaskData();
            String string3 = null;
            String string4 = null;
            if (stringArray.length > 0) {
                targetModuleIDArray = new TargetModuleID[stringArray.length - 1];
                for (int i = 1; i < stringArray.length; ++i) {
                    string3 = stringArray[i][0];
                    string4 = stringArray[i][1];
                    string4 = util.getModuleURIFromUniqueName(string4);
                    String string5 = this.getModuleType(string4);
                    String string6 = stringArray[i][2];
                    try {
                        TargetModuleIDImpl targetModuleIDImpl = J2EEAppDeploymentImpl.createTargetMod(string4, string5, targetModuleID.getTarget(), targetModuleID);
                        targetModuleIDArray[i - 1] = targetModuleIDImpl;
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw new AdminException(throwable, "Unknown exception");
                    }
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAvailableModules");
            }
        }
        return targetModuleIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableChildren(AppManagement appManagement, String string, TargetModuleID targetModuleID, Hashtable hashtable, String string2) throws TargetException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableChildren");
        }
        TargetModuleID[] targetModuleIDArray = null;
        try {
            AppDeploymentTask appDeploymentTask = (AppDeploymentTask)appManagement.listModules(string, hashtable, string2);
            String[][] stringArray = appDeploymentTask.getTaskData();
            String string3 = null;
            String string4 = null;
            if (stringArray.length > 0) {
                targetModuleIDArray = new TargetModuleID[stringArray.length - 1];
                for (int i = 1; i < stringArray.length; ++i) {
                    string3 = stringArray[i][0];
                    string4 = stringArray[i][1];
                    string4 = util.getModuleURIFromUniqueName(string4);
                    String string5 = this.getModuleType(string4);
                    String string6 = stringArray[i][2];
                    try {
                        TargetModuleIDImpl targetModuleIDImpl = J2EEAppDeploymentImpl.createTargetMod(string4, string5, targetModuleID.getTarget(), targetModuleID);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "targetMod: " + targetModuleIDImpl);
                        }
                        targetModuleIDArray[i - 1] = targetModuleIDImpl;
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw new AdminException(throwable, "Unknown exception");
                    }
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAvailableChildren");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetModID list: " + targetModuleIDArray);
            if (targetModuleIDArray != null) {
                for (int i = 0; i < targetModuleIDArray.length; ++i) {
                    Tr.debug(tc, "availableChildren[" + i + "]" + targetModuleIDArray[i]);
                }
            }
        }
        return targetModuleIDArray;
    }

    private boolean isStartable(TargetModuleIDImpl targetModuleIDImpl) {
        boolean bl = false;
        TargetModuleID[] targetModuleIDArray = targetModuleIDImpl.getChildTargetModuleID();
        if (targetModuleIDArray != null) {
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                TargetModuleIDImpl targetModuleIDImpl2 = (TargetModuleIDImpl)targetModuleIDArray[i];
                if (!targetModuleIDImpl2.getModuleType().equals(DeploymentManagerImpl.EJB_MODULE) && !targetModuleIDImpl2.getModuleType().equals(DeploymentManagerImpl.WAR_MODULE)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Target isThisServerATarget(ServerEntry serverEntry, String string, Target[] targetArray) {
        for (int i = 0; i < targetArray.length; ++i) {
            if (!string.equals(((TargetImpl)targetArray[i]).getNode()) || !serverEntry.getServerName().equals(((TargetImpl)targetArray[i]).getServerName())) continue;
            return targetArray[i];
        }
        return null;
    }

    private String getModuleType(String string) {
        String string2 = null;
        string2 = string.indexOf(".jar") >= 0 ? DeploymentManagerImpl.EJB_MODULE : (string.indexOf(".war") >= 0 ? DeploymentManagerImpl.WAR_MODULE : (string.indexOf(".rar") >= 0 ? DeploymentManagerImpl.RAR_MODULE : "Unknown"));
        return string2;
    }

    private Vector getValidTargetList(RepositoryContext repositoryContext, WorkSpace workSpace, Locale locale, Target[] targetArray) throws TargetException {
        boolean bl = true;
        Object var6_6 = null;
        Exception exception = null;
        Vector<RepositoryContext> vector = new Vector<RepositoryContext>();
        for (int i = 0; i < targetArray.length; ++i) {
            TargetImpl targetImpl = (TargetImpl)targetArray[i];
            String string = targetImpl.getNode();
            String string2 = targetImpl.getServerName();
            boolean bl2 = true;
            try {
                RepositoryContext repositoryContext2;
                Object[] objectArray;
                if (targetImpl.isCluster()) {
                    objectArray = null;
                    if (objectArray == null) {
                        objectArray = AppUtils.getContextArray("clusters", repositoryContext, workSpace);
                    }
                    if (objectArray != null && objectArray.length > 0) {
                        repositoryContext2 = AppUtils.getContextFromArray(objectArray, string2, null, false);
                        if (repositoryContext2 == null) {
                            bl2 = false;
                        } else {
                            vector.add(repositoryContext2);
                        }
                    } else {
                        bl2 = false;
                    }
                } else {
                    objectArray = null;
                    if (objectArray == null) {
                        objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
                    }
                    if (objectArray != null && objectArray.length > 0) {
                        repositoryContext2 = AppUtils.getContextFromArray(objectArray, string2, string, false);
                        if (repositoryContext2 == null) {
                            bl2 = false;
                        } else {
                            vector.add(repositoryContext2);
                        }
                    } else {
                        bl2 = false;
                    }
                }
            }
            catch (Exception exception2) {
                bl2 = false;
                exception = exception2;
            }
            if (bl2) continue;
            if (targetImpl.isCluster()) {
                throw new J2EEDeployTargetException(AppUtils.getMessage(AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", locale), "ADMJ1026E", new Object[]{string2}), exception);
            }
            throw new J2EEDeployTargetException(AppUtils.getMessage(AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", locale), "ADMJ1008E", new Object[]{string2, string}), exception);
        }
        return vector;
    }

    public static TargetModuleIDImpl createTargetMod(String string, String string2, Target target, TargetModuleID targetModuleID) throws Exception {
        return AppDeploymentUtil.createTargetMod(string, string2, target, targetModuleID);
    }

    static {
        seqNum = 0L;
    }
}

