/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.EJBModuleConfiguration;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.HostFactory;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.ConfigureTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class AppAssociation {
    private static TraceComponent tc = Tr.register(AppAssociation.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static AppdeploymentFactory appFactory = null;
    private static boolean isReg = false;
    AppManagementImpl appM;
    String workspaceID;
    Hashtable prefs;
    ResourceBundle resBundle;

    private static AppdeploymentFactory getAppFactory() {
        if (appFactory == null) {
            AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            appFactory = appdeploymentPackage.getAppdeploymentFactory();
        }
        return appFactory;
    }

    public AppAssociation(AppManagementImpl appManagementImpl, Hashtable hashtable, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppAssociation: , " + string);
        }
        this.appM = appManagementImpl;
        this.workspaceID = string;
        this.prefs = hashtable;
        this.resBundle = AppUtils.getBundle(this.prefs);
        if (!isReg) {
            ConfigInit.init();
            AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            AppdeploymentPackageImpl.init();
            isReg = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppAssociation");
        }
    }

    public static void handleCatch(Throwable throwable, String string, String string2, Object object) throws AdminException {
        FFDCFilter.processException(throwable, object.getClass().getName() + "." + string, string2, object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exception thrown in " + string + ": " + throwable);
        }
        if (throwable instanceof AdminException) {
            throw (AdminException)throwable;
        }
        throw new AdminException(throwable, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppsFromNode(String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromNode: " + string + ", " + string2);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string2, null, null, workSpace, true);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string2}));
            }
            RepositoryContext repositoryContext2 = AppUtils.findContext("nodes", string, null, repositoryContext, workSpace, false);
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5040E", new String[]{string}));
            }
            URI uRI = URI.createURI("serverindex.xml");
            Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + repositoryContext2 + " SI doc res: " + resource);
            }
            if (resource != null) {
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                Vector<String> vector = new Vector<String>();
                EList eList = serverIndex.getServerEntries();
                for (int i = 0; i < eList.size(); ++i) {
                    vector.addElement(((ServerEntry)eList.get(i)).getServerName());
                }
                Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
                hashtable.put(string, vector);
                this.removeAppAssociation(string2, hashtable, new Vector(), workSpace);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting serverindex.xml");
            }
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "removeAllAppsFromNode", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeAllAppsFromNode");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeAllAppsFromNode");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppsFromServer(ObjectName objectName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromServer: " + objectName);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            String string = objectName.getKeyProperty("cell");
            String string2 = objectName.getKeyProperty("node");
            String string3 = objectName.getKeyProperty("server");
            Vector<String> vector = new Vector<String>();
            vector.addElement(string3);
            Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
            hashtable.put(string2, vector);
            this.removeAppAssociation(string, hashtable, new Vector(), workSpace);
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "removeAllAppsFromServer", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeAllAppsFromServer");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeAllAppsFromServer");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void removeAllAppsFromCluster(ObjectName var1_1) throws AdminException {
        if (AppAssociation.tc.isEntryEnabled()) {
            Tr.entry(AppAssociation.tc, "removeAllAppsFromCluster: " + var1_1);
        }
        var2_2 = null;
        var3_3 = false;
        try {
            var2_2 = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            var4_4 = var1_1.getKeyProperty("cell");
            var5_6 = var1_1.getKeyProperty("cluster");
            var6_7 = AppUtils.findContext("cells", var4_4, null, null, var2_2, true);
            if (var6_7 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{var4_4}));
            }
            var7_8 = new Vector<String>();
            var7_8.addElement(var5_6);
            var8_9 = new Hashtable<String, Vector<String>>();
            var9_10 = AppUtils.findContext("clusters", var5_6, var4_4, var6_7, var2_2, true);
            if (var9_10 == null) {
                Tr.warning(AppAssociation.tc, AppUtils.getMessage(this.resBundle, "ADMA5051W", new Object[]{var5_6}));
            } else {
                var10_11 = URI.createURI("cluster.xml");
                var11_12 = var9_10.getResourceSet().getResource(var10_11, true);
                var12_13 = (ServerCluster)var11_12.getContents().get(0);
                if (AppAssociation.tc.isDebugEnabled()) {
                    Tr.debug(AppAssociation.tc, "Cluster obj: " + var12_13);
                }
                var13_14 = var12_13.getMembers();
                for (var14_15 = 0; var14_15 < var13_14.size(); ++var14_15) {
                    var15_16 = (ClusterMember)var13_14.get(var14_15);
                    var16_17 = var15_16.getMemberName();
                    var17_18 = var15_16.getNodeName();
                    var18_19 = (Vector<String>)var8_9.get(var17_18);
                    if (var18_19 == null) {
                        var18_19 = new Vector<String>();
                        var8_9.put(var17_18, var18_19);
                    }
                    var18_19.addElement(var16_17);
                }
            }
            this.removeAppAssociation(var4_4, var8_9, var7_8, var2_2);
            EditApplication.doFinally(var2_2, this.workspaceID, null, var3_3 == false);
        }
        catch (Throwable var4_5) {
            try {
                var3_3 = true;
                AppAssociation.handleCatch(var4_5, "removeAllAppsFromCluster", "106", this);
                EditApplication.doFinally(var2_2, this.workspaceID, null, var3_3 == false);
            }
            catch (Throwable var19_20) {
                EditApplication.doFinally(var2_2, this.workspaceID, null, var3_3 == false);
                if (AppAssociation.tc.isEntryEnabled()) {
                    Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
                }
                throw var19_20;
            }
            if (AppAssociation.tc.isEntryEnabled()) {
                Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
            } else {
                ** GOTO lbl54
            }
        }
        if (AppAssociation.tc.isEntryEnabled()) {
            Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
        }
        if (AppAssociation.tc.isEntryEnabled()) {
            Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
        }
    }

    private void removeAppAssociation(String string, Hashtable hashtable, Vector vector, WorkSpace workSpace) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAppAssociation: " + hashtable);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusters: " + vector);
        }
        RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Enumeration enumeration = hashtable.keys();
        HashMap hashMap = new HashMap();
        while (enumeration.hasMoreElements()) {
            Object object4;
            Notifier notifier;
            String string2 = (String)enumeration.nextElement();
            object3 = (Vector)hashtable.get(string2);
            object2 = AppUtils.findContext("nodes", string2, null, repositoryContext, workSpace, false);
            if (object2 == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string2 + " not found.");
                continue;
            }
            object = URI.createURI("serverindex.xml");
            Resource resource = object2.getResourceSet().getResource((URI)object, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + object2 + " SI doc res: " + resource);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                notifier = (ServerEntry)eList.get(i);
                if (!((Vector)object3).contains(notifier.getServerName())) continue;
                object4 = notifier.getDeployedApplications();
                while (object4.size() > 0) {
                    if (!vector2.contains(object4.get(0))) {
                        vector2.add(object4.get(0));
                    }
                    object4.remove(0);
                }
            }
            resource.save(new HashMap(0));
            URI uRI = URI.createURI("systemapps.xml");
            notifier = object2.getResourceSet().getResource(uRI, true);
            if (notifier == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "systemapps.xml not found.");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + object2 + " systemapp SI doc res: " + notifier);
            }
            object4 = (ServerIndex)notifier.getContents().get(0);
            EList eList2 = object4.getServerEntries();
            for (int i = 0; i < eList2.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList2.get(i);
                if (!((Vector)object3).contains(serverEntry.getServerName())) continue;
                EList eList3 = serverEntry.getDeployedApplications();
                while (eList3.size() > 0) {
                    if (!vector3.contains(eList3.get(0))) {
                        vector3.add(eList3.get(0));
                    }
                    eList3.remove(0);
                }
                eList2.remove(serverEntry);
            }
            notifier.save(new HashMap(0));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "depls: " + vector2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplsSysApp: " + vector3);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            object3 = ConfigRepoHelper.getAppContextFromSIEntry((String)vector2.elementAt(i), repositoryContext, workSpace);
            if (object3 == null) {
                Tr.warning(tc, "ADMA5041E", (Object)new Object[]{vector2.get(i), ""});
                continue;
            }
            object2 = ConfigRepoHelper.getAppDeploymentResource((RepositoryContext)object3);
            object = (Deployment)object2.getContents().get(0);
            this.removeAppTargets((Deployment)object, hashtable, vector);
            object2.save(new HashMap(0));
        }
    }

    private void removeAppTargets(Deployment deployment, Hashtable hashtable, Vector vector) throws Exception {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAppTargets");
        }
        EList eList = deployment.getDeploymentTargets();
        ArrayList<DeploymentTarget> arrayList = new ArrayList<DeploymentTarget>();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(i);
            if (deploymentTarget instanceof ClusteredTarget) {
                if (!vector.contains(deploymentTarget.getName())) continue;
                arrayList.add(deploymentTarget);
                continue;
            }
            Vector vector2 = (Vector)hashtable.get(((ServerTarget)deploymentTarget).getNodeName());
            if (vector2 == null || !vector2.contains(deploymentTarget.getName())) continue;
            arrayList.add(deploymentTarget);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDT: " + arrayList);
        }
        this.removeDTFromDeployment(deployment.getDeployedObject(), arrayList);
        EList eList2 = ((ApplicationDeployment)deployment.getDeployedObject()).getModules();
        for (n = 0; n < eList2.size(); ++n) {
            this.removeDTFromDeployment((DeployedObject)eList2.get(n), arrayList);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            deployment.getDeploymentTargets().remove(arrayList.get(n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAppTargets");
        }
    }

    private void removeDTFromDeployment(DeployedObject deployedObject, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDTFromDeployment");
        }
        for (int i = 0; i < deployedObject.getTargetMappings().size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)deployedObject.getTargetMappings().get(i);
            if (!list.contains(deploymentTargetMapping.getTarget())) continue;
            deployedObject.getTargetMappings().remove(deploymentTargetMapping);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDTFromDeployment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeServerToCluster(ObjectName objectName, ObjectName objectName2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerToCluster: " + objectName + " -to-> " + objectName2);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            Object object;
            Object object2;
            int n;
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            String string = objectName.getKeyProperty("cell");
            String string2 = objectName.getKeyProperty("node");
            String string3 = objectName.getKeyProperty("server");
            String string4 = objectName2.getKeyProperty("cluster");
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string}));
            }
            RepositoryContext repositoryContext2 = AppUtils.findContext("nodes", string2, string, repositoryContext, workSpace, true);
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{objectName}));
            }
            URI uRI = URI.createURI("serverindex.xml");
            Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + repositoryContext2 + " SI doc res: " + resource);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            Vector<RepositoryContext> vector = new Vector<RepositoryContext>();
            EList eList = serverIndex.getServerEntries();
            for (n = 0; n < eList.size(); ++n) {
                if (!((ServerEntry)eList.get(n)).getServerName().equals(string3)) continue;
                object2 = ((ServerEntry)eList.get(n)).getDeployedApplications();
                for (int i = 0; i < object2.size(); ++i) {
                    try {
                        object = ConfigRepoHelper.getAppContextFromSIEntry((String)object2.get(i), repositoryContext, workSpace);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "rc: " + object);
                        }
                        vector.addElement((RepositoryContext)object);
                        continue;
                    }
                    catch (Exception exception) {
                        Tr.warning(tc, AppUtils.getMessage(this.resBundle, "ADMA5053W", new Object[]{exception, object2.get(i)}));
                    }
                }
                break;
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = (RepositoryContext)vector.elementAt(n);
                try {
                    resource = ConfigRepoHelper.getAppDeploymentResource((RepositoryContext)object2);
                    Deployment deployment = (Deployment)resource.getContents().get(0);
                    object = null;
                    EList eList2 = deployment.getDeploymentTargets();
                    for (int i = 0; i < eList2.size(); ++i) {
                        ServerTarget serverTarget;
                        if (!(eList2.get(i) instanceof ServerTarget) || !(serverTarget = (ServerTarget)eList2.get(i)).getName().equals(string3) || !serverTarget.getNodeName().equals(string2)) continue;
                        object = serverTarget;
                        break;
                    }
                    if (object == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "ServerTarget not found for " + string3 + "-" + string2 + " in " + deployment);
                        continue;
                    }
                    ClusteredTarget clusteredTarget = AppAssociation.getAppFactory().createClusteredTarget();
                    clusteredTarget.setName(string4);
                    this.replaceTarget((DeploymentTarget)object, (DeploymentTarget)clusteredTarget, deployment);
                    resource.save(new HashMap(0));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.warning(tc, AppUtils.getMessage(this.resBundle, "ADMA5054W", new Object[]{throwable, object2.getName(), string3, string4}));
                }
            }
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "changeServerToCluster", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "changeServerToCluster");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "changeServerToCluster");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerToCluster");
        }
    }

    private void replaceTarget(DeploymentTarget deploymentTarget, DeploymentTarget deploymentTarget2, Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceTarget: " + deploymentTarget);
        }
        deployment.getDeploymentTargets().add(deploymentTarget2);
        this.replaceTarget(deploymentTarget, deploymentTarget2, deployment.getDeployedObject());
        EList eList = ((ApplicationDeployment)deployment.getDeployedObject()).getModules();
        for (int i = 0; i < eList.size(); ++i) {
            this.replaceTarget(deploymentTarget, deploymentTarget2, (DeployedObject)eList.get(i));
        }
        deployment.getDeploymentTargets().remove(deploymentTarget);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceTarget");
        }
    }

    private void replaceTarget(DeploymentTarget deploymentTarget, DeploymentTarget deploymentTarget2, DeployedObject deployedObject) throws Exception {
        EList eList = deployedObject.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(i);
            if (!deploymentTargetMapping.getTarget().equals(deploymentTarget)) continue;
            deploymentTargetMapping.setTarget(deploymentTarget2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterMemberAdded(ObjectName objectName, ObjectName objectName2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clusterMemberAdded: " + objectName + " to " + objectName2);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            Object object;
            EObject eObject;
            List list;
            Object object2;
            Notifier notifier;
            RepositoryContext repositoryContext;
            Object object3;
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            String string = objectName.getKeyProperty("cell");
            String string2 = objectName.getKeyProperty("node");
            String string3 = objectName.getKeyProperty("server");
            String string4 = objectName2.getKeyProperty("cluster");
            RepositoryContext repositoryContext2 = AppUtils.findContext("cells", string, null, null, workSpace, true);
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string}));
            }
            RepositoryContext repositoryContext3 = AppUtils.findContext("clusters", string4, string, repositoryContext2, workSpace, true);
            if (repositoryContext3 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5055E", new Object[]{string4, string3}));
            }
            RepositoryContext repositoryContext4 = AppUtils.findContext("nodes", string2, string, repositoryContext2, workSpace, true);
            if (repositoryContext4 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{string2}));
            }
            URI uRI = URI.createURI("cluster.xml");
            Resource resource = repositoryContext3.getResourceSet().getResource(uRI, true);
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            EList eList = serverCluster.getMembers();
            List list2 = null;
            EList eList2 = null;
            Resource resource2 = null;
            URI uRI2 = null;
            ServerEntry serverEntry = null;
            RepositoryContext repositoryContext5 = null;
            String string5 = null;
            EObject eObject2 = null;
            if (eList.size() > 1) {
                block11: for (int i = 0; i < eList.size(); ++i) {
                    object3 = (ClusterMember)eList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Member: " + object3.getMemberName() + " - " + object3.getNodeName() + " sName: " + string3 + " nName: " + string2);
                    }
                    if (object3.getMemberName().equals(string3) && object3.getNodeName().equals(string2)) continue;
                    repositoryContext = AppUtils.findContext("nodes", object3.getNodeName(), string, repositoryContext2, workSpace, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node context: " + repositoryContext);
                    }
                    if (repositoryContext == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid member: " + object3.getMemberName());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Member: " + object3.getMemberName() + " - " + object3.getNodeName());
                    }
                    uRI = URI.createURI("serverindex.xml");
                    notifier = repositoryContext.getResourceSet().getResource(uRI, true);
                    object2 = (ServerIndex)notifier.getContents().get(0);
                    list = object2.getServerEntries();
                    for (int j = 0; j < list.size(); ++j) {
                        eObject = (ServerEntry)list.get(j);
                        if (!eObject.getServerName().equals(object3.getMemberName())) continue;
                        list2 = eObject.getDeployedApplications();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add: " + list2);
                        }
                        serverEntry = eObject;
                        string5 = object3.getMemberName();
                        repositoryContext5 = repositoryContext;
                        break;
                    }
                    uRI2 = URI.createURI("systemapps.xml");
                    Resource resource3 = repositoryContext.getResourceSet().getResource(uRI2, true);
                    if (resource3 == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "systemapps.xml not found.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found for node " + repositoryContext + " systemapp SI doc res: " + resource3);
                    }
                    eObject = (ServerIndex)resource3.getContents().get(0);
                    object = eObject.getServerEntries();
                    for (int j = 0; j < object.size(); ++j) {
                        ServerEntry serverEntry2 = (ServerEntry)object.get(j);
                        if (!serverEntry2.getServerName().equals(object3.getMemberName())) continue;
                        eList2 = serverEntry2.getDeployedApplications();
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "addSysApp: " + eList2);
                        break block11;
                    }
                    break;
                }
            }
            if (list2 == null) {
                list2 = new ArrayList<String>();
                Object[] objectArray = AppUtils.getContextArray("deployments", repositoryContext2, workSpace);
                block14: for (int i = 0; i < objectArray.length; ++i) {
                    repositoryContext = (RepositoryContext)objectArray[i];
                    resource = ConfigRepoHelper.getAppDeploymentResource(repositoryContext);
                    notifier = (Deployment)resource.getContents().get(0);
                    object2 = notifier.getDeploymentTargets();
                    for (int j = 0; j < object2.size(); ++j) {
                        if (!(object2.get(j) instanceof ClusteredTarget) || !((ClusteredTarget)object2.get(j)).getName().equals(string4)) continue;
                        list2.add(ConfigRepoHelper.getSIEntryText(repositoryContext));
                        continue block14;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add is: " + list2);
            }
            uRI = URI.createURI("serverindex.xml");
            resource = repositoryContext4.getResourceSet().getResource(uRI, true);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            object3 = serverIndex.getServerEntries();
            for (int i = 0; i < object3.size(); ++i) {
                notifier = (ServerEntry)object3.get(i);
                if (!notifier.getServerName().equals(string3)) continue;
                eObject2 = notifier;
                for (int j = 0; j < list2.size(); ++j) {
                    if (notifier.getDeployedApplications().contains(list2.get(j))) continue;
                    notifier.getDeployedApplications().add(list2.get(j));
                }
                break;
            }
            resource.save(new HashMap(0));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("cell.name", string);
            hashtable.put("node.name", string2);
            ConfigRepoHelper.getReferenceToSystemAppsXML(workSpace, hashtable);
            uRI2 = URI.createURI("systemapps.xml");
            resource2 = repositoryContext4.getResourceSet().getResource(uRI2, true);
            notifier = (ServerIndex)resource2.getContents().get(0);
            object2 = notifier.getServerEntries();
            list = ConfigRepoHelper.getServerNameForServerEntries((List)object2);
            if (!list.contains(string3)) {
                ConfigRepoHelper.createServerEntry((ServerIndex)notifier, string3);
            }
            object2 = notifier.getServerEntries();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serversEntries for " + repositoryContext4.getName() + " are " + object2);
            }
            if (eList2 != null) {
                for (int i = 0; i < object2.size(); ++i) {
                    eObject = (ServerEntry)object2.get(i);
                    if (!eObject.getServerName().equals(string3)) continue;
                    for (int j = 0; j < eList2.size(); ++j) {
                        if (eObject.getDeployedApplications().contains(eList2.get(j))) continue;
                        eObject.getDeployedApplications().add(eList2.get(j));
                    }
                    break;
                }
                resource2.save(new HashMap(0));
            }
            uRI = URI.createURI("deployment.xml");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < list2.size(); ++i) {
                try {
                    object = ConfigRepoHelper.getAppContextFromSIEntry((String)list2.get(i), repositoryContext2, workSpace);
                    resource = object.getResourceSet().getResource(uRI, true);
                    resource.save(new HashMap(0));
                    arrayList.add(object);
                    continue;
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception: " + throwable + " in touching deployment.xml " + " in " + list2.get(i));
                    }
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppAssociation.clusterMemberAdded", "751", this);
                    arrayList = new ArrayList();
                }
            }
            Archive archive = null;
            boolean bl2 = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appCs = " + arrayList);
            }
            try {
                Object object4;
                EObject eObject3;
                int n;
                List list3;
                ArrayList<String> arrayList2;
                ArrayList<String> arrayList3 = new ArrayList<String>();
                block21: for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList2 = (RepositoryContext)arrayList.get(i);
                    archive = ConfigRepoHelper.getEarFileFromDeployment(workSpace, (RepositoryContext)((Object)arrayList2));
                    list3 = archive.getWebModuleRefs();
                    for (n = 0; n < list3.size(); ++n) {
                        eObject3 = (WebAppBinding)((ModuleRef)list3.get(n)).getBindings();
                        if (eObject3 == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "null binding for " + arrayList2 + " - " + ((ModuleRef)list3.get(n)).getUri());
                            continue;
                        }
                        object4 = eObject3.getVirtualHostName();
                        if (object4 == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "vhost = " + (String)object4);
                        }
                        if (!arrayList3.contains(object4)) {
                            arrayList3.add((String)object4);
                        }
                        if (arrayList3.size() > 1) continue block21;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "vh = " + arrayList3);
                }
                EObject eObject4 = null;
                if (arrayList3.size() == 1) {
                    arrayList2 = (String)arrayList3.get(0);
                    uRI = URI.createURI("virtualhosts.xml");
                    resource = repositoryContext2.getResourceSet().getResource(uRI, true);
                    list3 = resource.getContents();
                    block23: for (n = 0; n < list3.size(); ++n) {
                        eObject3 = (VirtualHost)list3.get(n);
                        if (!((String)((Object)arrayList2)).equals(eObject3.getName())) continue;
                        bl2 = true;
                        eObject4 = eObject3;
                        object4 = eObject4.getAliases();
                        for (int i = 0; i < object4.size(); ++i) {
                            HostAlias hostAlias = (HostAlias)object4.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "alias: " + hostAlias.getHostname());
                            }
                            if ("*".equals(hostAlias.getHostname())) continue;
                            bl2 = false;
                            continue block23;
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "shouldProceed: " + bl2 + ", " + eObject4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string5 + ", " + repositoryContext5 + ", " + serverEntry);
                }
                arrayList2 = new ArrayList<String>();
                if (bl2 && string5 != null && repositoryContext5 != null && serverEntry != null) {
                    list3 = eObject4.getAliases();
                    for (n = 0; n < list3.size(); ++n) {
                        arrayList2.add(((HostAlias)list3.get(n)).getPort());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "current ports: " + arrayList2);
                    }
                    List list4 = AppAssociation.getEndPorts(string5, repositoryContext5, serverEntry);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endPorts for other: " + list4);
                    }
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        list4.remove(arrayList2.get(i));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endPorts for other after remove: " + list4);
                    }
                    if (list4.size() != 0) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    list3 = AppAssociation.getEndPorts(string3, repositoryContext4, (ServerEntry)eObject2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endPorts to add: " + list3);
                    }
                    for (int i = 0; i < list3.size(); ++i) {
                        if (arrayList2.contains(list3.get(i))) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "port already defined, skipping -" + list3.get(i));
                            continue;
                        }
                        HostAlias hostAlias = HostFactory.eINSTANCE.createHostAlias();
                        hostAlias.setHostname("*");
                        hostAlias.setPort((String)list3.get(i));
                        eObject4.getAliases().add(hostAlias);
                    }
                    eObject4.eResource().save(new HashMap());
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception in updating server with http ports: " + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppAssociation.clusterMemberAdded", "763", this);
            }
            finally {
                if (archive != null) {
                    archive.close();
                }
            }
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "clusterMemberAdded", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "clusterMemberAdded");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "clusterMemberAdded");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clusterMemberAdded");
        }
    }

    public static List getEndPorts(String string, RepositoryContext repositoryContext, ServerEntry serverEntry) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPorts: " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        RepositoryContext repositoryContext2 = repositoryContext.getChild(AppUtils.getContextType("servers"), string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contexts: node=" + repositoryContext + ", server=" + repositoryContext2);
        }
        URI uRI = URI.createURI("server.xml");
        Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resource: " + resource);
        }
        Server server = (Server)resource.getContents().get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found server: " + server);
        }
        EList eList = server.getComponents();
        for (int i = 0; i < eList.size(); ++i) {
            if (!(eList.get(i) instanceof ApplicationServer)) continue;
            ApplicationServer applicationServer = (ApplicationServer)eList.get(i);
            object2 = applicationServer.getComponents();
            for (int j = 0; j < object2.size(); ++j) {
                if (!(object2.get(j) instanceof WebContainer)) continue;
                WebContainer webContainer = (WebContainer)object2.get(j);
                object = webContainer.getTransports();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "transports: " + object);
                }
                for (int k = 0; k < object.size(); ++k) {
                    Transport transport = (Transport)object.get(k);
                    if (transport.getAddress() == null || arrayList.contains("" + transport.getAddress().getPort())) continue;
                    arrayList.add("" + transport.getAddress().getPort());
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "After adding ports from webcontainer: " + arrayList);
            }
        }
        EList eList2 = server.getServices();
        for (int i = 0; i < eList2.size(); ++i) {
            if (!(eList2.get(i) instanceof TransportChannelService)) continue;
            object2 = (TransportChannelService)eList2.get(i);
            EList eList3 = object2.getChains();
            for (int j = 0; j < eList3.size(); ++j) {
                int n;
                object = (Chain)eList3.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "chain: " + object);
                }
                EList eList4 = object.getTransportChannels();
                boolean bl = false;
                for (n = 0; n < eList4.size(); ++n) {
                    if (!(eList4.get(n) instanceof WebContainerInboundChannel)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No WCInbound for this chain");
                    continue;
                }
                for (n = 0; n < eList4.size(); ++n) {
                    if (!(eList4.get(n) instanceof TCPInboundChannel)) continue;
                    TCPInboundChannel tCPInboundChannel = (TCPInboundChannel)eList4.get(n);
                    String string2 = tCPInboundChannel.getEndPointName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ep name: " + string2);
                    }
                    String string3 = AppAssociation.getPortForEP(serverEntry, string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "port: " + string3);
                    }
                    if (string3 == null || arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPorts: " + arrayList);
        }
        return arrayList;
    }

    private static String getPortForEP(ServerEntry serverEntry, String string) {
        EList eList = serverEntry.getSpecialEndpoints();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "looking for ep port for: " + string);
        }
        for (int i = 0; i < eList.size(); ++i) {
            NamedEndPoint namedEndPoint;
            if (!(eList.get(i) instanceof NamedEndPoint) || !string.equals((namedEndPoint = (NamedEndPoint)eList.get(i)).getEndPointName())) continue;
            return "" + namedEndPoint.getEndPoint().getPort();
        }
        return null;
    }

    public static void populateDeployTargets(Deployment deployment, ModuleDeployment moduleDeployment, String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace, AppcfgFactory appcfgFactory, AppdeploymentFactory appdeploymentFactory) throws Exception {
        ConfigureTask.populateDeployTargets(deployment, moduleDeployment, string, string2, repositoryContext, workSpace, appcfgFactory, appdeploymentFactory);
    }

    public static Vector getServerNames(String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        return ConfigRepoHelper.getServerNames(string, string2, true, repositoryContext, workSpace);
    }

    public static Vector getServerNames(String string, String string2, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        return ConfigRepoHelper.getServerNames(string, string2, bl, repositoryContext, workSpace);
    }

    private static int existsInNewConfig(DeploymentTargetMapping deploymentTargetMapping, Vector vector) {
        for (int i = 0; i < vector.size(); i += 2) {
            RepositoryContext repositoryContext = (RepositoryContext)vector.elementAt(i);
            String string = (String)vector.elementAt(i + 1);
            String string2 = null;
            ModuleConfig moduleConfig = (ModuleConfig)deploymentTargetMapping.getConfig();
            if (moduleConfig != null) {
                string2 = moduleConfig.getName();
            }
            if ((!AppUtils.isEmpty(string) || !AppUtils.isEmpty(string2)) && !string.equals(string2) || !repositoryContext.getName().equals(deploymentTargetMapping.getTarget().getName())) continue;
            if (deploymentTargetMapping.getTarget() instanceof ClusteredTarget && AppUtils.isCluster(repositoryContext)) {
                return i;
            }
            if (!(deploymentTargetMapping.getTarget() instanceof ServerTarget) || !AppUtils.isServer(repositoryContext) || !repositoryContext.getParent().getName().equals(((ServerTarget)deploymentTargetMapping.getTarget()).getNodeName())) continue;
            return i;
        }
        return -1;
    }

    private static ModuleConfig getOrCreateConfig(ModuleDeployment moduleDeployment, String string, AppcfgFactory appcfgFactory) throws Exception {
        EList eList = moduleDeployment.getConfigs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleConfig moduleConfig = (ModuleConfig)eList.get(i);
            if (!moduleConfig.getName().equals(string)) continue;
            return moduleConfig;
        }
        if (AppUtils.isEmpty(string)) {
            return null;
        }
        if (moduleDeployment instanceof EJBModuleDeployment) {
            EJBModuleConfiguration eJBModuleConfiguration = appcfgFactory.createEJBModuleConfiguration();
            eJBModuleConfiguration.setName(string);
            eList.add(eJBModuleConfiguration);
            return eJBModuleConfiguration;
        }
        if (moduleDeployment instanceof WebModuleDeployment) {
            WebModuleConfig webModuleConfig = appcfgFactory.createWebModuleConfig();
            webModuleConfig.setName(string);
            eList.add(webModuleConfig);
            return webModuleConfig;
        }
        return null;
    }

    private static DeploymentTarget getOrCreateTarget(Deployment deployment, RepositoryContext repositoryContext, AppdeploymentFactory appdeploymentFactory) throws Exception {
        EList eList = deployment.getDeploymentTargets();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(i);
            if (deploymentTarget instanceof ClusteredTarget && AppUtils.isCluster(repositoryContext) && deploymentTarget.getName().equals(repositoryContext.getName())) {
                return deploymentTarget;
            }
            if (!(deploymentTarget instanceof ServerTarget) || !AppUtils.isServer(repositoryContext) || !deploymentTarget.getName().equals(repositoryContext.getName()) || !repositoryContext.getParent().getName().equals(((ServerTarget)deploymentTarget).getNodeName())) continue;
            return deploymentTarget;
        }
        DeploymentTarget deploymentTarget = null;
        deploymentTarget = AppUtils.isCluster(repositoryContext) ? appdeploymentFactory.createClusteredTarget() : appdeploymentFactory.createServerTarget();
        deploymentTarget.setName(repositoryContext.getName());
        if (deploymentTarget instanceof ServerTarget) {
            ((ServerTarget)deploymentTarget).setNodeName(repositoryContext.getParent().getName());
        }
        deployment.getDeploymentTargets().add(deploymentTarget);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created target: " + deploymentTarget);
        }
        return deploymentTarget;
    }
}

