/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpFactoryConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundLink;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.OutboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;

public class HttpOutboundChannel
extends OutboundProtocolChannel {
    private static final TraceComponent tc = Tr.register(HttpOutboundChannel.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_RUNNING = 2;
    private Class appInterface = null;
    private Class devInterface = null;
    private Class devAddrInterface = null;
    private Class[] appAddrInterfaces = new Class[1];
    private HttpObjectFactory myObjectFactory = null;
    private HttpOutboundChannelFactory channelFactory = null;
    private HttpChannelConfig myConfig = null;
    private int myState = 0;

    public HttpOutboundChannel(ChannelData channelData, HttpOutboundChannelFactory httpOutboundChannelFactory, HttpObjectFactory httpObjectFactory) {
        super(channelData);
        this.channelFactory = httpOutboundChannelFactory;
        this.appInterface = HttpOutboundServiceContext.class;
        this.devInterface = TCPConnectionContext.class;
        this.devAddrInterface = TCPConnectRequestContext.class;
        this.appAddrInterfaces[0] = HttpAddress.class;
        this.myObjectFactory = httpObjectFactory;
        this.update(channelData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
    }

    public final ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        return new HttpOutboundLink(this, virtualConnection);
    }

    public final Class getApplicationInterface() {
        return this.appInterface;
    }

    public final Class getDeviceInterface() {
        return this.devInterface;
    }

    public final Class getDeviceAddress() {
        return this.devAddrInterface;
    }

    public final Class[] getApplicationAddress() {
        return this.appAddrInterfaces;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myConfig;
    }

    public final void setHttpConfig(HttpChannelConfig httpChannelConfig) {
        this.myConfig = httpChannelConfig;
    }

    public final HttpFactoryConfig getFactoryConfig() {
        return this.channelFactory.getConfig();
    }

    public final HttpObjectFactory getObjectFactory() {
        return this.myObjectFactory;
    }

    public synchronized boolean isRunning() {
        return 2 == this.myState;
    }

    public synchronized boolean isStopping() {
        return 2 != this.myState;
    }

    public synchronized boolean isStopped() {
        return 0 == this.myState;
    }

    private synchronized void setState(int n) {
        this.myState = n;
    }

    public void start() {
        this.setState(2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
    }

    public void stop(long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stopping channel with (" + l + ") : " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
        if (0L == l) {
            this.setState(0);
        } else {
            this.setState(1);
        }
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
    }

    public void destroy() {
        this.setState(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
        this.channelFactory.destroyChannel(this.getConfig().getName());
    }

    public void update(ChannelData channelData) {
        this.setHttpConfig(new HttpChannelConfig(channelData));
        super.setConfig(channelData);
    }
}

