/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSCReadCallback myInstance = null;

    private HttpOSCReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSCReadCallback();
        }
    }

    public static final HttpOSCReadCallback getRef() {
        if (null == myInstance) {
            HttpOSCReadCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + virtualConnection);
        }
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        VirtualConnection virtualConnection2 = null;
        try {
            do {
                if (httpOutboundServiceContextImpl.parseMessage()) {
                    httpOutboundServiceContextImpl.handleParsedMessage();
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reading for more data");
                }
                httpOutboundServiceContextImpl.setupReadBuffers(httpOutboundServiceContextImpl.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (virtualConnection2 = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)this, false, httpOutboundServiceContextImpl.getReadTimeout())));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".complete", "112", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception: " + exception.getMessage());
            }
            httpOutboundServiceContextImpl.setPersistent(false);
            httpOutboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)exception);
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + virtualConnection + " ioe=" + iOException);
        }
        if ((httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).canceledRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring error callback on canceled read");
            }
            httpOutboundServiceContextImpl.resetCanceledRead();
            return;
        }
        httpOutboundServiceContextImpl.setPersistent(false);
        httpOutboundServiceContextImpl.reConnect(virtualConnection, iOException);
    }
}

