/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpFactoryConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.inbound.impl.Http100ContWriteCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCBodyReadCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCWriteCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCWriteErrorCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.values.impl.ReturnCodes;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.IllegalResponseObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class HttpInboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpInboundServiceContext {
    private static final TraceComponent tc = Tr.register(HttpInboundServiceContextImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final String CLASS_NAME = HttpInboundServiceContextImpl.class.getName();
    private static final String HTTP_ERROR_IDENTIFIER = "Http Error ID";
    private HttpInboundLink myLink = null;
    private boolean bCheckedAcceptEncoding = false;
    private boolean bCompressionAllowed = false;
    private boolean bIsRequestFormData = false;
    private boolean bContainsLargeMessage = false;

    public HttpInboundServiceContextImpl(TCPConnectionContext tCPConnectionContext, HttpInboundLink httpInboundLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        this.init(tCPConnectionContext, (ConnectionLink)httpInboundLink, virtualConnection, httpChannelConfig);
    }

    public void init(TCPConnectionContext tCPConnectionContext, ConnectionLink connectionLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing ISC: " + this);
        }
        super.init(tCPConnectionContext, httpChannelConfig);
        this.setBodyRC(HttpISCBodyReadCallback.getRef());
        this.myLink = (HttpInboundLink)connectionLink;
        this.setVC(virtualConnection);
        virtualConnection.getStateMap().put(CallbackIDs.CALLBACK_HTTPISC, this);
        this.getRequestImpl().initScheme();
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying ISC: " + this);
        }
        this.getVC().getStateMap().remove(CallbackIDs.CALLBACK_HTTPISC);
        this.getVC().getStateMap().remove(HTTP_ERROR_IDENTIFIER);
        this.myLink = null;
        super.destroy();
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing ISC: " + this);
        }
        super.clear();
        this.bCheckedAcceptEncoding = false;
        this.bIsRequestFormData = false;
        this.bContainsLargeMessage = false;
        this.getVC().getStateMap().remove("HTTPFinalWrite");
    }

    protected void updatePersistence(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (this.myLink.maxRequestsServed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Max requests already processed on this connection");
            }
            this.setPersistent(false);
        } else if (this.getResponse().getStatusCode().isErrorCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error status code disabling persistence.");
            }
            this.setPersistent(false);
        } else {
            super.updatePersistence(httpBaseMessageImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePersistence(inbound) updated: " + this.isPersistent());
        }
    }

    protected void updateBodyLengthHeaders(HttpBaseMessage httpBaseMessage) {
        if (!this.getRequestImpl().getMethodValue().equals(HttpConstants.METHOD_HEAD)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Body not valid on response, fixing headers");
            }
            if (0 < httpBaseMessage.getContentLength()) {
                httpBaseMessage.removeHeader(HttpConstants.HDR_CONTENT_LENGTH);
            }
            httpBaseMessage.setTransferEncoding(HttpConstants.TRANSFER_ENCODING_NOTSET);
        }
    }

    private ReturnCodes parseQValue(byte[] byArray, int n) {
        ReturnCodes returnCodes = new ReturnCodes(false);
        if (n >= byArray.length || 113 != byArray[n] && 81 != byArray[n]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non qvalue found");
            }
        } else if (++n >= byArray.length || 61 != byArray[n]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid qvalue found (missing equals)");
            }
        } else if (++n < byArray.length) {
            if (49 == byArray[n]) {
                returnCodes.setBooleanValue(true);
            } else if (48 == byArray[n]) {
                if (++n < byArray.length && 46 == byArray[n]) {
                    for (int i = 0; ++n < byArray.length && i < 3; ++i) {
                        if (48 == byArray[n]) continue;
                        if (49 <= byArray[n] && 57 >= byArray[n]) {
                            returnCodes.setBooleanValue(true);
                            break;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Non-digit qvalue decimal: " + (char)byArray[n]);
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non-digit qvalue found: " + (char)byArray[n]);
            }
        }
        returnCodes.setIntValue(n);
        return returnCodes;
    }

    protected boolean isCompressionAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isCompressionAllowed");
        }
        if (this.bCheckedAcceptEncoding) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isCompressionAllowed(1): " + this.bCompressionAllowed);
            }
            return this.bCompressionAllowed;
        }
        boolean bl = false;
        byte[] byArray = null;
        if (this.isGZipEncoded() || this.isXGZipEncoded()) {
            byArray = HttpConstants.CONTENT_ENCODING_GZIP.getByteArray();
        } else if (this.isZlibEncoded()) {
            byArray = HttpConstants.CONTENT_ENCODING_DEFLATE.getByteArray();
        } else {
            this.bCheckedAcceptEncoding = true;
            this.bCompressionAllowed = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isCompressionAllowed(2): false");
            }
            return false;
        }
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray2 = this.getRequest().getHeaderAsByteArray(HttpConstants.HDR_ACCEPT_ENCODING);
        if (null != byArray2) {
            while (n < byArray2.length) {
                int n2;
                ReturnCodes returnCodes;
                if (32 == byArray2[n] && (n = GenericUtils.skipWhiteSpace(byArray2, n)) >= byArray2.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Ran out of data");
                    }
                    break;
                }
                if (42 == byArray2[n]) {
                    bl2 = true;
                    if (++n < byArray2.length && 59 == byArray2[n]) {
                        returnCodes = this.parseQValue(byArray2, ++n);
                        bl3 = returnCodes.getBooleanValue();
                        n = GenericUtils.skipToChar(byArray2, returnCodes.getIntValue(), (byte)44) + 1;
                        continue;
                    }
                    bl3 = true;
                    continue;
                }
                if (n < byArray2.length && (120 == byArray2[n] || 88 == byArray2[n])) {
                    if (++n < byArray2.length && 45 == byArray2[n]) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "skipping past [x-]");
                        }
                        ++n;
                    } else {
                        --n;
                    }
                }
                for (n2 = 0; n2 < byArray.length && n < byArray2.length && (byArray[n2] == byArray2[n] || GenericUtils.reverseCase(byArray[n2]) == byArray2[n]); ++n2, ++n) {
                }
                if (n2 != byArray.length) {
                    n = GenericUtils.skipToChar(byArray2, n, (byte)44) + 1;
                    continue;
                }
                if (n < byArray2.length && 32 == byArray2[n]) {
                    n = GenericUtils.skipWhiteSpace(byArray2, n);
                }
                if (n < byArray2.length && 44 == byArray2[n]) {
                    bl = true;
                    break;
                }
                if (n < byArray2.length && 59 == byArray2[n]) {
                    returnCodes = this.parseQValue(byArray2, ++n);
                    bl = returnCodes.getBooleanValue();
                    break;
                }
                if (n >= byArray2.length) {
                    bl = true;
                    break;
                }
                n = GenericUtils.skipToChar(byArray2, n, (byte)44) + 1;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Accept-Encoding header not present");
            }
            bl = true;
        }
        if (!bl && bl2 && bl3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No explicit match, but wildcard was found");
            }
            bl = true;
        }
        this.bCheckedAcceptEncoding = true;
        this.bCompressionAllowed = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isCompressionAllowed(3): " + bl);
        }
        return bl;
    }

    public boolean isIncomingMessageFullyRead() {
        if (!this.isBodyComplete()) {
            return !super.isIncomingBodyExpected();
        }
        return true;
    }

    public HttpRequestMessage getRequest() {
        return this.getRequestImpl();
    }

    protected final HttpRequestMessageImpl getRequestImpl() {
        if (null == this.getMyRequest()) {
            this.setMyRequest(this.getObjectFactory().getRequest(this));
            this.getMyRequest().setHeaderChangeLimit(this.getHttpConfig().getHeaderChangeLimit());
        }
        return this.getMyRequest();
    }

    public HttpResponseMessage getResponse() {
        return this.getResponseImpl();
    }

    protected final HttpResponseMessageImpl getResponseImpl() {
        if (null == this.getMyResponse()) {
            this.setMyResponse(this.getObjectFactory().getResponse(this));
        }
        return this.getMyResponse();
    }

    public void setResponse(HttpResponseMessage httpResponseMessage) throws IllegalResponseObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setResponse");
        }
        if (null == httpResponseMessage) {
            throw new IllegalResponseObjectException("Illegal null message");
        }
        HttpResponseMessageImpl httpResponseMessageImpl = null;
        try {
            httpResponseMessageImpl = (HttpResponseMessageImpl)httpResponseMessage;
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non msg impl passed to setResponse");
            }
            throw new IllegalResponseObjectException("Invalid message provided");
        }
        if (null != this.getMyResponse() && this.isResponseOwner()) {
            this.getMyResponse().destroy();
        }
        this.setMyResponse(httpResponseMessageImpl);
        this.getMyResponse().init(this);
        this.getMyResponse().setHeaderChangeLimit(this.getHttpConfig().getHeaderChangeLimit());
        this.updatePersistence(this.getMyResponse());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setResponse");
        }
    }

    public void sendResponseHeaders() throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendResponseHeaders(sync)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".sendResponseHeaders", "594");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            throw iOException;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        this.sendHeaders(this.getResponseImpl());
        if (this.getResponseImpl().isTemporaryStatusCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Temp response sent, resetting send flags.");
            }
            this.resetWrite();
        }
    }

    public VirtualConnection sendResponseHeaders(InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendResponseHeaders(async)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".sendResponseHeaders", "639");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendReponseHeaders(async): no request");
            }
            return null;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendHeaders(this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != virtualConnection && this.getResponseImpl().isTemporaryStatusCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Temp response sent, resetting send flags.");
            }
            this.resetWrite();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendResponseHeaders(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public void sendResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendResponseBody(body)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".sendResponseBody", "684");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            throw iOException;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "sendBody() setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.sendOutgoing(wsByteBufferArray, this.getResponseImpl());
    }

    public VirtualConnection sendResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendResponseBody(body,cb)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".sendResponseBody", "746");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "sendBody(cb) setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        return this.sendOutgoing(wsByteBufferArray, this.getResponseImpl(), HttpISCWriteCallback.getRef());
    }

    public void sendRawResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawResponseBody(sync)");
        }
        this.setRawBody(true);
        this.sendResponseBody(wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawResponseBody(sync)");
        }
    }

    public VirtualConnection sendRawResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRawResponseBody(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.sendResponseBody(wsByteBufferArray, interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRawResponseBody(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    protected HttpInvalidMessageException checkResponseValidity() {
        if (!HttpConstants.METHOD_HEAD.equals(this.getRequest().getMethodValue())) {
            int n = this.getResponse().getContentLength();
            int n2 = this.getNumBytesWritten();
            if (-1 != n && n2 != n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Response had content-length of " + n + " but sent " + n2);
                }
                if (this.getHttpConfig().isErrorLoggingEnabled()) {
                    this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_ERROR, "Mismatch in content-length and bytes written: " + n + " but sent " + n2, (HttpServiceContext)this);
                }
                this.setPersistent(false);
                return new HttpInvalidMessageException("Response length: " + n + " " + n2);
            }
        }
        return null;
    }

    protected void logFinalResponse() {
        if (!this.getHttpConfig().isAccessLoggingEnabled()) {
            return;
        }
        if (HttpConstants.METHOD_UNDEF.equals(this.getRequest().getMethodValue())) {
            return;
        }
        this.getHttpConfig().getHttpLogger().logAccess(this.getRequest(), this.getResponse(), this.getRequestVersion().getName(), null, this.getRemoteAddr().getHostAddress(), this.getNumBytesWritten());
    }

    public void finishResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishResponseMessage(body)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".finishResponseMessage", "941");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            throw iOException;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getResponseImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "finishMessage() setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.sendFullOutgoing(wsByteBufferArray, this.getResponseImpl());
        this.logFinalResponse();
        HttpInvalidMessageException httpInvalidMessageException = this.checkResponseValidity();
        if (null != httpInvalidMessageException) {
            throw httpInvalidMessageException;
        }
    }

    public VirtualConnection finishResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishResponseMessage(body,cb)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".finishResponseMessage", "1010");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getResponseImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "finishMessage(cb) setting partial body false");
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendFullOutgoing(wsByteBufferArray, this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != virtualConnection) {
            this.logFinalResponse();
            HttpInvalidMessageException httpInvalidMessageException = this.checkResponseValidity();
            if (null != httpInvalidMessageException) {
                interChannelCallback.error(virtualConnection, (Throwable)httpInvalidMessageException);
                return null;
            }
        }
        return virtualConnection;
    }

    public void finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawResponseMessage(sync)");
        }
        this.setRawBody(true);
        this.finishResponseMessage(wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawResponseMessage(sync)");
        }
    }

    public VirtualConnection finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRawResponseMessage(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.finishResponseMessage(wsByteBufferArray, interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRawResponseMessage(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public void sendError(HttpError httpError) throws MessageSentException {
        VirtualConnection virtualConnection;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called sendError with: " + httpError);
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".sendError", "1116");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to send response without a request msg");
            }
            this.finishSendError(iOException);
            return;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (null == httpError) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset null error to Internal Server Error");
            }
            httpError = HttpConstants.STATUS_INTERNAL_ERROR.getHttpError();
        }
        this.getResponse().setStatusCode(httpError.getErrorCode());
        if (this.getResponse().getStatusCode().isErrorCode()) {
            this.setPersistent(false);
        }
        this.getVC().getStateMap().put(HTTP_ERROR_IDENTIFIER, httpError);
        this.getResponseImpl().setConnection(HttpConstants.CONN_CLOSE);
        if (this.getHttpConfig().isErrorLoggingEnabled()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_ERROR, "Sending an error status code: " + httpError.getErrorCode(), (HttpServiceContext)this);
        }
        if (null != (virtualConnection = this.finishResponseMessage(httpError.getErrorBody(), HttpISCWriteErrorCallback.getRef(), false))) {
            this.finishSendError(httpError.getClosingException());
        }
    }

    protected void finishSendError() {
        HttpError httpError;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishSendError: " + this.getVC());
        }
        if (null != (httpError = (HttpError)this.getVC().getStateMap().get(HTTP_ERROR_IDENTIFIER))) {
            this.myLink.close(this.getVC(), httpError.getClosingException());
        } else {
            this.myLink.close(this.getVC(), null);
        }
    }

    protected void finishSendError(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finishSendError(exception): " + this.getVC());
        }
        this.myLink.close(this.getVC(), exception);
    }

    protected boolean check100Continue() {
        if (!this.getRequest().isExpect100Continue()) {
            return true;
        }
        if (this.myLink.getChannel().isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped, sending error instead of 100-continue");
            }
            try {
                this.sendError(HttpConstants.STATUS_UNAVAILABLE.getHttpError());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, CLASS_NAME + ".check100Continue", "1206");
            }
            return false;
        }
        if (this.getHttpConfig().isServantRegion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "100 continue not sent on SR");
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Request contains [Expect: 100-continue]");
        }
        if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Request contains the Expect: 100 Continues header", (HttpServiceContext)this);
        }
        HttpResponseMessageImpl httpResponseMessageImpl = this.getResponseImpl();
        httpResponseMessageImpl.setStatusCode(HttpConstants.STATUS_CONTINUE);
        httpResponseMessageImpl.setContentLength(0);
        VirtualConnection virtualConnection = this.sendHeaders(httpResponseMessageImpl, Http100ContWriteCallback.getRef());
        if (null == virtualConnection) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Async write of 100 continue still going");
            }
            return false;
        }
        this.resetMsgSentState();
        httpResponseMessageImpl.setStatusCode(HttpConstants.STATUS_OK);
        httpResponseMessageImpl.removeHeader(HttpConstants.HDR_CONTENT_LENGTH);
        return true;
    }

    public boolean isFormData() {
        return this.bIsRequestFormData;
    }

    protected boolean checkFormData() {
        return false;
    }

    protected void finishFormDataReads() {
        if (!this.isBodyComplete()) {
            try {
                this.getNextReadBuffer();
                if (this.readBodyBuffers(this.getRequestImpl(), true)) {
                    return;
                }
            }
            catch (BodyCompleteException bodyCompleteException) {
            }
            catch (Exception exception) {
                this.formDataError(exception);
                return;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Body fully read: " + this.isBodyComplete());
        }
        this.myLink.handleDiscrimination();
    }

    protected void formDataError(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Closing the connection due to exception: " + exception);
        }
        if (this.getHttpConfig().isErrorLoggingEnabled()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "Closing connection to client: " + exception, (HttpServiceContext)this);
        }
        if (exception instanceof SocketTimeoutException) {
            try {
                this.sendError(HttpConstants.STATUS_REQ_TIMEOUT.getHttpError());
            }
            catch (MessageSentException messageSentException) {
                this.myLink.getDeviceLink().close(this.getVC(), (Exception)messageSentException);
            }
        } else {
            this.myLink.getDeviceLink().close(this.getVC(), exception);
        }
    }

    public void purgeBodyBuffers(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Discarding body buffers...");
        }
        super.clearStorage();
        super.clearTempStorage();
        if (bl) {
            this.myLink.close(this.getVC(), null);
        }
    }

    public WsByteBuffer[] getRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffers(sync)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".getRequestBodyBuffers", "1281");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            throw iOException;
        }
        if (!this.isIncomingBodyValid()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(sync): No body allowed");
            }
            return null;
        }
        WsByteBuffer[] wsByteBufferArray = null;
        this.setMultiRead(true);
        if (!this.isBodyComplete()) {
            try {
                this.readBodyBuffers(this.getRequestImpl(), false);
            }
            catch (BodyCompleteException bodyCompleteException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffers(sync): BodyCompleteException");
                }
                return null;
            }
        }
        wsByteBufferArray = this.getAllStorageBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffers(sync): " + (null == wsByteBufferArray ? 0 : wsByteBufferArray.length));
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffers(async)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".getRequestBodyBuffers", "1355");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): no hdrs yet");
            }
            return null;
        }
        if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): read not needed");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getRequestImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffers(async): read finished");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffers(async): exception:" + iOException);
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffers(async): null");
        }
        return null;
    }

    public WsByteBuffer getRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffer(sync)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".getRequestBodyBuffer", "1436");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            throw iOException;
        }
        if (!this.isIncomingBodyValid()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(sync): No body allowed");
            }
            return null;
        }
        this.setMultiRead(false);
        WsByteBuffer wsByteBuffer = this.getNextBuffer();
        if (null == wsByteBuffer && !this.isBodyComplete()) {
            try {
                this.readBodyBuffer(this.getRequestImpl(), false);
            }
            catch (BodyCompleteException bodyCompleteException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffer(sync): BodyCompleteException");
                }
                return null;
            }
            wsByteBuffer = this.getNextBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffer(sync): " + wsByteBuffer);
        }
        return wsByteBuffer;
    }

    public VirtualConnection getRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestBodyBuffer(async)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException(iOException, CLASS_NAME + ".getRequestBodyBuffer", "1511");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to read a body without headers");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): no hdrs yet");
            }
            return null;
        }
        if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): read not needed");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(false);
        try {
            if (!this.readBodyBuffer(this.getRequestImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequestBodyBuffer(async): read finished");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequestBodyBuffer(async): exception: " + iOException);
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestBodyBuffer(async): null");
        }
        return null;
    }

    public WsByteBuffer getRawRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffer(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer wsByteBuffer = this.getRequestBodyBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffer(sync): " + wsByteBuffer);
        }
        return wsByteBuffer;
    }

    public WsByteBuffer[] getRawRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffers(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer[] wsByteBufferArray = this.getRequestBodyBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffers(sync): " + wsByteBufferArray);
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getRawRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffer(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getRequestBodyBuffer(interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffer(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    public VirtualConnection getRawRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawRequestBodyBuffers(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getRequestBodyBuffers(interChannelCallback, bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawRequestBodyBuffers(async): " + virtualConnection);
        }
        return virtualConnection;
    }

    protected HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getRequestImpl();
    }

    protected HttpBaseMessageImpl getMessageBeingSent() {
        return this.getResponseImpl();
    }

    protected final void parsingComplete() throws Exception {
        super.parsingComplete();
        if (super.isContentLength()) {
            this.checkIncomingMessageLimit(super.getContentLength());
        }
    }

    protected final boolean containsLargeMessage() {
        return this.bContainsLargeMessage;
    }

    protected final void checkIncomingMessageLimit(int n) throws MessageTooLargeException {
        int n2;
        super.addToIncomingMsgSize(n);
        HttpFactoryConfig httpFactoryConfig = this.myLink.getChannel().getFactory().getConfig();
        if (!httpFactoryConfig.areMessagesLimited() || !this.myLink.getChannel().isMessageSizeLimited()) {
            return;
        }
        boolean bl = false;
        int n3 = super.queryIncomingMsgSize();
        if (this.bContainsLargeMessage) {
            n2 = httpFactoryConfig.getLargerBufferSize();
            if (n2 < n3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message hit the higher size limit: " + this);
                }
                bl = true;
            }
        } else {
            n2 = httpFactoryConfig.getMessageSize();
            if (n2 < n3) {
                if (this.myLink.getChannel().getFactory().allowLargeMessage(n3)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Large message allowed in: " + n3 + " " + this);
                    }
                    this.bContainsLargeMessage = true;
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message too large: " + n3 + "/" + n2);
            }
            throw new MessageTooLargeException("Size: " + n3 + " Limit: " + n2);
        }
    }

    public final HttpInboundLink getLink() {
        return this.myLink;
    }

    protected boolean reconnectAllowed() {
        return false;
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.myLink ? null : this.myLink.getObjectFactory();
    }

    public boolean isInboundConnection() {
        return true;
    }
}

