/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.CallStack;
import com.ibm.ws.ffdc.DiagnosticModuleRegistrationFailureException;
import com.ibm.ws.ffdc.IncidentStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DiagnosticModule {
    String[] directives;
    String[] defaultDirectives;
    Hashtable methodTable = new Hashtable();
    boolean continueProcessing = true;
    private static ThreadLocal threadLocal = new ThreadLocal();
    static final Class[] ffdcDumpParams = new Class[]{Throwable.class, IncidentStream.class, Object.class, new Object[0].getClass(), String.class};
    static final String ffdcDumpPrefix = "ffdcdump";
    static final String ffdcDumpDefault = "default";
    static final boolean debug = false;
    static final int PREFLEN = "ffdcdump".length();

    protected final void init() throws DiagnosticModuleRegistrationFailureException {
        Method[] methodArray = null;
        try {
            methodArray = this.getClass().getMethods();
            this.buildMethods(methodArray);
        }
        catch (Exception exception) {
            methodArray = new Method[]{};
            exception.printStackTrace();
            throw new DiagnosticModuleRegistrationFailureException("Exception: " + exception + " caught!", exception);
        }
    }

    public boolean validate() {
        System.out.println("This method is NOT intended to be called from the runtime");
        System.out.println("but is provided as part of unit test for diagnostic modules");
        try {
            this.init();
        }
        catch (DiagnosticModuleRegistrationFailureException diagnosticModuleRegistrationFailureException) {
            System.out.println("Diagnostic Module failed to register");
            diagnosticModuleRegistrationFailureException.printStackTrace();
            return false;
        }
        catch (Throwable throwable) {
            System.out.println("Some unknown failure occured");
            throwable.printStackTrace();
            return false;
        }
        System.out.println("ffdc methods on the diagnostic module : ");
        Enumeration enumeration = this.methodTable.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.println("    " + string);
        }
        System.out.println("The default directives are : ");
        if (this.defaultDirectives == null || this.defaultDirectives.length == 0) {
            System.out.println("No default directives were found");
            System.out.println("This diagnostic module would fail to register");
            return false;
        }
        for (int i = 0; i < this.defaultDirectives.length && this.defaultDirectives[i] != null; ++i) {
            System.out.println("    " + this.defaultDirectives[i]);
        }
        return true;
    }

    public void stopProcessingException() {
        this.continueProcessing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpComponentData(String[] stringArray, Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string, String[] stringArray2) {
        this.continueProcessing = true;
        try {
            threadLocal.set(stringArray2);
            incidentStream.writeLine("==> Performing default dump from " + this.getClass().getName() + " ", new Date());
            this.getDataForDirectives(this.defaultDirectives, throwable, incidentStream, object, objectArray, string);
            if (stringArray != null && stringArray.length > 0) {
                incidentStream.writeLine("==> Default dump complete for " + this.getClass().getName() + ".\n\n==> Now customized dump is running... ", new Date());
                this.getDataForDirectives(stringArray, throwable, incidentStream, object, objectArray, string);
            }
            incidentStream.writeLine("==> Dump complete for " + this.getClass().getName() + " ", new Date());
        }
        catch (Throwable throwable2) {
            incidentStream.writeLine("==> Dump did not complete for " + this.getClass().getName() + " ", new Date());
        }
        finally {
            threadLocal.set(null);
        }
        return this.continueProcessing;
    }

    protected static final String getExecutionMethodName() {
        String string = null;
        int n = 0;
        try {
            String[] stringArray = (String[])threadLocal.get();
            if (stringArray != null && (n = CallStack.currentExecutionPoint(stringArray)) != -1) {
                string = stringArray[n];
            }
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    void buildMethods(Method[] methodArray) {
        Object object;
        Object object2;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            object2 = method2.getName().toLowerCase();
            if (((String)object2).length() <= PREFLEN || !((String)object2).startsWith(ffdcDumpPrefix)) continue;
            object = method2.getParameterTypes();
            if (((Class<?>[])object).length != ffdcDumpParams.length) {
                throw new IllegalStateException("Error: " + method2 + " starts with " + ffdcDumpPrefix + " but takes " + ((Object)object).length + " parameters.  It is supposed to have " + ffdcDumpParams.length + " parameters and have the signature " + ffdcDumpPrefix + "<....>(" + this.buildParamList() + ");" + " Method skipped!");
            }
            boolean bl = false;
            for (int j = 0; j < ((Class<?>[])object).length; ++j) {
                if (object[j] == ffdcDumpParams[j]) continue;
                throw new IllegalStateException("Error: " + method2 + " starts with " + ffdcDumpPrefix + " but does not conform to the signature\n\t" + ffdcDumpPrefix + "<....>(" + this.buildParamList() + "); \n\tParameter " + (j + 1) + " does not match.  Method skipped!");
            }
            if (bl) continue;
            this.methodTable.put(((String)object2).substring(PREFLEN), method2);
        }
        this.directives = new String[this.methodTable.size()];
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        object2 = this.methodTable.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            this.directives[n++] = object;
            if (!((String)object).startsWith(ffdcDumpDefault)) continue;
            vector.addElement(object);
        }
        if (vector.isEmpty()) {
            throw new IllegalStateException("Error: class " + this.getClass().getName() + " must have at least one DEFAULT dumping method of the form:\n\t" + ffdcDumpPrefix + ffdcDumpDefault + "<....>(" + this.buildParamList() + ");");
        }
        this.defaultDirectives = vector.toArray(new String[0]);
    }

    public String[] getDirectives() {
        return this.directives;
    }

    public void getDataForDirectives(String[] stringArray, Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (this.getDataForDirective(string2, throwable, incidentStream, object, objectArray, string)) {
                incidentStream.writeLine("+Data for directive [" + string2 + "] obtained.", "");
                continue;
            }
            incidentStream.writeLine("Error while processing directive [" + string2 + "] !!!", "");
        }
    }

    boolean getDataForDirective(String string, Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string2) {
        Method method2 = (Method)this.methodTable.get(string.toLowerCase());
        if (method2 == null) {
            return false;
        }
        try {
            Object[] objectArray2 = new Object[ffdcDumpParams.length];
            objectArray2[0] = throwable;
            objectArray2[1] = incidentStream;
            objectArray2[2] = object;
            objectArray2[3] = objectArray;
            objectArray2[4] = string2;
            method2.invoke((Object)this, objectArray2);
            return true;
        }
        catch (Throwable throwable2) {
            incidentStream.writeLine("Error: " + throwable2 + " occured during DM ffdc processing.", "");
            throwable2.printStackTrace();
            return false;
        }
    }

    String buildParamList() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ffdcDumpParams.length; ++i) {
            stringBuffer.append(DiagnosticModule.getTypeName(ffdcDumpParams[i]));
            if (i >= ffdcDumpParams.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("[]");
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }

    void msg(Object object) {
        System.out.println(object);
    }
}

