/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.bootstrap.ProtectionMetaData;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public class ProtectionClassLoader
extends ClassLoader
implements WsClassLoader {
    private static final TraceComponent tc = Tr.register(ProtectionClassLoader.class, "Websphere ClassLoader", null);
    private ClassLoader parent;
    private Class grandParent;
    private boolean protectClasses;
    private static final Permission accessRuntimePermission = new WebSphereRuntimePermission("accessRuntimeClasses");

    public ProtectionClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.parent = classLoader;
        this.grandParent = classLoader.getParent().getClass();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("ibm.websphere.internalClassAccessMode", "allow");
            }
        });
        string = string.toLowerCase();
        this.protectClasses = string.equals("restrict");
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        final Class<?> clazz = this.parent.loadClass(string);
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
        if (classLoader != null && (classLoader.getClass() == this.grandParent || classLoader == this.parent) && ProtectionClassLoader.isProtected(string)) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPermission(accessRuntimePermission);
                }
                catch (SecurityException securityException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempted to access protected class: " + string, securityException);
                    }
                    throw new ClassNotFoundException(string);
                }
            } else {
                if (this.protectClasses) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempted to access protected class: " + string);
                    }
                    throw new ClassNotFoundException(string);
                }
                if (tc.isDebugEnabled()) {
                    Exception exception = new Exception("Access given to protected class: " + string);
                    FFDCFilter.processException(exception, "com.ibm.ws.classloader.ProtectionClassLoader", "91");
                }
            }
        }
        return clazz;
    }

    public String getClassPath() {
        if (this.parent instanceof WsClassLoader) {
            return ((WsClassLoader)((Object)this.parent)).getClassPath();
        }
        return System.getProperty("java.class.path");
    }

    public static boolean isProtected(String string) {
        return ProtectionMetaData.isProtected(string);
    }
}

