/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.URL.ParserUtils;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class Handler
extends AbstractURLStreamHandlerService {
    private static TraceComponent tc = Tr.register(Handler.class.getName(), "Websphere ClassLoader", null);
    private static final String ENABLE_GETCONTENTTYPE_PROPERTY = "ibm.was.enable.wsjar.connection.getcontexttype";
    private static final boolean enableGetContentType = Boolean.getBoolean("ibm.was.enable.wsjar.connection.getcontexttype");
    static /* synthetic */ Class class$com$ibm$ws$classloader$Handler$ClassLoaderURLConnection;

    public static boolean register() {
        BundleContext bundleContext = BundleContextMap.instance().get(Handler.class.getClassLoader());
        if (bundleContext == null) {
            return false;
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        hashtable.put("url.handler.protocol", new String[]{"wsjar"});
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new Handler(), hashtable);
        return true;
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openConnection", uRL);
        }
        ClassLoaderURLConnection classLoaderURLConnection = new ClassLoaderURLConnection(uRL);
        ((URLConnection)classLoaderURLConnection).connect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openConnection");
        }
        return classLoaderURLConnection;
    }

    protected static int indexOfBangSlash(String string) {
        int n = string.length();
        while ((n = string.lastIndexOf(33, n)) != -1) {
            if (n != string.length() - 1 && string.charAt(n + 1) == '/') {
                return n;
            }
            --n;
        }
        return -1;
    }

    protected void parseURL(URL uRL, String string, int n, int n2) {
        int n3;
        int n4;
        String string2 = uRL.getFile();
        string2 = string2 != null ? (string.charAt(0) == '/' ? ((n4 = Handler.indexOfBangSlash(string2)) != -1 ? string2.substring(0, n4 + 1) + string : string2 + "!" + string) : ((n3 = string2.lastIndexOf("/")) == -1 ? "/" + string : (n3 == string2.length() - 1 ? string2 + string : string2.substring(0, n3 + 1) + string))) : string.substring(n, n2);
        this.setURL(uRL, "wsjar", uRL.getHost(), uRL.getPort(), string2, null);
    }

    private static class ZipEntryInputStream
    extends FilterInputStream {
        private ZipFile zipFile;

        ZipEntryInputStream(ZipFile zipFile, InputStream inputStream) {
            super(inputStream);
            this.zipFile = zipFile;
        }

        public void close() throws IOException {
            this.zipFile.close();
        }
    }

    static class ClassLoaderURLConnection
    extends URLConnection {
        private static TraceComponent tc = Tr.register((class$com$ibm$ws$classloader$Handler$ClassLoaderURLConnection == null ? (class$com$ibm$ws$classloader$Handler$ClassLoaderURLConnection = Handler.class$("com.ibm.ws.classloader.Handler$ClassLoaderURLConnection")) : class$com$ibm$ws$classloader$Handler$ClassLoaderURLConnection).getName(), "Websphere ClassLoader", null);
        URL _url;
        boolean isConnected = false;

        ClassLoaderURLConnection(URL uRL) throws MalformedURLException {
            super(uRL);
            this._url = uRL;
        }

        public synchronized void connect() throws IOException {
            if (this.isConnected) {
                return;
            }
            this.isConnected = true;
        }

        public InputStream getInputStream() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInputStream");
            }
            ZipFile zipFile = null;
            InputStream inputStream = null;
            try {
                String string = ParserUtils.decode((String)this._url.getFile());
                int n = Handler.indexOfBangSlash(string);
                String string2 = string.substring(n + 2);
                string = string.substring(5, n);
                zipFile = new ZipFile(string);
                ZipEntry zipEntry = zipFile.getEntry(string2);
                inputStream = zipFile.getInputStream(zipEntry);
                inputStream = new ZipEntryInputStream(zipFile, inputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInputStream");
            }
            return inputStream;
        }

        public long getLastModified() {
            String string = ParserUtils.decode((String)this._url.getFile());
            int n = Handler.indexOfBangSlash(string);
            string = string.substring(5, n);
            File file = new File(string);
            return file.lastModified();
        }

        public Permission getPermission() throws IOException {
            String string = ParserUtils.decode((String)this._url.getFile());
            int n = Handler.indexOfBangSlash(string);
            string = string.substring(5, n);
            if (File.separatorChar == '/') {
                return new FilePermission(string, "read");
            }
            return new FilePermission(string.replace('/', File.separatorChar), "read");
        }

        public String getContentType() {
            String string = null;
            if (enableGetContentType) {
                Object object;
                try {
                    this.connect();
                    object = this.getInputStream();
                    string = URLConnection.guessContentTypeFromStream(new BufferedInputStream((InputStream)object));
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (string == null) {
                    object = null;
                    String string2 = this._url.getFile();
                    int n = string2.lastIndexOf(33);
                    if (n < 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "URL lacks '!'");
                        }
                    } else {
                        if (++n != string2.length()) {
                            object = string2.substring(n, string2.length());
                        }
                        string = object != null ? URLConnection.guessContentTypeFromName((String)object) : "x-java/jar";
                    }
                }
                if (string == null) {
                    string = "content/unknown";
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getContentType is disabled");
            }
            return string;
        }
    }
}

