/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.ws.classloader.ClassGraph;
import com.ibm.ws.classloader.ClassGraphState;
import com.ibm.ws.classloader.ClassLoaderDump;
import com.ibm.ws.classloader.ClassLoaderListener;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.classloader.SingleServerClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;

public class ClassLoaderManager {
    private static TraceComponent tc = Tr.register(ClassLoaderManager.class.getName(), "Websphere ClassLoader", null);
    protected ClassLoader parent = null;
    protected ReloadableClassLoader applicationClassLoader;
    protected EARFile earFile = null;
    protected Map moduleClassLoaderLookup = Collections.synchronizedMap(new HashMap());
    protected HashMap listenerListLookup = new HashMap();
    protected boolean disposed = false;
    protected HashSet timers = new HashSet();
    protected boolean overrideReload = false;
    protected long overrideReloadInterval = 0L;
    protected boolean processFarFiles = false;
    protected String specifiedWasPolicy = null;
    protected boolean specifiedLibraryDelegation;
    protected ClassLoader warParent = null;
    protected ClassGraphState classGraphState = null;
    private static boolean singleServerClassLoader = false;
    protected boolean singleWarClassLoader = false;
    private static boolean defaultDelegationMode = true;
    protected static JarClassLoader serverClassLoader = null;

    public static void setSingleServerClassLoader(boolean bl) {
        singleServerClassLoader = bl;
    }

    public static boolean getSingleServerClassLoader() {
        return singleServerClassLoader;
    }

    public static void setDefaultDelegationMode(boolean bl) {
        defaultDelegationMode = bl;
    }

    public static boolean getDefaultDelegationMode() {
        return defaultDelegationMode;
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, boolean bl2, String string, boolean bl3, long l) {
        this(classLoader, eARFile, bl, stringArray, bl2, string, bl3, l, false);
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, boolean bl2, String string, boolean bl3, long l, boolean bl4) {
        this(classLoader, eARFile, bl, stringArray, new String[0], bl2, string, bl3, l, false);
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2, String string, boolean bl3, long l, boolean bl4) {
        this.overrideReload = bl3;
        this.overrideReloadInterval = l;
        this.processFarFiles = bl4;
        this.specifiedLibraryDelegation = bl2;
        this.specifiedWasPolicy = string;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        hashMap.put(null, stringArray);
        hashMap2.put(null, stringArray2);
        this.initialize(classLoader, eARFile, bl, hashMap, hashMap2);
        hashMap.clear();
        hashMap2.clear();
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, Map map, Map map2, boolean bl2, String string, boolean bl3, long l, boolean bl4) {
        this.overrideReload = bl3;
        this.overrideReloadInterval = l;
        this.processFarFiles = bl4;
        this.specifiedLibraryDelegation = bl2;
        this.specifiedWasPolicy = string;
        this.initialize(classLoader, eARFile, bl, map, map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(ClassLoader classLoader, EARFile eARFile, boolean bl, Map map, Map map2) {
        ModuleRef moduleRef;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.parent = classLoader;
        this.earFile = eARFile;
        this.singleWarClassLoader = bl;
        if (singleServerClassLoader) {
            object = classLoader;
            synchronized (object) {
                if (serverClassLoader == null) {
                    serverClassLoader = new SingleServerClassLoader(classLoader, defaultDelegationMode);
                }
            }
        }
        object = new ClassGraph(classLoader, map, map2, this.specifiedLibraryDelegation, bl);
        Iterator iterator = eARFile.getModuleRefs().iterator();
        while (iterator.hasNext()) {
            moduleRef = (ModuleRef)iterator.next();
            ((ClassGraph)object).addModule(moduleRef);
        }
        if (this.processFarFiles) {
            this.processFARFiles(eARFile, (ClassGraph)object);
        }
        this.warParent = ((ClassGraph)object).calculate(eARFile, this.specifiedWasPolicy);
        this.classGraphState = ((ClassGraph)object).getState();
        iterator = eARFile.getModuleRefs().iterator();
        while (iterator.hasNext()) {
            moduleRef = (ModuleRef)iterator.next();
            ReloadableClassLoader reloadableClassLoader = ((ClassGraph)object).lookupClassLoader(moduleRef);
            if (reloadableClassLoader == null) continue;
            this.moduleClassLoaderLookup.put(moduleRef, reloadableClassLoader);
            if (reloadableClassLoader != serverClassLoader) {
                this.createTimer(moduleRef);
            }
            ClassLoaderDump.addModule(moduleRef.getUri(), reloadableClassLoader);
        }
        this.applicationClassLoader = ((ClassGraph)object).lookupClassLoader(null);
        this.moduleClassLoaderLookup.put(null, this.applicationClassLoader);
        this.createTimer(null);
        ClassLoaderDump.addApplication(eARFile.getURI(), this.applicationClassLoader);
        ((ClassGraph)object).dispose();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClassLoaderManager");
        }
    }

    public void addNewModule(ModuleRef moduleRef) {
        ClassGraph classGraph = new ClassGraph(this.classGraphState);
        classGraph.addModule(moduleRef);
        classGraph.updateClassLoaders((EARFile)moduleRef.getEarFile(), this.specifiedWasPolicy, this.warParent);
        ReloadableClassLoader reloadableClassLoader = classGraph.lookupClassLoader(moduleRef);
        String string = moduleRef != null ? moduleRef.getUri() : null;
        Iterator iterator = null;
        ModuleRef moduleRef2 = null;
        Object var7_7 = null;
        if (reloadableClassLoader != null) {
            this.moduleClassLoaderLookup.put(moduleRef, reloadableClassLoader);
            if (reloadableClassLoader != serverClassLoader) {
                this.createTimer(moduleRef);
            }
            ClassLoaderDump.addModule(moduleRef.getUri(), reloadableClassLoader);
        }
        iterator = this.listenerListLookup.keySet().iterator();
        Vector vector = (Vector)this.listenerListLookup.get(null);
        while (iterator.hasNext()) {
            var7_7 = iterator.next();
            if (var7_7 == null || !(moduleRef2 = (ModuleRef)var7_7).getUri().equals(string)) continue;
            vector = (Vector)this.listenerListLookup.get(moduleRef2);
            this.listenerListLookup.remove(moduleRef2);
            break;
        }
        this.listenerListLookup.put(moduleRef, vector);
    }

    protected void processFARFiles(EARFile eARFile, ClassGraph classGraph) {
        List list = eARFile.getFARFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Archive archive = (Archive)list.get(i);
            RuntimeClasspathEntry[] runtimeClasspathEntryArray = archive.getLocalRuntimeClassPath();
            for (int j = 0; j < runtimeClasspathEntryArray.length; ++j) {
                arrayList.add(runtimeClasspathEntryArray[j].getAbsolutePath());
            }
            RuntimeClasspathEntry[] runtimeClasspathEntryArray2 = archive.getDependencyClassPath();
            for (int j = 0; j < runtimeClasspathEntryArray2.length; ++j) {
                arrayList.add(runtimeClasspathEntryArray2[j].getAbsolutePath());
            }
        }
        if (arrayList.size() > 0) {
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            classGraph.addUtilityJars(stringArray);
        }
    }

    public void dispose() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dispose " + this.earFile.getURI());
        }
        this.disposed = true;
        this.cancelAllTimers();
        this.parent = null;
        this.earFile = null;
        if (this.applicationClassLoader != serverClassLoader) {
            ClassLoaderDump.removeClassLoader(this.applicationClassLoader);
            this.applicationClassLoader.dispose(false);
        }
        this.classGraphState.dispose(serverClassLoader);
        this.moduleClassLoaderLookup.clear();
        this.listenerListLookup.clear();
        this.applicationClassLoader = null;
    }

    public ReloadableClassLoader lookupClassLoader(ModuleRef moduleRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupClassLoader", moduleRef.getUri());
        }
        ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupClassLoader");
        }
        return reloadableClassLoader;
    }

    public void removeClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.remove(moduleRef);
        if (reloadableClassLoader != null && reloadableClassLoader != this.applicationClassLoader) {
            reloadableClassLoader.setRemoved(true);
            ClassLoaderDump.removeClassLoader(reloadableClassLoader);
            reloadableClassLoader.dispose(false);
            this.cancelTimer(moduleRef);
        }
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public void setDelegationMode(ModuleRef moduleRef, boolean bl) {
        ReloadableClassLoader reloadableClassLoader;
        if (!this.singleWarClassLoader && (reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.setDelegationMode(bl);
        }
    }

    public void addClassLoaderListener(ClassLoaderListener classLoaderListener, ModuleRef moduleRef) {
        Vector<ClassLoaderListener> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClassLoaderListener", moduleRef != null ? moduleRef.getUri() : "appClassLoader");
        }
        if ((vector = (Vector<ClassLoaderListener>)this.listenerListLookup.get(moduleRef)) == null) {
            vector = new Vector<ClassLoaderListener>();
            this.listenerListLookup.put(moduleRef, vector);
        }
        vector.addElement(classLoaderListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClassLoaderListener");
        }
    }

    public void removeClassLoaderListener(ClassLoaderListener classLoaderListener, ModuleRef moduleRef) {
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClassLoaderListener", moduleRef.getUri());
        }
        if ((vector = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
            vector.removeElement(classLoaderListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClassLoaderListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reload");
        }
        Map map = this.moduleClassLoaderLookup;
        synchronized (map) {
            Iterator iterator = this.moduleClassLoaderLookup.values().iterator();
            while (iterator.hasNext()) {
                ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)iterator.next();
                if (reloadableClassLoader == serverClassLoader) continue;
                reloadableClassLoader.reload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reload");
        }
    }

    public void reloadClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reloadClassLoader");
        }
        if ((reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.reload();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reloadClassLoader");
        }
    }

    public void createTimer(ModuleRef moduleRef) {
        Object object;
        long l = 0L;
        if (this.overrideReload) {
            l = this.overrideReloadInterval * 1000L;
        } else if (moduleRef != null && moduleRef.isWeb()) {
            object = null;
            try {
                object = (WebAppExtension)moduleRef.getExtensions();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.ClassLoaderManager.createTimer", "278", this);
                Tr.error(tc, "Error loading web application extension {0}", exception);
            }
            if (object != null && object.isReloadingEnabled()) {
                l = object.getReloadInterval() * 1000;
            }
        } else {
            l = this.earFile.getExtensions().getReloadInterval() * 1000L;
        }
        if (l > 0L) {
            object = null;
            object = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
            if (object != serverClassLoader) {
                ((ReloadableClassLoader)object).enableReloading();
                ReloadTimerTask reloadTimerTask = new ReloadTimerTask(moduleRef, l);
                reloadTimerTask.alarm = AlarmManager.createDeferrable(l, reloadTimerTask);
                this.timers.add(reloadTimerTask);
            }
        }
    }

    public synchronized void cancelTimer(ModuleRef moduleRef) {
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ReloadTimerTask reloadTimerTask = (ReloadTimerTask)iterator.next();
            if (reloadTimerTask.moduleRef != moduleRef || reloadTimerTask.alarm == null) continue;
            reloadTimerTask.alarm.cancel();
            this.timers.remove(reloadTimerTask);
            return;
        }
    }

    public void cancelAllTimers() {
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ReloadTimerTask reloadTimerTask = (ReloadTimerTask)iterator.next();
            if (reloadTimerTask.alarm == null) continue;
            reloadTimerTask.alarm.cancel();
        }
        this.timers.clear();
    }

    private boolean checkAndNotify(ReloadableClassLoader reloadableClassLoader, ModuleRef moduleRef) {
        boolean bl = false;
        if (reloadableClassLoader.checkForUpdate()) {
            Vector vector;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "class has chanaged");
            }
            if ((vector = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ClassLoaderListener classLoaderListener = (ClassLoaderListener)vector.elementAt(i);
                    classLoaderListener.classChanged(moduleRef);
                }
                bl = !this.moduleClassLoaderLookup.containsKey(moduleRef);
            }
        }
        return bl;
    }

    private class ReloadTimerTask
    implements AlarmListener {
        public ModuleRef moduleRef;
        public long reloadInterval;
        Alarm alarm;

        public ReloadTimerTask(ModuleRef moduleRef, long l) {
            this.moduleRef = moduleRef;
            this.reloadInterval = l;
        }

        public void alarm(Object object) {
            boolean bl;
            ReloadableClassLoader reloadableClassLoader;
            if (!ClassLoaderManager.this.disposed && (reloadableClassLoader = (ReloadableClassLoader)ClassLoaderManager.this.moduleClassLoaderLookup.get(this.moduleRef)) != null && !(bl = ClassLoaderManager.this.checkAndNotify(reloadableClassLoader, this.moduleRef))) {
                this.alarm = AlarmManager.createDeferrable(this.reloadInterval, this);
            }
        }
    }
}

