/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.validation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.WebSphereDelegateCrossValidator;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.ValidationChannelTypeManager;
import com.ibm.ws.channel.validation.ChannelFrameworkValidator;
import com.ibm.ws.channel.validation.ChannelTypeValidatorManager;
import com.ibm.ws.channel.validation.ChannelValidationCollector;
import com.ibm.wsspi.channel.ChannelFactoryTypeValidator;
import com.ibm.wsspi.channel.ChannelTypeValidator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class ChannelFrameworkCrossValidator
extends WebSphereDelegateCrossValidator {
    private static TraceComponent tc = Tr.register(ChannelFrameworkCrossValidator.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private ChannelTypeManager _typeManager = new ValidationChannelTypeManager();
    private ChannelTypeValidatorManager _validatorManager = new ChannelTypeValidatorManager((MOFValidator)this, this._typeManager);

    public ChannelFrameworkCrossValidator(MOFValidator mOFValidator) {
        super(mOFValidator);
    }

    public String getLocalBundleID() {
        return "com.ibm.ws.channel.resources.channelframeworkvalidation";
    }

    public String getLocalTraceName() {
        return "ChannelFrameworkCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "basicValidate", ChannelFrameworkValidator.getID((EObject)object));
        }
        if (!(object instanceof TransportChannelService)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "basicValidate");
            }
            return super.basicValidate(object);
        }
        try {
            TransportChannelService transportChannelService = (TransportChannelService)object;
            EList eList = transportChannelService.getFactories();
            if (eList != null && !eList.isEmpty()) {
                this.validateFactories(eList);
            }
            if ((eList = transportChannelService.getTransportChannels()) != null && !eList.isEmpty()) {
                this.validateChannels(eList);
            }
            if ((eList = transportChannelService.getChains()) != null && !eList.isEmpty()) {
                this.validateChains(eList);
            }
        }
        catch (Exception exception) {
            this.addError("generic.validation.exception", new String[]{exception.getMessage()}, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "basicValidate");
        }
        return true;
    }

    private void validateFactories(List list) throws ValidationException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ChannelFactoryTypeValidator channelFactoryTypeValidator;
            TransportChannelFactory transportChannelFactory = (TransportChannelFactory)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating " + ChannelFrameworkValidator.getID(transportChannelFactory));
            }
            if ((channelFactoryTypeValidator = this._validatorManager.getChannelFactoryTypeValidator(transportChannelFactory)) == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "could not find extension validator for type " + transportChannelFactory.getClass().getName());
                continue;
            }
            if (channelFactoryTypeValidator == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating factory with " + ((Object)((Object)channelFactoryTypeValidator)).getClass().getName());
            }
            channelFactoryTypeValidator.crossValidate(transportChannelFactory);
        }
    }

    private void validateChannels(List list) throws ValidationException {
        ChannelValidationCollector channelValidationCollector = new ChannelValidationCollector(this._typeManager);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ChannelTypeValidator channelTypeValidator;
            TransportChannel transportChannel = (TransportChannel)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating " + ChannelFrameworkValidator.getID(transportChannel));
            }
            if ((channelTypeValidator = this._validatorManager.getChannelTypeValidator(transportChannel)) == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "could not find extension validator for type " + transportChannel.getClass().getName());
                continue;
            }
            if (channelTypeValidator == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating channel with " + ((Object)((Object)channelTypeValidator)).getClass().getName());
            }
            channelTypeValidator.crossValidate(transportChannel);
            channelValidationCollector.collectChannel(transportChannel);
        }
        iterator = channelValidationCollector.getChannelTypes().iterator();
        while (iterator.hasNext()) {
            ChannelTypeManager.ChannelMetaData channelMetaData = (ChannelTypeManager.ChannelMetaData)iterator.next();
            this.validateAllChannels(channelMetaData, channelValidationCollector.getChannels(channelMetaData));
        }
    }

    private void validateChains(List list) throws ValidationException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Chain chain = (Chain)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating " + ChannelFrameworkValidator.getID(chain));
            }
            this.validateChainChannels(chain);
        }
    }

    private void validateAllChannels(ChannelTypeManager.ChannelMetaData channelMetaData, List list) throws ValidationException {
        if (list == null) {
            return;
        }
        try {
            TransportChannel[] transportChannelArray = list.toArray(new TransportChannel[list.size()]);
            ChannelTypeValidator channelTypeValidator = (ChannelTypeValidator)this._validatorManager.getValidator(channelMetaData.getClass(channelMetaData.getValidatorClass()));
            channelTypeValidator.crossValidateAll(transportChannelArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateChainChannels(Chain chain) {
        EList eList = chain.getTransportChannels();
        for (int i = 0; i < eList.size(); ++i) {
            try {
                TransportChannel transportChannel = (TransportChannel)eList.get(i);
                ChannelTypeValidator channelTypeValidator = this._validatorManager.getChannelTypeValidator(transportChannel);
                channelTypeValidator.crossValidateInChain(transportChannel, chain);
                continue;
            }
            catch (ValidationException validationException) {
                Tr.debug(tc, "caught exception in validateChainChannels (Chain): ", validationException);
            }
        }
    }
}

