/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.channel.framework.impl.CFEndPointSerializer;
import com.ibm.ws.channel.framework.impl.OutboundChannelDefinitionImpl;
import com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.channel.ChannelFactory;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.WSVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CFEndPointImpl
implements CFEndPoint,
Serializable {
    private static final TraceComponent tc = Tr.register(CFEndPointImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static final long serialVersionUID = -4050856186139408312L;
    protected String name = null;
    protected String[] vhostArray = null;
    protected int port = 0;
    protected InetAddress address = null;
    protected OutboundChannelDefinition[] outboundChannelDefs = null;
    protected Class channelAccessor = null;
    protected transient WSVirtualConnectionFactory vcf = null;
    protected transient WSChannelFrameworkImpl framework = null;
    protected transient WSChainData outboundChainData = null;
    protected boolean isSSLEnabled = false;
    protected boolean isLocal = false;
    static /* synthetic */ Class class$com$ibm$wsspi$channel$SSLChannelFactory;
    static /* synthetic */ Class class$com$ibm$wsspi$channel$LocalChannelFactory;

    public CFEndPointImpl(String string, int n, String string2, InetAddress inetAddress, OutboundChannelDefinition[] outboundChannelDefinitionArray, Class clazz) throws NullCFEndPointException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.name = string;
        this.port = n;
        this.vhostArray = new String[]{string2};
        this.address = inetAddress;
        this.outboundChannelDefs = outboundChannelDefinitionArray;
        this.framework = null;
        this.channelAccessor = clazz;
        if (string == null || n < 1 || string2 == null || inetAddress == null || outboundChannelDefinitionArray == null || outboundChannelDefinitionArray.length == 0 || clazz == null) {
            String string3 = "Error found in parameters: " + this;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3);
            }
            throw new NullCFEndPointException(string3);
        }
        this.determineIsSSLEnabled();
        this.determineIsLocal();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public CFEndPointImpl(WSChainData wSChainData, WSChannelFrameworkImpl wSChannelFrameworkImpl) throws NullCFEndPointException, NoCFEndPointException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        Object var3_3 = null;
        ChannelData[] channelDataArray = wSChainData.getChannelList();
        String string = null;
        String string2 = null;
        String string3 = null;
        WSChannelFactory wSChannelFactory = null;
        OutboundChannelDefinition outboundChannelDefinition = null;
        HashMap<String, Object> hashMap = null;
        Map map = null;
        Iterator iterator = null;
        Object k = null;
        String string4 = null;
        this.framework = wSChannelFrameworkImpl;
        try {
            int n;
            NoCFEndPointException noCFEndPointException;
            Class clazz;
            wSChannelFactory = this.getWSChannelFactory(channelDataArray[channelDataArray.length - 1].getFactoryType());
            outboundChannelDefinition = wSChannelFactory.getOutboundChannelDefinition(new HashMap());
            if (null != outboundChannelDefinition && (clazz = outboundChannelDefinition.getOutboundFactory()).isAssignableFrom(((Object)((Object)(noCFEndPointException = new NoCFEndPointException("Chain " + wSChainData.getName() + " does not support CFEndPoints")))).getClass())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Chain " + wSChainData.getName() + " does not support CFEndPoints");
                }
                throw noCFEndPointException;
            }
            int n2 = channelDataArray.length - 1;
            int n3 = 0;
            this.name = wSChainData.getName();
            OutboundChannelDefinition[] outboundChannelDefinitionArray = new OutboundChannelDefinition[channelDataArray.length];
            Map map2 = wSChainData.getPropertyBag();
            if (map2 != null) {
                string = (String)map2.get("hostname");
                string2 = (String)map2.get("port");
                string3 = (String)map2.get("listeningPort");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resolving tcp properties: host=" + string + ", port=" + string2 + ", listenPort=" + string3);
                }
            } else {
                throw new NoCFEndPointException("No properties found in device side channel.  No CFEndPoint created.");
            }
            this.assignAddress(string);
            this.assignPort(string2, string3);
            for (n = 0; n < channelDataArray.length && n2 >= 0; ++n, --n2) {
                wSChannelFactory = this.getWSChannelFactory(channelDataArray[n].getFactoryType());
                hashMap = new HashMap<String, Object>();
                map = channelDataArray[n].getPropertyBag();
                if (map != null) {
                    iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        k = iterator.next();
                        string4 = (String)map.get(k);
                        if (string4 instanceof String) {
                            string4 = new String(string4);
                        }
                        hashMap.put((String)k, string4);
                    }
                }
                hashMap.put("Key_WsChainData", (Object)wSChainData);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting outbound channel definition for: " + var3_3);
                }
                outboundChannelDefinitionArray[n2] = wSChannelFactory.getOutboundChannelDefinition(hashMap);
                if (outboundChannelDefinitionArray[n2] != null) continue;
                ++n3;
            }
            if (n3 == 0) {
                this.outboundChannelDefs = outboundChannelDefinitionArray;
            } else {
                if (outboundChannelDefinitionArray.length - n3 <= 0) {
                    throw new NullCFEndPointException("There are no actual channels showing up in this chain");
                }
                this.outboundChannelDefs = new OutboundChannelDefinition[outboundChannelDefinitionArray.length - n3];
                int n4 = 0;
                for (n = 0; n < outboundChannelDefinitionArray.length; ++n) {
                    if (outboundChannelDefinitionArray[n] == null) continue;
                    this.outboundChannelDefs[n4++] = outboundChannelDefinitionArray[n];
                }
            }
            this.determineChannelAccessor();
            this.determineIsSSLEnabled();
            this.determineIsLocal();
            this.vhostArray = wSChannelFrameworkImpl.getVhost(string, string2);
        }
        catch (UnknownHostException unknownHostException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid address ");
            stringBuffer.append(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer + " Exception: " + unknownHostException);
            }
            throw new NullCFEndPointException(unknownHostException);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid port ");
            stringBuffer.append(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer + " Exception: " + numberFormatException);
            }
            throw new NullCFEndPointException(numberFormatException);
        }
        catch (ChannelFactoryException channelFactoryException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + (Object)((Object)channelFactoryException));
            }
            throw new NullCFEndPointException(channelFactoryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    private WSChannelFactory getWSChannelFactory(Class clazz) throws NoCFEndPointException, ChannelFactoryException {
        ChannelFactory channelFactory;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting WSChannelFactory for class: " + clazz);
        }
        if (!((channelFactory = this.framework.getChannelFactoryInternal(clazz, false)) instanceof WSChannelFactory)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Factory class ");
            stringBuffer.append(clazz);
            stringBuffer.append(" does not implement the WSChannelFactory interface.");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer.toString());
            }
            throw new NoCFEndPointException(stringBuffer.toString());
        }
        return (WSChannelFactory)channelFactory;
    }

    private void determineChannelAccessor() throws NullCFEndPointException, ChannelFactoryException {
        Class clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineChannelAccessor");
        }
        if ((clazz = this.outboundChannelDefs[0].getOutboundFactory()) == null) {
            throw new NullCFEndPointException("No factory class associated with outbound channel " + this.outboundChannelDefs[this.outboundChannelDefs.length - 1]);
        }
        ChannelFactory channelFactory = this.framework.getChannelFactoryInternal(clazz, false);
        if (channelFactory == null) {
            throw new NullCFEndPointException("No channel factory could be found for factory class " + clazz);
        }
        this.channelAccessor = channelFactory.getApplicationInterface();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineChannelAccessor");
        }
    }

    private void determineIsSSLEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineIsSSLEnabled");
        }
        this.isSSLEnabled = false;
        Class clazz = null;
        for (int i = 0; i < this.outboundChannelDefs.length; ++i) {
            if (!(class$com$ibm$wsspi$channel$SSLChannelFactory == null ? CFEndPointImpl.class$("com.ibm.wsspi.channel.SSLChannelFactory") : class$com$ibm$wsspi$channel$SSLChannelFactory).isAssignableFrom(clazz = this.outboundChannelDefs[i].getOutboundFactory())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found class implementing SSLChannelFactory inteface: " + clazz);
            }
            this.isSSLEnabled = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineIsSSLEnabled: " + this.isSSLEnabled());
        }
    }

    private void determineIsLocal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineIsLocal");
        }
        this.isLocal = false;
        Class clazz = null;
        for (int i = 0; i < this.outboundChannelDefs.length; ++i) {
            if (!(class$com$ibm$wsspi$channel$LocalChannelFactory == null ? CFEndPointImpl.class$("com.ibm.wsspi.channel.LocalChannelFactory") : class$com$ibm$wsspi$channel$LocalChannelFactory).isAssignableFrom(clazz = this.outboundChannelDefs[i].getOutboundFactory())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found class implementing LocalChannelFactory inteface: " + clazz);
            }
            this.isLocal = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineIsLocal: " + this.isLocal());
        }
    }

    private void assignAddress(String string) throws NullCFEndPointException, NoCFEndPointException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "assignAddress: " + string);
        }
        if (string == null) {
            throw new NoCFEndPointException("No address available in properties.  No CFEndPoint will be created.");
        }
        String string2 = null;
        VariableMap variableMap = (VariableMap)this.framework._cfService.getService(VariableMap.class);
        string2 = variableMap != null ? variableMap.expand(string) : string;
        if ("*".equals(string2)) {
            AdminService adminService;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AdminService to find node name");
            }
            if (null == (adminService = AdminServiceFactory.getAdminService())) {
                throw new NullCFEndPointException("Unable to access admin service to retrieve address");
            }
            String string3 = adminService.getNodeName();
            string2 = variableMap.expand(AdminHelper.getInstance().getNodeHostName(string3));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up address string [" + string2 + "]");
        }
        this.address = InetAddress.getByName(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "assignAddress: " + this.address);
        }
    }

    private void assignPort(String string, String string2) throws NoCFEndPointException, NumberFormatException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "assignPort");
        }
        if (string != null) {
            this.port = new Integer(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Port set from regular tcp port: " + this.port);
            }
        } else if (string2 != null) {
            this.port = new Integer(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Port set from tcp listening port: " + this.port);
            }
        } else {
            throw new NoCFEndPointException("Port not available in TCP channel properties.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "assignPort");
        }
    }

    public CFEndPointImpl() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getVhost() {
        if (this.vhostArray.length == 0) {
            return null;
        }
        return this.vhostArray[0];
    }

    public String[] getVhostArray() {
        return this.vhostArray;
    }

    public OutboundChannelDefinition[] getOutboundChannelDefs() {
        return this.outboundChannelDefs;
    }

    public Class getChannelAccessor() {
        return this.channelAccessor;
    }

    public boolean isSSLEnabled() {
        return this.isSSLEnabled;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    protected void setOutboundChainData(WSChainData wSChainData) {
        this.outboundChainData = wSChainData;
    }

    protected WSChainData getOutboundChainData() {
        return this.outboundChainData;
    }

    public void setFramework(WSChannelFrameworkImpl wSChannelFrameworkImpl) {
        this.framework = wSChannelFrameworkImpl;
    }

    public WSChainData createOutboundChain() throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOutboundChain");
        }
        if (this.framework == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null reference to channel framework, using factory");
            }
            this.framework = (WSChannelFrameworkImpl)ChannelFrameworkFactory.getChannelFramework();
        }
        if (this.outboundChainData == null) {
            this.outboundChainData = (WSChainData)this.framework.createOutboundChain(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOutboundChain");
        }
        return this.outboundChainData;
    }

    public WSVirtualConnectionFactory getOutboundVCFactory(Map map, boolean bl) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundVCFactory(ssl)");
        }
        Class clazz = null;
        OutboundChannelDefinition outboundChannelDefinition = null;
        int n = 0;
        boolean bl2 = false;
        for (n = 0; n < this.outboundChannelDefs.length; ++n) {
            outboundChannelDefinition = this.outboundChannelDefs[n];
            if (!(class$com$ibm$wsspi$channel$SSLChannelFactory == null ? CFEndPointImpl.class$("com.ibm.wsspi.channel.SSLChannelFactory") : class$com$ibm$wsspi$channel$SSLChannelFactory).isAssignableFrom(clazz = this.outboundChannelDefs[n].getOutboundFactory())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found class implementing SSLChannelFactory inteface: " + clazz);
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new IllegalStateException("The SSL channel factory does not exist in this CFEndPoint.");
        }
        OutboundChannelDefinitionImpl outboundChannelDefinitionImpl = new OutboundChannelDefinitionImpl(outboundChannelDefinition, map, bl);
        this.outboundChannelDefs[n] = outboundChannelDefinitionImpl;
        WSVirtualConnectionFactory wSVirtualConnectionFactory = this.getOutboundVCFactory();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundVCFactory(ssl)");
        }
        return wSVirtualConnectionFactory;
    }

    public WSVirtualConnectionFactory getOutboundVCFactory() {
        OutboundVirtualConnectionFactoryImpl outboundVirtualConnectionFactoryImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundVCFactory");
        }
        if (this.vcf != null && (outboundVirtualConnectionFactoryImpl = (OutboundVirtualConnectionFactoryImpl)this.vcf).getRefCount() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found destroyed vcf, nulling it out to build another");
            }
            this.vcf = null;
        }
        if (this.vcf == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Existing vcf not available.  Build one.");
            }
            if (this.outboundChainData != null) {
                try {
                    this.vcf = (WSVirtualConnectionFactory)this.framework.getOutboundVCFactory(this.outboundChainData.getName());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception while getting VCFactory: " + exception);
                    }
                    this.vcf = null;
                }
            } else if (this.framework != null) {
                try {
                    this.framework.prepareEndPoint(this);
                }
                catch (ChannelException channelException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception while preparing CFEndPoint: " + (Object)((Object)channelException));
                    }
                    this.vcf = null;
                }
                catch (ChainException chainException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception while preparing CFEndPoint: " + (Object)((Object)chainException));
                    }
                    this.vcf = null;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Framework is not available.  prePareEndPoint or determineBestEndPoint should have been called.");
                }
                this.vcf = null;
            }
        } else {
            outboundVirtualConnectionFactoryImpl = (OutboundVirtualConnectionFactoryImpl)this.vcf;
            outboundVirtualConnectionFactoryImpl.incrementRefCount();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found an existing VCF, updating the ref count to " + outboundVirtualConnectionFactoryImpl.getRefCount());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundVCFactory");
        }
        return this.vcf;
    }

    public void setOutboundVCFactory(WSVirtualConnectionFactory wSVirtualConnectionFactory) {
        this.vcf = wSVirtualConnectionFactory;
    }

    public String serializeToXML() throws NotSerializableException {
        return CFEndPointSerializer.serialize(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CFEndPoint: name = ");
        stringBuffer.append(this.getName());
        stringBuffer.append("\n\tvhostArray = ");
        if (this.vhostArray == null) {
            stringBuffer.append("null");
        } else {
            for (n = 0; n < this.vhostArray.length; ++n) {
                stringBuffer.append("\n\t\t" + this.vhostArray[n]);
            }
        }
        stringBuffer.append("\n\tport = ");
        stringBuffer.append(this.getPort());
        stringBuffer.append("\n\taddress = ");
        stringBuffer.append(this.getAddress());
        stringBuffer.append("\n\taccessor = ");
        stringBuffer.append(this.getChannelAccessor());
        stringBuffer.append("\n\tvcf = ");
        stringBuffer.append(this.vcf);
        stringBuffer.append("\n\tisSSLEnabled = ");
        stringBuffer.append(this.isSSLEnabled());
        stringBuffer.append("\n\tisLocal = ");
        stringBuffer.append(this.isLocal());
        stringBuffer.append("\n\tChannels: ");
        if (this.outboundChannelDefs != null) {
            for (n = 0; n < this.outboundChannelDefs.length; ++n) {
                stringBuffer.append("\n");
                stringBuffer.append(OutboundChannelDefinitionImpl.toString(this.outboundChannelDefs[n]));
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

