/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.common;

import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.common.ChannelPoolObject;
import com.ibm.ws.channel.common.PlatformConstants;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class ChannelUtilsBase {
    private static Map stats = new HashMap();
    protected boolean traceObtainRelease = Boolean.getBoolean("com.ibm.ws.channel.common.ChannelUtilsBase.traceObtainRelease");

    protected ChannelUtilsBase() {
    }

    protected final ChannelPoolObject getObject(Object object, String string, ObjectPool objectPool, boolean bl, boolean bl2) {
        boolean bl3 = false;
        ChannelPoolObject channelPoolObject = null;
        channelPoolObject = (ChannelPoolObject)objectPool.remove();
        boolean bl4 = bl3 = channelPoolObject != null;
        if (bl && this.traceObtainRelease) {
            this.trackObjectPool(object, string, objectPool, -1, bl3);
        }
        return channelPoolObject;
    }

    protected final boolean releaseObject(Object object, String string, ChannelPoolObject channelPoolObject, ObjectPool objectPool, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (channelPoolObject != null) {
            channelPoolObject.poolReset();
            bl3 = objectPool.add(channelPoolObject);
            if (bl && this.traceObtainRelease) {
                this.trackObjectPool(object, string, objectPool, 1, bl3);
            }
        }
        return bl3;
    }

    protected final void traceChains(Object object, ChannelFramework channelFramework, Class clazz, String string, String string2) {
        ChainData[] chainDataArray = null;
        String string3 = "(" + (clazz == null ? "no factory specified" : clazz.getName()) + ")";
        if (channelFramework == null) {
            this.debugTrace(object, string2 + " - No cfw to test factory " + string3);
            return;
        }
        try {
            chainDataArray = clazz != null ? channelFramework.getAllChains(clazz) : channelFramework.getAllChains();
        }
        catch (Exception exception) {
            this.debugTrace(object, "Caught Exception while trying to display configured chains: " + exception);
            exception.printStackTrace();
            return;
        }
        if (chainDataArray == null || chainDataArray.length <= 0) {
            this.debugTrace(object, string2 + " - No chains found for factory " + string3);
        } else {
            this.traceChains(object, Arrays.asList(chainDataArray), string, string2);
        }
    }

    protected final void traceChains(Object object, ChannelFramework channelFramework, String string, String string2, String string3) {
        String string4 = "(" + (string == null ? "no group specified" : string) + ")";
        if (channelFramework == null) {
            this.debugTrace(object, string3 + " - No cfw to test group " + string4);
        } else if (string == null) {
            this.debugTrace(object, string3 + " - No group specified");
        }
        if (channelFramework == null || string == null) {
            return;
        }
        ChainGroupData chainGroupData = null;
        ChainData[] chainDataArray = null;
        try {
            chainGroupData = channelFramework.getChainGroup(string);
            if (chainGroupData != null) {
                chainDataArray = chainGroupData.getChains();
            }
        }
        catch (Exception exception) {
            this.debugTrace(object, "Caught Exception while trying to display configured chains: " + exception);
            exception.printStackTrace();
            return;
        }
        if (chainDataArray == null || chainDataArray.length <= 0) {
            this.debugTrace(object, string3 + " - No chains defined for group " + string4);
        } else {
            this.traceChains(object, Arrays.asList(chainDataArray), string2, string3);
        }
    }

    protected final void traceChains(Object object, List list, String string, String string2) {
        if (list == null || list.size() <= 0) {
            this.debugTrace(object, string2 + " - Specified chain list is empty");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(string);
        stringBuffer.append(PlatformConstants.EOLN);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ChainData chainData = (ChainData)iterator.next();
            stringBuffer.append(string2 + "-chain ");
            stringBuffer.append(chainData.getName());
            stringBuffer.append(chainData.getType() == FlowType.OUTBOUND ? " - OUTBOUND" : " - INBOUND");
            stringBuffer.append(PlatformConstants.EOLN);
            List<ChannelData> list2 = Arrays.asList(chainData.getChannelList());
            Iterator<ChannelData> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                ChannelData channelData = iterator2.next();
                stringBuffer.append(string2 + "-chain ");
                stringBuffer.append(chainData.getName());
                stringBuffer.append(":       +  ");
                stringBuffer.append(channelData.getName());
                stringBuffer.append(" - ");
                stringBuffer.append(channelData.getFactoryType());
                stringBuffer.append(PlatformConstants.EOLN);
            }
        }
        this.debugTrace(object, stringBuffer.toString());
    }

    protected final void traceChannels(Object object, ChannelFramework channelFramework, String string, String string2) {
        if (channelFramework == null) {
            this.debugTrace(object, string2 + " - No cfw to trace channels");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(string2 + ": Configured Channels - ");
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(PlatformConstants.EOLN);
        ChannelData[] channelDataArray = channelFramework.getAllChannels();
        List<ChannelData> list = Arrays.asList(channelDataArray);
        Iterator<ChannelData> iterator = list.iterator();
        while (iterator.hasNext()) {
            ChannelData channelData = iterator.next();
            stringBuffer.append(string2 + ":    ");
            stringBuffer.append(channelData.getName());
            stringBuffer.append(" - ");
            stringBuffer.append(channelData.getFactoryType());
            stringBuffer.append(PlatformConstants.EOLN);
        }
        this.debugTrace(object, stringBuffer.toString());
    }

    protected final void traceDebugStack(Object object, Throwable throwable, String string) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append(PlatformConstants.EOLN + stackTraceElementArray[i].toString());
            }
            this.debugTrace(object, string + PlatformConstants.EOLN + stringBuffer.toString());
        }
    }

    public final void traceThreadStack(Object object, Thread thread2) {
        StackTraceElement[] stackTraceElementArray = thread2.getStackTrace();
        if (stackTraceElementArray != null) {
            StringBuffer stringBuffer = new StringBuffer("TRACEBACK for Thread " + thread2.getName() + ": ");
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append(PlatformConstants.EOLN + stackTraceElementArray[i].toString());
            }
            this.debugTrace(object, PlatformConstants.EOLN + stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void trackObjectPool(Object object, String string, ObjectPool objectPool, int n, boolean bl) {
        Object object2;
        if (!this.traceObtainRelease) {
            return;
        }
        int n2 = 0;
        if (bl) {
            object2 = stats;
            synchronized (object2) {
                Object v = stats.get(objectPool);
                if (v == null) {
                    stats.put(objectPool, n);
                } else {
                    n2 = (Integer)v;
                    stats.put(objectPool, n2 + n);
                }
            }
        }
        object2 = new StringBuffer("ChannelObjectPool: ");
        ((StringBuffer)object2).append(n2);
        ((StringBuffer)object2).append(" objects in ");
        ((StringBuffer)object2).append(objectPool.getName());
        ((StringBuffer)object2).append(" (");
        ((StringBuffer)object2).append(string);
        ((StringBuffer)object2).append(")");
        this.debugTrace(object, ((StringBuffer)object2).toString());
    }

    protected abstract void debugTrace(Object var1, String var2);

    protected abstract void entryTrace(Object var1, String var2, Object var3);

    protected abstract void exitTrace(Object var1, String var2, Object var3);
}

