/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.WSLauncher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public class PathChecksum {
    private static Checksum cs = null;

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        if (string != null) {
            PathChecksum.pathChecksum(stringArray[0]);
        } else {
            System.out.println("Syntax is DirectoryChecksum [directory names]");
        }
    }

    public static long pathChecksum(String string) {
        if (cs == null) {
            cs = new Adler32();
        }
        cs.reset();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PathChecksum.scanDirectory(new File(string2));
        }
        WSLauncher.debug("CRC: " + cs.getValue());
        return cs.getValue();
    }

    public static long streamChecksum(String string, RandomAccessFile randomAccessFile) throws IOException {
        int n;
        if (cs == null) {
            cs = new Adler32();
        }
        cs.reset();
        byte[] byArray = string.getBytes();
        cs.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[4096];
        while ((n = randomAccessFile.read(byArray2)) != -1) {
            cs.update(byArray2, 0, n);
        }
        return cs.getValue();
    }

    private static void scanDirectory(File file) {
        block6: {
            block5: {
                byte[] byArray = file.getAbsolutePath().getBytes();
                cs.update(byArray, 0, byArray.length);
                if (!file.isDirectory()) break block5;
                String[] stringArray = file.list();
                if (stringArray == null) break block6;
                for (int i = 0; i < stringArray.length; ++i) {
                    PathChecksum.scanDirectory(new File(file, stringArray[i]));
                }
                break block6;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, cs);
                byte[] byArray = new byte[4096];
                while (checkedInputStream.read(byArray) != -1) {
                }
                checkedInputStream.close();
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

