/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;

public class WASPrincipal
implements WSPrincipal {
    public static final String UNAUTHENTICATED = "UNAUTHENTICATED";
    private String name;
    private String uniqueUserId;
    private List uniqueGroupIds;
    private static final ArrayList EMPTY_LIST = new ArrayList(0);

    public WASPrincipal(String string, String string2, List list) {
        this.name = string == null ? ContextManagerFactory.getInstance().getUnauthenticatedString() : string;
        this.uniqueUserId = string2;
        this.uniqueGroupIds = list == null ? EMPTY_LIST : list;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof WASPrincipal) {
            WASPrincipal wASPrincipal = (WASPrincipal)object;
            String string = wASPrincipal.getUniqueUserId();
            if (this.uniqueUserId == null && string == null) {
                return true;
            }
            if (this.uniqueUserId == null || string == null) {
                return false;
            }
            return this.uniqueUserId.equals(string);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueUserId() {
        return this.uniqueUserId;
    }

    public List getUniqueGroupIds() {
        return this.uniqueGroupIds;
    }

    public int hashCode() {
        if (this.uniqueUserId != null) {
            return this.uniqueUserId.hashCode();
        }
        return 0;
    }

    public WSCredential getCredential() {
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager != null) {
            try {
                Subject subject = contextManager.getInvocationSubject();
                return SubjectHelper.getWSCredentialFromSubject(subject);
            }
            catch (WSSecurityException wSSecurityException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("securityName: ");
        stringBuffer.append(this.name).append(", uid: ").append(this.uniqueUserId);
        stringBuffer.append(", gid: ").append(this.uniqueGroupIds.toString());
        return stringBuffer.toString();
    }
}

