/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.resource;

import com.ibm.websphere.resource.WASResourceFactoryRegistryImpl;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class WASResourceSetImpl
extends ResourceSetImpl {
    public static final boolean RELOAD = true;
    public static final boolean NO_RELOAD = false;
    public static final boolean UNLOAD = true;
    public static final boolean NO_UNLOAD = false;
    public static final boolean LOAD_ON_DEMAND = true;
    public static final boolean NO_LOAD_ON_DEMAND = false;
    private static boolean debug = false;

    public WASResourceSetImpl() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = WASResourceFactoryRegistryImpl.INSTANCE;
        }
    }

    private synchronized Resource getExistingResource(URI uRI) {
        if (debug) {
            System.out.println("WASRSI: getExistingResource : entry : " + uRI);
        }
        Resource resource = null;
        URIConverter uRIConverter = this.getURIConverter();
        URI uRI2 = uRIConverter.normalize(uRI);
        EList eList = this.getResources();
        BasicEList basicEList = new BasicEList(eList);
        int n = basicEList.size();
        for (int i = 0; i < n; ++i) {
            Resource resource2 = (Resource)basicEList.get(i);
            if (!uRIConverter.normalize(resource2.getURI()).equals(uRI2)) continue;
            if (!resource2.isLoaded()) {
                try {
                    this.demandLoad(resource2);
                }
                catch (Resource.IOWrappedException iOWrappedException) {
                    throw new WrappedException(iOWrappedException.getWrappedException());
                }
                catch (IOException iOException) {
                    throw new WrappedException(iOException);
                }
            }
            resource = resource2;
            break;
        }
        if (debug) {
            System.out.println("WASRSI: getExistingResource : exit : " + resource);
        }
        return resource;
    }

    public synchronized Resource createResource(URI uRI) {
        if (debug) {
            System.out.println("WASRSI: createResource : entry : " + uRI);
        }
        Resource resource = null;
        Resource.Factory factory = this.getResourceFactoryRegistry().getFactory(uRI);
        if (factory != null && (resource = this.getExistingResource(uRI)) == null) {
            resource = factory.createResource(uRI);
            this.getResources().add(resource);
        }
        if (debug) {
            System.out.println("WASRSI: createResource : exit : " + resource);
        }
        return resource;
    }

    public synchronized Resource getResource(URI uRI, boolean bl, boolean bl2) {
        Resource resource;
        if (debug) {
            System.out.println("WASRSI: getResource (uri, loadOnDemand, reload) : entry : " + uRI + ", loadOnDemand = " + bl + ", reload = " + bl2);
        }
        if (bl2) {
            if (debug) {
                System.out.println("WASRSI: getResource: reload chosen ... checking for loaded resource");
            }
            if ((resource = this.getResource(uRI, false)) != null) {
                if (debug) {
                    System.out.println("WASRSI: getResource: unloading resource to force a reload");
                }
                resource.unload();
            }
            bl = true;
        }
        resource = this.getResource(uRI, bl);
        if (debug) {
            System.out.println("WASRSI: getResource: exit : " + resource);
        }
        return resource;
    }

    public synchronized Resource getResource(URI uRI, boolean bl) {
        if (debug) {
            System.out.println("WASRSI: getResource (uri, loadOnDemand) : entry : " + uRI + ", loadOnDemand = " + bl);
        }
        Resource resource = super.getResource(uRI, bl);
        if (debug) {
            if (resource == null) {
                System.out.println("WASRSI: getResource: resource not found");
                Thread.dumpStack();
            }
            System.out.println("WASRSI: getResource : exit : " + resource);
        }
        return resource;
    }

    public synchronized List getResourceElements(URI uRI, boolean bl) {
        BasicEList basicEList;
        Resource resource;
        if (debug) {
            System.out.println("WASRSI: getResourceElements : entry: " + uRI + ", loadOnDemand = " + bl);
        }
        if ((resource = this.getResource(uRI, bl)) != null) {
            EList eList = resource.getContents();
            basicEList = new BasicEList(eList);
        } else {
            basicEList = null;
        }
        if (debug) {
            int n = basicEList != null ? basicEList.size() : 0;
            System.out.println("WASRSI: getResourceElements : exit : size = " + n + ", list = " + basicEList);
        }
        return basicEList;
    }

    public synchronized void removeResource(Resource resource, boolean bl) {
        if (debug) {
            System.out.println("WASRSI: removeResource : entry : " + resource + ", unload = " + bl);
        }
        this.removeResource(resource);
        if (bl) {
            resource.unload();
        }
        if (debug) {
            System.out.println("WASRSI: removeResource : exit");
        }
    }

    public synchronized void removeResource(Resource resource) {
        if (debug) {
            System.out.println("WASRSI: removeResource : entry : " + resource);
        }
        this.getResources().remove(resource);
        if (debug) {
            System.out.println("WASRSI: removeResource : exit");
        }
    }

    public synchronized void removeAllResources(boolean bl) {
        if (debug) {
            System.out.println("WASRSI: removeAllResources : entry : unload = " + bl);
        }
        EList eList = this.getResources();
        Resource[] resourceArray = eList.toArray(new Resource[eList.size()]);
        eList.clear();
        if (bl) {
            for (int i = 0; i < resourceArray.length; ++i) {
                resourceArray[i].unload();
            }
        }
        if (debug) {
            System.out.println("WASRSI: removeAllResources : exit");
        }
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = WASResourceFactoryRegistryImpl.INSTANCE;
        }
        return this.resourceFactoryRegistry;
    }

    static {
        if (System.getProperty("com.ibm.websphere.resource.resourceDebug") != null) {
            debug = true;
        }
    }
}

