/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.history;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.WASProductException;
import com.ibm.websphere.product.history.WASHistoryException;
import com.ibm.websphere.product.history.filters.EFixAppliedFilenameFilter;
import com.ibm.websphere.product.history.filters.EFixDriverFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFAppliedFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFDriverFilenameFilter;
import com.ibm.websphere.product.history.xml.AppliedHandler;
import com.ibm.websphere.product.history.xml.AppliedWriter;
import com.ibm.websphere.product.history.xml.EventHandler;
import com.ibm.websphere.product.history.xml.EventWriter;
import com.ibm.websphere.product.history.xml.componentApplied;
import com.ibm.websphere.product.history.xml.efixApplied;
import com.ibm.websphere.product.history.xml.efixDriver;
import com.ibm.websphere.product.history.xml.eventHistory;
import com.ibm.websphere.product.history.xml.ptfApplied;
import com.ibm.websphere.product.history.xml.ptfDriver;
import com.ibm.websphere.product.utils.HistoryInfoGenerator;
import com.ibm.websphere.product.xml.BaseFactory;
import com.ibm.websphere.product.xml.BaseHandlerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXParseException;

public class WASHistory {
    public static final String pgmVersion = "1.13";
    public static final String pgmUpdate = "4/26/06";
    public static final String bundleId = "com.ibm.websphere.product.history.WASHistoryNLS";
    public static final ResourceBundle msgs;
    protected ArrayList boundExceptions;
    protected ArrayList recoverableErrors;
    protected ArrayList warnings;
    public static final String HISTORY_DIR_PROPERTY_NAME = "was.history.dir";
    public static final String DEFAULT_LOCAL_HISTORY_DIR_NAME = "history";
    protected static final int PRODUCT_DIR_OFFSET = 0;
    protected static final int VERSION_DIR_OFFSET = 1;
    protected static final int HISTORY_DIR_OFFSET = 2;
    public static final String HISTORY_FILE_NAME = "event.history";
    public static final String BACKUP_SUFFIX = ".backup";
    protected eventHistory history;
    public static final int MAX_BACKUPS = 10;
    protected ArrayList efixDrivers = null;
    protected ArrayList efixDriverNames = null;
    protected ArrayList ptfDrivers = null;
    protected ArrayList ptfDriverNames = null;
    protected ArrayList efixApplieds = null;
    protected HashMap efixAppliedMapping = null;
    protected ArrayList efixAppliedNames = null;
    protected ArrayList ptfApplieds = null;
    protected HashMap ptfAppliedMapping = null;
    protected ArrayList ptfAppliedNames = null;
    protected HashMap historyInfo;
    public static final String EFIX_DRIVER_TYPE = "efixDriver";
    public static final String EFIX_APPLIED_TYPE = "efixApplied";
    public static final String PTF_DRIVER_TYPE = "ptfDriver";
    public static final String PTF_APPLIED_TYPE = "ptfApplied";
    protected File productDir;
    protected String productDirName;
    protected File versionDir;
    protected String versionDirName;
    protected File dtdDir;
    protected String dtdDirName;
    protected File historyDir;
    protected String historyDirName;
    protected File historyFile;
    protected String historyFileName;
    protected File backupFile;
    protected String backupFileName;

    protected static String getString(String string) {
        if (msgs == null) {
            return "com.ibm.websphere.product.history.WASHistoryNLS:" + string;
        }
        try {
            return msgs.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "com.ibm.websphere.product.history.WASHistoryNLS:" + string;
        }
    }

    protected static String getString(String string, Object object) {
        String string2 = WASHistory.getString(string);
        Object[] objectArray = new Object[]{object};
        return MessageFormat.format(string2, objectArray);
    }

    protected static String getString(String string, Object object, Object object2) {
        String string2 = WASHistory.getString(string);
        Object[] objectArray = new Object[]{object, object2};
        return MessageFormat.format(string2, objectArray);
    }

    protected static String getString(String string, Object[] objectArray) {
        String string2 = WASHistory.getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    protected void addException(WASHistoryException wASHistoryException) {
        this.boundExceptions.add(wASHistoryException);
    }

    public int numExceptions() {
        return this.boundExceptions.size();
    }

    public Iterator getExceptions() {
        return this.boundExceptions.iterator();
    }

    protected void addRecoverableError(SAXParseException sAXParseException) {
        this.recoverableErrors.add(sAXParseException);
    }

    public int numRecoverableErrors() {
        return this.recoverableErrors.size();
    }

    public Iterator getRecoverableErrors() {
        return this.recoverableErrors.iterator();
    }

    protected void addWarning(SAXParseException sAXParseException) {
        this.warnings.add(sAXParseException);
    }

    public int numWarnings() {
        return this.warnings.size();
    }

    public Iterator getWarnings() {
        return this.warnings.iterator();
    }

    protected void transferErrors(BaseFactory baseFactory) {
        Object object;
        Iterator iterator = baseFactory.getRecoverableErrors();
        while (iterator.hasNext()) {
            object = (SAXParseException)iterator.next();
            this.addRecoverableError((SAXParseException)object);
        }
        object = baseFactory.getWarnings();
        while (object.hasNext()) {
            SAXParseException sAXParseException = (SAXParseException)object.next();
            this.addWarning(sAXParseException);
        }
    }

    protected void clearExceptions() {
        this.boundExceptions = new ArrayList();
        this.recoverableErrors = new ArrayList();
        this.warnings = new ArrayList();
    }

    protected void addException(String string) {
        this.addException(WASHistory.createException(string, null, null));
    }

    protected void addException(String string, Exception exception) {
        this.addException(WASHistory.createException(string, null, exception));
    }

    protected void addException(String string, Object[] objectArray, Exception exception) {
        this.addException(WASHistory.createException(string, objectArray, exception));
    }

    protected static WASHistoryException createException(String string, Object[] objectArray, Exception exception) {
        return new WASHistoryException(string, objectArray, exception);
    }

    public static String[] determineHistoryDirNames() throws WASHistoryException {
        String string;
        try {
            string = WASProduct.computeProductDirName();
        }
        catch (WASProductException wASProductException) {
            throw WASHistory.createException("WVER201e", null, wASProductException);
        }
        String string2 = WASProduct.computeVersionDirName(string);
        String string3 = WASHistory.determineHistoryDirName(string2);
        return new String[]{string, string2, string3};
    }

    public static String determineHistoryDirName(String string) {
        String string2 = System.getProperty(HISTORY_DIR_PROPERTY_NAME);
        string2 = string2 == null ? WASHistory.getHistoryDirName(string) : WASProduct.preparePath(string2, false);
        return string2;
    }

    public static String getHistoryDirName(String string) {
        string = WASProduct.preparePath(string, false);
        return string + File.separator + DEFAULT_LOCAL_HISTORY_DIR_NAME;
    }

    public WASHistory() {
        this.clearExceptions();
        try {
            String[] stringArray = WASHistory.determineHistoryDirNames();
            this.initialize(stringArray[0], stringArray[1], stringArray[2]);
        }
        catch (WASHistoryException wASHistoryException) {
            this.addException(wASHistoryException);
        }
    }

    public WASHistory(String string, String string2, String string3) {
        this.clearExceptions();
        this.initialize(string, string2, string3);
    }

    protected void initialize(String string, String string2, String string3) {
        this.productDir = new File(string);
        this.productDirName = this.productDir.getAbsolutePath();
        this.versionDir = new File(string2);
        this.versionDirName = this.versionDir.getAbsolutePath();
        this.dtdDirName = WASProduct.getDTDDirName(this.versionDirName);
        this.dtdDir = new File(this.dtdDirName);
        this.dtdDirName = this.dtdDir.getAbsolutePath();
        this.historyDir = new File(string3);
        this.historyDirName = this.historyDir.getAbsolutePath();
        String string4 = this.historyDirName + File.separator + HISTORY_FILE_NAME;
        this.historyFile = new File(string4);
        this.historyFileName = this.historyFile.getAbsolutePath();
        String string5 = string4 + BACKUP_SUFFIX;
        this.backupFile = new File(string5);
        this.backupFileName = this.backupFile.getAbsolutePath();
        this.historyInfo = new HashMap();
        this.loadHistory();
    }

    public eventHistory getHistory() {
        return this.history;
    }

    protected void loadHistory() {
        if (!this.ensureHistoryDirectory()) {
            this.addException("WVER0204E", new Object[]{this.historyDirName}, null);
            return;
        }
        String string = WASProduct.getBackupDirName(this.versionDirName);
        try {
            HistoryInfoGenerator.transformHistoryXmls(string, WASProduct.getLogDirName(this.productDirName), this.historyDirName, this.versionDirName);
        }
        catch (TransformerException transformerException) {
            this.addException("WVER0203E", new Object[]{transformerException.getMessage()}, null);
            return;
        }
        catch (IOException iOException) {
            this.addException("WVER0203E", new Object[]{iOException.getMessage()}, null);
            return;
        }
        if (!this.historyFile.exists()) {
            this.history = new eventHistory();
        } else {
            BaseFactory baseFactory = new BaseFactory(new EventHandler(), null);
            List list = null;
            try {
                list = baseFactory.load(this.getDTDDirName(), this.getHistoryDirName(), HISTORY_FILE_NAME);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.history = (eventHistory)list.iterator().next();
            this.transferErrors(baseFactory);
            BaseHandlerException baseHandlerException = baseFactory.getException();
            if (baseHandlerException != null) {
                this.history = null;
                this.addException("WVER0202E", new Object[]{this.historyFileName}, baseHandlerException);
            }
        }
    }

    public String loadHistoryInfoAsXMLString() {
        return this.loadHistoryInfoAsXMLString(this.historyFileName);
    }

    public boolean save(boolean bl) {
        BaseHandlerException baseHandlerException;
        this.clearExceptions();
        if (bl) {
            try {
                this.backupHistoryFile();
            }
            catch (IOException iOException) {
                this.addException("WVER0205E", new Object[]{this.historyFileName, this.backupFileName}, iOException);
                return false;
            }
        }
        if ((baseHandlerException = this.saveHistory()) != null) {
            this.addException("WVER0206E", new Object[]{this.historyFileName}, baseHandlerException);
            return false;
        }
        return true;
    }

    public boolean ensureHistoryDirectory() {
        return this.historyDir.exists() || this.historyDir.mkdirs();
    }

    public void backupHistoryFile() throws IOException {
    }

    protected BaseHandlerException saveHistory() {
        return BaseFactory.saveSingleton(this.getHistory(), new EventWriter(), this.getHistoryFileName());
    }

    public efixDriver getEFixDriverByFilename(String string) {
        if (!AppliedHandler.acceptsEFixDriverFileName(string)) {
            return null;
        }
        return (efixDriver)this.getHistoryInfo(string);
    }

    public efixDriver getEFixDriverById(String string) {
        efixDriver efixDriver2 = null;
        Iterator iterator = this.getEFixDrivers();
        while (efixDriver2 == null && iterator.hasNext()) {
            efixDriver efixDriver3 = (efixDriver)iterator.next();
            if (!efixDriver3.getId().equals(string)) continue;
            efixDriver2 = efixDriver3;
        }
        return efixDriver2;
    }

    public boolean efixDriverPresent(String string) {
        return this.getEFixDriverById(string) != null;
    }

    public ptfDriver getPTFDriverByFilename(String string) {
        if (!AppliedHandler.acceptsPTFDriverFileName(string)) {
            return null;
        }
        return (ptfDriver)this.getHistoryInfo(string);
    }

    public ptfDriver getPTFDriverById(String string) {
        ptfDriver ptfDriver2 = null;
        Iterator iterator = this.getPTFDrivers();
        while (ptfDriver2 == null && iterator.hasNext()) {
            ptfDriver ptfDriver3 = (ptfDriver)iterator.next();
            if (!ptfDriver3.getId().equals(string)) continue;
            ptfDriver2 = ptfDriver3;
        }
        return ptfDriver2;
    }

    public boolean ptfDriverPresent(String string) {
        return this.getPTFDriverById(string) != null;
    }

    public boolean saveEFixDriver(efixDriver efixDriver2) {
        this.clearExceptions();
        String string = efixDriver2.getStandardFileName();
        String string2 = this.getHistoryFileName(string);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(efixDriver2, new AppliedWriter(), string2);
        if (baseHandlerException == null) {
            this.addEFixDriverName(string);
            this.addEFixDriver(efixDriver2);
            return true;
        }
        this.addException("WVER0260E", new String[]{efixDriver2.getId(), string2}, baseHandlerException);
        return false;
    }

    public boolean removeEFixDriver(efixDriver efixDriver2) {
        this.clearExceptions();
        String string = efixDriver2.getStandardFileName();
        String string2 = this.getHistoryFileName(string);
        File file = new File(string2);
        boolean bl = file.delete();
        if (bl) {
            this.removeEFixDriverName(string);
            this.basicRemoveEFixDriver(efixDriver2);
        } else {
            this.addException("WVER0265E", new String[]{efixDriver2.getId(), string2}, null);
        }
        return bl;
    }

    protected void addEFixDriver(efixDriver efixDriver2) {
        if (this.efixDrivers == null) {
            this.efixDrivers = this.basicGetEFixDrivers();
        }
        this.efixDrivers.add(efixDriver2);
    }

    protected void basicRemoveEFixDriver(efixDriver efixDriver2) {
        if (this.efixDrivers == null) {
            this.efixDrivers = this.basicGetEFixDrivers();
        }
        this.efixDrivers.remove(this.efixDrivers.indexOf(efixDriver2));
    }

    public Iterator getEFixDrivers() {
        if (this.efixDrivers == null) {
            this.efixDrivers = this.basicGetEFixDrivers();
        }
        return this.efixDrivers.iterator();
    }

    protected ArrayList basicGetEFixDrivers() {
        Iterator iterator = this.getEFixDriverNames();
        return this.collectHistoryInfo(iterator);
    }

    protected void addEFixDriverName(String string) {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        this.efixDriverNames.add(string);
    }

    protected void removeEFixDriverName(String string) {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        this.efixDriverNames.remove(this.efixDriverNames.indexOf(string));
    }

    public Iterator getEFixDriverNames() {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        return this.efixDriverNames.iterator();
    }

    public int getEFixDriverCount() {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        return this.efixDriverNames.size();
    }

    protected ArrayList basicGetEFixDriverNames() {
        return this.listFileNames(new EFixDriverFilenameFilter());
    }

    public boolean savePTFDriver(ptfDriver ptfDriver2) {
        this.clearExceptions();
        String string = ptfDriver2.getStandardFileName();
        String string2 = this.getHistoryFileName(string);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(ptfDriver2, new AppliedWriter(), string2);
        if (baseHandlerException == null) {
            this.addPTFDriverName(string);
            this.addPTFDriver(ptfDriver2);
            return true;
        }
        this.addException("WVER0266E", new String[]{ptfDriver2.getId(), string2}, baseHandlerException);
        return false;
    }

    public boolean removePTFDriver(ptfDriver ptfDriver2) {
        this.clearExceptions();
        String string = ptfDriver2.getStandardFileName();
        String string2 = this.getHistoryFileName(string);
        File file = new File(string2);
        boolean bl = file.delete();
        if (bl) {
            this.removePTFDriverName(string);
            this.basicRemovePTFDriver(ptfDriver2);
        } else {
            this.addException("WVER0270E", new String[]{ptfDriver2.getId(), string2}, null);
        }
        return bl;
    }

    protected void addPTFDriver(ptfDriver ptfDriver2) {
        if (this.ptfDrivers == null) {
            this.ptfDrivers = this.basicGetPTFDrivers();
        }
        this.ptfDrivers.add(ptfDriver2);
    }

    protected void basicRemovePTFDriver(ptfDriver ptfDriver2) {
        if (this.ptfDrivers == null) {
            this.ptfDrivers = this.basicGetPTFDrivers();
        }
        this.ptfDrivers.remove(this.ptfDrivers.indexOf(ptfDriver2));
    }

    public Iterator getPTFDrivers() {
        if (this.ptfDrivers == null) {
            this.ptfDrivers = this.basicGetPTFDrivers();
        }
        return this.ptfDrivers.iterator();
    }

    protected ArrayList basicGetPTFDrivers() {
        Iterator iterator = this.getPTFDriverNames();
        return this.collectHistoryInfo(iterator);
    }

    protected void addPTFDriverName(String string) {
        if (this.ptfDriverNames == null) {
            this.ptfDriverNames = this.basicGetPTFDriverNames();
        }
        this.ptfDriverNames.add(string);
    }

    protected void removePTFDriverName(String string) {
        if (this.ptfDriverNames == null) {
            this.ptfDriverNames = this.basicGetPTFDriverNames();
        }
        this.ptfDriverNames.remove(this.ptfDriverNames.indexOf(string));
    }

    public Iterator getPTFDriverNames() {
        if (this.ptfDriverNames == null) {
            this.ptfDriverNames = this.basicGetPTFDriverNames();
        }
        return this.ptfDriverNames.iterator();
    }

    public int getPTFDriverCount() {
        if (this.ptfDriverNames == null) {
            this.ptfDriverNames = this.basicGetPTFDriverNames();
        }
        return this.ptfDriverNames.size();
    }

    protected ArrayList basicGetPTFDriverNames() {
        return this.listFileNames(new PTFDriverFilenameFilter());
    }

    public efixApplied getEFixAppliedByFilename(String string) {
        if (!AppliedHandler.acceptsEFixAppliedFileName(string)) {
            return null;
        }
        return (efixApplied)this.getHistoryInfo(string);
    }

    public efixApplied getEFixAppliedById(String string) {
        return (efixApplied)this.getEFixAppliedMapping().get(string);
    }

    public componentApplied getEFixComponentAppliedById(String string, String string2) {
        efixApplied efixApplied2 = this.getEFixAppliedById(string);
        if (efixApplied2 != null) {
            return efixApplied2.selectComponentApplied(string2);
        }
        return null;
    }

    public boolean efixAppliedPresent(String string) {
        return this.getEFixAppliedById(string) != null;
    }

    public boolean efixComponentAppliedPresent(String string, String string2) {
        return this.getEFixComponentAppliedById(string, string2) != null;
    }

    public ptfApplied getPTFAppliedById(String string) {
        return (ptfApplied)this.getPTFAppliedMapping().get(string);
    }

    public componentApplied getPTFComponentAppliedById(String string, String string2) {
        ptfApplied ptfApplied2 = this.getPTFAppliedById(string);
        if (ptfApplied2 != null) {
            return ptfApplied2.selectComponentApplied(string2);
        }
        return null;
    }

    public ptfApplied getPTFAppliedByFilename(String string) {
        if (!AppliedHandler.acceptsPTFDriverFileName(string)) {
            return null;
        }
        return (ptfApplied)this.getHistoryInfo(string);
    }

    public boolean ptfAppliedPresent(String string) {
        return this.getPTFAppliedById(string) != null;
    }

    public boolean ptfComponentAppliedPresent(String string, String string2) {
        return this.getPTFComponentAppliedById(string, string2) != null;
    }

    public boolean recordEFixApplication(String string, componentApplied componentApplied2) {
        boolean bl;
        this.clearExceptions();
        efixApplied efixApplied2 = this.getEFixAppliedById(string);
        if (efixApplied2 == null) {
            efixApplied2 = new efixApplied();
            efixApplied2.setEFixId(string);
            bl = true;
        } else {
            bl = false;
        }
        efixApplied2.addComponentApplied(componentApplied2);
        String string2 = efixApplied2.getStandardFileName();
        String string3 = this.getHistoryFileName(string2);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(efixApplied2, new AppliedWriter(), string3);
        if (baseHandlerException == null) {
            if (bl) {
                this.mapEFixApplied(efixApplied2);
                this.addEFixAppliedName(string2);
            }
            return true;
        }
        this.addException("WVER0261E", new String[]{string, componentApplied2.getComponentName(), string3}, baseHandlerException);
        return false;
    }

    public boolean clearEFixApplication(String string, componentApplied componentApplied2) {
        this.clearExceptions();
        String string2 = componentApplied2.getComponentName();
        efixApplied efixApplied2 = this.getEFixAppliedById(string);
        if (efixApplied2 == null) {
            this.addException("WVER0264E", new String[]{string, string2}, null);
            return false;
        }
        componentApplied componentApplied3 = efixApplied2.removeComponentApplied(string2);
        if (componentApplied3 == null) {
            this.addException("WVER0264E", new String[]{string, string2}, null);
            return false;
        }
        String string3 = efixApplied2.getStandardFileName();
        String string4 = this.getHistoryFileName(string3);
        if (efixApplied2.getComponentAppliedCount() != 0) {
            BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(efixApplied2, new AppliedWriter(), string4);
            if (baseHandlerException != null) {
                this.addException("WVER0262E", new String[]{string, string2, string4}, baseHandlerException);
                return false;
            }
            return true;
        }
        File file = new File(string4);
        boolean bl = file.delete();
        if (!bl) {
            this.addException("WVER0263E", new String[]{string, string2, string4}, null);
        } else {
            this.unmapEFixApplied(efixApplied2);
            this.removeEFixAppliedName(string3);
        }
        return bl;
    }

    public Iterator getEFixApplieds() {
        this.ensureEFixApplieds();
        return this.efixApplieds.iterator();
    }

    protected HashMap getEFixAppliedMapping() {
        this.ensureEFixApplieds();
        return this.efixAppliedMapping;
    }

    protected void ensureEFixApplieds() {
        if (this.efixApplieds == null) {
            this.efixApplieds = this.basicGetEFixApplieds();
            this.computeEFixAppliedMapping(this.efixApplieds.iterator());
        }
    }

    protected void mapEFixApplied(efixApplied efixApplied2) {
        this.efixAppliedMapping.put(efixApplied2.getEFixId(), efixApplied2);
    }

    protected void unmapEFixApplied(efixApplied efixApplied2) {
        this.efixAppliedMapping.remove(efixApplied2.getEFixId());
    }

    protected void computeEFixAppliedMapping(Iterator iterator) {
        this.efixAppliedMapping = new HashMap();
        while (iterator.hasNext()) {
            efixApplied efixApplied2 = (efixApplied)iterator.next();
            this.efixAppliedMapping.put(efixApplied2.getEFixId(), efixApplied2);
        }
    }

    protected ArrayList basicGetEFixApplieds() {
        Iterator iterator = this.getEFixAppliedNames();
        return this.collectHistoryInfo(iterator);
    }

    protected void addEFixAppliedName(String string) {
        this.efixAppliedNames.add(string);
    }

    protected void removeEFixAppliedName(String string) {
        this.efixAppliedNames.remove(this.efixAppliedNames.indexOf(string));
    }

    public Iterator getEFixAppliedNames() {
        if (this.efixAppliedNames == null) {
            this.efixAppliedNames = this.basicGetEFixAppliedNames();
        }
        return this.efixAppliedNames.iterator();
    }

    protected ArrayList basicGetEFixAppliedNames() {
        return this.listFileNames(new EFixAppliedFilenameFilter());
    }

    public boolean recordPTFApplication(String string, componentApplied componentApplied2) {
        this.clearExceptions();
        ptfApplied ptfApplied2 = this.getPTFAppliedById(string);
        if (ptfApplied2 == null) {
            ptfApplied2 = new ptfApplied();
            ptfApplied2.setPTFId(string);
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        ptfApplied2.addComponentApplied(componentApplied2);
        String string2 = ptfApplied2.getStandardFileName();
        String string3 = this.getHistoryFileName(string2);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(ptfApplied2, new AppliedWriter(), string3);
        if (baseHandlerException == null) {
            this.mapPTFApplied(ptfApplied2);
            this.addPTFAppliedName(string2);
            return true;
        }
        this.addException("WVER0268E", new String[]{string, componentApplied2.getComponentName(), string3}, baseHandlerException);
        return false;
    }

    public boolean clearPTFApplication(String string, componentApplied componentApplied2) {
        this.clearExceptions();
        String string2 = componentApplied2.getComponentName();
        ptfApplied ptfApplied2 = this.getPTFAppliedById(string);
        if (ptfApplied2 == null) {
            this.addException("WVER0269E", new String[]{string, string2}, null);
            return false;
        }
        componentApplied componentApplied3 = ptfApplied2.removeComponentApplied(string2);
        if (componentApplied3 == null) {
            this.addException("WVER0269E", new String[]{string, string2}, null);
            return false;
        }
        String string3 = ptfApplied2.getStandardFileName();
        String string4 = this.getHistoryFileName(string3);
        if (ptfApplied2.getComponentAppliedCount() != 0) {
            BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(ptfApplied2, new AppliedWriter(), string4);
            if (baseHandlerException != null) {
                this.addException("WVER0267E", new String[]{string, string2, string4}, baseHandlerException);
                return false;
            }
            return true;
        }
        File file = new File(string4);
        boolean bl = file.delete();
        if (!bl) {
            this.addException("WVER0268E", new String[]{string, string2, string4}, null);
        } else {
            this.unmapPTFApplied(ptfApplied2);
            this.removePTFAppliedName(string3);
        }
        return bl;
    }

    public Iterator getPTFApplieds() {
        this.ensurePTFApplieds();
        return this.ptfApplieds.iterator();
    }

    protected HashMap getPTFAppliedMapping() {
        this.ensurePTFApplieds();
        return this.ptfAppliedMapping;
    }

    protected void ensurePTFApplieds() {
        if (this.ptfApplieds == null) {
            this.ptfApplieds = this.basicGetPTFApplieds();
            this.computePTFAppliedMapping(this.ptfApplieds.iterator());
        }
    }

    protected void mapPTFApplied(ptfApplied ptfApplied2) {
        this.ptfAppliedMapping.put(ptfApplied2.getPTFId(), ptfApplied2);
    }

    protected void unmapPTFApplied(ptfApplied ptfApplied2) {
        this.ptfAppliedMapping.remove(ptfApplied2.getPTFId());
    }

    protected void computePTFAppliedMapping(Iterator iterator) {
        this.ptfAppliedMapping = new HashMap();
        while (iterator.hasNext()) {
            ptfApplied ptfApplied2 = (ptfApplied)iterator.next();
            this.ptfAppliedMapping.put(ptfApplied2.getPTFId(), ptfApplied2);
        }
    }

    protected ArrayList basicGetPTFApplieds() {
        Iterator iterator = this.getPTFAppliedNames();
        return this.collectHistoryInfo(iterator);
    }

    protected void addPTFAppliedName(String string) {
        this.ptfAppliedNames.add(string);
    }

    protected void removePTFAppliedName(String string) {
        this.ptfAppliedNames.remove(this.ptfAppliedNames.indexOf(string));
    }

    public Iterator getPTFAppliedNames() {
        if (this.ptfAppliedNames == null) {
            this.ptfAppliedNames = this.basicGetPTFAppliedNames();
        }
        return this.ptfAppliedNames.iterator();
    }

    protected ArrayList basicGetPTFAppliedNames() {
        return this.listFileNames(new PTFAppliedFilenameFilter());
    }

    protected ArrayList collectHistoryInfo(Iterator iterator) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.getHistoryInfo(string);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected Object getHistoryInfo(String string) {
        Object object = this.historyInfo.get(string);
        if (object == null && (object = this.loadHistoryInfo(string)) != null) {
            this.historyInfo.put(string, object);
        }
        return object;
    }

    protected Object loadHistoryInfo(String string) {
        if (!(AppliedHandler.acceptsEFixDriverFileName(string) || AppliedHandler.acceptsEFixAppliedFileName(string) || AppliedHandler.acceptsPTFDriverFileName(string) || AppliedHandler.acceptsPTFAppliedFileName(string))) {
            this.addException("WVER0271E", new Object[]{string}, null);
            return null;
        }
        AppliedHandler appliedHandler = new AppliedHandler();
        BaseFactory baseFactory = new BaseFactory(appliedHandler, null);
        List list = null;
        try {
            list = baseFactory.load(this.getDTDDirName(), this.getHistoryDirName(), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.transferErrors(baseFactory);
        BaseHandlerException baseHandlerException = baseFactory.getException();
        if (baseHandlerException != null) {
            this.addException("WVER0272E", new Object[]{string}, baseHandlerException);
            return null;
        }
        return list.iterator().next();
    }

    protected ArrayList listFileNames(FilenameFilter filenameFilter) {
        File[] fileArray = this.listFiles(filenameFilter);
        return this.listFileNames(fileArray);
    }

    protected ArrayList listFileNames(File[] fileArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i].getName());
        }
        return arrayList;
    }

    protected File[] listFiles(FilenameFilter filenameFilter) {
        return this.getHistoryDir().listFiles(filenameFilter);
    }

    public String[] loadAllHistoryInfoByType(String string) {
        FilenameFilter filenameFilter;
        if (string.equalsIgnoreCase(EFIX_APPLIED_TYPE)) {
            filenameFilter = new EFixAppliedFilenameFilter();
        }
        if ((filenameFilter = string.equalsIgnoreCase(EFIX_DRIVER_TYPE) ? new EFixDriverFilenameFilter() : (string.equalsIgnoreCase(PTF_DRIVER_TYPE) ? new PTFDriverFilenameFilter() : (string.equalsIgnoreCase(PTF_APPLIED_TYPE) ? new PTFAppliedFilenameFilter() : null))) == null) {
            return null;
        }
        File[] fileArray = this.listFiles(filenameFilter);
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = this.loadHistoryInfoAsXMLString(fileArray[i].getName());
        }
        return stringArray;
    }

    public String loadHistoryInfoAsXMLString(String string) {
        File file = new File(this.getHistoryDir(), string);
        if (!file.exists()) {
            return "";
        }
        try {
            return this.loadFile(file, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addException("WVER0203E", new Object[]{string}, fileNotFoundException);
            return "";
        }
        catch (IOException iOException) {
            this.addException("WVER0203E", new Object[]{string}, iOException);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadFile(File file, String string) throws FileNotFoundException, IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                printWriter.println(string2);
            }
        }
        finally {
            bufferedReader.close();
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public String toString() {
        return "WASHistory: " + this.getProductDirName() + " :: " + this.getVersionDirName() + " :: " + this.getHistoryDirName();
    }

    public String getProductDirName() {
        return this.productDirName;
    }

    public String getVersionDirName() {
        return this.versionDirName;
    }

    public String getDTDDirName() {
        return this.dtdDirName;
    }

    protected File getHistoryDir() {
        return this.historyDir;
    }

    public String getHistoryDirName() {
        return this.historyDirName;
    }

    public String getHistoryFileName() {
        return this.historyFileName;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    public String getHistoryFileName(String string) {
        String string2 = this.getHistoryDirName() + File.separator + string;
        File file = new File(string2);
        return file.getAbsolutePath();
    }

    static {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(bundleId);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        msgs = resourceBundle;
    }
}

