/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASProductException;
import com.ibm.websphere.product.filters.ComponentFilenameFilter;
import com.ibm.websphere.product.filters.EFixFilenameFilter;
import com.ibm.websphere.product.filters.ExtensionFilenameFilter;
import com.ibm.websphere.product.filters.PTFFilenameFilter;
import com.ibm.websphere.product.filters.ProductFilenameFilter;
import com.ibm.websphere.product.filters.RegistrarFilenameFilter;
import com.ibm.websphere.product.xml.BaseFactory;
import com.ibm.websphere.product.xml.BaseHandler;
import com.ibm.websphere.product.xml.BaseHandlerException;
import com.ibm.websphere.product.xml.component.ComponentHandler;
import com.ibm.websphere.product.xml.component.ComponentWriter;
import com.ibm.websphere.product.xml.component.component;
import com.ibm.websphere.product.xml.efix.EFixHandler;
import com.ibm.websphere.product.xml.efix.EFixWriter;
import com.ibm.websphere.product.xml.efix.efix;
import com.ibm.websphere.product.xml.efix.ptf;
import com.ibm.websphere.product.xml.extension.ExtensionHandler;
import com.ibm.websphere.product.xml.extension.extension;
import com.ibm.websphere.product.xml.product.ProductHandler;
import com.ibm.websphere.product.xml.product.ProductWriter;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.product.xml.registrar.RegistrarHandler;
import com.ibm.websphere.product.xml.registrar.registrar;
import com.ibm.websphere.product.xml.websphere.WebSphereHandler;
import com.ibm.websphere.product.xml.websphere.websphere;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.xml.sax.SAXParseException;

public class WASProduct {
    public static final String pgmVersion = "1.53";
    public static final String pgmUpdate = "6/15/06";
    public static final String PRODUCTID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String PRODUCTID_EXPRESS = "EXPRESS";
    public static final String PRODUCTID_BASE = "BASE";
    public static final String PRODUCTID_ND = "ND";
    public static final String PRODUCTID_XD = "XD";
    public static final String PRODUCTID_WXD = "WXD";
    public static final String PRODUCTID_PME = "PME";
    public static final String PRODUCTID_CLIENT = "CLIENT";
    public static final String PRODUCTID_JDK = "JDK";
    static final String PRODUCTID_EXPRESS_TRIAL = "EXPRESSTRIAL";
    static final String PRODUCTID_BASE_TRIAL = "BASETRIAL";
    public static final String[] PRODUCT_IDS = new String[]{"embeddedEXPRESS", "EXPRESS", "BASE", "ND", "XD", "WXD", "PME", "CLIENT", "JDK"};
    public static final String REGISTRARID_BASE = "BASE";
    public static final String REGISTRARID_ADD = "ADD";
    public static final String bundleId = "com.ibm.websphere.product.WASProductNLS";
    public static ResourceBundle msgs = null;
    protected ArrayList boundExceptions;
    protected ArrayList recoverableErrors;
    protected ArrayList warnings;
    public static final String INSTALL_ROOT_PROPERTY_NAME = "was.install.root";
    public static final String VERSION_DIR_PROPERTY_NAME = "was.version.dir";
    public static final String DTD_DIR_PROPERTY_NAME = "was.version.dtd.dir";
    public static final String LOG_DIR_PROPERTY_NAME = "was.version.log.dir";
    public static final String BACKUP_DIR_PROPERTY_NAME = "was.version.backup.dir";
    public static final String TMP_DIR_PROPERTY_NAME = "was.version.tmp.dir";
    public static final String JAVA_TMP_DIR_PROPERTY_NAME = "java.io.tmpdir";
    public static final String PROPERTIES_DIR_NAME = "properties";
    public static final String VERSION_DIR_NAME = "version";
    public static final String DTD_DIR_NAME = "dtd";
    public static final String LOG_DIR_NAME = "logs";
    public static final String UPDATE_DIR_NAME = "update";
    public static final String BACKUP_DIR_NAME = "backup";
    public static final String DEFAULT_TMP_DIR_NAME = "tmp";
    public static final String FULL_INSTALL_DIR_NAME = "install";
    public static final String CURRENT_VERSION_DIR_NAME = "6.1.0.0";
    public static final String NIF_DIR_NAME = "nif";
    protected ArrayList products = null;
    protected ArrayList productNames = null;
    protected ArrayList components = null;
    protected ArrayList componentNames = null;
    protected ArrayList efixes = null;
    protected ArrayList efixNames = null;
    protected ArrayList ptfs = null;
    protected ArrayList ptfNames = null;
    protected ArrayList extensions = null;
    protected ArrayList extensionNames = null;
    protected ArrayList registrars = null;
    protected ArrayList registrarNames = null;
    protected HashMap versionInfo;
    public static final String PRODUCT_TYPE = "product";
    public static final String COMPONENT_TYPE = "component";
    public static final String EFIX_TYPE = "efix";
    public static final String PTF_TYPE = "ptf";
    public static final String EXTENSION_TYPE = "extension";
    protected File productDir;
    protected String productDirName;
    protected File versionDir;
    protected String versionDirName;
    protected File dtdDir;
    protected String dtdDirName;
    protected File logDir;
    protected String logDirName;
    protected File backupDir;
    protected String backupDirName;

    public static void InitResourceBundle() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(bundleId);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        msgs = resourceBundle;
    }

    protected static String getString(String string) {
        if (msgs == null) {
            WASProduct.InitResourceBundle();
        }
        if (msgs == null) {
            return "com.ibm.websphere.product.WASProductNLS:" + string;
        }
        try {
            return msgs.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "com.ibm.websphere.product.WASProductNLS:" + string;
        }
    }

    protected static String getString(String string, Object object) {
        String string2 = WASProduct.getString(string);
        Object[] objectArray = new Object[]{object};
        return MessageFormat.format(string2, objectArray);
    }

    protected static String getString(String string, Object object, Object object2) {
        String string2 = WASProduct.getString(string);
        Object[] objectArray = new Object[]{object, object2};
        return MessageFormat.format(string2, objectArray);
    }

    protected static String getString(String string, Object[] objectArray) {
        String string2 = WASProduct.getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    protected void addException(WASProductException wASProductException) {
        this.boundExceptions.add(wASProductException);
    }

    public int numExceptions() {
        return this.boundExceptions.size();
    }

    public Iterator getExceptions() {
        return this.boundExceptions.iterator();
    }

    protected void addRecoverableError(SAXParseException sAXParseException) {
        this.recoverableErrors.add(sAXParseException);
    }

    public int numRecoverableErrors() {
        return this.recoverableErrors.size();
    }

    public Iterator getRecoverableErrors() {
        return this.recoverableErrors.iterator();
    }

    protected void addWarning(SAXParseException sAXParseException) {
        this.warnings.add(sAXParseException);
    }

    public int numWarnings() {
        return this.warnings.size();
    }

    public Iterator getWarnings() {
        return this.warnings.iterator();
    }

    protected void transferErrors(BaseFactory baseFactory) {
        Object object;
        Iterator iterator = baseFactory.getRecoverableErrors();
        while (iterator.hasNext()) {
            object = (SAXParseException)iterator.next();
            this.addRecoverableError((SAXParseException)object);
        }
        object = baseFactory.getWarnings();
        while (object.hasNext()) {
            SAXParseException sAXParseException = (SAXParseException)object.next();
            this.addWarning(sAXParseException);
        }
    }

    protected void clearExceptions() {
        this.boundExceptions = new ArrayList();
        this.recoverableErrors = new ArrayList();
        this.warnings = new ArrayList();
    }

    protected void addException(String string) {
        this.addException(WASProduct.createException(string, null, null));
    }

    protected void addException(String string, Exception exception) {
        this.addException(WASProduct.createException(string, null, exception));
    }

    protected void addException(String string, Object[] objectArray, Exception exception) {
        this.addException(WASProduct.createException(string, objectArray, exception));
    }

    protected static WASProductException createException(String string, Object[] objectArray, Exception exception) {
        return new WASProductException(string, objectArray, exception);
    }

    public static String computeProductDirName() throws WASProductException {
        String string = System.getProperty(INSTALL_ROOT_PROPERTY_NAME);
        if (string == null) {
            throw WASProduct.createException("WVER0001E", null, null);
        }
        string = WASProduct.preparePath(string, false);
        return string;
    }

    public static String computeVersionDirName(String string) {
        String string2 = System.getProperty(VERSION_DIR_PROPERTY_NAME);
        string2 = string2 == null ? WASProduct.getVersionDirName(string) : WASProduct.preparePath(string2, false);
        return string2;
    }

    public static String getVersionDirName(String string) {
        string = WASProduct.preparePath(string, false);
        return string + File.separator + PROPERTIES_DIR_NAME + File.separator + VERSION_DIR_NAME;
    }

    public static String computeDTDDirName(String string) throws WASProductException {
        String string2 = System.getProperty(DTD_DIR_PROPERTY_NAME);
        if (string2 == null) {
            if (string == null) {
                throw WASProduct.createException("WVER0019", null, null);
            }
            string2 = WASProduct.getDTDDirName(string);
        } else {
            string2 = WASProduct.preparePath(string2, false);
        }
        return string2;
    }

    public static String getDTDDirName(String string) {
        string = WASProduct.preparePath(string, false);
        return string + File.separator + DTD_DIR_NAME;
    }

    public static String computeLogDirName(String string) throws WASProductException {
        String string2 = System.getProperty(LOG_DIR_PROPERTY_NAME);
        if (string2 == null) {
            if (string == null) {
                throw WASProduct.createException("WVER0017", null, null);
            }
            string2 = WASProduct.getLogDirName(string);
        } else {
            string2 = WASProduct.preparePath(string2, false);
        }
        return string2;
    }

    public static String getLogDirName(String string) {
        string = WASProduct.preparePath(string, false);
        return string + File.separator + LOG_DIR_NAME;
    }

    public static String computeBackupDirName(String string) throws WASProductException {
        String string2 = System.getProperty(BACKUP_DIR_PROPERTY_NAME);
        if (string2 == null) {
            if (string == null) {
                throw WASProduct.createException("WVER0018", null, null);
            }
            string2 = WASProduct.getBackupDirName(string);
        } else {
            string2 = WASProduct.preparePath(string2, false);
        }
        return string2;
    }

    public static String getBackupDirName(String string) {
        String string2 = (string = WASProduct.preparePath(string, false)) + File.separator + UPDATE_DIR_NAME + File.separator + BACKUP_DIR_NAME;
        if (new File(string2).exists()) {
            return string2;
        }
        return string + File.separator + NIF_DIR_NAME + File.separator + BACKUP_DIR_NAME;
    }

    public static String getTmpDirName() {
        String string = System.getProperty(TMP_DIR_PROPERTY_NAME);
        if (string == null && (string = System.getProperty(JAVA_TMP_DIR_PROPERTY_NAME)) == null) {
            string = DEFAULT_TMP_DIR_NAME;
        }
        string = WASProduct.preparePath(string, false);
        return string;
    }

    public static String preparePath(String string, boolean bl) {
        string = string.replace('/', File.separatorChar);
        if ((string = string.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            if (!bl) {
                string = string.substring(0, string.length() - File.separator.length());
            }
        } else if (bl) {
            string = string + File.separator;
        }
        return string;
    }

    public WASProduct() {
        this.clearExceptions();
        try {
            String string = WASProduct.computeProductDirName();
            String string2 = WASProduct.computeVersionDirName(string);
            String string3 = WASProduct.computeDTDDirName(string2);
            String string4 = WASProduct.computeLogDirName(string);
            String string5 = WASProduct.computeBackupDirName(string2);
            this.initialize(string, string2, string3, string4, string5);
        }
        catch (WASProductException wASProductException) {
            this.addException(wASProductException);
        }
    }

    public WASProduct(String string) {
        this.clearExceptions();
        try {
            String string2 = WASProduct.computeVersionDirName(string);
            String string3 = WASProduct.computeDTDDirName(string2);
            String string4 = WASProduct.computeLogDirName(string);
            String string5 = WASProduct.computeBackupDirName(string2);
            this.initialize(string, string2, string3, string4, string5);
        }
        catch (WASProductException wASProductException) {
            this.addException(wASProductException);
        }
    }

    public WASProduct(String string, String string2, String string3, String string4, String string5) {
        this.clearExceptions();
        this.initialize(string, string2, string3, string4, string5);
    }

    protected void initialize(String string, String string2, String string3, String string4, String string5) {
        this.productDir = new File(string);
        this.traceFileProperties(this.productDir);
        this.productDirName = this.productDir.getAbsolutePath();
        if (!this.productDir.exists()) {
            this.addException("WVER0048E", new Object[]{this.productDirName}, null);
        } else if (!this.productDir.isDirectory()) {
            this.addException("WVER0049E", new Object[]{this.productDirName}, null);
        }
        this.versionDir = new File(string2);
        this.traceFileProperties(this.versionDir);
        this.versionDirName = this.versionDir.getAbsolutePath();
        if (!this.versionDir.exists()) {
            this.addException("WVER0040E", new Object[]{this.versionDirName}, null);
        } else if (!this.versionDir.isDirectory()) {
            this.addException("WVER0041E", new Object[]{this.versionDirName}, null);
        }
        this.dtdDir = new File(string3);
        this.traceFileProperties(this.dtdDir);
        this.dtdDirName = this.dtdDir.getAbsolutePath();
        if (!this.dtdDir.exists()) {
            this.addException("WVER0042E", new Object[]{this.dtdDirName}, null);
        } else if (!this.dtdDir.isDirectory()) {
            this.addException("WVER0043E", new Object[]{this.dtdDirName}, null);
        }
        this.logDir = new File(string4);
        this.traceFileProperties(this.logDir);
        this.logDirName = this.logDir.getAbsolutePath();
        this.backupDir = new File(string5);
        this.traceFileProperties(this.backupDir);
        this.backupDirName = this.backupDir.getAbsolutePath();
        this.versionInfo = new HashMap();
    }

    public boolean initializeLogAndBackup() {
        this.clearExceptions();
        boolean bl = true;
        if (!this.logDir.exists()) {
            if (!this.logDir.mkdirs()) {
                this.addException("WVER0044E", new Object[]{this.logDirName}, null);
                bl = false;
            }
        } else if (!this.logDir.isDirectory()) {
            this.addException("WVER0045E", new Object[]{this.logDirName}, null);
            bl = false;
        }
        if (!this.backupDir.exists()) {
            if (!this.backupDir.mkdirs()) {
                this.addException("WVER0046E", new Object[]{this.backupDirName}, null);
                bl = false;
            }
        } else if (!this.backupDir.isDirectory()) {
            this.addException("WVER0047E", new Object[]{this.backupDirName}, null);
            bl = false;
        }
        return bl;
    }

    public websphere getPlatform() {
        return (websphere)this.getVersionInfo("platform.websphere");
    }

    public product getProductByFilename(String string) {
        if (!ProductHandler.accepts(string)) {
            return null;
        }
        return (product)this.getVersionInfo(string);
    }

    public product getProductById(String string) {
        product product2 = null;
        Iterator iterator = this.getProducts();
        while (product2 == null && iterator.hasNext()) {
            product product3 = (product)iterator.next();
            if (!product3.getId().equals(string)) continue;
            product2 = product3;
        }
        return product2;
    }

    public boolean productPresent(String string) {
        return this.getProductById(string) != null;
    }

    public boolean addProduct(product product2) {
        this.clearExceptions();
        String string = product2.getId() + ".product";
        String string2 = this.getVersionFileName(string);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(product2, new ProductWriter(), string2);
        if (baseHandlerException == null) {
            this.addProductName(string);
            this.basicAddProduct(product2);
            return true;
        }
        this.addException("WVER0021E", new String[]{product2.getId(), string2}, baseHandlerException);
        return false;
    }

    public boolean removeProduct(product product2) {
        this.clearExceptions();
        String string = product2.getId() + ".product";
        String string2 = this.getVersionFileName(string);
        File file = new File(string2);
        this.traceFileProperties(file);
        boolean bl = file.delete();
        if (bl) {
            this.removeProductName(string);
            this.basicRemoveProduct(product2);
        } else {
            this.addException("WVER0029E", new String[]{product2.getId(), string2}, null);
        }
        return bl;
    }

    public component getComponentByFilename(String string) {
        if (!ComponentHandler.accepts(string)) {
            return null;
        }
        return (component)this.getVersionInfo(string);
    }

    public component getComponentByName(String string) {
        component component2 = null;
        Iterator iterator = this.getComponents();
        while (component2 == null && iterator.hasNext()) {
            component component3 = (component)iterator.next();
            if (!component3.getName().equals(string)) continue;
            component2 = component3;
        }
        return component2;
    }

    public boolean componentPresent(String string) {
        return this.getComponentByName(string) != null;
    }

    public boolean addComponent(component component2) {
        this.clearExceptions();
        String string = component2.getName() + ".component";
        String string2 = this.getVersionFileName(string);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(component2, new ComponentWriter(), string2);
        if (baseHandlerException == null) {
            boolean bl = false;
            Iterator iterator = this.getComponentNames();
            while (iterator.hasNext() && !bl) {
                String string3 = (String)iterator.next();
                if (!string3.equals(string)) continue;
                bl = true;
            }
            if (!bl) {
                this.addComponentName(string);
                this.basicAddComponent(component2);
            }
            return true;
        }
        this.addException("WVER0021E", new String[]{component2.getName(), string2}, baseHandlerException);
        return false;
    }

    public boolean removeComponent(component component2) {
        this.clearExceptions();
        String string = component2.getName() + ".component";
        String string2 = this.getVersionFileName(string);
        File file = new File(string2);
        this.traceFileProperties(file);
        boolean bl = file.delete();
        if (bl) {
            this.removeComponentName(string);
            this.basicRemoveComponent(component2);
        } else {
            this.addException("WVER0029E", new String[]{component2.getName(), string2}, null);
        }
        return bl;
    }

    public efix getEFixByFilename(String string) {
        if (!EFixHandler.acceptsEFixFileName(string)) {
            return null;
        }
        return (efix)this.getVersionInfo(string);
    }

    public efix getEFixById(String string) {
        efix efix2 = null;
        Iterator iterator = this.getEFixes();
        while (efix2 == null && iterator.hasNext()) {
            efix efix3 = (efix)iterator.next();
            if (!efix3.getId().equals(string)) continue;
            efix2 = efix3;
        }
        return efix2;
    }

    public boolean efixPresent(String string) {
        return this.getEFixById(string) != null;
    }

    public ptf getPTFByFilename(String string) {
        if (!EFixHandler.acceptsPTFFileName(string)) {
            return null;
        }
        return (ptf)this.getVersionInfo(string);
    }

    public ptf getPTFById(String string) {
        ptf ptf2 = null;
        Iterator iterator = this.getPTFs();
        while (ptf2 == null && iterator.hasNext()) {
            ptf ptf3 = (ptf)iterator.next();
            if (!ptf3.getId().equals(string)) continue;
            ptf2 = ptf3;
        }
        return ptf2;
    }

    public boolean ptfPresent(String string) {
        return this.getPTFById(string) != null;
    }

    public extension getExtensionByFilename(String string) {
        if (!ExtensionHandler.accepts(string)) {
            return null;
        }
        return (extension)this.getVersionInfo(string);
    }

    public extension getExtensionByName(String string) {
        extension extension2 = null;
        Iterator iterator = this.getExtensions();
        while (extension2 == null && iterator.hasNext()) {
            extension extension3 = (extension)iterator.next();
            if (!extension3.getName().equals(string)) continue;
            extension2 = extension3;
        }
        return extension2;
    }

    public boolean extensionPresent(String string) {
        return this.getExtensionByName(string) == null;
    }

    public registrar getRegistrarById(String string) {
        registrar registrar2 = null;
        Iterator iterator = this.getRegistrars();
        while (registrar2 == null && iterator.hasNext()) {
            registrar registrar3 = (registrar)iterator.next();
            if (!registrar3.getId().equals(string)) continue;
            registrar2 = registrar3;
        }
        return registrar2;
    }

    public boolean registrarPresent(String string) {
        return this.getRegistrarById(string) != null;
    }

    public Iterator getProducts() {
        if (this.products == null) {
            this.products = this.basicGetProducts();
        }
        return this.products.iterator();
    }

    protected ArrayList basicGetProducts() {
        Iterator iterator = this.getProductNames();
        return this.collectVersionInfo(iterator);
    }

    protected void basicAddProduct(product product2) {
        this.products.add(product2);
    }

    protected void basicRemoveProduct(product product2) {
        this.products.remove(this.products.indexOf(product2));
    }

    public Iterator getProductNames() {
        if (this.productNames == null) {
            this.productNames = this.basicGetProductNames();
        }
        return this.productNames.iterator();
    }

    protected ArrayList basicGetProductNames() {
        ArrayList arrayList = this.listFileNames(new ProductFilenameFilter());
        return arrayList;
    }

    protected void addProductName(String string) {
        this.productNames.add(string);
    }

    protected void removeProductName(String string) {
        this.productNames.remove(this.productNames.indexOf(string));
    }

    public Iterator getComponents() {
        if (this.components == null) {
            this.components = this.basicGetComponents();
        }
        return this.components.iterator();
    }

    protected void basicAddComponent(component component2) {
        this.components.add(component2);
    }

    protected void basicRemoveComponent(component component2) {
        this.components.remove(this.components.indexOf(component2));
    }

    protected ArrayList basicGetComponents() {
        Iterator iterator = this.getComponentNames();
        return this.collectVersionInfo(iterator);
    }

    public Iterator getComponentNames() {
        if (this.componentNames == null) {
            this.componentNames = this.basicGetComponentNames();
        }
        return this.componentNames.iterator();
    }

    protected ArrayList basicGetComponentNames() {
        ArrayList arrayList = this.listFileNames(new ComponentFilenameFilter());
        return arrayList;
    }

    protected void addComponentName(String string) {
        this.componentNames.add(string);
    }

    protected void removeComponentName(String string) {
        this.componentNames.remove(this.componentNames.indexOf(string));
    }

    public boolean saveEFix(efix efix2) {
        this.clearExceptions();
        String string = efix2.getStandardFileName();
        String string2 = this.getVersionFileName(string);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(efix2, new EFixWriter(), string2);
        if (baseHandlerException == null) {
            this.addEFixName(string);
            this.addEFix(efix2);
            return true;
        }
        this.addException("WVER0021E", new String[]{efix2.getId(), string2}, baseHandlerException);
        return false;
    }

    public boolean removeEFix(efix efix2) {
        this.clearExceptions();
        String string = efix2.getStandardFileName();
        String string2 = this.getVersionFileName(string);
        File file = new File(string2);
        this.traceFileProperties(file);
        boolean bl = file.delete();
        if (bl) {
            this.removeEFixName(string);
            this.basicRemoveEFix(efix2);
        } else {
            this.addException("WVER0029E", new String[]{efix2.getId(), string2}, null);
        }
        return bl;
    }

    protected void addEFix(efix efix2) {
        this.efixes.add(efix2);
    }

    protected void basicRemoveEFix(efix efix2) {
        this.efixes.remove(this.efixes.indexOf(efix2));
    }

    public Iterator getEFixes() {
        if (this.efixes == null) {
            this.efixes = this.basicGetEFixes();
        }
        return this.efixes.iterator();
    }

    public int getEFixCount() {
        return this.efixes.size();
    }

    protected ArrayList basicGetEFixes() {
        Iterator iterator = this.getEFixNames();
        return this.collectVersionInfo(iterator);
    }

    protected void addEFixName(String string) {
        this.efixNames.add(string);
    }

    protected void removeEFixName(String string) {
        this.efixNames.remove(this.efixNames.indexOf(string));
    }

    public Iterator getEFixNames() {
        if (this.efixNames == null) {
            this.efixNames = this.basicGetEFixNames();
        }
        return this.efixNames.iterator();
    }

    protected ArrayList basicGetEFixNames() {
        ArrayList arrayList = this.listFileNames(new EFixFilenameFilter());
        return arrayList;
    }

    public boolean savePTF(ptf ptf2) {
        this.clearExceptions();
        String string = ptf2.getStandardFileName();
        String string2 = this.getVersionFileName(string);
        BaseHandlerException baseHandlerException = BaseFactory.saveSingleton(ptf2, new EFixWriter(), string2);
        if (baseHandlerException == null) {
            this.addPTFName(string);
            this.addPTF(ptf2);
            return true;
        }
        this.addException("WVER0030E", new String[]{ptf2.getId(), string2}, baseHandlerException);
        return false;
    }

    public boolean removePTF(ptf ptf2) {
        this.clearExceptions();
        String string = ptf2.getStandardFileName();
        String string2 = this.getVersionFileName(string);
        File file = new File(string2);
        this.traceFileProperties(file);
        boolean bl = file.delete();
        if (bl) {
            this.removePTFName(string);
            this.basicRemovePTF(ptf2);
        } else {
            this.addException("WVER0035E", new String[]{ptf2.getId(), string2}, null);
        }
        return bl;
    }

    protected void addPTF(ptf ptf2) {
        this.ptfs.add(ptf2);
    }

    protected void basicRemovePTF(ptf ptf2) {
        this.ptfs.remove(this.ptfs.indexOf(ptf2));
    }

    public Iterator getPTFs() {
        if (this.ptfs == null) {
            this.ptfs = this.basicGetPTFs();
        }
        return this.ptfs.iterator();
    }

    protected ArrayList basicGetPTFs() {
        Iterator iterator = this.getPTFNames();
        return this.collectVersionInfo(iterator);
    }

    protected void addPTFName(String string) {
        this.ptfNames.add(string);
    }

    protected void removePTFName(String string) {
        this.ptfNames.remove(this.ptfNames.indexOf(string));
    }

    public Iterator getPTFNames() {
        if (this.ptfNames == null) {
            this.ptfNames = this.basicGetPTFNames();
        }
        return this.ptfNames.iterator();
    }

    protected ArrayList basicGetPTFNames() {
        ArrayList arrayList = this.listFileNames(new PTFFilenameFilter());
        return arrayList;
    }

    public Iterator getExtensions() {
        if (this.extensions == null) {
            this.extensions = this.basicGetExtensions();
        }
        return this.extensions.iterator();
    }

    protected ArrayList basicGetExtensions() {
        Iterator iterator = this.getExtensionNames();
        return this.collectVersionInfo(iterator);
    }

    public Iterator getExtensionNames() {
        if (this.extensionNames == null) {
            this.extensionNames = this.basicGetExtensionNames();
        }
        return this.extensionNames.iterator();
    }

    protected ArrayList basicGetExtensionNames() {
        ArrayList arrayList = this.listFileNames(new ExtensionFilenameFilter());
        return arrayList;
    }

    public Iterator getRegistrars() {
        if (this.registrars == null) {
            this.registrars = this.basicGetRegistrars();
        }
        return this.registrars.iterator();
    }

    protected ArrayList basicGetRegistrars() {
        Iterator iterator = this.getRegistrarNames();
        return this.collectVersionInfo(iterator);
    }

    public Iterator getRegistrarNames() {
        if (this.registrarNames == null) {
            this.registrarNames = this.basicGetRegistrarNames();
        }
        return this.registrarNames.iterator();
    }

    protected ArrayList basicGetRegistrarNames() {
        ArrayList arrayList = this.listFileNames(new RegistrarFilenameFilter());
        return arrayList;
    }

    protected ArrayList collectVersionInfo(Iterator iterator) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.getVersionInfo(string);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected Object getVersionInfo(String string) {
        Object object = this.versionInfo.get(string);
        if (object == null && (object = this.loadVersionInfo(string)) != null) {
            this.versionInfo.put(string, object);
        }
        return object;
    }

    protected Object loadVersionInfo(String string) {
        BaseHandler baseHandler = WebSphereHandler.accepts(string) ? new WebSphereHandler() : (ProductHandler.accepts(string) ? new ProductHandler() : (ComponentHandler.accepts(string) ? new ComponentHandler() : (EFixHandler.acceptsEFixFileName(string) || EFixHandler.acceptsPTFFileName(string) ? new EFixHandler() : (ExtensionHandler.accepts(string) ? new ExtensionHandler() : (RegistrarHandler.accepts(string) ? new RegistrarHandler() : null)))));
        if (baseHandler == null) {
            this.addException("WVER0002E", new Object[]{string}, null);
            return null;
        }
        BaseFactory baseFactory = new BaseFactory(baseHandler, null);
        List list = null;
        try {
            list = baseFactory.load(this.getDTDDirName(), this.getVersionDirName(), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.transferErrors(baseFactory);
        BaseHandlerException baseHandlerException = baseFactory.getException();
        if (baseHandlerException != null) {
            this.addException("WVER0013E", new Object[]{string}, baseHandlerException);
            return null;
        }
        return list.iterator().next();
    }

    public String[] loadAllVersionInfoByType(String string) {
        FilenameFilter filenameFilter = string.equalsIgnoreCase(PRODUCT_TYPE) ? new ProductFilenameFilter() : (string.equalsIgnoreCase(COMPONENT_TYPE) ? new ComponentFilenameFilter() : (string.equalsIgnoreCase(EFIX_TYPE) ? new EFixFilenameFilter() : (string.equalsIgnoreCase(PTF_TYPE) ? new PTFFilenameFilter() : (string.equalsIgnoreCase(EXTENSION_TYPE) ? new ExtensionFilenameFilter() : null))));
        if (filenameFilter == null) {
            return null;
        }
        File[] fileArray = this.listFiles(filenameFilter);
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = this.loadVersionInfoAsXMLString(fileArray[i].getName());
        }
        return stringArray;
    }

    public String loadVersionInfoAsXMLString(String string) {
        String string2 = "";
        File file = new File(this.getVersionDir(), string);
        if (file.exists()) {
            try {
                string2 = this.loadFile(file, string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addException("WVER0014E", new Object[]{string}, fileNotFoundException);
            }
            catch (IOException iOException) {
                this.addException("WVER0014E", new Object[]{string}, iOException);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadFile(File file, String string) throws FileNotFoundException, IOException {
        String string2;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                printWriter.println(string2);
            }
        }
        finally {
            bufferedReader.close();
        }
        printWriter.close();
        string2 = stringWriter.toString();
        return string2;
    }

    protected File getProductDir() {
        return this.productDir;
    }

    public String getProductDirName() {
        return this.productDirName;
    }

    protected File getVersionDir() {
        return this.versionDir;
    }

    public String getVersionDirName() {
        return this.versionDirName;
    }

    public String getVersionFileName(String string) {
        Object object;
        String string2 = this.getVersionDirName();
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            object = fileArray[i].getName();
            if (!((String)object).equalsIgnoreCase(string)) continue;
            return fileArray[i].getAbsolutePath();
        }
        String string3 = string2 + File.separator + string;
        object = new File(string3);
        this.traceFileProperties((File)object);
        return ((File)object).getAbsolutePath();
    }

    public String getDTDDirName() {
        return this.dtdDirName;
    }

    public String getLogDirName() {
        return this.logDirName;
    }

    public String getBackupDirName() {
        return this.backupDirName;
    }

    protected ArrayList listFileNames(FilenameFilter filenameFilter) {
        File[] fileArray = this.listFiles(filenameFilter);
        ArrayList arrayList = this.listFileNames(fileArray);
        return arrayList;
    }

    protected ArrayList listFileNames(File[] fileArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i].getName());
        }
        return arrayList;
    }

    protected File[] listFiles(FilenameFilter filenameFilter) {
        File[] fileArray = this.getVersionDir().listFiles(filenameFilter);
        return fileArray;
    }

    public String toString() {
        return "WASProduct: " + this.getProductDirName() + " :: " + this.getVersionDirName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void traceFileProperties(File file) {
        boolean bl = file.exists();
        if (!bl) return;
        try {
            File file2 = file.getCanonicalFile();
            if (file.equals(file2)) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

