/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiUtil;

public class StatsUtil {
    public static String statsToTclAttrString(Stats stats, DataDescriptor dataDescriptor, String string, String string2) {
        return StatsUtil.statsToTclAttrString(null, stats, dataDescriptor, string, string2);
    }

    public static String statsToTclAttrString(String string, Stats stats, DataDescriptor dataDescriptor, String string2, String string3) {
        Stats[] statsArray;
        PmiConstants pmiConstants;
        if (stats == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        String string4 = string;
        String string5 = stats.getStatsType();
        if (string5 == null) {
            string5 = dataDescriptor.getModuleName();
        }
        if (string == null) {
            if (string5.equals("pmi")) {
                string = "PMI data for server";
                string4 = null;
            } else {
                pmiConstants = PerfModules.getConfig(PmiUtil.statsTypeToModuleID(string5));
                string4 = string = pmiConstants.getDescription();
            }
        }
        stringBuffer.append("{Description ").append(string).append("} ");
        stringBuffer.append("{Descriptor ").append(StatsUtil.safeString(StatsUtil.pmiDescriptorToTclAttrString(string5, dataDescriptor, string2, string3))).append("} ");
        stringBuffer.append("{Level ").append(stats.getLevel()).append("}");
        pmiConstants = null;
        Statistic[] statisticArray = stats.listStatistics();
        if (statisticArray != null && statisticArray.length > 0) {
            stringBuffer.append(" {Data {");
            for (int i = 0; i < statisticArray.length; ++i) {
                pmiConstants = new DataDescriptor(dataDescriptor, statisticArray[i].getId());
                stringBuffer.append("{").append(StatsUtil.statisticToTclAttrString(statisticArray[i], stats.getTime(), string5, (DataDescriptor)pmiConstants, string2, string3)).append("}");
                if (i >= statisticArray.length - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append("}}");
        }
        if ((statsArray = stats.listSubStats()) != null && statsArray.length > 0) {
            stringBuffer.append(" {SubCollections {");
            for (int i = 0; i < statsArray.length; ++i) {
                pmiConstants = new DataDescriptor(dataDescriptor, statsArray[i].getName());
                stringBuffer.append("{").append(StatsUtil.statsToTclAttrString(string4, statsArray[i], (DataDescriptor)pmiConstants, string2, string3)).append("}");
                if (i >= statsArray.length - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append("}}");
        }
        return stringBuffer.toString();
    }

    public static String statisticToTclAttrString(Statistic statistic, long l, String string, DataDescriptor dataDescriptor, String string2, String string3) {
        if (statistic == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("{Id ").append(statistic.getId()).append("} ");
        stringBuffer.append("{Descriptor ").append(StatsUtil.safeString(StatsUtil.pmiDescriptorToTclAttrString(string, dataDescriptor, string2, string3))).append("} ");
        stringBuffer.append("{PmiDataInfo ").append(StatsUtil.safeString(StatsUtil.pmiDataInfoToTclAttrString(statistic.getDataInfo()))).append("} ");
        stringBuffer.append("{Time ").append(l).append("} ");
        stringBuffer.append("{Value ").append(StatsUtil.statisticToValue(statistic)).append("}");
        return stringBuffer.toString();
    }

    public static String statisticToTclAttrString(Statistic statistic, long l, DataDescriptor dataDescriptor, String string, String string2) {
        return StatsUtil.statisticToTclAttrString(statistic, l, dataDescriptor.getModuleName(), dataDescriptor, string, string2);
    }

    private static String statisticToValue(Statistic statistic) {
        if (statistic == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (statistic instanceof CountStatisticImpl) {
            CountStatisticImpl countStatisticImpl = (CountStatisticImpl)statistic;
            stringBuffer.append("{Count ").append(countStatisticImpl.getCount()).append("} ");
        } else if (statistic instanceof TimeStatisticImpl) {
            TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)statistic;
            stringBuffer.append("{Total ").append(timeStatisticImpl.getTotal()).append("} ");
            stringBuffer.append("{Count ").append(timeStatisticImpl.getCount()).append("} ");
            stringBuffer.append("{Mean ").append(timeStatisticImpl.getMean()).append("} ");
        } else if (statistic instanceof RangeStatisticImpl) {
            RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)statistic;
            stringBuffer.append("{Current ").append(rangeStatisticImpl.getCurrent()).append("} ");
            stringBuffer.append("{LowWaterMark ").append(rangeStatisticImpl.getLowWaterMark()).append("} ");
            stringBuffer.append("{HighWaterMark ").append(rangeStatisticImpl.getHighWaterMark()).append("} ");
            stringBuffer.append("{MBean ").append(rangeStatisticImpl.getMean()).append("} ");
        }
        return stringBuffer.toString();
    }

    public static String pmiDataInfoToTclAttrString(PmiDataInfo pmiDataInfo) {
        if (pmiDataInfo == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name ").append(StatsUtil.safeString(pmiDataInfo.getName())).append("} ");
        stringBuffer.append("{Id ").append(pmiDataInfo.getId()).append("} ");
        stringBuffer.append("{Description ").append(StatsUtil.safeString(pmiDataInfo.getDescription())).append("} ");
        stringBuffer.append("{Level ").append(pmiDataInfo.getLevel()).append("} ");
        stringBuffer.append("{Comment ").append(StatsUtil.safeString(pmiDataInfo.getComment())).append("} ");
        stringBuffer.append("{SubmoduleName ").append(StatsUtil.safeString(pmiDataInfo.getSubmoduleName())).append("} ");
        stringBuffer.append("{Type ").append(pmiDataInfo.getType()).append("} ");
        stringBuffer.append("{Unit ").append(pmiDataInfo.getUnit()).append("} ");
        stringBuffer.append("{Resettable ").append(pmiDataInfo.isResettable()).append("}");
        return stringBuffer.toString();
    }

    public static String pmiDescriptorToTclAttrString(String string, DataDescriptor dataDescriptor, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Node ").append(StatsUtil.safeString(string2)).append("} ");
        stringBuffer.append("{Server ").append(StatsUtil.safeString(string3)).append("} ");
        if (dataDescriptor.getType() != 12) {
            stringBuffer.append("{Module ").append(StatsUtil.safeString(string)).append("} ");
            stringBuffer.append("{Name ").append(StatsUtil.safeString(dataDescriptor.getName())).append("} ");
        }
        stringBuffer.append("{Type ").append(StatsUtil.pdTypeToString(dataDescriptor.getType())).append("}");
        return stringBuffer.toString();
    }

    public static String pmiDescriptorToTclAttrString(DataDescriptor dataDescriptor, String string, String string2) {
        return StatsUtil.pmiDescriptorToTclAttrString(dataDescriptor.getModuleName(), dataDescriptor, string, string2);
    }

    public static String pdTypeToString(int n) {
        switch (n) {
            case 10: {
                return "ROOT";
            }
            case 11: {
                return "NODE";
            }
            case 12: {
                return "SERVER";
            }
            case 13: {
                return "MODULE";
            }
            case 14: {
                return "INSTANCE";
            }
            case 15: {
                return "SUBMODULE";
            }
            case 16: {
                return "SUBINSTANCE";
            }
            case 17: {
                return "COLLECTION";
            }
            case 18: {
                return "DATA";
            }
            case 24: {
                return "MODULEROOT";
            }
        }
        return "UNKNOWN";
    }

    private static String safeString(String string) {
        if (null == string) {
            return string;
        }
        if (-1 != string.indexOf(" ")) {
            return "{" + string + "}";
        }
        return string;
    }
}

