/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class InstallRARTask {
    String LOCAL = "local_";
    private static TraceComponent tc = Tr.register(InstallRARTask.class, "management", "com.ibm.ws.management.resources.configservice");
    private ConfigService configService;

    public InstallRARTask(ConfigService configService) {
        this.configService = configService;
    }

    public ObjectName installResourceAdapter(Session session, String string, String string2, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter", new Object[]{session, string, string2, hashtable});
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((objectNameArray = this.configService.resolve(session, "Node=" + string)).length == 0) {
            FFDCFilter.processException(new Throwable().fillInStackTrace(), "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "63", this);
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0034E", new Object[]{string}, null);
            throw new ConfigServiceException(string3);
        }
        int n = 0;
        Boolean bl = (Boolean)hashtable.get("rar.DeleteSourceRar");
        if (bl != null && bl.booleanValue()) {
            n = 1000;
        }
        ObjectName objectName = objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node", objectName);
        }
        String string4 = "getResourceAdapterFromRAR";
        String[] stringArray = new String[]{"java.lang.String", "java.util.Hashtable"};
        Object[] objectArray = new Object[]{string2, hashtable};
        AttributeList attributeList = (AttributeList)this.invoke(session, objectName, string, string4, objectArray, stringArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "raAttrList", attributeList);
        }
        string4 = "extractArchive";
        stringArray = new String[]{"java.lang.String", "java.lang.String", "int"};
        String string5 = null;
        try {
            string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "archivePath");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            String string6 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null);
            throw new ConfigServiceException(attributeNotFoundException, string6);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dest", string5);
        }
        objectArray = new Object[]{string2, string5, new Integer(n)};
        this.invoke(session, objectName, string, string4, objectArray, stringArray);
        ObjectName objectName2 = this.configService.createConfigData(session, objectName, "J2CResourceAdapter", null, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter", objectName2);
        }
        return objectName2;
    }

    private Object invoke(Session session, ObjectName objectName, String string, String string2, Object[] objectArray, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{session, objectName, string, string2, objectArray, stringArray});
        }
        Object object = null;
        try {
            if (this.configService instanceof ConfigServiceProxy) {
                Object object2;
                Object object3;
                ObjectName objectName2;
                ObjectName objectName3;
                ConfigServiceProxy configServiceProxy = (ConfigServiceProxy)this.configService;
                AdminClient adminClient = configServiceProxy.getAdminClient();
                String string3 = (String)adminClient.invoke(objectName3 = adminClient.getServerMBean(), "getProcessType", null, null);
                if (string3.equals("UnManagedProcess")) {
                    objectName2 = new ObjectName("*:node=" + string + ",type=AdminOperations,*");
                } else {
                    object3 = new ObjectName("*:node=" + string + ",type=NodeAgent,*");
                    object2 = adminClient.queryNames((ObjectName)object3, null);
                    if (object2.isEmpty()) {
                        throw new InstanceNotFoundException(((ObjectName)object3).getCanonicalName());
                    }
                    String string4 = ((ObjectName)object2.iterator().next()).getKeyProperty("process");
                    objectName2 = new ObjectName("*:node=" + string + ",process=" + string4 + ",type=AdminOperations,*");
                }
                object3 = adminClient.queryNames(objectName2, null);
                if (object3.size() == 0) {
                    throw new InstanceNotFoundException(objectName2.getCanonicalName());
                }
                object2 = (ObjectName)object3.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminOp", object2);
                }
                object = adminClient.invoke((ObjectName)object2, string2, objectArray, stringArray);
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    String string5 = System.getProperty("local.node");
                    Tr.debug(tc, "local node=" + string5 + "while the target node =" + string);
                    if (!string5.equals(string)) {
                        throw new UnsupportedOperationException("Target node should be the same as the current node in local node mode.");
                    }
                    Class<?> clazz = Class.forName("com.ibm.ws.management.component.AdminOperationsMBean");
                    Class<?> clazz2 = Class.forName("java.lang.String");
                    Class<Integer> clazz3 = Integer.TYPE;
                    Class<?> clazz4 = Class.forName("java.util.Hashtable");
                    ObjectName[] objectNameArray = this.configService.getRelationship(session, objectName, "parent");
                    String string6 = ConfigServiceHelper.getDisplayName(objectNameArray[0]);
                    String string7 = System.getProperty("was.repository.root");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configRoot" + string7 + " cell=" + string6 + "node = " + string);
                    }
                    Class[] classArray = null;
                    Object[] objectArray2 = null;
                    if (string2.equals("getResourceAdapterFromRAR") || string2.equals("getRARInfo")) {
                        classArray = new Class[]{clazz2, clazz4, clazz2, clazz2, clazz2};
                        objectArray2 = new Object[]{objectArray[0], objectArray[1], string7, string6, string};
                    } else {
                        classArray = new Class[]{clazz2, clazz2, clazz3, clazz2, clazz2, clazz2};
                        objectArray2 = new Object[]{objectArray[0], objectArray[1], objectArray[2], string7, string6, string};
                    }
                    Method method2 = clazz.getMethod(this.LOCAL + string2, classArray);
                    object = method2.invoke(null, objectArray2);
                } else {
                    Object object4;
                    ObjectName objectName4;
                    if (adminService.getProcessType().equals("UnManagedProcess")) {
                        objectName4 = new ObjectName("*:node=" + string + ",type=AdminOperations,*");
                    } else {
                        object4 = AdminHelper.getInstance().getNodeAgentName(string);
                        objectName4 = new ObjectName("*:node=" + string + ",process=" + (String)object4 + ",type=AdminOperations,*");
                    }
                    object4 = adminService.queryNames(objectName4, null);
                    if (object4.size() == 0) {
                        throw new InstanceNotFoundException(objectName4.getCanonicalName());
                    }
                    ObjectName objectName5 = (ObjectName)object4.iterator().next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adminOp", objectName5);
                    }
                    object = adminService.invoke(objectName5, string2, objectArray, stringArray);
                }
            }
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new ConfigServiceException(throwable);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "71", this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", object);
        }
        return object;
    }

    public Hashtable getRARInfo(Session session, String string, String string2, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter", new Object[]{session, string, string2, hashtable});
        }
        Hashtable hashtable2 = new Hashtable();
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((objectNameArray = this.configService.resolve(session, "Node=" + string)).length == 0) {
            FFDCFilter.processException(new Throwable().fillInStackTrace(), "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "63", this);
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0034E", new Object[]{string}, null);
            throw new ConfigServiceException(string3);
        }
        ObjectName objectName = objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node", objectName);
        }
        String string4 = "getRARInfo";
        String[] stringArray = new String[]{"java.lang.String", "java.util.Hashtable"};
        Object[] objectArray = new Object[]{string2, hashtable};
        hashtable2 = (Hashtable)this.invoke(session, objectName, string, string4, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRAInfo", hashtable2);
        }
        return hashtable2;
    }
}

