/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.crypto;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import java.util.Map;
import java.util.TreeMap;

public class KeySetHelper {
    private static final TraceComponent tc = Tr.register(KeySetHelper.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static KeySetHelper thisClass = null;
    private static final WebSphereRuntimePermission GET_KEYSETGROUPS = new WebSphereRuntimePermission("getKeySetGroups");
    private static final WebSphereRuntimePermission GET_KEYSETS = new WebSphereRuntimePermission("getKeySets");

    public static KeySetHelper getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (thisClass == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new instance of KeySetHelper.");
            }
            thisClass = new KeySetHelper();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return thisClass;
    }

    public Map getAllKeysForKeySetGroup(String string) throws KeyException, SecurityException {
        WSKeySetGroup wSKeySetGroup;
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeysByVersion", new Object[]{string});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString());
            }
            try {
                securityManager.checkPermission(GET_KEYSETGROUPS);
            }
            catch (SecurityException securityException) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString() + "." + string);
                securityManager.checkPermission(new WebSphereRuntimePermission("GetKeySetGroups." + string));
            }
        }
        if ((wSKeySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySetGroup name is not found.");
            }
            throw new KeyException("KeySetGroup name " + string + " is not found.");
        }
        TreeMap treeMap = wSKeySetGroup.getAllKeysByVersion();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysByVersion", new Object[]{treeMap});
        }
        return treeMap;
    }

    public Map getLatestKeysForKeySetGroup(String string) throws KeyException, SecurityException {
        WSKeySetGroup wSKeySetGroup;
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeysForKeySetGroup", new Object[]{string});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString());
            }
            try {
                securityManager.checkPermission(GET_KEYSETGROUPS);
            }
            catch (SecurityException securityException) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString() + "." + string);
                securityManager.checkPermission(new WebSphereRuntimePermission("GetKeySetGroups." + string));
            }
        }
        if ((wSKeySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySetGroup name is not found.");
            }
            throw new KeyException("KeySetGroup name " + string + " is not found.");
        }
        Map map = wSKeySetGroup.getLatestKeys();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeysForKeySetGroup", new Object[]{map});
        }
        return map;
    }

    public Map getAllKeysForKeySet(String string) throws KeyException {
        WSKeySet wSKeySet;
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeysForKeySet", new Object[]{string});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString());
            }
            try {
                securityManager.checkPermission(GET_KEYSETS);
            }
            catch (SecurityException securityException) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString() + "." + string);
                securityManager.checkPermission(new WebSphereRuntimePermission("GetKeySets." + string));
            }
        }
        if ((wSKeySet = KeySetManager.getInstance().getKeySet(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySet name is not found.");
            }
            throw new KeyException("KeySet name " + string + " is not found.");
        }
        Map map = wSKeySet.getAllKeys();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysForKeySet", new Object[]{map});
        }
        return map;
    }

    public Object getLatestKeyForKeySet(String string) throws KeyException {
        WSKeySet wSKeySet;
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyForKeySet", new Object[]{string});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString());
            }
            try {
                securityManager.checkPermission(GET_KEYSETS);
            }
            catch (SecurityException securityException) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString() + "." + string);
                securityManager.checkPermission(new WebSphereRuntimePermission("GetKeySets." + string));
            }
        }
        if ((wSKeySet = KeySetManager.getInstance().getKeySet(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySet name is not found.");
            }
            throw new KeyException("KeySet name " + string + " is not found.");
        }
        Object object = wSKeySet.getLatestKey();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeyForKeySet", new Object[]{object});
        }
        return object;
    }
}

