/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.D;
import com.ibm.toad.utils.Strings;

public final class JavaTypeDesc {
    final char firstChar;
    final String jvmdesc;
    final String basedesc;
    public static final JavaTypeDesc BYTE = new JavaTypeDesc("B");
    public static final JavaTypeDesc CHAR = new JavaTypeDesc("C");
    public static final JavaTypeDesc DOUBLE = new JavaTypeDesc("D");
    public static final JavaTypeDesc FLOAT = new JavaTypeDesc("F");
    public static final JavaTypeDesc INT = new JavaTypeDesc("I");
    public static final JavaTypeDesc LONG = new JavaTypeDesc("J");
    public static final JavaTypeDesc SHORT = new JavaTypeDesc("S");
    public static final JavaTypeDesc VOID = new JavaTypeDesc("V");
    public static final JavaTypeDesc BOOLEAN = new JavaTypeDesc("Z");

    private JavaTypeDesc(String string) {
        this.jvmdesc = string;
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        this.basedesc = n != 0 ? string.substring(n) : string;
        this.firstChar = string.charAt(0);
    }

    public boolean isArray() {
        return this.firstChar == '[';
    }

    public boolean isObject() {
        return this.firstChar == 'L';
    }

    public boolean isReference() {
        return this.firstChar == '[' || this.firstChar == 'L';
    }

    public boolean isPrimitive() {
        return this.firstChar != '[' && this.firstChar != 'L';
    }

    public int getNumArrayDimensions() {
        D.pre(this.isArray());
        int n = 0;
        while (this.jvmdesc.charAt(n) == '[') {
            ++n;
        }
        return n;
    }

    public JavaTypeDesc getBaseType() {
        if (this.isArray()) {
            return new JavaTypeDesc(this.basedesc);
        }
        return this;
    }

    public String getPackage() {
        D.pre(this.isObject());
        int n = this.basedesc.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return this.basedesc.substring(1, n).replace('/', '.');
    }

    public String getClassName() {
        D.pre(this.isObject());
        int n = this.basedesc.lastIndexOf(47);
        if (n == -1) {
            return this.basedesc.substring(1, this.basedesc.length() - 1);
        }
        return this.basedesc.substring(n + 1, this.basedesc.length() - 1);
    }

    public int getNumBytes() {
        int n;
        if (this.isReference()) {
            n = 4;
        } else {
            switch (this.firstChar) {
                case 'B': {
                    n = 1;
                    break;
                }
                case 'C': {
                    n = 2;
                    break;
                }
                case 'D': {
                    n = 8;
                    break;
                }
                case 'F': {
                    n = 4;
                    break;
                }
                case 'I': {
                    n = 4;
                    break;
                }
                case 'J': {
                    n = 8;
                    break;
                }
                case 'S': {
                    n = 2;
                    break;
                }
                case 'V': {
                    n = 0;
                    break;
                }
                case 'Z': {
                    n = 1;
                    break;
                }
                default: {
                    n = -1;
                    D.abort("D.getNumBytes");
                }
            }
        }
        return n;
    }

    private String getBaseInEnglish() {
        String string;
        switch (this.basedesc.charAt(0)) {
            case 'B': {
                string = "byte";
                break;
            }
            case 'C': {
                string = "char";
                break;
            }
            case 'D': {
                string = "double";
                break;
            }
            case 'F': {
                string = "float";
                break;
            }
            case 'I': {
                string = "int";
                break;
            }
            case 'J': {
                string = "long";
                break;
            }
            case 'S': {
                string = "short";
                break;
            }
            case 'V': {
                string = "void";
                break;
            }
            case 'Z': {
                string = "boolean";
                break;
            }
            case 'L': {
                string = this.basedesc.substring(1, this.basedesc.length() - 1).replace('/', '.');
                break;
            }
            default: {
                string = null;
                D.abort("getBaseInEnglish");
            }
        }
        return string;
    }

    public String getInEnglish() {
        if (this.firstChar == '[') {
            String string = this.getBaseInEnglish();
            int n = this.getNumArrayDimensions();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 2 * n);
            stringBuffer.append(string);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }
        return this.getBaseInEnglish();
    }

    public String getInJVMStyle() {
        return this.jvmdesc;
    }

    private static boolean isValidJVMDesc(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = JavaTypeDesc.getEndOfJVMDesc(string, 0);
        return n2 == n;
    }

    private static int getEndOfJVMDesc(String string, int n) {
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == '[') {
            ++n;
        }
        if (n == n2) {
            return -1;
        }
        block0 : switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                ++n;
                break;
            }
            case 'L': {
                int n3 = 0;
                block9: while (true) {
                    ++n;
                    if (n3 == 2) break block0;
                    if (n == n2) {
                        return -1;
                    }
                    c = string.charAt(n);
                    switch (n3) {
                        case 0: {
                            if (!Character.isJavaIdentifierStart(c)) {
                                return -1;
                            }
                            n3 = 1;
                            continue block9;
                        }
                        case 1: {
                            if (c == ';') {
                                n3 = 2;
                                continue block9;
                            }
                            if (c == '/') {
                                n3 = 0;
                                continue block9;
                            }
                            if (Character.isJavaIdentifierPart(c)) continue block9;
                            return -1;
                        }
                    }
                    D.abort();
                }
            }
            default: {
                return -1;
            }
        }
        return n;
    }

    public static String[] getFromJVMStyleParameterList(String string) {
        D.pre(string != null);
        int n = string.length();
        if (n == 0 || string.charAt(0) != '(' || string.charAt(n - 1) != ')') {
            return null;
        }
        Strings.List list = null;
        int n2 = 0;
        int n3 = 1;
        while (n3 < n - 1) {
            int n4 = JavaTypeDesc.getEndOfJVMDesc(string, n3);
            if (n4 == -1) {
                return null;
            }
            ++n2;
            list = new Strings.List(string.substring(n3, n4), list);
            n3 = n4;
        }
        String[] stringArray = new String[n2];
        for (int i = n2 - 1; i >= 0; --i) {
            stringArray[i] = list.head;
            list = list.tail;
        }
        return stringArray;
    }

    public static JavaTypeDesc[] mkFromJVMStyleParameterList(String string) {
        String[] stringArray = JavaTypeDesc.getFromJVMStyleParameterList(string);
        if (stringArray == null) {
            return null;
        }
        JavaTypeDesc[] javaTypeDescArray = new JavaTypeDesc[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            javaTypeDescArray[i] = JavaTypeDesc.mkFromJVMStyleDesc(stringArray[i]);
            if (javaTypeDescArray[i] != null) continue;
            return null;
        }
        return javaTypeDescArray;
    }

    public static JavaTypeDesc mkFromJVMStyleDesc(String string) {
        D.pre(string != null);
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case 'B': {
                    return BYTE;
                }
                case 'C': {
                    return CHAR;
                }
                case 'D': {
                    return DOUBLE;
                }
                case 'F': {
                    return FLOAT;
                }
                case 'I': {
                    return INT;
                }
                case 'J': {
                    return LONG;
                }
                case 'S': {
                    return SHORT;
                }
                case 'V': {
                    return VOID;
                }
                case 'Z': {
                    return BOOLEAN;
                }
            }
        }
        if (!JavaTypeDesc.isValidJVMDesc(string)) {
            return null;
        }
        JavaTypeDesc javaTypeDesc = new JavaTypeDesc(string);
        return javaTypeDesc;
    }

    public static JavaTypeDesc mkFromEnglish(String string) {
        String string2 = JavaTypeDesc.convertEnglishDescToJVMStyleDesc(string);
        if (string2 == null) {
            return null;
        }
        return JavaTypeDesc.mkFromJVMStyleDesc(string2);
    }

    private static String convertEnglishDescToJVMStyleDesc(String string) {
        int n;
        String[] stringArray = new String[]{"byte", "char", "double", "float", "int", "long", "short", "void", "boolean"};
        String[] stringArray2 = new String[]{"B", "C", "D", "F", "I", "J", "S", "V", "Z"};
        String string2 = "";
        Lexer lexer = new Lexer(string);
        lexer.getTok();
        if (lexer.tokenType != 1) {
            return null;
        }
        String string3 = lexer.ident.toString();
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!string3.regionMatches(0, stringArray[n], 0, stringArray[n].length())) continue;
            string2 = stringArray2[n];
            bl = true;
        }
        if (!bl) {
            string2 = "L" + string3.replace('.', '/') + ";";
        }
        n = 0;
        lexer.getTok();
        while (lexer.tokenType == 3) {
            lexer.getTok();
            if (lexer.tokenType != 4) {
                return null;
            }
            lexer.getTok();
            ++n;
        }
        if (lexer.tokenType != -1) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            string2 = "[" + string2;
        }
        return string2;
    }

    private static final class Lexer {
        static final int EOF = -1;
        static final int ERROR = 0;
        static final int IDENT = 1;
        static final int LBRAK = 3;
        static final int RBRAK = 4;
        StringBuffer ident = new StringBuffer(32);
        int integer;
        int tokenType;
        private char[] in;
        private int len;
        private int pos;

        Lexer(String string) {
            this.in = string.toCharArray();
            this.len = this.in.length;
            this.pos = 0;
        }

        private void ident() {
            this.ident.setLength(0);
            do {
                this.ident.append(this.in[this.pos++]);
            } while (this.pos < this.len && (this.in[this.pos] == '.' || Character.isJavaIdentifierPart(this.in[this.pos])));
        }

        int getTok() {
            while (this.pos < this.len && Character.isWhitespace(this.in[this.pos])) {
                ++this.pos;
            }
            if (this.pos == this.len) {
                this.tokenType = -1;
                return -1;
            }
            char c = this.in[this.pos];
            if (Character.isJavaIdentifierStart(c)) {
                this.tokenType = 1;
                this.ident();
            } else if (c == '[') {
                this.tokenType = 3;
                ++this.pos;
            } else if (c == ']') {
                this.tokenType = 4;
                ++this.pos;
            } else {
                this.tokenType = 0;
                ++this.pos;
            }
            return this.tokenType;
        }
    }
}

