/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.attributes.LineNumberAttrInfo;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.ByteInstruction;
import com.ibm.toad.cfparse.instruction.ByteInstructionFactory;
import com.ibm.toad.cfparse.instruction.CodeViewer;
import com.ibm.toad.cfparse.instruction.InstructionFactory;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.utils.D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class MutableCodeSegment
implements TagFactory {
    private static final String baseTag = "TAG_";
    private int d_curTagNum;
    private HashMap d_off2tagNum;
    private HashMap d_off2iNum;
    private HashMap d_tagNum2tagStr;
    private HashMap d_tagStr2tagNum;
    private HashMap d_tagStr2iNum;
    private Vector d_instructions;
    int d_numExceptions;
    CodeAttrInfo.ExceptionInfo[] d_exceptions;
    ConstantPool d_cp;
    private InstructionFactory d_if;

    private MutableCodeSegment(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_curTagNum = 0;
        this.d_off2tagNum = new HashMap();
        this.d_off2iNum = new HashMap();
        this.d_tagNum2tagStr = new HashMap();
        this.d_tagStr2tagNum = new HashMap();
        this.d_tagStr2iNum = new HashMap();
        this.d_instructions = new Vector();
    }

    private void init(byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n) {
        if (byArray != null) {
            this.readCode(byArray);
        }
        this.makeExcTable(exceptionInfoArray, n);
        this.fixTags();
    }

    public MutableCodeSegment(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n) {
        this(constantPool);
        this.d_if = new ByteInstructionFactory();
        this.init(byArray, exceptionInfoArray, n);
    }

    public MutableCodeSegment(ConstantPool constantPool, CodeAttrInfo codeAttrInfo, boolean bl) {
        this(constantPool);
        this.d_if = new ByteInstructionFactory();
        this.init(codeAttrInfo.getCode(), codeAttrInfo.getExceptions(), codeAttrInfo.getNumExceptions());
        if (bl) {
            this.addLines(codeAttrInfo);
        }
    }

    public MutableCodeSegment(ConstantPool constantPool, CodeAttrInfo codeAttrInfo) {
        this(constantPool, codeAttrInfo, true);
    }

    private void addLines(CodeAttrInfo codeAttrInfo) {
        AttrInfoList attrInfoList = codeAttrInfo.getAttrs();
        if (attrInfoList == null) {
            return;
        }
        LineNumberAttrInfo lineNumberAttrInfo = (LineNumberAttrInfo)attrInfoList.get("LineNumberTable");
        if (lineNumberAttrInfo == null) {
            return;
        }
        byte[] byArray = new byte[]{-2, 0, 0};
        for (int i = 0; i < lineNumberAttrInfo.length(); ++i) {
            ByteArray.writeShort(byArray, 1, lineNumberAttrInfo.getLineNumber(i));
            ByteInstruction byteInstruction = new ByteInstruction(this, this.d_cp, byArray, 0, 3);
            Integer n = (Integer)this.d_off2iNum.get(new Integer(lineNumberAttrInfo.getStartPC(i)));
            if (n == null) {
                this.panicCleanupLineNumbers(codeAttrInfo);
                return;
            }
            this.d_instructions.insertElementAt(byteInstruction, n + i);
        }
    }

    private void panicCleanupLineNumbers(CodeAttrInfo codeAttrInfo) {
        for (int i = 0; i < this.d_instructions.size(); ++i) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(i);
            if (baseInstruction.getOpCode() != 254) continue;
            this.d_instructions.removeElementAt(i);
            --i;
        }
        AttrInfoList attrInfoList = codeAttrInfo.getAttrs();
        if (attrInfoList == null) {
            return;
        }
        attrInfoList.remove("LineNumberTable");
    }

    public MutableCodeSegment(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n, InstructionFactory instructionFactory) {
        this(constantPool);
        this.d_if = instructionFactory;
        this.init(byArray, exceptionInfoArray, n);
    }

    public MutableCodeSegment(ConstantPool constantPool, CodeAttrInfo codeAttrInfo, boolean bl, InstructionFactory instructionFactory) {
        this(constantPool);
        this.d_if = instructionFactory;
        this.init(codeAttrInfo.getCode(), codeAttrInfo.getExceptions(), codeAttrInfo.getNumExceptions());
        if (bl) {
            this.addLines(codeAttrInfo);
        }
    }

    public MutableCodeSegment(ConstantPool constantPool, CodeAttrInfo codeAttrInfo, InstructionFactory instructionFactory) {
        this(constantPool, codeAttrInfo, true, instructionFactory);
    }

    public void setInstructionFactory(InstructionFactory instructionFactory) {
        this.d_if = instructionFactory;
    }

    private void fixTags() {
        Iterator iterator = this.d_off2tagNum.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer n = (Integer)this.d_off2iNum.get((Integer)entry.getKey());
            String string = (String)this.d_tagNum2tagStr.get((Integer)entry.getValue());
            ((BaseInstruction)this.d_instructions.elementAt(n)).setTag(string);
            this.d_tagStr2iNum.put(string, n);
        }
    }

    private void makeExcTable(CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n) {
        this.d_numExceptions = n;
        this.d_exceptions = new CodeAttrInfo.ExceptionInfo[this.d_numExceptions];
        for (int i = 0; i < this.d_numExceptions; ++i) {
            int n2 = exceptionInfoArray[i].getStart();
            int n3 = exceptionInfoArray[i].getEnd();
            int n4 = exceptionInfoArray[i].getHandler();
            this.d_exceptions[i] = new CodeAttrInfo.ExceptionInfo(this.d_cp, this.addTag(n2), this.addTag(n3), this.addTag(n4), exceptionInfoArray[i].getCatch());
        }
    }

    public int tagFor(String string, boolean bl) {
        Integer n = (Integer)this.d_tagStr2tagNum.get(string);
        if (n != null) {
            return n;
        }
        if (!bl) {
            return -1;
        }
        int n2 = this.d_curTagNum++;
        Integer n3 = new Integer(n2);
        this.d_tagNum2tagStr.put(n3, string);
        this.d_tagStr2tagNum.put(string, n3);
        return n2;
    }

    private void readCode(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            int n3 = ByteArray.getByteAtOffset(byArray, n);
            int n4 = 0;
            boolean bl = false;
            int n5 = 0;
            int n6 = 0;
            BaseInstruction baseInstruction = null;
            int n7 = 0;
            int n8 = 0;
            ++n;
            JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[n3];
            switch (n3) {
                case 170: {
                    int n9;
                    n4 = (4 - n % 4) % 4;
                    n5 = ByteArray.getIntAtOffset(byArray, n += n4);
                    n7 = this.addTag(n2 + n5);
                    int n10 = ByteArray.getIntAtOffset(byArray, n += 4);
                    int n11 = ByteArray.getIntAtOffset(byArray, n += 4);
                    n += 4;
                    byte[] byArray2 = new byte[13 + (n11 - n10 + 1) * 4];
                    byArray2[0] = (byte)n3;
                    ByteArray.writeInt(byArray2, 1, n7);
                    ByteArray.writeInt(byArray2, 5, n10);
                    ByteArray.writeInt(byArray2, 9, n11);
                    n6 = 13;
                    for (n9 = n10; n9 <= n11; ++n9) {
                        n5 = ByteArray.getIntAtOffset(byArray, n);
                        n8 = this.addTag(n2 + n5);
                        ByteArray.writeInt(byArray2, n6, n8);
                        n6 += 4;
                        n += 4;
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, byArray2.length);
                    break;
                }
                case 171: {
                    int n12;
                    n4 = (4 - n % 4) % 4;
                    n5 = ByteArray.getIntAtOffset(byArray, n += n4);
                    n7 = this.addTag(n2 + n5);
                    int n9 = ByteArray.getIntAtOffset(byArray, n += 4);
                    n += 4;
                    byte[] byArray2 = new byte[9 + n9 * 8];
                    byArray2[0] = (byte)n3;
                    ByteArray.writeInt(byArray2, 1, n7);
                    ByteArray.writeInt(byArray2, 5, n9);
                    n6 = 9;
                    for (n12 = 0; n12 < n9; ++n12) {
                        int n13 = ByteArray.getIntAtOffset(byArray, n);
                        ByteArray.writeInt(byArray2, n6, n13);
                        n5 = ByteArray.getIntAtOffset(byArray, n += 4);
                        n8 = this.addTag(n2 + n5);
                        ByteArray.writeInt(byArray2, n6 += 4, n8);
                        n6 += 4;
                        n += 4;
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, byArray2.length);
                    break;
                }
                case 196: {
                    int n12 = ByteArray.getByteAtOffset(byArray, n);
                    n += 3;
                    if (n12 == 132) {
                        n += 2;
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray, n2, n - n2);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    n5 = ByteArray.getSignedShortAtOffset(byArray, n);
                    n8 = this.addTag(n2 + n5);
                    byte[] byArray2 = new byte[]{(byte)n3, (byte)(n8 >>> 8 & 0xFF), (byte)(n8 >>> 0 & 0xFF)};
                    n += JVMInstruction.argSkip('a');
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, 3);
                    break;
                }
                case 200: 
                case 201: {
                    n5 = ByteArray.getIntAtOffset(byArray, n);
                    n8 = this.addTag(n2 + n5);
                    byte[] byArray2 = new byte[]{(byte)n3, (byte)(n8 >>> 24 & 0xFF), (byte)(n8 >>> 16 & 0xFF), (byte)(n8 >>> 8 & 0xFF), (byte)(n8 >>> 0 & 0xFF)};
                    n += JVMInstruction.argSkip('A');
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, 5);
                    break;
                }
                default: {
                    String string = jVMInstruction.operandTypes();
                    int n14 = string.length();
                    for (int i = 0; i < n14; ++i) {
                        n += JVMInstruction.argSkip(string.charAt(i));
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray, n2, n - n2);
                }
            }
            this.d_off2iNum.put(new Integer(n2), new Integer(this.d_instructions.size()));
            if (baseInstruction == null) continue;
            this.d_instructions.addElement(baseInstruction);
        }
    }

    public byte[] getCode() {
        Object object;
        BaseInstruction baseInstruction;
        int n;
        int[] nArray = new int[this.d_curTagNum];
        int n2 = 0;
        for (n = 0; n < this.d_instructions.size(); ++n) {
            BaseInstruction baseInstruction2 = (BaseInstruction)this.d_instructions.elementAt(n);
            if (baseInstruction2.getOpCode() == 254) continue;
            if (baseInstruction2.getTag() != null) {
                nArray[this.tagFor((String)baseInstruction2.getTag(), (boolean)false)] = n2;
            }
            n2 += baseInstruction2.getLength(n2);
        }
        n = 1;
        while (n != 0) {
            n = 0;
            n2 = 0;
            for (int i = 0; i < this.d_instructions.size(); ++i) {
                baseInstruction = (BaseInstruction)this.d_instructions.elementAt(i);
                if (baseInstruction.getOpCode() == 254) continue;
                object = baseInstruction.updateOffsets(nArray, n2);
                if (object != baseInstruction) {
                    this.d_instructions.setElementAt(object, i);
                    n = 1;
                }
                if (n != 0 && baseInstruction.getTag() != null) {
                    nArray[this.tagFor((String)baseInstruction.getTag(), (boolean)false)] = n2;
                }
                n2 += object.getLength(n2);
            }
        }
        byte[] byArray = new byte[n2];
        n2 = 0;
        for (int i = 0; i < this.d_instructions.size(); ++i) {
            baseInstruction = (BaseInstruction)this.d_instructions.elementAt(i);
            if (baseInstruction.getOpCode() == 254) continue;
            object = baseInstruction.getCode(nArray, n2);
            System.arraycopy(object, 0, byArray, n2, ((Object)object).length);
            D.azzert(((Object)object).length == baseInstruction.getLength(n2), "Bad lengths in getCode");
            n2 += baseInstruction.getLength(n2);
        }
        return byArray;
    }

    public CodeAttrInfo.ExceptionInfo[] getExcTable() {
        int n;
        int[] nArray = new int[this.d_curTagNum];
        int n2 = 0;
        for (n = 0; n < this.d_instructions.size(); ++n) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(n);
            if (baseInstruction.getOpCode() == 254) continue;
            if (baseInstruction.getTag() != null) {
                nArray[this.tagFor((String)baseInstruction.getTag(), (boolean)false)] = n2;
            }
            n2 += baseInstruction.getLength(n2);
        }
        if (n2 > Short.MAX_VALUE) {
            n = 1;
            while (n != 0) {
                n = 0;
                n2 = 0;
                for (int i = 0; i < this.d_instructions.size(); ++i) {
                    BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(i);
                    if (baseInstruction.getOpCode() == 254) continue;
                    BaseInstruction baseInstruction2 = baseInstruction.updateOffsets(nArray, n2);
                    if (baseInstruction2 != baseInstruction) {
                        this.d_instructions.setElementAt(baseInstruction2, i);
                        n = 1;
                    }
                    if (n != 0 && baseInstruction.getTag() != null) {
                        nArray[this.tagFor((String)baseInstruction.getTag(), (boolean)false)] = n2;
                    }
                    n2 += baseInstruction2.getLength(n2);
                }
            }
        }
        CodeAttrInfo.ExceptionInfo[] exceptionInfoArray = new CodeAttrInfo.ExceptionInfo[this.d_numExceptions];
        for (int i = 0; i < this.d_numExceptions; ++i) {
            int n3 = this.d_exceptions[i].getStart();
            int n4 = this.d_exceptions[i].getEnd();
            int n5 = this.d_exceptions[i].getHandler();
            exceptionInfoArray[i] = new CodeAttrInfo.ExceptionInfo(this.d_cp, nArray[n3], nArray[n4], nArray[n5], this.d_exceptions[i].getCatch());
        }
        return exceptionInfoArray;
    }

    public void fixLineNumberTable(LineNumberAttrInfo lineNumberAttrInfo) {
        int n = 0;
        boolean bl = true;
        lineNumberAttrInfo.clear();
        for (int i = 0; i < this.d_instructions.size(); ++i) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(i);
            if (baseInstruction.getOpCode() == 254) {
                if (bl) {
                    lineNumberAttrInfo.clear();
                    bl = false;
                }
                int n2 = ByteArray.getShortAtOffset(baseInstruction.getCode(null, 0), 1);
                lineNumberAttrInfo.add(n2, n);
                continue;
            }
            n += baseInstruction.getLength(n);
        }
    }

    public int getLineNumber(int n) {
        boolean bl = false;
        int n2 = -1;
        if (n < 0 || n >= this.d_instructions.size()) {
            throw new IllegalArgumentException("Instruction index " + n + " larger than size of instructions array: " + this.d_instructions.size());
        }
        for (int i = n; i >= 0; --i) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(i);
            if (baseInstruction.getOpCode() != 254) continue;
            n2 = ByteArray.getShortAtOffset(baseInstruction.getCode(null, 0), 1);
            return n2;
        }
        return -1;
    }

    public void updateCodeAttrInfo(CodeAttrInfo codeAttrInfo) {
        codeAttrInfo.setCode(this.getCode());
        codeAttrInfo.setExceptions(this.getExcTable());
        AttrInfoList attrInfoList = codeAttrInfo.getAttrs();
        if (attrInfoList == null) {
            return;
        }
        LineNumberAttrInfo lineNumberAttrInfo = (LineNumberAttrInfo)attrInfoList.get("LineNumberTable");
        if (lineNumberAttrInfo == null) {
            return;
        }
        this.fixLineNumberTable(lineNumberAttrInfo);
    }

    private int addTag(int n) {
        Integer n2 = (Integer)this.d_off2tagNum.get(new Integer(n));
        if (n2 != null) {
            return n2;
        }
        int n3 = this.d_curTagNum++;
        Integer n4 = new Integer(n3);
        Integer n5 = new Integer(n);
        this.d_off2tagNum.put(n5, n4);
        this.d_tagNum2tagStr.put(n4, baseTag + n3);
        this.d_tagStr2tagNum.put(baseTag + n3, n4);
        return n3;
    }

    public int tag2Inum(String string) {
        Integer n = (Integer)this.d_tagStr2iNum.get(string);
        return n == null ? -1 : n;
    }

    public int getNumExceptions() {
        return this.d_numExceptions;
    }

    public CodeAttrInfo.ExceptionInfo getException(int n) {
        if (n < 0 || n > this.d_numExceptions) {
            return null;
        }
        return this.d_exceptions[n];
    }

    public int numTags() {
        return this.d_curTagNum;
    }

    public String getTag(int n) {
        return (String)this.d_tagNum2tagStr.get(new Integer(n));
    }

    public BaseInstruction create(String string) throws InstructionFormatException {
        BaseInstruction baseInstruction = this.d_if.create(this, this.d_cp, string);
        String string2 = baseInstruction.getTag();
        if (string2 != null) {
            this.tagFor(string2, true);
        }
        return baseInstruction;
    }

    public Vector getInstructions() {
        return this.d_instructions;
    }

    public void setInstructions(Vector vector) {
        this.d_instructions = vector;
    }

    public int getNumInstructions() {
        return this.d_instructions.size();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.d_instructions.size(); ++n2) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(n2);
            String string = baseInstruction.getTag() != null ? baseInstruction.getTag() + ":" : "\t";
            stringBuffer.append(n2 + ":" + string + this.sindent(n) + " " + baseInstruction + "\n");
        }
        stringBuffer.append(this.sindent(n) + "Exception Table:\n");
        if (this.d_numExceptions == 0) {
            stringBuffer.append(this.sindent(n) + "  <none>\n");
        } else {
            for (n2 = 0; n2 < this.d_numExceptions; ++n2) {
                stringBuffer.append(this.sindent(n) + this.d_exceptions[n2] + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private String sindent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }

    public static CodeViewer getViewer() {
        return new CodeViewer(){
            InstructionFactory d_if;

            public void setInstructionType(InstructionFactory instructionFactory) {
                this.d_if = instructionFactory;
            }

            public String view(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n, String string) {
                Object object;
                int n2;
                MutableCodeSegment mutableCodeSegment = this.d_if == null ? new MutableCodeSegment(constantPool, byArray, exceptionInfoArray, n) : new MutableCodeSegment(constantPool, byArray, exceptionInfoArray, n, this.d_if);
                StringBuffer stringBuffer = new StringBuffer();
                Vector vector = mutableCodeSegment.getInstructions();
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    BaseInstruction baseInstruction = (BaseInstruction)vector.elementAt(n2);
                    object = baseInstruction.getTag() != null ? baseInstruction.getTag() + ":" : "\t";
                    stringBuffer.append(n2 + ":" + (String)object + string + " " + baseInstruction + "\n");
                }
                n2 = mutableCodeSegment.getNumExceptions();
                stringBuffer.append(string + "Exception Table:\n");
                if (n2 == 0) {
                    stringBuffer.append(string + "  <none>\n");
                } else {
                    for (int i = 0; i < n2; ++i) {
                        object = mutableCodeSegment.getException(i);
                        stringBuffer.append(string + "start_tag = " + mutableCodeSegment.getTag(((CodeAttrInfo.ExceptionInfo)object).getStart()));
                        stringBuffer.append(", end_tag = " + mutableCodeSegment.getTag(((CodeAttrInfo.ExceptionInfo)object).getEnd()));
                        stringBuffer.append(", handler_tag = " + mutableCodeSegment.getTag(((CodeAttrInfo.ExceptionInfo)object).getHandler()));
                        stringBuffer.append(", catch_type = " + ((CodeAttrInfo.ExceptionInfo)object).getCatchType() + "\n");
                    }
                }
                return stringBuffer.toString();
            }
        };
    }

    public void createExceptionBlock(String string, String string2, String string3, String string4) {
        if (this.d_exceptions == null || this.d_numExceptions == this.d_exceptions.length) {
            this.resize();
        }
        int n = this.tagFor(string, true);
        int n2 = this.tagFor(string2, true);
        int n3 = this.tagFor(string3, true);
        this.d_exceptions[this.d_numExceptions] = new CodeAttrInfo.ExceptionInfo(this.d_cp, n, n2, n3, string4);
        ++this.d_numExceptions;
    }

    private void resize() {
        CodeAttrInfo.ExceptionInfo[] exceptionInfoArray = new CodeAttrInfo.ExceptionInfo[this.d_numExceptions + 10];
        if (this.d_exceptions != null) {
            System.arraycopy(this.d_exceptions, 0, exceptionInfoArray, 0, this.d_numExceptions);
        }
        this.d_exceptions = exceptionInfoArray;
    }
}

