/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import java.util.BitSet;

final class ByteInstruction
implements BaseInstruction {
    private int d_opCode;
    private byte[] d_code;
    private BitSet d_uses;
    private String d_tag;
    private ConstantPool d_cp;
    private TagFactory d_fac;
    private boolean marked = false;

    ByteInstruction(TagFactory tagFactory, ConstantPool constantPool, byte[] byArray, int n, int n2) {
        this.d_cp = constantPool;
        this.d_code = new byte[n2];
        System.arraycopy(byArray, n, this.d_code, 0, n2);
        this.d_opCode = byArray[n] & 0xFF;
        this.d_fac = tagFactory;
        this.d_tag = null;
    }

    ByteInstruction(TagFactory tagFactory, ConstantPool constantPool, String string) throws InstructionFormatException {
        throw new InstructionFormatException("Cannot create ByteInstruction from String...");
    }

    BitSet uses() {
        return this.setUses();
    }

    public void setTag(String string) {
        this.d_tag = string;
    }

    public BaseInstruction updateOffsets(int[] nArray, int n) {
        JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[this.d_opCode];
        if (jVMInstruction.d_operandTypes.equals("") || nArray == null) {
            return this;
        }
        if (jVMInstruction.d_operandTypes.charAt(0) != 'a') {
            return this;
        }
        int n2 = ByteArray.getSignedShortAtOffset(this.d_code, 1);
        int n3 = nArray[n2] - n;
        int n4 = this.getOpCode();
        if (n3 <= Short.MAX_VALUE && n3 >= Short.MIN_VALUE) {
            return this;
        }
        if (n4 != 167 && n4 != 168) {
            return null;
        }
        byte[] byArray = new byte[]{(byte)(n4 == 167 ? 200 : 201), (byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 >>> 0 & 0xFF)};
        ByteInstruction byteInstruction = new ByteInstruction(this.d_fac, this.d_cp, byArray, 0, 5);
        byteInstruction.setTag(this.d_tag);
        return byteInstruction;
    }

    public byte[] getCode(int[] nArray, int n) {
        byte[] byArray = null;
        JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[this.d_opCode];
        if (jVMInstruction.d_operandTypes.equals("") || nArray == null) {
            return this.d_code;
        }
        switch (jVMInstruction.d_operandTypes.charAt(0)) {
            case 's': {
                switch (this.d_opCode) {
                    case 171: {
                        int n2 = (4 - (n + 1) % 4) % 4;
                        int n3 = 0;
                        int n4 = 0;
                        byArray = new byte[n2 + this.d_code.length];
                        byArray[n3++] = (byte)this.d_opCode;
                        for (n4 = 0; n4 < n2; ++n4) {
                            byArray[n3++] = 0;
                        }
                        int n5 = ByteArray.getIntAtOffset(this.d_code, 1);
                        int n6 = nArray[n5] - n;
                        byArray[n3++] = (byte)(n6 >>> 24 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 16 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 8 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 0 & 0xFF);
                        for (n4 = 5; n4 < 9; ++n4) {
                            byArray[n3++] = this.d_code[n4];
                        }
                        int n7 = ByteArray.getIntAtOffset(this.d_code, 5);
                        int n8 = 9;
                        for (int i = 0; i < n7; ++i) {
                            for (n4 = 0; n4 < 4; ++n4) {
                                byArray[n3++] = this.d_code[n8 + n4];
                            }
                            n5 = ByteArray.getIntAtOffset(this.d_code, n8 += 4);
                            n6 = nArray[n5] - n;
                            byArray[n3++] = (byte)(n6 >>> 24 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 16 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 8 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 0 & 0xFF);
                            n8 += 4;
                        }
                        break;
                    }
                    case 170: {
                        int n9 = (4 - (n + 1) % 4) % 4;
                        int n10 = 0;
                        int n11 = 0;
                        byArray = new byte[n9 + this.d_code.length];
                        byArray[n10++] = (byte)this.d_opCode;
                        for (n11 = 0; n11 < n9; ++n11) {
                            byArray[n10++] = 0;
                        }
                        int n12 = ByteArray.getIntAtOffset(this.d_code, 1);
                        int n13 = nArray[n12] - n;
                        byArray[n10++] = (byte)(n13 >>> 24 & 0xFF);
                        byArray[n10++] = (byte)(n13 >>> 16 & 0xFF);
                        byArray[n10++] = (byte)(n13 >>> 8 & 0xFF);
                        byArray[n10++] = (byte)(n13 >>> 0 & 0xFF);
                        for (n11 = 5; n11 < 13; ++n11) {
                            byArray[n10++] = this.d_code[n11];
                        }
                        int n14 = ByteArray.getIntAtOffset(this.d_code, 5);
                        int n15 = ByteArray.getIntAtOffset(this.d_code, 9);
                        int n16 = 13;
                        for (int i = n14; i <= n15; ++i) {
                            n12 = ByteArray.getIntAtOffset(this.d_code, n16);
                            n13 = nArray[n12] - n;
                            byArray[n10++] = (byte)(n13 >>> 24 & 0xFF);
                            byArray[n10++] = (byte)(n13 >>> 16 & 0xFF);
                            byArray[n10++] = (byte)(n13 >>> 8 & 0xFF);
                            byArray[n10++] = (byte)(n13 >>> 0 & 0xFF);
                            n16 += 4;
                        }
                        break;
                    }
                    case 196: {
                        byArray = this.d_code;
                    }
                }
                break;
            }
            case 'a': {
                int n17 = ByteArray.getSignedShortAtOffset(this.d_code, 1);
                int n18 = nArray[n17] - n;
                byArray = new byte[this.d_code.length];
                byArray[0] = (byte)this.d_opCode;
                byArray[1] = (byte)(n18 >>> 8 & 0xFF);
                byArray[2] = (byte)(n18 >>> 0 & 0xFF);
                break;
            }
            case 'A': {
                int n19 = ByteArray.getIntAtOffset(this.d_code, 1);
                int n20 = nArray[n19] - n;
                byArray = new byte[this.d_code.length];
                byArray[0] = (byte)this.d_opCode;
                byArray[1] = (byte)(n20 >>> 24 & 0xFF);
                byArray[2] = (byte)(n20 >>> 16 & 0xFF);
                byArray[3] = (byte)(n20 >>> 8 & 0xFF);
                byArray[4] = (byte)(n20 >>> 0 & 0xFF);
                break;
            }
            default: {
                byArray = this.d_code;
            }
        }
        return byArray;
    }

    private BitSet setUses() {
        if (this.marked) {
            return this.d_uses;
        }
        this.marked = true;
        if (this.d_opCode != 170 && this.d_opCode != 171 && this.d_opCode != 196) {
            JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[this.d_opCode];
            String string = jVMInstruction.d_operandTypes;
            int n = jVMInstruction.d_operandTypes.length();
            block4: for (int i = 0; i < n; ++i) {
                switch (jVMInstruction.d_operandTypes.charAt(i)) {
                    case 'c': {
                        if (this.d_uses == null) {
                            this.d_uses = new BitSet(this.d_cp.length());
                        }
                        this.d_uses.set(ByteArray.getByteAtOffset(this.d_code, 1));
                        continue block4;
                    }
                    case 'C': {
                        if (this.d_uses == null) {
                            this.d_uses = new BitSet(this.d_cp.length());
                        }
                        this.d_uses.set(ByteArray.getShortAtOffset(this.d_code, 1));
                    }
                }
            }
        }
        return this.d_uses;
    }

    void sprintOperand(StringBuffer stringBuffer, int n, char c) {
        int n2 = 0;
        switch (c) {
            case 'c': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(this.d_cp.getAsJava(n2));
                break;
            }
            case 'C': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append(this.d_cp.getAsJava(n2));
                break;
            }
            case 'v': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case 'V': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case '0': 
            case 'u': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'i': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                if (n2 > 127) {
                    n2 -= 256;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'I': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                if (n2 > Short.MAX_VALUE) {
                    n2 -= 65536;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'l': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'a': {
                n2 = ByteArray.getSignedShortAtOffset(this.d_code, n);
                stringBuffer.append(this.d_fac.getTag(n2));
                break;
            }
            case 'A': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append(this.d_fac.getTag(n2));
                break;
            }
            case 't': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(JVMInstruction.arrayTypeCode2String(n2));
                break;
            }
            default: {
                stringBuffer.append("<unknown operand type: " + c + ">");
            }
        }
    }

    public int getLength(int n) {
        if (this.d_opCode != 170 && this.d_opCode != 171) {
            return this.d_code.length;
        }
        int n2 = (4 - (n + 1) % 4) % 4;
        return this.d_code.length + n2;
    }

    public String getTag() {
        return this.d_tag;
    }

    public int getOpCode() {
        return this.d_code[0] & 0xFF;
    }

    public String toBytes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.d_code.length; ++i) {
            int n = ByteArray.getByteAtOffset(this.d_code, i);
            if (n < 10) {
                stringBuffer.append("0x0" + Integer.toHexString(n) + " ");
                continue;
            }
            stringBuffer.append("0x" + Integer.toHexString(n) + " ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer;
        block4: {
            JVMInstruction jVMInstruction;
            block6: {
                block5: {
                    block3: {
                        char[] cArray = new char[]{'i', 'l', 'f', 'd', 'a'};
                        jVMInstruction = JVMInstruction.d_instrTable[this.d_opCode];
                        stringBuffer = new StringBuffer(jVMInstruction.name() + " ");
                        if (this.d_opCode != 170) break block3;
                        int n = 1;
                        this.sprintOperand(stringBuffer, n, 'A');
                        stringBuffer.append(" ");
                        int n2 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                        this.sprintOperand(stringBuffer, n, 'l');
                        stringBuffer.append("-");
                        int n3 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                        this.sprintOperand(stringBuffer, n, 'l');
                        n += 4;
                        stringBuffer.append(" ");
                        for (int i = n2; i <= n3; ++i) {
                            this.sprintOperand(stringBuffer, n, 'A');
                            n += 4;
                            stringBuffer.append(" ");
                        }
                        break block4;
                    }
                    if (this.d_opCode != 171) break block5;
                    int n = 1;
                    this.sprintOperand(stringBuffer, n, 'A');
                    stringBuffer.append(" ");
                    int n4 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                    this.sprintOperand(stringBuffer, n, 'l');
                    n += 4;
                    stringBuffer.append(" ");
                    for (int i = 0; i < n4; ++i) {
                        stringBuffer.append("(");
                        this.sprintOperand(stringBuffer, n, 'l');
                        stringBuffer.append(", ");
                        this.sprintOperand(stringBuffer, n += 4, 'A');
                        n += 4;
                        stringBuffer.append(") ");
                    }
                    break block4;
                }
                if (this.d_opCode != 196) break block6;
                int n = ByteArray.getByteAtOffset(this.d_code, 1);
                JVMInstruction jVMInstruction2 = JVMInstruction.d_instrTable[n];
                stringBuffer.append(jVMInstruction2.name() + " ");
                this.sprintOperand(stringBuffer, 2, 'V');
                stringBuffer.append(" ");
                if (n != 132) break block4;
                this.sprintOperand(stringBuffer, 4, 'I');
                break block4;
            }
            int n = 1;
            int n5 = jVMInstruction.d_operandTypes.length();
            for (int i = 0; i < n5; ++i) {
                this.sprintOperand(stringBuffer, n, jVMInstruction.d_operandTypes.charAt(i));
                n += JVMInstruction.argSkip(jVMInstruction.d_operandTypes.charAt(i));
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }
}

