/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.CodeViewer;
import com.ibm.toad.cfparse.instruction.ImmutableCodeSegment;
import com.ibm.toad.cfparse.instruction.InstructionFactory;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.MutableCodeSegment;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.cfparse.utils.CPUtils;
import com.ibm.toad.cfparse.utils.DataIOUtils;
import com.ibm.toad.utils.D;
import com.ibm.toad.utils.HexDump;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;

public final class CodeAttrInfo
extends AttrInfo {
    private int d_maxStack;
    private int d_maxLocals;
    private static CodeViewer d_viewer;
    private byte[] d_code;
    private int d_numExceptions;
    private ExceptionInfo[] d_exceptions;
    private AttrInfoList d_attrs;

    CodeAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
        this.d_len = 0;
        this.d_maxStack = 2;
        this.d_maxLocals = 2;
        this.d_numExceptions = 0;
        this.d_code = new byte[0];
        this.d_exceptions = null;
        this.d_attrs = new AttrInfoList(constantPool, this.d_depth + 1);
    }

    protected BitSet uses() {
        BitSet bitSet = super.uses();
        bitSet.or(this.codeUses());
        if (this.d_exceptions != null) {
            for (int i = 0; i < this.d_exceptions.length; ++i) {
                String string = this.d_exceptions[i].getCatchType();
                if (string.equals("all")) continue;
                int n = this.d_cp.find(7, CPUtils.dots2slashes(string));
                D.azzert(n != -1, "Couldn't find " + CPUtils.dots2slashes(string) + "+in ConstantPool");
                bitSet.set(n);
            }
        }
        bitSet.or(this.d_attrs.uses());
        return bitSet;
    }

    private BitSet codeUses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        ImmutableCodeSegment immutableCodeSegment = new ImmutableCodeSegment(this.d_code);
        block4: for (int i = 0; i < immutableCodeSegment.getNumInstructions(); ++i) {
            int n = immutableCodeSegment.getOffset(i);
            int n2 = this.d_code[n] & 0xFF;
            switch (n2) {
                case 18: {
                    bitSet.set(ByteArray.getByteAtOffset(this.d_code, 1 + n));
                    continue block4;
                }
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    bitSet.set(ByteArray.getShortAtOffset(this.d_code, 1 + n));
                }
            }
        }
        return bitSet;
    }

    protected void sort(int[] nArray) {
        super.sort(nArray);
        if (this.d_exceptions != null) {
            for (int i = 0; i < this.d_exceptions.length; ++i) {
                this.d_exceptions[i].sort(nArray);
            }
        }
        MutableCodeSegment mutableCodeSegment = new MutableCodeSegment(this.d_cp, this, false);
        mutableCodeSegment.setInstructionFactory(new RawByteInstructionFactory());
        Vector vector = mutableCodeSegment.getInstructions();
        block6: for (int i = 0; i < vector.size(); ++i) {
            BaseInstruction baseInstruction = (BaseInstruction)vector.get(i);
            byte[] byArray = baseInstruction.getCode(null, 0);
            int n = byArray[0] & 0xFF;
            switch (n) {
                case 18: {
                    byte[] byArray2;
                    int n2 = nArray[ByteArray.getByteAtOffset(byArray, 1)];
                    if (n2 > 255) {
                        byArray2 = new byte[]{19, (byte)(n2 >>> 8 & 0xFF), (byte)(n2 >>> 0 & 0xFF)};
                        byArray = byArray2;
                    } else {
                        byArray[1] = (byte)n2;
                    }
                    vector.set(i, new RawByteInstr(byArray, baseInstruction.getTag()));
                    continue block6;
                }
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    int n2 = nArray[ByteArray.getShortAtOffset(byArray, 1)];
                    byArray[1] = (byte)(n2 >>> 8 & 0xFF);
                    byArray[2] = (byte)(n2 >>> 0 & 0xFF);
                    vector.set(i, new RawByteInstr(byArray, baseInstruction.getTag()));
                    continue block6;
                }
                case 19: {
                    byte[] byArray2;
                    int n2 = nArray[ByteArray.getShortAtOffset(byArray, 1)];
                    if (n2 < 255) {
                        byArray2 = new byte[]{18, (byte)n2};
                        byArray = byArray2;
                    } else {
                        byArray[1] = (byte)(n2 >>> 8 & 0xFF);
                        byArray[2] = (byte)(n2 >>> 0 & 0xFF);
                    }
                    vector.set(i, new RawByteInstr(byArray, baseInstruction.getTag()));
                }
            }
        }
        this.setCode(mutableCodeSegment.getCode());
        if (this.d_exceptions != null) {
            this.d_exceptions = mutableCodeSegment.getExcTable();
        }
        this.d_attrs.sort(nArray);
    }

    private void resize() {
        ExceptionInfo[] exceptionInfoArray = new ExceptionInfo[this.d_numExceptions + 10];
        if (this.d_exceptions != null) {
            System.arraycopy(this.d_exceptions, 0, exceptionInfoArray, 0, this.d_numExceptions);
        }
        this.d_exceptions = exceptionInfoArray;
    }

    public static void setViewer(CodeViewer codeViewer) {
        d_viewer = codeViewer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + "\n" + this.sindent() + "// max_stack: " + this.d_maxStack + "\n" + this.sindent() + "// max_locals: " + this.d_maxLocals + "\n");
        if (d_viewer != null) {
            stringBuffer.append(d_viewer.view(this.d_cp, this.d_code, this.d_exceptions, this.d_numExceptions, this.sindent()));
        } else {
            stringBuffer.append(HexDump.toBytes(this.d_code));
            stringBuffer.append(this.sindent() + "Exception Table:\n");
            if (this.d_numExceptions == 0) {
                stringBuffer.append(this.sindent() + "  <none>\n");
            } else {
                for (int i = 0; i < this.d_numExceptions; ++i) {
                    stringBuffer.append(this.sindent() + this.d_exceptions[i] + "\n");
                }
            }
        }
        stringBuffer.append(this.d_attrs + "\n");
        return stringBuffer.toString();
    }

    public AttrInfoList getAttrs() {
        return this.d_attrs;
    }

    public void setAttrs(AttrInfoList attrInfoList) {
        this.d_attrs = attrInfoList;
    }

    public int getNumExceptions() {
        return this.d_numExceptions;
    }

    public ExceptionInfo getException(int n) {
        if (n < 0 || n > this.d_numExceptions) {
            return null;
        }
        return this.d_exceptions[n];
    }

    public void setException(ExceptionInfo exceptionInfo, int n) {
        if (n < 0 || n > this.d_numExceptions) {
            return;
        }
        this.d_exceptions[n] = exceptionInfo;
    }

    public ExceptionInfo[] getExceptions() {
        return this.d_exceptions;
    }

    public void setExceptions(ExceptionInfo[] exceptionInfoArray) {
        this.d_exceptions = exceptionInfoArray;
        this.d_numExceptions = exceptionInfoArray == null ? 0 : exceptionInfoArray.length;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = DataIOUtils.readUnsignedIntAsInt(dataInputStream);
        this.d_maxStack = dataInputStream.readUnsignedShort();
        this.d_maxLocals = dataInputStream.readUnsignedShort();
        int n = DataIOUtils.readUnsignedIntAsInt(dataInputStream);
        this.d_code = new byte[n];
        dataInputStream.readFully(this.d_code);
        this.d_numExceptions = dataInputStream.readUnsignedShort();
        this.d_exceptions = new ExceptionInfo[this.d_numExceptions];
        for (int i = 0; i < this.d_numExceptions; ++i) {
            this.d_exceptions[i] = new ExceptionInfo(this.d_cp);
            this.d_exceptions[i].read(dataInputStream);
        }
        this.d_attrs.read(dataInputStream);
        D.azzert(this.d_len == 8 + n + 2 + this.d_numExceptions * 8 + this.d_attrs.size(), "d_len != 2 + 2 + 4 + codeLen + 2 + d_numExceptions * 8 + d_attrs.size()\n" + this.d_len + " != 2 + 2 + 4 + " + n + " + 2 + " + this.d_numExceptions + " * 8 + " + this.d_attrs.size());
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeInt(8 + this.d_code.length + 2 + this.d_numExceptions * 8 + this.d_attrs.size());
        dataOutputStream.writeShort(this.d_maxStack);
        dataOutputStream.writeShort(this.d_maxLocals);
        dataOutputStream.writeInt(this.d_code.length);
        dataOutputStream.write(this.d_code, 0, this.d_code.length);
        dataOutputStream.writeShort(this.d_numExceptions);
        for (int i = 0; i < this.d_numExceptions; ++i) {
            this.d_exceptions[i].write(dataOutputStream);
        }
        this.d_attrs.write(dataOutputStream);
    }

    protected int size() {
        return 8 + this.d_code.length + 2 + this.d_numExceptions * 8 + this.d_attrs.size();
    }

    public int getMaxStack() {
        return this.d_maxStack;
    }

    public void setMaxStack(int n) {
        this.d_maxStack = n;
    }

    public int getMaxLocals() {
        return this.d_maxLocals;
    }

    public void setMaxLocals(int n) {
        this.d_maxLocals = n;
    }

    public void setCode(byte[] byArray) {
        D.azzert(this.d_code != null, "cannot set null code segment");
        this.d_code = byArray;
    }

    public byte[] getCode() {
        return this.d_code;
    }

    public void createExceptionBlock(int n, int n2, int n3, String string) {
        if (this.d_exceptions == null || this.d_numExceptions == this.d_exceptions.length) {
            this.resize();
        }
        this.d_exceptions[this.d_numExceptions] = new ExceptionInfo(this.d_cp, n, n2, n3, string);
        ++this.d_numExceptions;
    }

    public static class ExceptionInfo {
        private ConstantPool d_cp;
        private int d_startPC;
        private int d_endPC;
        private int d_handlerPC;
        private int d_catchType;

        ExceptionInfo(ConstantPool constantPool) {
            this.d_cp = constantPool;
        }

        public ExceptionInfo(ConstantPool constantPool, int n, int n2, int n3, int n4) {
            this.d_cp = constantPool;
            this.d_startPC = n;
            this.d_endPC = n2;
            this.d_handlerPC = n3;
            this.d_catchType = n4;
        }

        public ExceptionInfo(ConstantPool constantPool, int n, int n2, int n3, String string) {
            this.d_cp = constantPool;
            this.d_startPC = n;
            this.d_endPC = n2;
            this.d_handlerPC = n3;
            if (string.equals("all")) {
                this.d_catchType = 0;
            } else {
                this.d_catchType = this.d_cp.find(7, CPUtils.dots2slashes(string));
                if (this.d_catchType == -1) {
                    this.d_catchType = this.d_cp.addClass(CPUtils.dots2slashes(string));
                }
            }
        }

        protected void read(DataInputStream dataInputStream) throws IOException {
            this.d_startPC = dataInputStream.readUnsignedShort();
            this.d_endPC = dataInputStream.readUnsignedShort();
            this.d_handlerPC = dataInputStream.readUnsignedShort();
            this.d_catchType = dataInputStream.readUnsignedShort();
        }

        protected void sort(int[] nArray) {
            if (this.d_catchType != 0) {
                this.d_catchType = nArray[this.d_catchType];
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExceptionInfo)) {
                return false;
            }
            ExceptionInfo exceptionInfo = (ExceptionInfo)object;
            return exceptionInfo.getStart() == this.d_startPC && exceptionInfo.getEnd() == this.d_endPC && exceptionInfo.getCatchType().equals(this.getCatchType()) && exceptionInfo.getHandler() == this.d_handlerPC;
        }

        public int getStart() {
            return this.d_startPC;
        }

        public int getEnd() {
            return this.d_endPC;
        }

        public int getHandler() {
            return this.d_handlerPC;
        }

        public void setStart(int n) {
            this.d_startPC = n;
        }

        public void setEnd(int n) {
            this.d_endPC = n;
        }

        public void setHandler(int n) {
            this.d_handlerPC = n;
        }

        public String getCatchType() {
            return this.d_catchType == 0 ? "all" : this.d_cp.getAsJava(this.d_catchType);
        }

        public int getCatch() {
            return this.d_catchType;
        }

        public void setCatchType(String string) {
            if (string.equals("all")) {
                this.d_catchType = 0;
            } else {
                this.d_catchType = this.d_cp.find(7, CPUtils.dots2slashes(string));
                if (this.d_catchType == -1) {
                    this.d_catchType = this.d_cp.addClass(CPUtils.dots2slashes(string));
                }
            }
        }

        protected void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.d_startPC);
            dataOutputStream.writeShort(this.d_endPC);
            dataOutputStream.writeShort(this.d_handlerPC);
            dataOutputStream.writeShort(this.d_catchType);
        }

        public String toString() {
            return "(" + this.d_startPC + "," + this.d_endPC + ") ->" + this.d_handlerPC + " on " + (this.d_catchType == 0 ? "all" : this.d_cp.getAsJava(this.d_catchType));
        }
    }

    class RawByteInstructionFactory
    implements InstructionFactory {
        RawByteInstructionFactory() {
        }

        public BaseInstruction create(TagFactory tagFactory, ConstantPool constantPool, byte[] byArray, int n, int n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return new RawByteInstr(byArray2, null);
        }

        public BaseInstruction create(TagFactory tagFactory, ConstantPool constantPool, String string) throws InstructionFormatException {
            throw new InstructionFormatException("Cannot create RawByteInstr from String..");
        }
    }

    class RawByteInstr
    implements BaseInstruction {
        byte[] d_code;
        String d_tag;

        RawByteInstr(byte[] byArray, String string) {
            this.d_code = byArray;
            this.d_tag = string;
        }

        public String getTag() {
            return this.d_tag;
        }

        public int getLength(int n) {
            return this.d_code.length;
        }

        public int getOpCode() {
            return this.d_code[0] & 0xFF;
        }

        public BaseInstruction updateOffsets(int[] nArray, int n) {
            return this;
        }

        public byte[] getCode(int[] nArray, int n) {
            return this.d_code;
        }

        public void setTag(String string) {
            this.d_tag = string;
        }
    }
}

