/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ClassFile;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.instruction.CodeViewer;
import com.ibm.toad.cfparse.instruction.ImmutableCodeSegment;
import com.ibm.toad.cfparse.instruction.MipsInstructionFactory;
import com.ibm.toad.cfparse.instruction.MutableCodeSegment;
import com.ibm.toad.cfparse.instruction.StringInstructionFactory;
import com.ibm.toad.cfparse.utils.Access;
import com.ibm.toad.cfparse.utils.CFUtils;

public class Main {
    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            Main.exitUsage();
        }
        boolean bl = false;
        boolean bl2 = false;
        ClassFile classFile = null;
        CodeViewer codeViewer = MutableCodeSegment.getViewer();
        codeViewer.setInstructionType(new StringInstructionFactory());
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string = stringArray[n].substring(1);
            if (string.equals("help") || string.equals("h") || string.equals("?")) {
                Main.exitUsage();
            }
            if (string.equals("c")) {
                bl = true;
                continue;
            }
            if (string.equals("nocp")) {
                bl2 = true;
                continue;
            }
            if (string.equals("v")) {
                if (++n == stringArray.length) {
                    Main.exitUsage();
                }
                if (stringArray[n].equals("raw")) {
                    codeViewer = null;
                    continue;
                }
                if (stringArray[n].equals("immut")) {
                    codeViewer = ImmutableCodeSegment.getViewer();
                    continue;
                }
                if (stringArray[n].equals("pi")) {
                    codeViewer = MutableCodeSegment.getViewer();
                    continue;
                }
                System.err.println("Unknown viewer");
                System.err.println("try cfparse -help for more details");
                System.exit(0);
                continue;
            }
            if (string.equals("i")) {
                if (++n == stringArray.length) {
                    Main.exitUsage();
                }
                if (stringArray[n].equals("plain")) {
                    if (codeViewer == null) continue;
                    codeViewer.setInstructionType(new StringInstructionFactory());
                    continue;
                }
                if (stringArray[n].equals("mips")) {
                    if (codeViewer == null) continue;
                    codeViewer.setInstructionType(new MipsInstructionFactory());
                    continue;
                }
                System.err.println("Unknown instruction type");
                System.err.println("try cfparse -help for more details");
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option -" + string);
            System.err.println("try cfparse -help for more details");
            System.exit(0);
        }
        if (n == stringArray.length) {
            System.err.println("Unspecified ClassFile");
            System.err.println("try cfparse -help for more details");
            System.exit(0);
        }
        CodeAttrInfo.setViewer(codeViewer);
        if (bl) {
            classFile = (ClassFile)CFUtils.forName(stringArray[n], 3, true);
        } else {
            try {
                classFile = new ClassFile(stringArray[n]);
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception);
                exception.printStackTrace();
                System.exit(0);
            }
        }
        if (!bl2) {
            System.out.println(classFile);
        } else {
            System.out.println("Magic: 0x" + Integer.toHexString(classFile.getMagic()) + "\n" + "Compiler Version: " + classFile.getMajor() + "." + classFile.getMinor());
            System.out.println("Class: \n" + Access.getClassAsString(classFile.getAccess()) + classFile.getName() + (classFile.getSuperName() == null ? "" : " extends " + classFile.getSuperName()));
            System.out.println(classFile.getInterfaces() + "\n" + classFile.getFields() + "\n" + classFile.getMethods() + "\n" + classFile.getAttrs());
        }
    }

    public static void exitUsage() {
        System.out.println("CFParse - command-line ClassFile viewer.\nUsage: java com.ibm.toad.cfparse.Main [-help] [-v raw/immut/pi] [-i plain/mips] [-nocp] [-c] classfile\n-help\t\t: prints this message\n-c\t\t: denotes that the classFile is the name of the class rather \n\t\t\tthan its absolute location\n-nocp \t\t: supresses priting the ConstantPool\n-v \t \t: sets the CodeViewer...\n\traw \t: bytes only.\n\timmut \t: jumps as relative offsets.\n\tpi \t: jumps as position independent tags.\n-i \t \t: sets the instruction type...\n\tplain \t: java bytecode.\n\tmips \t: mips pseudocode.\n");
        System.out.println("defaults are: classFile is absolute, ConstantPool is printed, -v pi, -i plain");
        System.exit(0);
    }
}

