/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.utils.CPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class InterfaceList {
    private ConstantPool d_cp;
    private int d_numInterfaces;
    private int[] d_interfaces;

    InterfaceList(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_numInterfaces = 0;
        this.d_interfaces = null;
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        for (int i = 0; i < this.d_numInterfaces; ++i) {
            bitSet.set(this.d_interfaces[i]);
        }
        return bitSet;
    }

    public void sort(int[] nArray) {
        for (int i = 0; i < this.d_numInterfaces; ++i) {
            this.d_interfaces[i] = nArray[this.d_interfaces[i]];
        }
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_numInterfaces = dataInputStream.readUnsignedShort();
        this.d_interfaces = new int[this.d_numInterfaces];
        for (int i = 0; i < this.d_numInterfaces; ++i) {
            this.d_interfaces[i] = dataInputStream.readShort();
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numInterfaces);
        for (int i = 0; i < this.d_numInterfaces; ++i) {
            dataOutputStream.writeShort(this.d_interfaces[i]);
        }
    }

    private void resize() {
        int[] nArray = new int[this.d_numInterfaces + 10];
        if (this.d_interfaces != null) {
            System.arraycopy(this.d_interfaces, 0, nArray, 0, this.d_numInterfaces);
        }
        this.d_interfaces = nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.d_numInterfaces > 0) {
            stringBuffer.append("implements ");
            for (int i = 0; i < this.d_numInterfaces; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.d_cp.getAsJava(this.d_interfaces[i]));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.d_numInterfaces;
    }

    public String getInterfaceName(int n) {
        if (n < 0 || n > this.d_numInterfaces) {
            return null;
        }
        return this.d_cp.getAsJava(this.d_interfaces[n]);
    }

    public String get(int n) {
        if (n < 0 || n > this.d_numInterfaces) {
            return null;
        }
        return this.d_cp.getAsJava(this.d_interfaces[n]);
    }

    public void remove(int n) {
        if (n < 0 || n > this.d_numInterfaces - 1) {
            return;
        }
        for (int i = n; i < this.d_numInterfaces - 1; ++i) {
            this.d_interfaces[i] = this.d_interfaces[i + 1];
        }
        --this.d_numInterfaces;
    }

    public void add(String string) {
        int n;
        if (this.d_interfaces == null || this.d_numInterfaces + 1 >= this.d_interfaces.length) {
            this.resize();
        }
        if ((n = this.d_cp.find(7, string = CPUtils.dots2slashes(string))) == -1) {
            n = this.d_cp.addClass(string);
        }
        this.d_interfaces[this.d_numInterfaces++] = n;
    }

    public void set(int n, String string) {
        if (n < 0 || n > this.d_numInterfaces - 1) {
            return;
        }
        int n2 = this.d_cp.find(7, string = CPUtils.dots2slashes(string));
        if (n2 == -1) {
            n2 = this.d_cp.addClass(string);
        }
        this.d_interfaces[n] = n2;
    }
}

