/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASHandler;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASILogger;
import com.ibm.ras.RASIMessageLogger;
import com.ibm.ras.RASIOException;
import com.ibm.ras.RASITraceLogger;
import com.ibm.ras.RASObject;
import com.ibm.ras.RASUtil;
import com.ibm.ras.mgr.RASBaseGroup;
import com.ibm.ras.mgr.RASConfig;
import com.ibm.ras.mgr.RASGroup;
import com.ibm.ras.mgr.RASIDataStore;
import com.ibm.ras.mgr.RASIManager;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class RASManager
implements RASConstants,
RASIManager {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    protected static final Object dsLock = new Object();
    protected static final Object getMgrLock = new Object();
    protected static final Object getObjLock = new Object();
    private RASIDataStore dataStore = null;
    private RASBaseGroup baseGroup = null;
    private static RASManager mgr = null;

    public static RASManager getManager() {
        RASManager.getManager(null);
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RASManager getManager(RASIDataStore rASIDataStore) {
        Object object = getMgrLock;
        synchronized (object) {
            if (mgr == null) {
                mgr = new RASManager(rASIDataStore);
            }
        }
        return mgr;
    }

    protected RASManager(RASIDataStore rASIDataStore) {
        this.addDataStore(rASIDataStore);
        try {
            this.restoreConfig();
        }
        catch (RASIOException rASIOException) {
            rASIOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataStore(RASIDataStore rASIDataStore) {
        Object object = dsLock;
        synchronized (object) {
            if (rASIDataStore != null) {
                this.dataStore = rASIDataStore;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataStore(RASIDataStore rASIDataStore) {
        Object object = dsLock;
        synchronized (object) {
            if (rASIDataStore != null && this.dataStore.equals(rASIDataStore)) {
                this.dataStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getDataStores() {
        Vector<RASIDataStore> vector = new Vector<RASIDataStore>(1);
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                vector.addElement(this.dataStore);
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreConfig() throws RASIOException {
        RASBaseGroup rASBaseGroup = null;
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                rASBaseGroup = this.dataStore.restoreConfig();
            }
        }
        object = getObjLock;
        synchronized (object) {
            if (rASBaseGroup != null) {
                RASBaseGroup rASBaseGroup2 = this.baseGroup;
                this.baseGroup = rASBaseGroup;
                this.baseGroup.updateActiveObjects(rASBaseGroup2, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws RASIOException {
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                this.dataStore.saveConfig(this.baseGroup);
            }
        }
    }

    public RASIMessageLogger getMessageLogger(String string) {
        return this.getMessageLogger(string, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIMessageLogger getMessageLogger(String string, String string2) {
        RASIMessageLogger rASIMessageLogger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup rASGroup = this.baseGroup.getGroup(string2);
            if (rASGroup != null) {
                rASIMessageLogger = this.getMessageLogger(string, rASGroup);
            }
        }
        return rASIMessageLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIMessageLogger getMessageLogger(String string, RASGroup rASGroup) {
        RASIMessageLogger rASIMessageLogger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig rASConfig = rASGroup.getMessageLoggerConfig(string);
            if (rASConfig != null) {
                rASIMessageLogger = (RASIMessageLogger)((Object)this.getObject(rASConfig));
                this.addHandlers(rASIMessageLogger, rASConfig, rASGroup);
            }
        }
        return rASIMessageLogger;
    }

    public void returnMessageLogger(RASIMessageLogger rASIMessageLogger) {
        String string = rASIMessageLogger.getGroup();
        if (string.equals("")) {
            this.returnMessageLogger(rASIMessageLogger, this.baseGroup);
        } else {
            this.returnMessageLogger(rASIMessageLogger, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessageLogger(RASIMessageLogger rASIMessageLogger, String string) {
        if (string != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup rASGroup = this.baseGroup.getGroup(string);
                if (rASGroup != null) {
                    this.returnMessageLogger(rASIMessageLogger, rASGroup);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessageLogger(RASIMessageLogger rASIMessageLogger, RASGroup rASGroup) {
        if (rASIMessageLogger != null && rASGroup != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASConfig rASConfig = rASGroup.getMessageLoggerConfig(rASIMessageLogger.getName());
                if (rASConfig != null && rASConfig.decrementInUseCount() == 0) {
                    this.removeHandlers(rASIMessageLogger, rASGroup);
                    rASConfig.setObject(null);
                    rASIMessageLogger = null;
                }
            }
        }
    }

    public RASITraceLogger getTraceLogger(String string) {
        return this.getTraceLogger(string, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASITraceLogger getTraceLogger(String string, String string2) {
        RASITraceLogger rASITraceLogger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup rASGroup = this.baseGroup.getGroup(string2);
            if (rASGroup != null) {
                rASITraceLogger = this.getTraceLogger(string, rASGroup);
            }
        }
        return rASITraceLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASITraceLogger getTraceLogger(String string, RASGroup rASGroup) {
        RASITraceLogger rASITraceLogger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig rASConfig = rASGroup.getTraceLoggerConfig(string);
            if (rASConfig != null) {
                rASITraceLogger = (RASITraceLogger)((Object)this.getObject(rASConfig));
                this.addHandlers(rASITraceLogger, rASConfig, rASGroup);
            }
        }
        return rASITraceLogger;
    }

    public void returnTraceLogger(RASITraceLogger rASITraceLogger) {
        String string = rASITraceLogger.getGroup();
        if (string.equals("")) {
            this.returnTraceLogger(rASITraceLogger, this.baseGroup);
        } else {
            this.returnTraceLogger(rASITraceLogger, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTraceLogger(RASITraceLogger rASITraceLogger, String string) {
        if (string != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup rASGroup = this.baseGroup.getGroup(string);
                if (rASGroup != null) {
                    this.returnTraceLogger(rASITraceLogger, rASGroup);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTraceLogger(RASITraceLogger rASITraceLogger, RASGroup rASGroup) {
        if (rASITraceLogger != null && rASGroup != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASConfig rASConfig = rASGroup.getTraceLoggerConfig(rASITraceLogger.getName());
                if (rASConfig != null && rASConfig.decrementInUseCount() == 0) {
                    this.removeHandlers(rASITraceLogger, rASGroup);
                    rASConfig.setObject(null);
                    rASITraceLogger = null;
                }
            }
        }
    }

    public RASIHandler getHandler(String string) {
        return this.getHandler(string, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIHandler getHandler(String string, String string2) {
        RASIHandler rASIHandler = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup rASGroup = this.baseGroup.getGroup(string2);
            if (rASGroup != null) {
                rASIHandler = this.getHandler(string, rASGroup);
            }
        }
        return rASIHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIHandler getHandler(String string, RASGroup rASGroup) {
        RASIHandler rASIHandler = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig rASConfig = rASGroup.getHandlerConfig(string);
            if (rASConfig != null) {
                rASIHandler = (RASIHandler)((Object)this.getObject(rASConfig));
                this.addFormatters(rASIHandler, rASConfig, rASGroup);
            }
        }
        return rASIHandler;
    }

    public void returnHandler(RASIHandler rASIHandler) {
        String string = rASIHandler.getGroup();
        if (string.equals("")) {
            this.returnHandler(rASIHandler, this.baseGroup);
        } else {
            this.returnHandler(rASIHandler, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnHandler(RASIHandler rASIHandler, String string) {
        if (string != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup rASGroup = this.baseGroup.getGroup(string);
                if (rASGroup != null) {
                    this.returnHandler(rASIHandler, rASGroup);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnHandler(RASIHandler rASIHandler, RASGroup rASGroup) {
        if (rASIHandler != null && rASGroup != null) {
            String string = rASIHandler.getName();
            Object object = getObjLock;
            synchronized (object) {
                RASConfig rASConfig = rASGroup.getHandlerConfig(string);
                if (rASConfig == null) {
                    rASConfig = this.baseGroup.getHandlerConfig(string);
                }
                if (rASConfig != null && rASConfig.decrementInUseCount() == 0) {
                    rASIHandler.stop();
                    this.removeFormatters(rASIHandler, rASGroup);
                    rASConfig.setObject(null);
                    rASIHandler = null;
                }
            }
        }
    }

    public RASIFormatter getFormatter(String string) {
        return this.getFormatter(string, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIFormatter getFormatter(String string, String string2) {
        RASIFormatter rASIFormatter = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup rASGroup = this.baseGroup.getGroup(string2);
            if (rASGroup != null) {
                rASIFormatter = this.getFormatter(string, rASGroup);
            }
        }
        return rASIFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIFormatter getFormatter(String string, RASGroup rASGroup) {
        RASIFormatter rASIFormatter = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig rASConfig = rASGroup.getFormatterConfig(string);
            if (rASConfig != null) {
                rASIFormatter = (RASIFormatter)((Object)this.getObject(rASConfig));
            }
        }
        return rASIFormatter;
    }

    public void returnFormatter(RASIFormatter rASIFormatter) {
        String string = rASIFormatter.getGroup();
        if (string.equals("")) {
            this.returnFormatter(rASIFormatter, this.baseGroup);
        } else {
            this.returnFormatter(rASIFormatter, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnFormatter(RASIFormatter rASIFormatter, String string) {
        if (string != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup rASGroup = this.baseGroup.getGroup(string);
                if (rASGroup != null) {
                    this.returnFormatter(rASIFormatter, rASGroup);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnFormatter(RASIFormatter rASIFormatter, RASGroup rASGroup) {
        if (rASIFormatter != null && rASGroup != null) {
            String string = rASIFormatter.getName();
            Object object = getObjLock;
            synchronized (object) {
                RASConfig rASConfig = rASGroup.getFormatterConfig(string);
                if (rASConfig == null) {
                    rASConfig = this.baseGroup.getFormatterConfig(string);
                }
                if (rASConfig != null && rASConfig.decrementInUseCount() == 0) {
                    rASConfig.setObject(null);
                    rASIFormatter = null;
                }
            }
        }
    }

    public RASBaseGroup getBaseGroup() {
        return this.baseGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseGroup(RASBaseGroup rASBaseGroup) {
        Object object = dsLock;
        synchronized (object) {
            this.baseGroup = rASBaseGroup;
        }
    }

    protected RASObject getObject(RASConfig rASConfig) {
        Object var2_2 = null;
        RASObject rASObject = null;
        if (rASConfig != null) {
            rASObject = rASConfig.getObject();
            if (rASObject == null && (rASObject = (RASObject)RASUtil.createObject((String)rASConfig.get("className"))) != null) {
                rASObject.setConfig(rASConfig);
                rASConfig.setObject(rASObject);
            }
            if (rASObject != null) {
                rASConfig.incrementInUseCount();
            }
        }
        return rASObject;
    }

    protected void addHandlers(RASILogger rASILogger, RASConfig rASConfig, RASGroup rASGroup) {
        if (rASILogger != null) {
            StringTokenizer stringTokenizer;
            String string = (String)rASConfig.get("handlerNames");
            if ((string == null || string.equals("")) && (string = rASILogger instanceof RASIMessageLogger ? this.baseGroup.getDefaultMessageHandlers() : this.baseGroup.getDefaultTraceHandlers()) == null) {
                string = this.baseGroup.getDefaultHandlers();
            }
            Vector vector = new Vector();
            Object object = rASILogger.getHandlers();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            if (string != null) {
                stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    object = this.getHandler(string2, rASGroup);
                    if (object == null) {
                        object = this.getHandler(string2, this.baseGroup);
                    }
                    if (object == null) continue;
                    if (vector.contains(object)) {
                        this.returnHandler((RASIHandler)object);
                        vector.removeElement(object);
                        continue;
                    }
                    rASILogger.addHandler((RASIHandler)object);
                }
            }
            stringTokenizer = vector.elements();
            while (stringTokenizer.hasMoreElements()) {
                object = (RASHandler)stringTokenizer.nextElement();
                rASILogger.removeHandler((RASIHandler)object);
                this.returnHandler((RASIHandler)object);
            }
        }
    }

    protected void removeHandlers(RASILogger rASILogger, RASGroup rASGroup) {
        Enumeration enumeration = rASILogger.getHandlers();
        while (enumeration.hasMoreElements()) {
            RASIHandler rASIHandler = (RASIHandler)enumeration.nextElement();
            this.returnHandler(rASIHandler, rASGroup);
        }
    }

    protected void addFormatters(RASIHandler rASIHandler, RASConfig rASConfig, RASGroup rASGroup) {
        String string;
        if (rASIHandler != null && (string = (String)rASConfig.get("formatterNames")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                RASIFormatter rASIFormatter = this.getFormatter(string2, rASGroup);
                if (rASIFormatter == null) {
                    rASIFormatter = this.getFormatter(string2, this.baseGroup);
                }
                if (rASIFormatter == null) continue;
                rASIHandler.addFormatter(rASIFormatter);
            }
        }
    }

    protected void removeFormatters(RASIHandler rASIHandler, RASGroup rASGroup) {
        Enumeration enumeration = rASIHandler.getFormatters();
        while (enumeration.hasMoreElements()) {
            RASIFormatter rASIFormatter = (RASIFormatter)enumeration.nextElement();
            if (rASIFormatter.isDefault()) continue;
            this.returnFormatter(rASIFormatter, rASGroup);
        }
    }

    protected void finalize() throws Throwable {
        Enumeration enumeration = this.baseGroup.getHandlerConfigs().elements();
        this.stopHandlers(enumeration, this.baseGroup);
        enumeration = this.baseGroup.getGroups().elements();
        while (enumeration.hasMoreElements()) {
            RASGroup rASGroup = (RASGroup)enumeration.nextElement();
            Enumeration enumeration2 = rASGroup.getHandlerConfigs().elements();
            this.stopHandlers(enumeration2, rASGroup);
        }
        super.finalize();
    }

    private void stopHandlers(Enumeration enumeration, RASGroup rASGroup) {
        while (enumeration.hasMoreElements()) {
            RASConfig rASConfig = (RASConfig)enumeration.nextElement();
            RASHandler rASHandler = (RASHandler)rASConfig.getObject();
            if (rASHandler == null) continue;
            this.returnHandler((RASIHandler)rASHandler, rASGroup);
        }
    }
}

