/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASCircularQueue;
import com.ibm.ras.RASConstants;
import com.ibm.ras.RASEvent;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASIQueue;
import com.ibm.ras.RASMaskChangeGenerator;
import com.ibm.ras.RASMessageFormatter;
import com.ibm.ras.RASQueue;
import com.ibm.ras.RASQueueEmptyException;
import com.ibm.ras.RASQueueFullException;
import com.ibm.ras.RASTraceFormatter;
import com.ibm.ras.RASUtil;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class RASHandler
extends RASMaskChangeGenerator
implements RASConstants,
RASIHandler,
Runnable {
    private static final String S = "(C) Copyright IBM Corp. 1998. (C) Copyright Tivoli Systems 1999.";
    public static final int DEFAULT_QUEUE_SIZE = 10000;
    public static final int DEFAULT_RETRY_INTERVAL = 5000;
    public transient boolean deviceOpen = false;
    private transient boolean done = false;
    private transient boolean stopRequested = false;
    protected Hashtable formatters;
    protected transient int deviceFailures = 0;
    private transient int discardedEventCount = 0;
    protected int retryInterval;
    protected transient Object deviceLock = new Object();
    protected transient Object queueLock = new Object();
    protected transient Object queueEmptyLock = new Object();
    protected transient Object queueFullLock = new Object();
    protected transient PrintWriter pWriter = null;
    private transient RASIQueue inQueue;
    private transient RASIQueue outQueue;
    private String formatterNames;
    protected transient Thread myThread;

    public RASHandler() {
        this(null, null);
    }

    public RASHandler(String string) {
        this(string, null);
    }

    public RASHandler(String string, String string2) {
        super(string, string2);
        String string3 = this.getClass().getName() + ":" + this.getName();
        this.myThread = new Thread((Runnable)this, string3);
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    protected void init() {
        super.init();
        this.formatterNames = "";
        this.outQueue = this.inQueue = new RASQueue(10000);
        this.setRetryInterval(5000);
        this.addMessageEventClass("com.ibm.ras.RASMessageEvent");
        this.addTraceEventClass("com.ibm.ras.RASTraceEvent");
        this.formatters = new Hashtable();
        RASMessageFormatter rASMessageFormatter = new RASMessageFormatter();
        rASMessageFormatter.setDefault(true);
        this.addFormatter(rASMessageFormatter);
        RASTraceFormatter rASTraceFormatter = new RASTraceFormatter();
        rASTraceFormatter.setDefault(true);
        this.addFormatter(rASTraceFormatter);
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("maxQueueSize", new Integer(this.getMaximumQueueSize()).toString());
        hashtable.put("isCircular", new Boolean(this.isCircular()).toString());
        hashtable.put("retryInterval", new Integer(this.getRetryInterval()).toString());
        hashtable.put("formatterNames", this.formatterNames);
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("maxQueueSize")) {
            this.setMaximumQueueSize(new Integer((String)hashtable.get("maxQueueSize")));
        }
        if (hashtable.containsKey("isCircular")) {
            this.setCircular(new Boolean((String)hashtable.get("isCircular")));
        }
        if (hashtable.containsKey("retryInterval")) {
            this.setRetryInterval(new Integer((String)hashtable.get("retryInterval")));
        }
        if (hashtable.containsKey("formatterNames")) {
            this.formatterNames = (String)hashtable.get("formatterNames");
        }
    }

    public int getMaximumQueueSize() {
        return this.inQueue.getMaximumQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumQueueSize(int n) throws IllegalStateException {
        if (n >= 0) {
            Object object = this.queueEmptyLock;
            synchronized (object) {
                Object object2 = this.queueFullLock;
                synchronized (object2) {
                    if (this.inQueue.getQueueSize() != 0 || this.outQueue.getQueueSize() != 0) {
                        throw new IllegalStateException(RASUtil.rasMsgs.getMessage("ERR_QUEUE_STATE"));
                    }
                    this.newQueue(n, this.inQueue.isCircular());
                }
            }
        }
    }

    public boolean isCircular() {
        return this.inQueue.isCircular();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCircular(boolean bl) throws IllegalStateException {
        Object object = this.queueEmptyLock;
        synchronized (object) {
            Object object2 = this.queueFullLock;
            synchronized (object2) {
                if (this.inQueue.isCircular() != bl) {
                    if (this.inQueue.getQueueSize() != 0 || this.outQueue.getQueueSize() != 0) {
                        throw new IllegalStateException(RASUtil.rasMsgs.getMessage("ERR_QUEUE_STATE"));
                    }
                    this.newQueue(this.getMaximumQueueSize(), bl);
                }
            }
        }
    }

    protected void newQueue(int n, boolean bl) {
        if (bl) {
            this.inQueue = new RASCircularQueue(n);
            this.outQueue = new RASQueue(0);
        } else {
            this.outQueue = this.inQueue = new RASQueue(n);
        }
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int n) {
        if (n >= 0) {
            this.retryInterval = n;
        }
    }

    public int getQueueSize() {
        int n = this.isCircular() ? this.inQueue.getQueueSize() + this.outQueue.getQueueSize() : this.inQueue.getQueueSize();
        return n;
    }

    public void addFormatter(RASIFormatter rASIFormatter) {
        if (rASIFormatter != null) {
            Enumeration enumeration = rASIFormatter.getEventClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.formatters.put(string, rASIFormatter);
            }
        }
    }

    public void removeFormatter(RASIFormatter rASIFormatter) {
        if (rASIFormatter != null) {
            Enumeration enumeration = rASIFormatter.getEventClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.formatters.remove(string);
            }
        }
    }

    public Enumeration getFormatters() {
        return this.formatters.elements();
    }

    public abstract void openDevice();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.pWriter != null) {
                this.pWriter.close();
            }
            this.pWriter = null;
            this.deviceOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        while (!this.done) {
            RASEvent rASEvent;
            Object object = this.queueEmptyLock;
            synchronized (object) {
                try {
                    rASEvent = (RASEvent)this.outQueue.dequeue();
                }
                catch (RASQueueEmptyException rASQueueEmptyException) {
                    rASEvent = null;
                    if (this.stopRequested) {
                        this.done = true;
                    }
                    try {
                        this.queueEmptyLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (rASEvent == null) continue;
            object = this.queueFullLock;
            synchronized (object) {
                this.queueFullLock.notifyAll();
            }
            this.writeEvent(rASEvent);
            if (this.deviceOpen) {
                n = 0;
            } else if (!this.stopRequested) {
                if (n++ < 5) {
                    this.outQueue.requeue(rASEvent);
                }
                try {
                    int n2 = this.getRetryInterval();
                    if (n2 != 0) {
                        Thread.sleep(n2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.discardedEventCount == 0 || this.inQueue.isFull()) continue;
            if (this.discardedEventCount == 1) {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_QUEUE_OK_1", this.getName()));
            } else {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_QUEUE_OK_2", this.getName(), new Integer(this.discardedEventCount)));
            }
            this.discardedEventCount = 0;
        }
        Object object = this.queueEmptyLock;
        synchronized (object) {
            this.queueEmptyLock.notify();
        }
        this.closeDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.dumpQueue();
        Object object = this.queueEmptyLock;
        synchronized (object) {
            this.stopRequested = true;
            this.queueEmptyLock.notify();
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            while (!this.done) {
                try {
                    this.queueEmptyLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(RASIEvent rASIEvent) {
        if (rASIEvent != null && !this.stopRequested) {
            boolean bl = false;
            while (!bl) {
                try {
                    Object object = this.queueEmptyLock;
                    synchronized (object) {
                        this.inQueue.enqueue(rASIEvent);
                        bl = true;
                        if (!this.inQueue.isCircular()) {
                            this.queueEmptyLock.notify();
                        }
                    }
                }
                catch (RASQueueFullException rASQueueFullException) {
                    if (!Thread.currentThread().equals(this.myThread)) {
                        Object object = this.queueFullLock;
                        synchronized (object) {
                            this.myThread.interrupt();
                            try {
                                this.queueFullLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (this.discardedEventCount == 0) {
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_QUEUE_FULL", this.getName()));
                    }
                    ++this.discardedEventCount;
                    bl = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEvent(RASIEvent rASIEvent) {
        Object object = this.deviceLock;
        synchronized (object) {
            RASIFormatter rASIFormatter;
            if (!this.deviceOpen) {
                this.openDevice();
            }
            if (this.deviceOpen && (rASIFormatter = this.findFormatter(rASIEvent)) != null) {
                String string = rASIFormatter.format(rASIEvent);
                this.pWriter.println(string);
                if (this.pWriter.checkError()) {
                    this.closeDevice();
                    if (++this.deviceFailures <= 2) {
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_WRITE_MSG", this.getName()));
                    }
                } else if (this.deviceFailures != 0) {
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("RETRY_OK", this.getName()));
                    this.deviceFailures = 0;
                }
            }
        }
    }

    protected RASIFormatter findFormatter(RASIEvent rASIEvent) {
        boolean bl = false;
        Class<?> clazz = rASIEvent.getClass();
        RASIFormatter rASIFormatter = null;
        while (!bl && clazz != null) {
            String string = clazz.getName();
            if (this.formatters.containsKey(string)) {
                bl = true;
                rASIFormatter = (RASIFormatter)this.formatters.get(string);
                continue;
            }
            clazz = clazz.getSuperclass();
        }
        return rASIFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpQueue() {
        if (this.isCircular()) {
            boolean bl = false;
            Object object = this.queueEmptyLock;
            synchronized (object) {
                Object object2 = this.queueFullLock;
                synchronized (object2) {
                    while (!bl) {
                        try {
                            Object object3 = this.inQueue.dequeue();
                            this.outQueue.enqueue(object3);
                        }
                        catch (RASQueueEmptyException rASQueueEmptyException) {
                            bl = true;
                        }
                        catch (RASQueueFullException rASQueueFullException) {}
                    }
                    this.queueFullLock.notifyAll();
                }
                this.queueEmptyLock.notifyAll();
            }
        }
    }
}

