/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectResolver;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.oa.AdapterAlreadyExistsException;
import com.ibm.ejs.oa.EJSOAImpl;
import com.ibm.ejs.oa.EJSObjectAdapter;
import com.ibm.ejs.oa.EJSRootObjectAdapter;
import com.ibm.ejs.oa.InvalidUserKeyException;
import com.ibm.ejs.oa.LocationService;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.oa.WLMProfileService;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.MathUtil;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.ObjectAdapter;
import com.ibm.websphere.csi.ServantManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NamingContext;

public class EJSRootOAImpl
implements EJSRootObjectAdapter,
ObjectResolver {
    private static final TraceComponent tc = Tr.register(EJSRootOAImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    private static final String CLASS_NAME = "com.ibm.ejs.oa.EJSRootOAImpl";
    private static final int DEFAULT_SERVANT_CACHE_SIZE = 7001;
    public static final String RemoteObjectCacheSize = "com.ibm.websphere.RemoteObjectCacheSize";
    private ORB orb;
    private final Hashtable objAdapters = new Hashtable();
    private final FastHashtable ivServantObjects;
    private final FastHashtable ivServantKeys;
    private final int ivServantCacheSize;
    private boolean quiesce = false;
    private SystemException quiesceException = null;
    private byte[] serverNameBytes = null;
    private byte[] modelNameBytes = null;
    private ObjectResolver delegateOR;

    protected EJSRootOAImpl() {
        int n = 7001;
        String string = System.getProperty(RemoteObjectCacheSize);
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 >= 100 && n2 <= 50000) {
                    n = MathUtil.findNextPrime((int)n2);
                    Tr.info(tc, "WSVR0115I", Integer.toString(n));
                } else {
                    Tr.warning(tc, "WSVR0116W", (java.lang.Object)new java.lang.Object[]{string, Integer.toString(n)});
                }
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.oa.EJSRootOAImpl.<init>", "144", this);
                Tr.warning(tc, "WSVR0117W", (java.lang.Object)new java.lang.Object[]{string, Integer.toString(n)});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "RemoteObjectCacheSize = " + n);
        }
        this.ivServantObjects = new FastHashtable(n);
        this.ivServantKeys = new FastHashtable(n);
        this.ivServantCacheSize = n;
    }

    public void setDelegateResolver(ObjectResolver objectResolver) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDelegateResolver: " + objectResolver);
        }
        this.delegateOR = objectResolver;
    }

    public void setModelName(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setModelName: " + string);
        }
        if (string != null) {
            this.modelNameBytes = string.getBytes();
        }
    }

    public void init(ORB oRB, NamingContext namingContext, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init: " + string);
        }
        this.orb = oRB;
        this.serverNameBytes = string.getBytes();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init: " + string);
        }
    }

    public java.lang.Object keyToObject(byte[] byArray) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "keyToObject", byArray);
        }
        if (this.quiesce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "keyToObject: Server in quiesce state, throw exception");
            }
            throw this.quiesceException;
        }
        try {
            UserKey userKey = new UserKey(byArray);
            java.lang.Object object = this.ivServantObjects.get((java.lang.Object)userKey);
            if (object == null) {
                EJSOAImpl eJSOAImpl;
                ByteArray byteArray = new ByteArray(userKey.getOAKey());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OA key: " + byteArray);
                }
                if ((eJSOAImpl = (EJSOAImpl)this.objAdapters.get(byteArray)) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "keyToObject: Unknown object adapter");
                    }
                    throw new NoSuchObjectException("Unknown object adapter");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Cache miss, calling OA", eJSOAImpl);
                }
                object = eJSOAImpl.keyToObject(userKey.getServantKey());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "keyToObject: " + Util.identity((java.lang.Object)object));
            }
            return object;
        }
        catch (InvalidUserKeyException invalidUserKeyException) {
            FFDCFilter.processException((Throwable)invalidUserKeyException, "com.ibm.ejs.oa.EJSRootOAImpl.keyToObject", "264", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "keyToObject: Invalid object key");
            }
            throw new NoSuchObjectException("Invalid object key");
        }
    }

    public byte[] objectToKey(java.lang.Object object) {
        Tr.warning(tc, "WSVR0055W", (java.lang.Object)new java.lang.Object[]{object});
        return null;
    }

    public java.lang.Object preinvoke(java.lang.Object object, String string) {
        if (this.delegateOR != null) {
            return this.delegateOR.preinvoke(object, string);
        }
        return null;
    }

    public void postinvoke(java.lang.Object object) {
        if (this.delegateOR != null) {
            this.delegateOR.postinvoke(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter createObjectAdapter(String string) throws AdapterAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectAdapter: " + string);
        }
        ObjectAdapter objectAdapter = null;
        ByteArray byteArray = new ByteArray(string.getBytes());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OA key: " + byteArray);
        }
        Hashtable hashtable = this.objAdapters;
        synchronized (hashtable) {
            objectAdapter = (ObjectAdapter)this.objAdapters.get(byteArray);
            if (objectAdapter == null) {
                objectAdapter = new EJSOAImpl(this, string);
                this.objAdapters.put(byteArray, objectAdapter);
                if (!EJSPlatformHelper.isZOS()) {
                    LocationService.registerObjectAdapter(this.orb, string);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createObjectAdapter: Adapter already exists.");
                }
                throw new AdapterAlreadyExistsException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createObjectAdapter", objectAdapter);
        }
        return objectAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJSObjectAdapter createObjectAdapter(String string, ServantManager servantManager) throws AdapterAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectAdapter: " + string);
        }
        EJSObjectAdapter eJSObjectAdapter = null;
        ByteArray byteArray = new ByteArray(string.getBytes());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OA key: " + byteArray);
        }
        Hashtable hashtable = this.objAdapters;
        synchronized (hashtable) {
            eJSObjectAdapter = (EJSObjectAdapter)this.objAdapters.get(byteArray);
            if (eJSObjectAdapter == null) {
                eJSObjectAdapter = new EJSOAImpl(this, string, servantManager);
                this.objAdapters.put(byteArray, eJSObjectAdapter);
                if (!EJSPlatformHelper.isZOS()) {
                    LocationService.registerObjectAdapter(this.orb, string);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createObjectAdapter: Adapter already exists.");
                }
                throw new AdapterAlreadyExistsException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createObjectAdapter", eJSObjectAdapter);
        }
        return eJSObjectAdapter;
    }

    public void destroyObjectAdapter(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyObjectAdapter: " + string);
        }
        this.objAdapters.remove(new ByteArray(string.getBytes()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyObjectAdapter");
        }
    }

    public void quiesce(SystemException systemException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce: exception to throw for new incoming requests=" + (java.lang.Object)((java.lang.Object)systemException));
        }
        this.quiesce = true;
        this.quiesceException = systemException;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce");
        }
    }

    public void retireObjectAdapter(String string) {
        if (!EJSPlatformHelper.isZOS()) {
            LocationService.unregisterObjectAdapter(this.orb, string);
        }
    }

    public java.lang.Object getDelegateOR() {
        return this.delegateOR;
    }

    public ObjectAdapter getObjectAdapter(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectAdapter", string);
        }
        ObjectAdapter objectAdapter = null;
        ByteArray byteArray = new ByteArray(string.getBytes());
        objectAdapter = (ObjectAdapter)this.objAdapters.get(byteArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectAdapter", objectAdapter);
        }
        return objectAdapter;
    }

    void registerServant(Object object, byte[] byArray, boolean bl, boolean bl2, EJSOAImpl eJSOAImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)object), new ByteArray(byArray), new Boolean(bl), new Boolean(bl2), eJSOAImpl});
        }
        UserKey userKey = null;
        try {
            userKey = bl && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, eJSOAImpl.getKey().getBytes(), byArray) : new UserKey(this.serverNameBytes, false, eJSOAImpl.getKey().getBytes(), byArray);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (bl2) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (bl && this.modelNameBytes != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile);
                    }
                }
            }
            this.orb.register(object, userKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)userKey, (java.lang.Object)object);
            this.ivServantKeys.put((java.lang.Object)object, (java.lang.Object)userKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int n = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + n + "/" + this.ivServantCacheSize);
                if (n > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException invalidUserKeyException) {
            FFDCFilter.processException((Throwable)invalidUserKeyException, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "574", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", invalidUserKeyException);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object object, byte[] byArray, Identity identity, boolean bl, EJSOAImpl eJSOAImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)object), new ByteArray(byArray), identity, new Boolean(bl), eJSOAImpl});
        }
        UserKey userKey = null;
        boolean bl2 = identity != null;
        try {
            userKey = bl2 && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, eJSOAImpl.getKey().getBytes(), byArray) : new UserKey(this.serverNameBytes, false, eJSOAImpl.getKey().getBytes(), byArray);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (bl) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (identity != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile, identity);
                    }
                }
            }
            this.orb.register(object, userKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)userKey, (java.lang.Object)object);
            this.ivServantKeys.put((java.lang.Object)object, (java.lang.Object)userKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int n = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + n + "/" + this.ivServantCacheSize);
                if (n > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException invalidUserKeyException) {
            FFDCFilter.processException((Throwable)invalidUserKeyException, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "574", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", invalidUserKeyException);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object object, ByteArray byteArray, boolean bl, boolean bl2, EJSOAImpl eJSOAImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)object), byteArray, new Boolean(bl), new Boolean(bl2), eJSOAImpl});
        }
        UserKey userKey = null;
        try {
            userKey = bl && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, eJSOAImpl.getKey().getBytes(), byteArray) : new UserKey(this.serverNameBytes, false, eJSOAImpl.getKey().getBytes(), byteArray);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (bl2) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (bl && this.modelNameBytes != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile);
                    }
                }
            }
            this.orb.register(object, userKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)userKey, (java.lang.Object)object);
            this.ivServantKeys.put((java.lang.Object)object, (java.lang.Object)userKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int n = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + n + "/" + this.ivServantCacheSize);
                if (n > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException invalidUserKeyException) {
            FFDCFilter.processException((Throwable)invalidUserKeyException, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "667", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", invalidUserKeyException);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object object, ByteArray byteArray, Identity identity, boolean bl, EJSOAImpl eJSOAImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)object), byteArray, identity, new Boolean(bl), eJSOAImpl});
        }
        UserKey userKey = null;
        boolean bl2 = identity != null;
        try {
            userKey = bl2 && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, eJSOAImpl.getKey().getBytes(), byteArray) : new UserKey(this.serverNameBytes, false, eJSOAImpl.getKey().getBytes(), byteArray);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (bl) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (identity != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile, identity);
                    }
                }
            }
            this.orb.register(object, userKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)userKey, (java.lang.Object)object);
            this.ivServantKeys.put((java.lang.Object)object, (java.lang.Object)userKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int n = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + n + "/" + this.ivServantCacheSize);
                if (n > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException invalidUserKeyException) {
            FFDCFilter.processException((Throwable)invalidUserKeyException, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "764", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", invalidUserKeyException);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", Util.identity((java.lang.Object)object));
        }
        this.orb.connect(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterServant(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterServant", Util.identity((java.lang.Object)object));
        }
        try {
            this.orb.disconnect(object);
        }
        finally {
            UserKey userKey = (UserKey)this.ivServantKeys.get((java.lang.Object)object);
            if (userKey != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Removing servant from cache");
                }
                this.ivServantObjects.remove((java.lang.Object)userKey);
                this.ivServantKeys.remove((java.lang.Object)object);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Servant not found in cache");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterServant");
        }
    }

    void unregisterServantNoOrb(Object object) {
        UserKey userKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterServantNoOrb", Util.identity((java.lang.Object)object));
        }
        if ((userKey = (UserKey)this.ivServantKeys.get((java.lang.Object)object)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Removing servant from cache");
            }
            this.ivServantObjects.remove((java.lang.Object)userKey);
            this.ivServantKeys.remove((java.lang.Object)object);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Servant not found in cache");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterServantNoOrb");
        }
    }

    public IOR createIOR(ByteArray byteArray, Identity identity, boolean bl, String string, EJSOAImpl eJSOAImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createIOR", new java.lang.Object[]{byteArray, identity, new Boolean(bl), eJSOAImpl});
        }
        UserKey userKey = null;
        IOR iOR = null;
        boolean bl2 = identity != null;
        try {
            userKey = bl2 && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, eJSOAImpl.getKey().getBytes(), byteArray) : new UserKey(this.serverNameBytes, false, eJSOAImpl.getKey().getBytes(), byteArray);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (bl) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (bl2 && this.modelNameBytes != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile, identity);
                    }
                }
            } else if (bl2 && this.modelNameBytes != null && WLMProfileService.getService() != null) {
                profile = new com.ibm.rmi.Profile((com.ibm.rmi.ORB)this.orb);
                WLMProfileService.getService().setProfile(profile, identity);
            }
            ObjectKey objectKey = new ObjectKey(userKey.getBytes());
            iOR = ORB.createIOR((ORB)this.orb, (String)string, (Profile)profile, (int)1, (com.ibm.CORBA.iiop.UserKey)userKey);
        }
        catch (InvalidUserKeyException invalidUserKeyException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createIOR", invalidUserKeyException);
            }
            throw new Error("Invalid key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createIOR");
        }
        return iOR;
    }

    public UserKey createCompleteKey(boolean bl, EJSOAImpl eJSOAImpl, byte[] byArray) {
        UserKey userKey = null;
        try {
            userKey = bl && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, eJSOAImpl.getKey().getBytes(), byArray) : new UserKey(this.serverNameBytes, false, eJSOAImpl.getKey().getBytes(), byArray);
        }
        catch (InvalidUserKeyException invalidUserKeyException) {
            FFDCFilter.processException((Throwable)invalidUserKeyException, "com.ibm.ejs.oa.EJSRootOAImpl.createCompleteKey", "1066", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createCompleteKey", invalidUserKeyException);
            }
            throw new Error("Invalid servant key");
        }
        return userKey;
    }
}

