/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.util;

import com.ibm.bsf.util.Bean;
import com.ibm.bsf.util.MethodUtils;
import com.ibm.bsf.util.event.EventAdapter;
import com.ibm.bsf.util.event.EventAdapterRegistry;
import com.ibm.bsf.util.event.EventProcessor;
import com.ibm.bsf.util.type.TypeConvertor;
import com.ibm.bsf.util.type.TypeConvertorRegistry;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static void addEventListener(Object object, String string, EventProcessor eventProcessor) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object[] objectArray;
        Method method2;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        EventSetDescriptor eventSetDescriptor = (EventSetDescriptor)ReflectionUtils.findFeatureByName("event", string, beanInfo.getEventSetDescriptors());
        if (eventSetDescriptor == null) {
            throw new IllegalArgumentException("event set '" + string + "' unknown for source type '" + object.getClass() + "'");
        }
        Class<?> clazz = eventSetDescriptor.getListenerType();
        Class clazz2 = EventAdapterRegistry.lookup(clazz);
        if (clazz2 == null) {
            throw new IllegalArgumentException("event adapter for listner type '" + clazz + "' (eventset " + "'" + string + "') unknown");
        }
        EventAdapter eventAdapter = (EventAdapter)clazz2.newInstance();
        eventAdapter.setEventProcessor(eventProcessor);
        if (string.equals("propertyChange") || string.equals("vetoableChange")) {
            method2 = eventSetDescriptor.getAddListenerMethod();
            objectArray = new Object[]{eventAdapter};
        } else {
            method2 = eventSetDescriptor.getAddListenerMethod();
            objectArray = new Object[]{eventAdapter};
        }
        method2.invoke(object, objectArray);
    }

    public static Bean createBean(ClassLoader classLoader, String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (classArray != null) {
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            Constructor constructor = MethodUtils.getConstructor(clazz, classArray);
            return new Bean(clazz, constructor.newInstance(objectArray));
        }
        Object object = Beans.instantiate(classLoader, string);
        return new Bean(object.getClass(), object);
    }

    public static Bean createBean(ClassLoader classLoader, String string, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : null;
            }
        }
        return ReflectionUtils.createBean(classLoader, string, classArray, objectArray);
    }

    private static FeatureDescriptor findFeatureByName(String string, String string2, FeatureDescriptor[] featureDescriptorArray) {
        for (int i = 0; i < featureDescriptorArray.length; ++i) {
            if (!string2.equals(featureDescriptorArray[i].getName())) continue;
            return featureDescriptorArray[i];
        }
        return null;
    }

    public static Bean getField(Object object, String string) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Field field = clazz.getField(string);
            Class<?> clazz2 = field.getType();
            Object object2 = field.get(object);
            return new Bean(clazz2, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("field '" + string + "' is " + "unknown for '" + object + "'");
        }
    }

    public static Bean getProperty(Object object, String string, Integer n) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz;
        Method method2;
        Object object2;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)ReflectionUtils.findFeatureByName("property", string, beanInfo.getPropertyDescriptors());
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("property '" + string + "' is " + "unknown for '" + object + "'");
        }
        if (n != null) {
            if (!(propertyDescriptor instanceof IndexedPropertyDescriptor)) {
                throw new IllegalArgumentException("attempt to get non-indexed property '" + string + "' as being indexed");
            }
            object2 = (IndexedPropertyDescriptor)propertyDescriptor;
            method2 = ((IndexedPropertyDescriptor)object2).getIndexedReadMethod();
            clazz = ((IndexedPropertyDescriptor)object2).getIndexedPropertyType();
        } else {
            method2 = propertyDescriptor.getReadMethod();
            clazz = propertyDescriptor.getPropertyType();
        }
        if (method2 == null) {
            throw new IllegalArgumentException("property '" + string + "' is not readable");
        }
        object2 = null;
        object2 = n != null ? method2.invoke(object, n) : method2.invoke(object, null);
        return new Bean(clazz, object2);
    }

    public static void setField(Object object, String string, Bean bean, TypeConvertorRegistry typeConvertorRegistry) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Field field = clazz.getField(string);
            Class<?> clazz2 = field.getType();
            Object object2 = null;
            boolean bl = true;
            if (clazz2.isAssignableFrom(bean.type)) {
                object2 = bean.value;
            } else if (typeConvertorRegistry != null) {
                TypeConvertor typeConvertor = typeConvertorRegistry.lookup(bean.type, clazz2);
                if (typeConvertor != null) {
                    object2 = typeConvertor.convert(bean.type, clazz2, bean.value);
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                throw new IllegalArgumentException("unable to assign '" + bean.value + "' to field '" + string + "'");
            }
            field.set(object, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("field '" + string + "' is " + "unknown for '" + object + "'");
        }
    }

    public static void setProperty(Object object, String string, Integer n, Object object2, Class clazz, TypeConvertorRegistry typeConvertorRegistry) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz2;
        Method method2;
        Object object3;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)ReflectionUtils.findFeatureByName("property", string, beanInfo.getPropertyDescriptors());
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("property '" + string + "' is " + "unknown for '" + object + "'");
        }
        if (n != null) {
            if (!(propertyDescriptor instanceof IndexedPropertyDescriptor)) {
                throw new IllegalArgumentException("attempt to set non-indexed property '" + string + "' as being indexed");
            }
            object3 = (IndexedPropertyDescriptor)propertyDescriptor;
            method2 = ((IndexedPropertyDescriptor)object3).getIndexedWriteMethod();
            clazz2 = ((IndexedPropertyDescriptor)object3).getIndexedPropertyType();
        } else {
            method2 = propertyDescriptor.getWriteMethod();
            clazz2 = propertyDescriptor.getPropertyType();
        }
        if (method2 == null) {
            throw new IllegalArgumentException("property '" + string + "' is not writeable");
        }
        object3 = null;
        boolean bl = true;
        if (clazz2.isAssignableFrom(clazz)) {
            object3 = object2;
        } else if (typeConvertorRegistry != null) {
            TypeConvertor typeConvertor = typeConvertorRegistry.lookup(clazz, clazz2);
            if (typeConvertor != null) {
                object3 = typeConvertor.convert(clazz, clazz2, object2);
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            throw new IllegalArgumentException("unable to assign '" + object2 + "' to property '" + string + "'");
        }
        if (n != null) {
            method2.invoke(object, n, object3);
        } else {
            method2.invoke(object, object3);
        }
    }
}

