/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultFactory;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.internals.ContextManagerInternals;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.Vector;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;

public class ServiceInit {
    private static Vector orbRegistry = new Vector();
    private ConfigURLProperties securityProps = null;
    private static ServiceInit serviceInit = null;
    private static boolean initialized = false;
    private static TraceComponent tc = Tr.register("SASRas", null, "com.ibm.ISecurityL13SupportImpl.sec");

    private ServiceInit() {
    }

    public static ServiceInit getInstance() {
        if (serviceInit == null) {
            serviceInit = new ServiceInit();
        }
        return serviceInit;
    }

    public synchronized void initialize(com.ibm.CORBA.iiop.ORB oRB) {
        initialized = true;
        this.init(oRB);
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    private void init(com.ibm.CORBA.iiop.ORB oRB) {
        String string = "ServiceInit.init";
        String string2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            ConfigURLProperties configURLProperties = ConfigURLProperties.getInstance();
            String string3 = "";
            string3 = SecurityConfiguration.secConfigInitialized() ? "true" : configURLProperties.getProperty("com.ibm.CORBA.securityEnabled");
            if (string3 != null && (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security is enabled in ServiceInit.");
                }
                new SecurityLogger(oRB);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "SecurityConfiguration initialized";
                    SecurityLogger.debugMessage(string, string2);
                }
                Tr.audit(tc, "security.GettingConfig");
                SSLConfigManager sSLConfigManager = SSLConfigManager.getInstance();
                sSLConfigManager.initializeClientSSL();
                SecurityConfiguration securityConfiguration = new SecurityConfiguration((ORB)oRB, configURLProperties);
                String string4 = ((String)AuthenticationTarget.strings.get(new Integer(securityConfiguration.getauthenticationTarget()))).toUpperCase();
                if (string4.equals("LOCALOS")) {
                    Tr.audit(tc, "security.AuthTarget", new Object[]{"SWAM"});
                } else {
                    Tr.audit(tc, "security.AuthTarget", new Object[]{string4});
                }
                if (!securityConfiguration.getprincipalName().equals("")) {
                    Tr.audit(tc, "security.Principal", new Object[]{securityConfiguration.getprincipalName()});
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Initializing ORB security.";
                    SecurityLogger.debugMessage(string, string2);
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Security is being initialized for ORB: " + oRB;
                    SecurityLogger.debugMessage(string, string2);
                }
                if (orbRegistry.contains(oRB)) {
                    string2 = "security.JSAS0465E";
                    SecurityLogger.logError(string2, new Object[]{string});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, string);
                    }
                    return;
                }
                orbRegistry.addElement(oRB);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "LocateRequest processing in the ORB has been forced on.";
                    SecurityLogger.debugMessage(string, string2);
                }
                if (securityConfiguration.securityEnabled()) {
                    ContextManager contextManager;
                    MechanismFactory mechanismFactory = new MechanismFactory(securityConfiguration);
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "MechanismFactory initialized";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    VaultImpl vaultImpl = VaultFactory.createVault(mechanismFactory, securityConfiguration, oRB);
                    vaultImpl.setORB(oRB);
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "VaultImpl initialized";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    if ((contextManager = ContextManagerFactory.getInstance()) != null && contextManager instanceof ContextManagerInternals) {
                        ((ContextManagerInternals)contextManager).init();
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled in ServiceInit.");
            }
        }
        catch (Exception exception) {
            string2 = "security.JSAS0011E";
            SecurityLogger.logError(string2, new Object[]{string, exception});
            throw new INITIALIZE();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }
}

