/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.KeyFileEntry;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class KeyFile
extends Hashtable {
    private static final long serialVersionUID = -7416596310773730895L;
    String keyfileName = "";
    long keyfileSize = 0L;
    boolean isSvrKyFile = true;
    Vector tmpFileBuff = null;

    public KeyFile(String string) {
        if (string != null) {
            this.keyfileName = string;
        }
        this.load();
    }

    public KeyFileEntry find(String string) {
        KeyFileEntry keyFileEntry = (KeyFileEntry)this.get(string.toLowerCase());
        if (keyFileEntry != null) {
            return keyFileEntry;
        }
        String string2 = RealmSecurityName.getRealm(string);
        String string3 = RealmSecurityName.getSecurityName(string);
        if (string2 != null && !string2.trim().equals("") && string3 != null && !string3.trim().equals("")) {
            boolean bl = false;
            KeyFileEntry keyFileEntry2 = null;
            Enumeration enumeration = this.keys();
            Enumeration enumeration2 = this.elements();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                KeyFileEntry keyFileEntry3 = (KeyFileEntry)enumeration2.nextElement();
                if (!bl) {
                    keyFileEntry2 = keyFileEntry3;
                    bl = true;
                }
                String string5 = RealmSecurityName.getRealm(string4);
                String string6 = RealmSecurityName.getSecurityName(string4);
                if (string2 != null && string5 != null && string2.equalsIgnoreCase(string5)) {
                    return keyFileEntry3;
                }
                if (string3 == null || string6 == null || !string3.equals(string6)) continue;
                return keyFileEntry3;
            }
            if (bl) {
                return keyFileEntry2;
            }
        } else {
            return null;
        }
        return null;
    }

    public KeyFileEntry find(String string, String string2) {
        return this.find(RealmSecurityName.getRealm(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void load() {
        String string;
        String string2 = "KeyFile.load";
        String string3 = null;
        final File file = new File(this.keyfileName);
        RandomAccessFile randomAccessFile = null;
        long l = 0L;
        try {
            try {
                randomAccessFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!file.canWrite()) {
                            return null;
                        }
                        return new RandomAccessFile(file, "rw");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "252", this);
                throw privilegedActionException.getException();
            }
            if (randomAccessFile != null && randomAccessFile.length() != 0L) {
                if (SecurityLogger.traceEnabled || SecurityLogger.debugTraceEnabled) {
                    string3 = SecurityMessages.getMsgOrUseDefault("ActMsg460", "Successfully loaded configured key file: ");
                    SecurityLogger.debugMessage(string2, string3 + this.keyfileName);
                }
            } else {
                if (!SecurityLogger.debugTraceEnabled) return;
                string3 = SecurityMessages.getMsgOrUseDefault("ErrMsg482", "Failed to load configured key file: ");
                SecurityLogger.debugMessage(string2, string3 + (this.keyfileName == null ? "" : this.keyfileName));
                return;
            }
            this.keyfileSize = randomAccessFile.length();
            this.tmpFileBuff = new Vector((int)this.keyfileSize);
            l = randomAccessFile.getFilePointer();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "286", this);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string2, exception, 0, 0);
            }
            string3 = SecurityMessages.getMsgOrUseDefault("ErrMsg482", "Failed to load configured key file: ");
            SecurityLogger.debugMessage(string2, string3 + (this.keyfileName == null ? "" : this.keyfileName));
            return;
        }
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Object object = null;
        while ((string = randomAccessFile.readLine()) != null) {
            if (string.charAt(0) != '#') {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() == 3) {
                    block48: {
                        string4 = stringTokenizer.nextToken();
                        string5 = stringTokenizer.nextToken();
                        string6 = stringTokenizer.nextToken();
                        try {
                            string7 = PasswordUtil.decode(string6);
                        }
                        catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                            FFDCFilter.processException((Throwable)((Object)invalidPasswordDecodingException), "com.ibm.ISecurityUtilityImpl.KeyFile.load", "345", this);
                            string7 = string6;
                            try {
                                string6 = PasswordUtil.encode(string6);
                            }
                            catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
                                FFDCFilter.processException((Throwable)((Object)unsupportedCryptoAlgorithmException), "com.ibm.ISecurityUtilityImpl.KeyFile.load", "355", this);
                                if (SecurityLogger.debugTraceEnabled) {
                                    string3 = "Encountered unsupported cryptographic algorithm while encoding the password from key file " + this.keyfileName;
                                    SecurityLogger.debugMessage(string2, string3);
                                }
                                if (SecurityLogger.traceEnabled) {
                                    SecurityLogger.traceException(string2, (Exception)((Object)invalidPasswordDecodingException), 0, 0);
                                }
                            }
                            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
                                FFDCFilter.processException((Throwable)((Object)invalidPasswordEncodingException), "com.ibm.ISecurityUtilityImpl.KeyFile.load", "369", this);
                                if (SecurityLogger.debugTraceEnabled) {
                                    string3 = "Encountered invalidly encoded password from key file " + this.keyfileName;
                                    SecurityLogger.debugMessage(string2, string3);
                                }
                                if (SecurityLogger.traceEnabled) {
                                    SecurityLogger.traceException(string2, (Exception)((Object)invalidPasswordDecodingException), 0, 0);
                                }
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "385", this);
                            string7 = string6;
                            if (SecurityLogger.debugTraceEnabled) {
                                string3 = exception.toString() + " caught while decoding the password from key file " + this.keyfileName;
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            if (!SecurityLogger.traceEnabled) break block48;
                            SecurityLogger.traceException(string2, exception, 0, 0);
                        }
                    }
                    KeyFileEntry keyFileEntry = new KeyFileEntry(string5, string7);
                    this.tmpFileBuff.addElement(string4 + " " + string5 + " " + string6 + "\r" + "\n");
                    if (this.put(string4.toLowerCase(), keyFileEntry) == null || !SecurityLogger.debugTraceEnabled) continue;
                    string3 = "Duplicated entry for realm name: " + string4;
                    SecurityLogger.debugMessage(string2, string3);
                    continue;
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "An entry contains wrong number of values.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                string = string + "\r" + "\n";
                this.tmpFileBuff.addElement(string);
                continue;
            }
            string = string + "\r" + "\n";
            this.tmpFileBuff.addElement(string);
        }
        Object var17_24 = null;
        if (object != null && !object.equals(new EOFException())) return;
        try {
            if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                if (randomAccessFile != null) {
                    randomAccessFile.seek(l);
                }
                for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                    randomAccessFile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                }
            }
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "498", this);
            string3 = "security.JSAS0400E";
            SecurityLogger.logError(string3, new Object[]{string2});
        }
        return;
        {
            catch (EOFException eOFException) {
                FFDCFilter.processException((Throwable)eOFException, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "447", this);
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "456", this);
                    string3 = "security.JSAS0400E";
                    SecurityLogger.logError(string3, new Object[]{string2});
                    object = iOException;
                }
                object = eOFException;
                Object var17_25 = null;
                if (object != null && !object.equals(new EOFException())) return;
                try {
                    if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                        if (randomAccessFile != null) {
                            randomAccessFile.seek(l);
                        }
                        for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                            randomAccessFile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                        }
                    }
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "498", this);
                    string3 = "security.JSAS0400E";
                    SecurityLogger.logError(string3, new Object[]{string2});
                }
                return;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "467", this);
                if (SecurityLogger.traceEnabled) {
                    SecurityLogger.traceException(string2, iOException, 0, 0);
                }
                string3 = "security.JSAS0400E";
                SecurityLogger.logError(string3, new Object[]{string2});
                Object var17_26 = null;
                if (object != null && !object.equals(new EOFException())) return;
                try {
                    if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                        if (randomAccessFile != null) {
                            randomAccessFile.seek(l);
                        }
                        for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                            randomAccessFile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                        }
                    }
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException2) {
                    FFDCFilter.processException((Throwable)iOException2, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "498", this);
                    string3 = "security.JSAS0400E";
                    SecurityLogger.logError(string3, new Object[]{string2});
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_27 = null;
            if (object != null && !object.equals(new EOFException())) throw throwable;
            try {
                if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                    if (randomAccessFile != null) {
                        randomAccessFile.seek(l);
                    }
                    for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                        randomAccessFile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                    }
                }
                randomAccessFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "498", this);
                string3 = "security.JSAS0400E";
                SecurityLogger.logError(string3, new Object[]{string2});
            }
            throw throwable;
        }
    }
}

