/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfied;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.APPSECTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SSLCompoundTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponentHolder;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ServerConnectionKey;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.ObjectList;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityTaggedComponent;
import com.ibm.ISecurityUtilityImpl.ServiceInit;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionDataCarrier;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.DefaultConnectionInterceptor;
import com.ibm.ws.orb.transport.IIOPEndpointProfile;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.DefaultServerConnectionDataImpl;
import com.ibm.ws.security.orbssl.ExtendedSSLConnectionData;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.orbssl.SSLServerConnectionDataImpl;
import com.ibm.ws.security.orbssl.ServerConnectionDataImpl;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.utility.JAVAtoCPPUtilities;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;

public class SecurityConnectionInterceptor
extends DefaultConnectionInterceptor
implements ChainEventListener {
    private VaultImpl vault = null;
    private SecurityConfiguration secConfig = null;
    private MechanismFactory mechFactory = null;
    private ORB orb = null;
    private ChannelFramework cfw = null;
    private SSLServerConnectionData csiServerSSLConnData = null;
    private SSLServerConnectionData csiClientCertServerSSLConnData = null;
    private ServerConnectionData serverTCPConnData = null;
    private DefaultConnectionInterceptor defaultConnInt = null;
    public static Hashtable classNames = new Hashtable();
    private static final int OutcomeUnknown = 0;
    private static final int OutcomeSuccessful = 1;
    private static final int OutcomeRetry = 2;
    private static final int OutcomeFail = 3;
    private static final short WebSphereAS = 16384;
    private static final String ADMIN_CLASS = "adminsec.txt";
    private ObjectList list = null;
    private String activeUserRegistry = null;
    private static boolean prefer_iiop_to_local = false;

    public void init(ORB oRB) {
        String string = "SecurityConnectionInterceptor.init";
        String string2 = null;
        if (oRB == null) {
            throw new INTERNAL("ORB is NULL passed into Security!!!");
        }
        this.orb = oRB;
        this.defaultConnInt = new DefaultConnectionInterceptor();
        this.defaultConnInt.init(this.orb);
        if (ConfigURLProperties.isSecurityEnabled()) {
            SecurityLogger.logAudit(string, "security.LoadSCI");
            if (!ServiceInit.isInitialized()) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Initializing ServiceInit in SCI.";
                    SecurityLogger.debugMessage(string, string2);
                }
                ServiceInit serviceInit = ServiceInit.getInstance();
                serviceInit.initialize(oRB);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Initializing SecurityConnectionInterceptor.";
                SecurityLogger.debugMessage(string, string2);
            }
            this.vault = this.getVault();
            if (this.vault != null) {
                this.secConfig = this.getSecurityConfig();
                this.mechFactory = this.vault.getMechanismFactory();
                this.vault.setSecurityConnectionInterceptor(this);
                this.vault.setORB(this.orb);
            } else {
                string2 = "security.JSAS0010E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
            }
        }
    }

    public void notifyChainInitializationComplete(ChannelFramework channelFramework, ORB oRB, List list, List list2) {
        String string = "SecurityConnectionInterceptor.notifyChainInitializationComplete";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string + " secureChains=" + list + "; insecureChains=" + list2);
        }
        this.cfw = channelFramework;
        if (!PlatformHelperFactory.getPlatformHelper().isZOS() || PlatformHelperFactory.getPlatformHelper().isControlJvm() || PlatformHelperFactory.getPlatformHelper().isClientJvm()) {
            try {
                for (int i = 0; list != null && i < list.size(); ++i) {
                    channelFramework.addChainEventListener((ChainEventListener)this, (String)list.get(i));
                }
            }
            catch (Exception exception) {
                SecurityLogger.debugMessage(string, exception.toString());
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
        String string = "chainStarted";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        try {
            int n = this.cfw.getListeningPort(chainData.getName());
            this.orb.setProperty("com.ibm.CSI.SSLPort", Integer.toString(n));
        }
        catch (Exception exception) {
            SecurityLogger.debugMessage(string, exception.toString());
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void chainStopped(ChainData chainData) {
    }

    public void chainDestroyed(ChainData chainData) {
    }

    public void chainUpdated(ChainData chainData) {
    }

    protected short formCoalescedQOP(short s, short s2) {
        String string = "SecurityConnectionInterceptor.formCoalescedQOP";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        short s3 = s2;
        if ((s2 & 0x40) == 0 && this.getSecurityConfig().performClientAuthentication() && (s & 0x40) != 0) {
            s3 = (short)(s3 & 0x40);
        }
        if ((s2 & 0x20) == 0 && this.getSecurityConfig().performServerAuthentication() && (s & 0x20) != 0) {
            s3 = (short)(s3 & 0x20);
        }
        if ((s2 & 8) == 0 && this.getSecurityConfig().performMessageReplayDetection() && (s & 8) != 0) {
            s3 = (short)(s3 & 8);
        }
        if ((s2 & 0x10) == 0 && this.getSecurityConfig().performMessageOutOfSequenceDetection() && (s & 0x10) != 0) {
            s3 = (short)(s3 & 0x10);
        }
        if ((s2 & 2) == 0 && this.getSecurityConfig().performMessageIntegrity() && (s & 2) != 0) {
            s3 = (short)(s3 & 2);
        }
        if ((s2 & 4) == 0 && this.getSecurityConfig().performMessageConfidentiality() && (s & 4) != 0) {
            s3 = (short)(s3 & 4);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
        return s3;
    }

    protected short formCSIv2CoalescedQOP(short s, short s2, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        String string = "SecurityConnectionInterceptor.formCSIv2CoalescedQOP";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = " Input to formCSIv2CoalescedQOP: targetSupports: " + s + ", targetRequires: " + s2;
            SecurityLogger.debugMessage(string, string2);
        }
        short s3 = 0;
        if (cSIv2EffectivePerformPolicy != null) {
            if (cSIv2EffectivePerformPolicy.performTLClientAuth()) {
                s3 = (short)(s3 + 64);
            }
            if (cSIv2EffectivePerformPolicy.performTLServerAuth()) {
                s3 = (short)(s3 + 32);
            }
            if (cSIv2EffectivePerformPolicy.performMsgIntegrity()) {
                s3 = (short)(s3 + 2);
            }
            if (cSIv2EffectivePerformPolicy.performMsgConfidentiality()) {
                s3 = (short)(s3 + 4);
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = " Output from formCSIv2CoalescedQOP: targetSupports: " + s + " targetRequires: " + s2 + " coalescedQOP: " + s3;
            SecurityLogger.debugMessage(string, string2);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
        return s3;
    }

    protected String formConnectionKey(String string, int n, String string2, short s) {
        String string3 = null;
        Integer n2 = new Integer(n);
        Short s2 = new Short(s);
        if (string2 == null) {
            string2 = " ";
        }
        string3 = string2.equals(VaultConstants.SSL_MECH_TYPE) ? string + ":" + n2.toString() + ":" + "IIOPSSL" + ":" + s2.toString() : (string2.equals(VaultConstants.DCE_MECH_TYPE) ? string + ":" + n2.toString() + ":" + "IIOPDCE" : string + ":" + n2.toString());
        return string3;
    }

    public java.lang.Object getServerConnectionData(GIOPConnectionContext gIOPConnectionContext) {
        Map map;
        String string = "SecurityConnectionInterceptor.getServerConnectionData";
        String string2 = null;
        VirtualConnection virtualConnection = gIOPConnectionContext.getVirtualConnection();
        ConnectionInformation connectionInformation = null;
        if (virtualConnection != null && (map = virtualConnection.getStateMap()) != null && (connectionInformation = (ConnectionInformation)map.get("CSIv2ConnectionInfo")) == null) {
            DefaultServerConnectionDataImpl defaultServerConnectionDataImpl = new DefaultServerConnectionDataImpl();
            int n = 0;
            int n2 = 0;
            String string3 = null;
            ConnectionHandle connectionHandle = ConnectionHandle.getConnectionHandle((VirtualConnection)virtualConnection);
            if (connectionHandle != null && connectionHandle.getIsLocalComm()) {
                string3 = connectionHandle.toString();
                n = -1;
                n2 = -1;
                defaultServerConnectionDataImpl.setConnectionType(4L);
            } else {
                string3 = gIOPConnectionContext.getRemoteHost();
                n = gIOPConnectionContext.getRemotePort();
                n2 = gIOPConnectionContext.getLocalPort();
            }
            defaultServerConnectionDataImpl.setRemoteHost(string3);
            defaultServerConnectionDataImpl.setRemotePort(n);
            defaultServerConnectionDataImpl.setLocalHost(gIOPConnectionContext.getLocalHost());
            defaultServerConnectionDataImpl.setLocalPort(n2);
            defaultServerConnectionDataImpl.setConnectionHandle(connectionHandle);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Filter receive request GCC Information: \nConnectionHandle: " + (connectionHandle == null ? "null" : connectionHandle.toString()) + "\nisLocalComm: " + (connectionHandle != null ? connectionHandle.getIsLocalComm() : false) + "\nlocal host: " + defaultServerConnectionDataImpl.getLocalHost() + "\nlocal port: " + defaultServerConnectionDataImpl.getLocalPort() + "\nremote host: " + defaultServerConnectionDataImpl.getRemoteHost() + "\nremote port: " + defaultServerConnectionDataImpl.getRemotePort();
                SecurityLogger.debugMessage(string, string2);
            }
            SSLSession sSLSession = null;
            SSLConnectionContext sSLConnectionContext = gIOPConnectionContext.getSSLContext();
            if (sSLConnectionContext != null) {
                sSLSession = sSLConnectionContext.getSession();
            }
            X509Certificate[] x509CertificateArray = null;
            if (sSLSession != null) {
                try {
                    x509CertificateArray = (X509Certificate[])sSLSession.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            connectionInformation = new ConnectionInformationImpl(defaultServerConnectionDataImpl, x509CertificateArray, System.currentTimeMillis(), string3, n);
            map.put("CSIv2ConnectionInfo", connectionInformation);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = connectionInformation != null ? "ConnectionInformation: " + connectionInformation.toString() : "ConnectionInformation is NULL.";
            SecurityLogger.debugMessage(string, string2);
        }
        return connectionInformation;
    }

    public byte[] getClientConnectionInfo(Object object) {
        String string = "SecurityConnectionInterceptor.getClientConnectionInfo(Object)";
        String string2 = null;
        byte[] byArray = null;
        try {
            ConnectionInformation connectionInformation = (ConnectionInformation)object;
            if (connectionInformation != null) {
                ConnectionData connectionData = (ConnectionData)connectionInformation.getConnectionData();
                if (connectionData != null && connectionData instanceof ExtendedSSLConnectionData) {
                    byArray = ((ExtendedSSLConnectionData)connectionData).getBytes();
                } else if (connectionData != null) {
                    String string3 = connectionData.getConnectionKey();
                    byArray = string3.getBytes();
                }
            }
        }
        catch (Exception exception) {
            string2 = "Exception getting serialized connection data bytes." + exception.getMessage();
            if (SecurityLogger.debugTraceEnabled) {
                SecurityLogger.debugMessage(string, string2);
                SecurityLogger.logException(string, exception, 0, 0);
            }
            throw new INTERNAL("Could not flatten client connection data to bytes");
        }
        return byArray;
    }

    public java.lang.Object getClientConnectionInfo(byte[] byArray) {
        String string = "SecurityConnectionInterceptor.getClientConnectionInfo(bytes)";
        String string2 = null;
        ConnectionInformationImpl connectionInformationImpl = null;
        java.lang.Object var5_5 = null;
        boolean bl = false;
        java.lang.Object var7_7 = null;
        ExtendedSSLConnectionData extendedSSLConnectionData = null;
        try {
            extendedSSLConnectionData = byArray != null ? new ExtendedSSLConnectionData(byArray) : new ExtendedSSLConnectionData(null, 0L, 0, 0, null);
            connectionInformationImpl = new ConnectionInformationImpl(extendedSSLConnectionData, null, 0L, null, 0);
        }
        catch (Exception exception) {
            string2 = "Exception de-serializing connection data bytes." + exception.getMessage();
            if (SecurityLogger.debugTraceEnabled) {
                SecurityLogger.debugMessage(string, string2);
                SecurityLogger.logException(string, exception, 0, 0);
            }
            throw new INTERNAL("Could not initialize client connection data");
        }
        return connectionInformationImpl;
    }

    protected IIOPEndpointProfile getLocalCommEndpointProfile(IOR iOR, ConnectionData connectionData) {
        String string = "SecurityConnectionInterceptor.getLocalCommEndpointProfile";
        IIOPEndpointProfile iIOPEndpointProfile = null;
        Profile profile = iOR.getProfile();
        byte[] byArray = profile.getTaggedComponent(1229081869);
        if (byArray != null && byArray.length > 0) {
            CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = null;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            bl3 = ConfigURLProperties.isSecurityEnabled();
            if (connectionData != null && connectionData instanceof ExtendedSSLConnectionData) {
                cSIv2EffectivePerformPolicy = ((ExtendedSSLConnectionData)connectionData).getEffectivePolicy();
                bl = cSIv2EffectivePerformPolicy == null || !cSIv2EffectivePerformPolicy.performTLClientAuth();
            }
            boolean bl4 = bl2 = this.activeUserRegistry != null && this.activeUserRegistry.equals("LOCALOS");
            if (!bl3 || bl || bl2) {
                ExtendedSSLConnectionData extendedSSLConnectionData = new ExtendedSSLConnectionData(null, 4L, 0, 0, cSIv2EffectivePerformPolicy);
                extendedSSLConnectionData.setAltConnectionData(byArray);
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string + ": LSIP: ", byArray);
                }
                iIOPEndpointProfile = new IIOPEndpointProfile(iOR, "localcomm-ziop-out", extendedSSLConnectionData);
            }
        }
        return iIOPEndpointProfile;
    }

    protected IIOPEndpointProfile[] getUnsecureIIOPProfiles(IOR iOR, String string, String string2) {
        ConnectionData connectionData;
        IIOPEndpointProfile iIOPEndpointProfile;
        IIOPEndpointProfile[] iIOPEndpointProfileArray = this.defaultConnInt.getIIOPEndpointProfiles(iOR, string, string2);
        if (iIOPEndpointProfileArray != null && iIOPEndpointProfileArray.length > 0 && (iIOPEndpointProfile = this.getLocalCommEndpointProfile(iOR, connectionData = iIOPEndpointProfileArray[0].getConnectionData())) != null) {
            IIOPEndpointProfile[] iIOPEndpointProfileArray2 = new IIOPEndpointProfile[iIOPEndpointProfileArray.length + 1];
            if (prefer_iiop_to_local) {
                System.arraycopy(iIOPEndpointProfileArray, 0, iIOPEndpointProfileArray2, 0, iIOPEndpointProfileArray.length);
                iIOPEndpointProfileArray2[iIOPEndpointProfileArray.length] = iIOPEndpointProfile;
            } else {
                iIOPEndpointProfileArray2[0] = iIOPEndpointProfile;
                System.arraycopy(iIOPEndpointProfileArray, 0, iIOPEndpointProfileArray2, 1, iIOPEndpointProfileArray.length);
            }
            iIOPEndpointProfileArray = iIOPEndpointProfileArray2;
        }
        return iIOPEndpointProfileArray;
    }

    public IIOPEndpointProfile[] getIIOPEndpointProfiles(IOR iOR, String string, String string2) {
        java.lang.Object object;
        ConnectionDataCarrier connectionDataCarrier;
        if (iOR == null) {
            return null;
        }
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return this.getUnsecureIIOPProfiles(iOR, string, string2);
        }
        String string3 = "SecurityConnectionInterceptor.getIIOPEndpointProfiles";
        String string4 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string3);
        }
        boolean bl = false;
        IIOPEndpointProfile[] iIOPEndpointProfileArray = null;
        Profile profile = iOR.getProfile();
        bl = this.getConnectionKey(profile, 0, iOR, string, string2, connectionDataCarrier = new ConnectionDataCarrier());
        if (!bl) {
            string4 = "Security could not obtain a valid ConnectionKey.";
            if (SecurityLogger.debugTraceEnabled) {
                SecurityLogger.debugMessage(string3, string4);
            }
            throw new NO_PERMISSION(string4);
        }
        ConnectionData connectionData = connectionDataCarrier.getConnectionData();
        String string5 = super.getChainName(this.orb, 2L);
        if (connectionData != null && (object = connectionData.getConnectionKey()) != null && ((String)object).indexOf("IIOPSSL") != -1) {
            string5 = super.getChainName(this.orb, 1L);
        }
        object = new IIOPEndpointProfile(iOR, string5, connectionData);
        IIOPEndpointProfile iIOPEndpointProfile = this.getLocalCommEndpointProfile(iOR, connectionData);
        iIOPEndpointProfileArray = iIOPEndpointProfile != null ? (prefer_iiop_to_local ? new IIOPEndpointProfile[]{object, iIOPEndpointProfile} : new IIOPEndpointProfile[]{iIOPEndpointProfile, object}) : new IIOPEndpointProfile[]{object};
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugMessage(string3, "IIOP endpoint profile(s): " + (iIOPEndpointProfileArray == null ? "null" : iIOPEndpointProfileArray.toString()));
            SecurityLogger.debugExit(string3);
        }
        return iIOPEndpointProfileArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getConnectionKey(Profile profile, int n, IOR iOR, String string, String string2, ConnectionDataCarrier connectionDataCarrier) {
        java.lang.Object object;
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return this.defaultConnInt.getConnectionKey(profile, n, iOR, string, string2, connectionDataCarrier);
        }
        String string3 = "SecurityConnectionInterceptor.getConnectionKey";
        String string4 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string3);
        }
        this.activeUserRegistry = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        java.lang.Object var12_12 = null;
        boolean bl = false;
        int n2 = 0;
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string8 = null;
        CSIv2TaggedComponent[] cSIv2TaggedComponentArray = null;
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = null;
        boolean bl8 = false;
        APPSECTaggedComponent aPPSECTaggedComponent = null;
        short s4 = 0;
        if (string == null) {
            string = this.getClassName(iOR);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string4 = string != null ? "getConnectionKey invoked for operation " + string + "." + string2 + " on ORB " + this.orb : "getConnectionKey invoked with class_name NULL on ORB " + this.orb;
            SecurityLogger.debugMessage(string3, string4);
        }
        boolean bl9 = false;
        try {
            block32: {
                block33: {
                    cSIv2TaggedComponentArray = CSIv2TaggedComponent.getCSIv2TaggedComponentList(profile, iOR);
                    bl7 = cSIv2TaggedComponentArray != null;
                    object = null;
                    SSLTaggedComponent sSLTaggedComponent = null;
                    object = SSLCompoundTaggedComponent.getSSLCompoundTaggedComponent(profile, iOR);
                    if (object == null) {
                        sSLTaggedComponent = SSLTaggedComponent.getSSLTaggedComponent(profile, iOR);
                        if (sSLTaggedComponent != null) {
                            s = sSLTaggedComponent.get_targetCoalescedSuppQOP();
                            s2 = sSLTaggedComponent.get_targetCoalescedReqQOP();
                            n2 = sSLTaggedComponent.get_SSLPort();
                            bl3 = true;
                        }
                    } else {
                        bl4 = true;
                        s = ((SecurityTaggedComponent)object).get_targetCoalescedSuppQOP();
                        s2 = ((SecurityTaggedComponent)object).get_targetCoalescedReqQOP();
                        n2 = ((SSLCompoundTaggedComponent)object).get_SSLPort();
                        s3 = ((SecurityTaggedComponent)object).get_targetCoalescedReqQOP();
                        string7 = ((SSLCompoundTaggedComponent)object).getMechanismType().trim();
                        string5 = ((SecurityTaggedComponent)object).get_targetCompleteName();
                        string6 = RealmSecurityName.getRealm(((SecurityTaggedComponent)object).get_targetCompleteName());
                    }
                    if ((aPPSECTaggedComponent = APPSECTaggedComponent.getAPPSECTaggedComponent(profile, iOR)) != null) {
                        bl8 = true;
                        s4 = aPPSECTaggedComponent.get_enabledState();
                        this.activeUserRegistry = aPPSECTaggedComponent.get_activeUserRegistry();
                        if (SecurityLogger.debugTraceEnabled) {
                            SecurityLogger.debugMessage(string3, "Active user registry is: " + this.activeUserRegistry == null ? "null" : this.activeUserRegistry);
                        }
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        string4 = "SSL tag found is " + bl3 + ", SSL compound tag found is " + bl4 + ", CSIv2 tag found is " + bl7 + ", Mechanism is " + string7 + ", APPSec tag found is " + bl8 + ";";
                        SecurityLogger.debugMessage(string3, string4);
                    }
                    if (bl7 || bl4 || bl3) {
                        if (!bl7 && (bl4 || bl3)) {
                            string4 = "Found old SSL tagged component.";
                            SecurityLogger.debugMessage(string3, string4);
                            bl9 = false;
                        } else {
                            string4 = "Found CSIv2 tagged component.";
                            SecurityLogger.debugMessage(string3, string4);
                            bl9 = true;
                        }
                    }
                    if (!bl9) break block32;
                    cSIv2EffectivePerformPolicy = CSIv2EffectivePerformPolicy.getInstance(cSIv2TaggedComponentArray, string2, this.orb.IORToObject(iOR));
                    if (cSIv2EffectivePerformPolicy == null) break block33;
                    this.vault.getCurrent().setEffectivePolicy(cSIv2EffectivePerformPolicy);
                    string6 = string5 = cSIv2EffectivePerformPolicy.getTargetSecurityName();
                    CSIv2TaggedComponentHolder cSIv2TaggedComponentHolder = cSIv2EffectivePerformPolicy.getCSIv2TaggedComponent();
                    if (!cSIv2EffectivePerformPolicy.performSSLTLS() || cSIv2TaggedComponentHolder == null) break block32;
                    int n3 = cSIv2TaggedComponentHolder.value.get_Transport_tagID();
                    if (n3 == 36) {
                        TLS_SEC_TRANSHolder tLS_SEC_TRANSHolder = cSIv2TaggedComponentHolder.value.getTLS_SEC_TRANS();
                        s = tLS_SEC_TRANSHolder.value.target_supports;
                        s2 = tLS_SEC_TRANSHolder.value.target_requires;
                        string8 = cSIv2TaggedComponentHolder.value.get_Transport_Address().value.host_name;
                        n2 = cSIv2TaggedComponentHolder.value.get_Transport_Address().value.port;
                        bl6 = true;
                        if ((s2 & 0x20) == 0 && (s & 0x20) != 0) {
                            s2 = (short)(s2 | 0x20);
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            string4 = "CSIv2TransportFound is " + bl6 + ", sslTargetSupports is " + s + ", sslTargetRequires is " + s2 + ", sslport  is          " + n2 + ", hostname is          " + string8 + ";";
                            SecurityLogger.debugMessage(string3, string4);
                        }
                        break block32;
                    } else {
                        string4 = "Unrecognized transport tag ID: " + n3 + ". Connection refused.";
                        SecurityLogger.debugMessage(string3, string4);
                        if (SecurityLogger.debugEntryEnabled) {
                            SecurityLogger.debugExit(string3);
                        }
                        return false;
                    }
                }
                string4 = "Cannot form CSIv2EffectivePerformPolicy. Connection refused.";
                SecurityLogger.traceMessage(string3, string4);
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string3);
                }
                return false;
            }
            if (string6 != null && !string6.equals("")) {
                this.vault.getCurrent().setTargetSecurityRealm(string6);
            }
            bl5 = string2 == null || string2.length() == 0 ? this.getConnectionKeyForLocateRequest(profile, connectionDataCarrier, string, bl3, bl4, n2, s, s2, string2, bl6, cSIv2EffectivePerformPolicy) : (profile.getPort() != 0 && ORB.isSpecialMethod((String)string2) && cSIv2EffectivePerformPolicy != null && !cSIv2EffectivePerformPolicy.claimClientAuthenticationRequired() || profile.getPort() != 0 && SecurityConnectionInterceptor.isSpecialNamingMethod(string2, string) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(string2, string) ? this.getConnectionKeyForSpecialRequest(profile, connectionDataCarrier, string, bl3, bl4, n2, s, s2, string2, bl6, cSIv2EffectivePerformPolicy) : this.getConnectionKeyForMethodRequest(profile, connectionDataCarrier, string, bl3, bl4, n2, s, s2, s3, string2, string5, string7, bl6, cSIv2EffectivePerformPolicy));
        }
        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
            FFDCFilter.processException((Throwable)((java.lang.Object)cSIv2RequirementsNotSatisfied), "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getConnectionKey", "1245", this);
            string4 = "CSIv2RequirementsNotSatisfied Exception caught in getConnectionKey.";
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.debugMessage(string3, string4);
                SecurityLogger.logException(string3, (Exception)((java.lang.Object)cSIv2RequirementsNotSatisfied), 0, 0);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string3);
            }
            throw new INITIALIZE(cSIv2RequirementsNotSatisfied.debugMessage, 1229066442, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getConnectionKey", "1260", this);
            string4 = "Java runtime exception in getConnectionKey.";
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.debugMessage(string3, string4);
                SecurityLogger.logException(string3, exception, 0, 0);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string3);
            }
            if (exception.getMessage() != null && !exception.getMessage().equals("")) {
                throw new INTERNAL(string4, 1229066417, CompletionStatus.COMPLETED_NO);
            }
            throw new INTERNAL(exception.getMessage(), 1229066417, CompletionStatus.COMPLETED_NO);
        }
        if (bl5) {
            object = connectionDataCarrier.getConnectionData();
            if (object != null && cSIv2EffectivePerformPolicy != null) {
                cSIv2EffectivePerformPolicy.setConnectionKey(object.getConnectionKey());
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string3);
            }
            return true;
        }
        string4 = "Cannot form valid connection key. Connection refused.";
        SecurityLogger.traceMessage(string3, string4);
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string3);
        }
        return false;
    }

    public boolean getConnectionKeyForLocateRequest(Profile profile, ConnectionDataCarrier connectionDataCarrier, String string, boolean bl, boolean bl2, int n, short s, short s2, String string2, boolean bl3, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        String string3 = "SecurityConnectionInterceptor.getConnectionKeyForLocateRequest";
        String string4 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string3);
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n2 = 0;
        int n3 = 0;
        short s3 = 0;
        if (SecurityLogger.debugTraceEnabled) {
            if (string != null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Forming connection key for locate request on " + string;
                    SecurityLogger.debugMessage(string3, string4);
                }
            } else {
                string4 = "Forming connection key for locate request. No class_name available.";
                SecurityLogger.debugMessage(string3, string4);
            }
        }
        if ((bl || bl2 || bl3) && (cSIv2EffectivePerformPolicy == null || cSIv2EffectivePerformPolicy.performSSLTLS())) {
            string5 = SecurityConnectionInterceptor.getHostfromProfile(profile);
            n2 = n & 0xFFFF;
            n3 = 1;
            s3 = bl3 && cSIv2EffectivePerformPolicy != null ? this.formCSIv2CoalescedQOP(s, s2, cSIv2EffectivePerformPolicy) : this.formCoalescedQOP(s, s2);
            string6 = VaultConstants.SSL_MECH_TYPE;
            string7 = this.formConnectionKey(string5, n2, string6, s3);
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Setting SSL ExtendedSSLConnectionData object.";
                SecurityLogger.debugMessage(string3, string4);
            }
            connectionDataCarrier.setConnectionData(new ExtendedSSLConnectionData(string7, n3, s3, 0, cSIv2EffectivePerformPolicy));
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "SSL key set, mechanism is " + string6;
                SecurityLogger.debugMessage(string3, string4);
            }
        } else {
            string7 = this.createSimpleKey(SecurityConnectionInterceptor.getHostfromProfile(profile), profile.getPort(), string);
            n3 = 2;
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Setting TCPIP ConnectionDataImpl object.";
                SecurityLogger.debugMessage(string3, string4);
            }
            connectionDataCarrier.setConnectionData(new ExtendedSSLConnectionData(string7, n3, 0, 0, cSIv2EffectivePerformPolicy));
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "TCP Connection, connection type is " + n3;
                SecurityLogger.debugMessage(string3, string4);
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            if (string != null) {
                string4 = "Returning connection key - " + string7 + " for locate request on " + string;
                SecurityLogger.debugMessage(string3, string4);
            } else {
                string4 = "Returning connection key - " + string7 + " for locate request.";
                SecurityLogger.debugMessage(string3, string4);
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string3);
        }
        return true;
    }

    public boolean getConnectionKeyForMethodRequest(Profile profile, ConnectionDataCarrier connectionDataCarrier, String string, boolean bl, boolean bl2, int n, short s, short s2, short s3, String string2, String string3, String string4, boolean bl3, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        String string5 = "SecurityConnectionInterceptor.getConnectionKeyForMethodRequest";
        String string6 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string5);
        }
        String string7 = null;
        java.lang.Object var18_18 = null;
        String string8 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (SecurityLogger.debugTraceEnabled) {
            if (string != null) {
                string6 = "Forming connection key for method - " + string2 + " on " + string;
                SecurityLogger.debugMessage(string5, string6);
            } else {
                string6 = "Forming connection key for method - " + string2 + ". No class_name available.";
                SecurityLogger.debugMessage(string5, string6);
            }
        }
        string8 = SecurityConnectionInterceptor.getHostfromProfile(profile) + ":" + profile.getPort();
        string7 = this.establishConnectionInfo(profile, connectionDataCarrier, bl, bl2, n, s, s2, s3, string8, bl3, cSIv2EffectivePerformPolicy, string);
        if (SecurityLogger.debugTraceEnabled) {
            string6 = string != null ? "Returning connection key - " + string7 + " for " + string2 + " request on " + string : "Returning connection key - " + string7 + " for " + string2 + " request.";
            SecurityLogger.debugMessage(string5, string6);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string5);
        }
        return string7 != null;
    }

    public boolean getConnectionKeyForSpecialRequest(Profile profile, ConnectionDataCarrier connectionDataCarrier, String string, boolean bl, boolean bl2, int n, short s, short s2, String string2, boolean bl3, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        String string3 = "SecurityConnectionInterceptor.getConnectionKeyForSpecialRequest";
        String string4 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string3);
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n2 = 0;
        int n3 = 0;
        short s3 = 0;
        if (SecurityLogger.debugTraceEnabled) {
            if (string != null) {
                string4 = "Forming connection key for " + string2 + " request on " + string;
                SecurityLogger.debugMessage(string3, string4);
            } else {
                string4 = "Forming connection key for " + string2 + " request. No class_name available.";
                SecurityLogger.debugMessage(string3, string4);
            }
        }
        if (profile.getPort() == 0 && SecurityConnectionInterceptor.isSpecialNamingMethod(string2, string) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(string2, string) && (cSIv2EffectivePerformPolicy == null || cSIv2EffectivePerformPolicy.performSSLTLS())) {
            string5 = SecurityConnectionInterceptor.getHostfromProfile(profile);
            n2 = n & 0xFFFF;
            n3 = 1;
            s3 = bl3 && cSIv2EffectivePerformPolicy != null ? this.formCSIv2CoalescedQOP(s, s2, cSIv2EffectivePerformPolicy) : this.formCoalescedQOP(s, s2);
            string6 = VaultConstants.SSL_MECH_TYPE;
            string7 = this.formConnectionKey(string5, n2, string6, s3);
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Setting SSL ExtendedSSLConnectionData object for special naming method for CSIv2.";
                SecurityLogger.debugMessage(string3, string4);
            }
            connectionDataCarrier.setConnectionData(new ExtendedSSLConnectionData(string7, n3, s3, 0, cSIv2EffectivePerformPolicy));
        }
        if (string7 == null) {
            if (!(!bl && !bl2 && !bl3 || SecurityConnectionInterceptor.isSpecialNamingMethod(string2, string) && profile.getPort() != 0 || cSIv2EffectivePerformPolicy != null && !cSIv2EffectivePerformPolicy.performSSLTLS())) {
                string5 = SecurityConnectionInterceptor.getHostfromProfile(profile);
                n2 = n & 0xFFFF;
                n3 = 1;
                s3 = bl3 && cSIv2EffectivePerformPolicy != null ? this.formCSIv2CoalescedQOP(s, s2, cSIv2EffectivePerformPolicy) : this.formCoalescedQOP(s, s2);
                string6 = VaultConstants.SSL_MECH_TYPE;
                string7 = this.formConnectionKey(string5, n2, string6, s3);
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Setting SSL ExtendedSSLConnectionData object.";
                    SecurityLogger.debugMessage(string3, string4);
                }
                connectionDataCarrier.setConnectionData(new ExtendedSSLConnectionData(string7, n3, s3, 0, cSIv2EffectivePerformPolicy));
            } else {
                string7 = this.createSimpleKey(SecurityConnectionInterceptor.getHostfromProfile(profile), profile.getPort(), string);
                n3 = 2;
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Setting TCPIP ConnectionDataImpl object.";
                    SecurityLogger.debugMessage(string3, string4);
                }
                connectionDataCarrier.setConnectionData(new ExtendedSSLConnectionData(string7, n3, 0, 0, cSIv2EffectivePerformPolicy));
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string4 = string != null ? "Returning connection key - " + string7 + " for " + string2 + " on " + string : "Returning connection key - " + string7 + " for " + string2;
            SecurityLogger.debugMessage(string3, string4);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string3);
        }
        return true;
    }

    public SSLServerConnectionData getCSIRegisteredSSLServerConnectionDataObject() {
        return this.csiServerSSLConnData;
    }

    public SSLServerConnectionData getCSIClientCertRegisteredSSLServerConnectionDataObject() {
        return this.csiClientCertServerSSLConnData;
    }

    public ServerConnectionData getRegisteredTCPServerConnectionDataObject() {
        return this.serverTCPConnData;
    }

    public ServerConnectionData[] getServerConnectionData(ORB oRB) {
        String string = "SecurityConnectionInterceptor.getServerConnectionData";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (ConfigURLProperties.isSecurityEnabled()) {
            String string3 = null;
            List list = null;
            List list2 = null;
            try {
                string3 = oRB.getLocalHost();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getServerConnectionData", "1670", this);
                string3 = null;
                string2 = "security.JSAS0445E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
            }
            if (string3 == null || string3.length() == 0) {
                string3 = "localHost";
            }
            String string4 = oRB.getProperty("com.ibm.CORBA.TransportMode");
            boolean bl = true;
            if (string4 != null && !string4.equalsIgnoreCase("Pluggable")) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "*** IN CHANNEL FRAMEWORK MODE ACTING AS PLUGGABLE ***";
                    SecurityLogger.debugMessage(string, string2);
                }
            } else if (SecurityLogger.debugTraceEnabled) {
                string2 = "In pluggable transport mode.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (bl) {
                int n = 0;
                try {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Getting TCPIP ConnectionObject.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    this.getTcpConnectionObject(string3);
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Getting CSIv2 SSL (w/ and w/o ClientCert) ConnectionObjects for z/OS.";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        this.getCSISSLConnectionObject(string3);
                        if (this.secConfig.getCSIv2ClaimTransportAssocSSLTLSRequired()) {
                            ((ServerConnectionDataImpl)this.serverTCPConnData).setAddToServerProfile(false);
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "The TCP/IP port in the IOR profile will be 0.  The value of AddToServerProfile is " + this.serverTCPConnData.getAddToServerProfile();
                                SecurityLogger.debugMessage(string, string2);
                            }
                        }
                    } else if (this.secConfig.getCSIv2ClaimTransportAssocSSLTLSRequired()) {
                        if (this.secConfig.getCSIv2ClaimTLClientAuthenticationRequired()) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Getting CSIv2 SSL (w/ClientCert) ConnectionObject.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this.getCSIClientCertSSLConnectionObject(string3);
                        } else if (this.secConfig.getCSIv2ClaimTLClientAuthenticationSupported()) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Getting CSIv2 SSL (w/ and w/o ClientCert) ConnectionObjects.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this.getCSISSLConnectionObject(string3);
                            this.getCSIClientCertSSLConnectionObject(string3);
                        } else {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Getting CSIv2 SSL (w/o ClientCert) ConnectionObjects.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this.getCSISSLConnectionObject(string3);
                        }
                        ((ServerConnectionDataImpl)this.serverTCPConnData).setAddToServerProfile(false);
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "The TCP/IP port in the IOR profile will be 0.  The value of AddToServerProfile is " + this.serverTCPConnData.getAddToServerProfile();
                            SecurityLogger.debugMessage(string, string2);
                        }
                    } else if (this.secConfig.getCSIv2ClaimTransportAssocSSLTLSSupported()) {
                        if (this.secConfig.getCSIv2ClaimTLClientAuthenticationRequired()) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Getting CSIv2 SSL (w/ClientCert) ConnectionObject.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this.getCSIClientCertSSLConnectionObject(string3);
                        } else if (this.secConfig.getCSIv2ClaimTLClientAuthenticationSupported()) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Getting CSIv2 SSL (w/ and w/o ClientCert) ConnectionObjects.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this.getCSISSLConnectionObject(string3);
                            this.getCSIClientCertSSLConnectionObject(string3);
                        } else {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Getting CSIv2 SSL (w/o ClientCert) ConnectionObjects.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this.getCSISSLConnectionObject(string3);
                        }
                    }
                    if (this.serverTCPConnData != null) {
                        ++n;
                    }
                    if (this.csiServerSSLConnData != null) {
                        ++n;
                    }
                    if (this.csiClientCertServerSSLConnData != null) {
                        ++n;
                    }
                    ServerConnectionData[] serverConnectionDataArray = new ServerConnectionData[n];
                    int n2 = n;
                    if (this.serverTCPConnData != null) {
                        serverConnectionDataArray[n2 - n--] = this.serverTCPConnData;
                    }
                    if (this.csiServerSSLConnData != null) {
                        serverConnectionDataArray[n2 - n--] = this.csiServerSSLConnData;
                    }
                    if (this.csiClientCertServerSSLConnData != null) {
                        serverConnectionDataArray[n2 - n--] = this.csiClientCertServerSSLConnData;
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    return serverConnectionDataArray;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getServerConnectionData", "1881", this);
                    string2 = "Exception getting SSL server connection data array from pluggable transport configuration.  Exception is: " + exception.getMessage();
                    SecurityLogger.debugMessage(string, string2);
                    SecurityLogger.logException(string, exception, 0, 0);
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    return null;
                }
            }
            try {
                int n;
                String string5;
                Properties properties;
                int n3;
                ArrayList<java.lang.Object> arrayList = new ArrayList<java.lang.Object>();
                if (list2 != null && list2.size() > 0) {
                    for (n3 = 0; n3 < list2.size(); ++n3) {
                        java.lang.Object object;
                        properties = (Properties)list2.get(n3);
                        string5 = properties.getProperty("com.ibm.CORBA.ListenerPort");
                        n = 0;
                        if (string5 != null) {
                            n = new Short(string5).intValue();
                        }
                        if (n == oRB.getBootstrapPort()) continue;
                        if (SecurityLogger.debugTraceEnabled) {
                            object = properties.getProperty("ChainName");
                            String string6 = properties.getProperty("EndPointName");
                            string2 = "Creating TCP server connection data for chain name: " + (String)object + ", and endPointName: " + string6;
                            SecurityLogger.debugMessage(string, string2);
                        }
                        object = new ServerConnectionDataImpl();
                        object.setServerPort(n);
                        object.setConnectionKey(this.formConnectionKey(string3, n, " ", (short)0));
                        object.setConnectionType(2L);
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Requesting to create a TCPIP server connection with:";
                            SecurityLogger.debugMessage(string, string2);
                            string2 = "  Connection key: " + object.getConnectionKey() + ", Connection type: " + object.getConnectionType() + ", Server port: " + object.getServerPort();
                            SecurityLogger.debugMessage(string, string2);
                        }
                        arrayList.add(object);
                    }
                }
                if (list != null && list.size() > 0) {
                    for (n3 = 0; n3 < list.size(); ++n3) {
                        properties = (Properties)list.get(n3);
                        string5 = properties.getProperty("com.ibm.CSI.SSLPort");
                        n = 0;
                        if (string5 != null) {
                            n = new Short(string5).shortValue();
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            String string7 = properties.getProperty("ChainName");
                            String string8 = properties.getProperty("EndPointName");
                            string2 = "Creating SSL server connection data for chain name: " + string7 + ", and endPointName: " + string8;
                            SecurityLogger.debugMessage(string, string2);
                        }
                        short s = 0;
                        short s2 = 0;
                        String string9 = properties.getProperty("com.ibm.ssl.securityLevel");
                        if (string9 != null && string9.equalsIgnoreCase("high")) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Claim security level is HIGH for this transport tag.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            s = (short)(s | 2);
                            s2 = (short)(s2 | 2);
                            s = (short)(s | 4);
                            s2 = (short)(s2 | 4);
                            s2 = (short)(s2 | 0x20);
                        } else if (string9 != null && string9.equalsIgnoreCase("medium")) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Claim security level is MEDIUM for this transport tag.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            s = (short)(s | 2);
                            s2 = (short)(s2 | 2);
                            s2 = (short)(s2 | 4);
                            s2 = (short)(s2 | 0x20);
                        } else {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Claim security level is LOW for this transport tag.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            s2 = (short)(s2 | 2);
                            s2 = (short)(s2 | 4);
                            s2 = (short)(s2 | 0x20);
                        }
                        String string10 = properties.getProperty("com.ibm.ssl.clientAuthentication");
                        String string11 = properties.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                        if (string10 != null && string10.equals("true")) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Claim client authentication is required for this transport tag.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            s = (short)(s | 0x40);
                            s2 = (short)(s2 | 0x40);
                        } else if (string11 != null && string11.equals("true")) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Claim client authentication is supported for this transport tag.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            s2 = (short)(s2 | 0x40);
                        } else if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Claim client authentication is disabled for this transport tag.";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        SSLServerConnectionDataImpl sSLServerConnectionDataImpl = new SSLServerConnectionDataImpl();
                        sSLServerConnectionDataImpl.setConnectionKey(this.formConnectionKey(string3, n, VaultConstants.SSL_MECH_TYPE, s2));
                        sSLServerConnectionDataImpl.setConnectionType(1L);
                        sSLServerConnectionDataImpl.setServerPort(n);
                        sSLServerConnectionDataImpl.setTargetRequiresQOP(s);
                        sSLServerConnectionDataImpl.setTargetSupportsQOP(s2);
                        String string12 = properties.getProperty("com.ibm.ssl.alias");
                        sSLServerConnectionDataImpl.setSSLConfigAlias(string12);
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Requesting to create an SSL server connection with:";
                            SecurityLogger.debugMessage(string, string2);
                            string2 = "  Alias: " + string12;
                            SecurityLogger.debugMessage(string, string2);
                        }
                        arrayList.add(sSLServerConnectionDataImpl);
                    }
                }
                ServerConnectionData[] serverConnectionDataArray = arrayList.toArray(new ServerConnectionData[arrayList.size()]);
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string);
                }
                return serverConnectionDataArray;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getServerConnectionData", "2087", this);
                string2 = "Exception getting SSL server connection data array from channel framework configuration.  Exception is: " + exception.getMessage();
                SecurityLogger.debugMessage(string, string2);
                SecurityLogger.logException(string, exception, 0, 0);
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string);
                }
                return null;
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
        return this.defaultConnInt.getServerConnectionData(oRB);
    }

    public void notifyBrokenConnection(ConnectionInformation connectionInformation) {
        String string = "SecurityConnectionInterceptor.notifyBrokenConnection";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        ConnectionData connectionData = (ConnectionData)connectionInformation.getConnectionData();
        if (this.vault != null && this.secConfig.NotifyBrokenConnectionEnabled()) {
            if (connectionData != null && connectionData instanceof ExtendedSSLConnectionData) {
                String string3 = connectionData.getConnectionKey();
                if (SecurityLogger.debugTraceEnabled && string3 != null) {
                    string2 = "A client connection is broken:  " + string3;
                    SecurityLogger.debugMessage(string, string2);
                }
                this.vault.deleteSessionsForConnection(string3);
            } else {
                String string4 = connectionInformation.getRemoteHost();
                int n = connectionInformation.getRemotePort();
                long l = connectionInformation.getConnectionCreationTime();
                ServerConnectionKey serverConnectionKey = new ServerConnectionKey(l, string4, n);
                if (SecurityLogger.debugTraceEnabled && serverConnectionKey != null) {
                    string2 = "A server connection is broken: " + serverConnectionKey.get_server_connection_hash();
                    SecurityLogger.debugMessage(string, string2);
                }
                this.vault.deleteSessionsForConnection(serverConnectionKey);
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public static boolean isSpecial(String string, String string2) {
        String string3 = "SecurityConnectionInterceptor.isSpecial";
        String string4 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string3);
        }
        if (string2 != null) {
            string4 = "method  = " + string + ", class name = " + string2;
            SecurityLogger.debugMessage(string3, string4);
            if (string.equals("get_compatibility_level")) {
                string4 = "method matches";
                SecurityLogger.debugMessage(string3, string4);
            } else {
                string4 = "method no matches";
                SecurityLogger.debugMessage(string3, string4);
            }
            if (string2.equals("com.ibm.WsnOptimizedNaming._NamingContextStub")) {
                string4 = "interface matches";
                SecurityLogger.debugMessage(string3, string4);
            } else {
                string4 = "interface no matches";
                SecurityLogger.debugMessage(string3, string4);
            }
            return string.equals("get_compatibility_level") && string2.equals("com.ibm.WsnOptimizedNaming._NamingContextStub");
        }
        return false;
    }

    public static boolean isSpecialClass(String string, String string2) {
        String string3 = "SecurityConnectionInterceptor.isSpecialClass";
        java.lang.Object var3_3 = null;
        if (string2 != null) {
            if (string.equals("get_compatibility_level") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("get_compatibility_level") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("get_context_id_string") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("get_context_id_string") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("get_full_primary_name") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("get_full_primary_name") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("list") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("list") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("list_complete_info") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("list_complete_info") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("resolve") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("resolve") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("resolve_complete_info") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("resolve_complete_info") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("BindingIterator_next_one") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("BindingIterator_next_one") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("BindingIterator_next_one") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("BindingIterator_next_one") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (string.equals("BindingIterator_Destroy") && string2.equals("com.ibm.WsnBootstrap,_WsnNameServiceStub")) {
                return true;
            }
            return string.equals("BindingIterator_Destroy") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl");
        }
        return false;
    }

    public static boolean isSpecialNamingMethod(String string, String string2) {
        String string3 = "SecurityConnectionInterceptor.isSpecialNamingMethod";
        String string4 = null;
        if (string2 != null) {
            string4 = "method = " + string + ", class_name = " + string2;
            SecurityLogger.debugMessage(string3, string4);
            if (string.equals("getProperties") && string2.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (string.equals("getProperties") && string2.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            return string.equals("get") && string2.equals("com.ibm.rmi.corba.CORBAObjectImpl");
        }
        return false;
    }

    public static boolean isSpecialSSLRequiredNamingMethod(String string, String string2) {
        String string3 = "SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod";
        java.lang.Object var3_3 = null;
        if (string2 != null) {
            if (string2.equals("com.ibm.ws.security.server._SecurityServer_Stub")) {
                return true;
            }
            if (string2.equals("com.ibm.websphere.security._UserRegistry_Stub") && !string.equals("createCredential")) {
                return true;
            }
            if (string2.equals("com.ibm.ws.security.server._SecurityServerImpl_Tie")) {
                return true;
            }
            return string2.equals("com.ibm.ws.security.registry._UserRegistryImpl_Tie");
        }
        return false;
    }

    public String createSimpleKey(String string, int n, String string2) {
        String string3 = "SecurityConnectionInterceptor.createSimpleKey";
        String string4 = null;
        String string5 = string + ":" + n;
        if (string2 != null && (string2.equals("com.ibm.ws.orb.transport.DummyObjectImpl") || string2.equals("<unknown>"))) {
            this.vault.getCurrent().setFirstHost(string);
            this.vault.getCurrent().setFirstPort(Integer.toString(n));
            String string6 = this.vault.getCurrent().getAllHosts();
            if (string6.indexOf(string5) == -1) {
                this.vault.getCurrent().setAllHosts(string5 + "|" + string6);
                this.vault.getCurrent().setAllPorts(Integer.toString(n) + "|" + this.vault.getCurrent().getAllPorts());
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "New value of getFirstHost/Port():  " + this.vault.getCurrent().getFirstHost() + ":" + this.vault.getCurrent().getFirstPort();
                SecurityLogger.debugMessage(string3, string4);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "New value of getAllHosts():  " + this.vault.getCurrent().getAllHosts();
                SecurityLogger.debugMessage(string3, string4);
            }
        }
        return string5;
    }

    public VaultImpl getVault() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        return this.vault;
    }

    public SecurityConfiguration getSecurityConfig() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        if (this.secConfig == null) {
            SecurityConnectionInterceptor securityConnectionInterceptor = this;
            this.secConfig = securityConnectionInterceptor.vault.getSecurityConfiguration();
        }
        return this.secConfig;
    }

    public boolean getTcpConnectionObject(String string) {
        String string2 = "SecurityConnectionInterceptor.getTcpConnectionObject";
        String string3 = null;
        ServerConnectionDataImpl serverConnectionDataImpl = new ServerConnectionDataImpl();
        serverConnectionDataImpl.setServerPort(this.orb.getListenerPort());
        serverConnectionDataImpl.setConnectionKey(this.formConnectionKey(string, this.orb.getListenerPort(), " ", (short)0));
        serverConnectionDataImpl.setConnectionType(2L);
        this.serverTCPConnData = serverConnectionDataImpl;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Requesting to create a TCPIP server connection with:";
            SecurityLogger.debugMessage(string2, string3);
            string3 = "  Connection key: " + serverConnectionDataImpl.getConnectionKey() + ", Connection type: " + serverConnectionDataImpl.getConnectionType() + ", Server port: " + serverConnectionDataImpl.getServerPort();
            SecurityLogger.debugMessage(string2, string3);
        }
        return true;
    }

    public boolean getCSISSLConnectionObject(String string) {
        String string2 = "SecurityConnectionInterceptor.getCSISSLConnectionObject";
        String string3 = null;
        SecurityConfiguration securityConfiguration = this.getSecurityConfig();
        SSLServerConnectionDataImpl sSLServerConnectionDataImpl = new SSLServerConnectionDataImpl();
        short s = 0;
        s = (short)(s | 0x20);
        if (this.getSecurityConfig().getCSIv2ClaimMessageIntegrityRequired()) {
            s = (short)(s | 2);
        }
        if (this.getSecurityConfig().getCSIv2ClaimMessageConfidentialityRequired()) {
            s = (short)(s | 4);
        }
        short s2 = 0;
        s2 = (short)(s2 | 0x20);
        if (this.getSecurityConfig().getCSIv2ClaimMessageIntegritySupported()) {
            s2 = (short)(s2 | 2);
        }
        if (this.getSecurityConfig().getCSIv2ClaimMessageConfidentialitySupported()) {
            s2 = (short)(s2 | 4);
        }
        sSLServerConnectionDataImpl.setConnectionKey(this.formConnectionKey(string, this.getSecurityConfig().getCSISSLPort(), VaultConstants.SSL_MECH_TYPE, s2));
        sSLServerConnectionDataImpl.setConnectionType(1L);
        sSLServerConnectionDataImpl.setServerPort(this.getSecurityConfig().getCSISSLPort());
        sSLServerConnectionDataImpl.setTargetRequiresQOP(s);
        sSLServerConnectionDataImpl.setTargetSupportsQOP(s2);
        sSLServerConnectionDataImpl.setSSLConfigAlias(this.getSecurityConfig().getCSIInboundSSLConfigAlias());
        sSLServerConnectionDataImpl.setEndPointName("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
        this.csiServerSSLConnData = sSLServerConnectionDataImpl;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Requesting to create an SSL server connection with:";
            SecurityLogger.debugMessage(string2, string3);
            string3 = "  Alias: " + sSLServerConnectionDataImpl.getSSLConfigAlias();
            SecurityLogger.debugMessage(string2, string3);
        }
        return true;
    }

    public boolean getCSIClientCertSSLConnectionObject(String string) {
        String string2 = "SecurityConnectionInterceptor.getCSIClientCertSSLConnectionObject";
        String string3 = null;
        SecurityConfiguration securityConfiguration = this.getSecurityConfig();
        SSLServerConnectionDataImpl sSLServerConnectionDataImpl = new SSLServerConnectionDataImpl();
        short s = 0;
        s = (short)(s | 0x20);
        s = (short)(s | 0x40);
        if (this.getSecurityConfig().getCSIv2ClaimMessageIntegrityRequired()) {
            s = (short)(s | 2);
        }
        if (this.getSecurityConfig().getCSIv2ClaimMessageConfidentialityRequired()) {
            s = (short)(s | 4);
        }
        short s2 = 0;
        s2 = (short)(s2 | 0x20);
        s2 = (short)(s2 | 0x40);
        if (this.getSecurityConfig().getCSIv2ClaimMessageIntegritySupported()) {
            s2 = (short)(s2 | 2);
        }
        if (this.getSecurityConfig().getCSIv2ClaimMessageConfidentialitySupported()) {
            s2 = (short)(s2 | 4);
        }
        sSLServerConnectionDataImpl.setConnectionKey(this.formConnectionKey(string, this.getSecurityConfig().getCSIClientCertSSLPort(), VaultConstants.SSL_MECH_TYPE, s2));
        sSLServerConnectionDataImpl.setConnectionType(1L);
        sSLServerConnectionDataImpl.setServerPort(this.getSecurityConfig().getCSIClientCertSSLPort());
        sSLServerConnectionDataImpl.setTargetRequiresQOP(s);
        sSLServerConnectionDataImpl.setTargetSupportsQOP(s2);
        sSLServerConnectionDataImpl.setSSLConfigAlias(this.getSecurityConfig().getCSIInboundSSLConfigAlias());
        sSLServerConnectionDataImpl.setEndPointName("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
        this.csiClientCertServerSSLConnData = sSLServerConnectionDataImpl;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Requesting to create an SSL server connection including EstablishTrustInClient with:";
            SecurityLogger.debugMessage(string2, string3);
            string3 = "  Alias: " + sSLServerConnectionDataImpl.getSSLConfigAlias();
            SecurityLogger.debugMessage(string2, string3);
        }
        return true;
    }

    public String establishConnectionInfo(Profile profile, ConnectionDataCarrier connectionDataCarrier, boolean bl, boolean bl2, int n, short s, short s2, short s3, String string, boolean bl3, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, String string2) {
        String string3 = "SecurityConnectionInterceptor.establishConnectionInfo";
        String string4 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string3);
        }
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        int n3 = 0;
        short s4 = 0;
        boolean bl4 = false;
        if (bl || bl2 || bl3) {
            if (!this.secConfig.getCSIv2PerformTransportAssocSSLTLSSupported() && !this.secConfig.getCSIv2PerformTransportAssocSSLTLSRequired() && profile.getPort() == 0) {
                throw new NO_PERMISSION("SSL is not supported or required in client configuration, however, no TCP/IP port specified in IOR profile.");
            }
            if ((bl || bl2 || bl3) && (cSIv2EffectivePerformPolicy == null || cSIv2EffectivePerformPolicy.performSSLTLS())) {
                bl4 = true;
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string4 = ", Creating SSL connectionKey: " + bl4 + ", sslCmpdTagFound is " + bl2 + ", sslTagFound is " + bl + ";" + ", CSIv2TransportFound is " + bl3 + ";";
            SecurityLogger.debugMessage(string3, string4);
        }
        if (bl4) {
            n2 = n & 0xFFFF;
            n3 = 1;
            s4 = bl3 && cSIv2EffectivePerformPolicy != null ? this.formCSIv2CoalescedQOP(s, s2, cSIv2EffectivePerformPolicy) : this.formCoalescedQOP(s, s2);
            string5 = VaultConstants.SSL_MECH_TYPE;
            String string7 = null;
            int n4 = string.lastIndexOf(":");
            string7 = n4 >= 0 ? string.substring(0, n4) : string;
            string6 = this.formConnectionKey(string7, n2, string5, s4);
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Setting SSL ExtendedSSLConnectionData object.";
                SecurityLogger.debugMessage(string3, string4);
            }
            connectionDataCarrier.setConnectionData(new ExtendedSSLConnectionData(string6, n3, s4, 0, cSIv2EffectivePerformPolicy));
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string3);
            }
            return string6;
        }
        string6 = this.createSimpleKey(SecurityConnectionInterceptor.getHostfromProfile(profile), profile.getPort(), string2);
        n3 = 2;
        if (SecurityLogger.debugTraceEnabled) {
            string4 = "Setting TCPIP ConnectionDataImpl object.";
            SecurityLogger.debugMessage(string3, string4);
        }
        connectionDataCarrier.setConnectionData(new ExtendedSSLConnectionData(string6, n3, 0, 0, cSIv2EffectivePerformPolicy));
        if (SecurityLogger.debugTraceEnabled) {
            string4 = "SSL not enabled, returning connection key - " + string6;
            SecurityLogger.debugMessage(string3, string4);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string3);
        }
        return string6;
    }

    public SSLConnectionData getSSLConfigurationParameters(String string, long l, short s, int n) {
        return new ExtendedSSLConnectionData(string, l, s, n, null);
    }

    static String getHostfromProfile(Profile profile) {
        String string = null;
        try {
            string = profile.getHostIPAddress();
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getHostfromProfile", "4329");
            String string2 = "SecurityConnectionInterceptor.getHostfromProfile";
            if (SecurityLogger.traceEnabled) {
                String string3 = null;
                string3 = "Could not resolve host, ignore if HTTP Tunneling is enabled";
                SecurityLogger.traceMessage(string2, string3);
                SecurityLogger.traceException(string2, throwable, 0, 0);
            }
            string = null;
        }
        if (string == null) {
            string = profile.getHost();
        }
        return string;
    }

    private String getClassName(IOR iOR) {
        String string;
        String string2 = "SecurityConnectionInterceptor.getClassName";
        String string3 = null;
        String string4 = "<unknown>";
        if (iOR != null && (string4 = (String)classNames.get(string = iOR.stringify())) == null) {
            Object object;
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Getting class name from IOR.";
                SecurityLogger.debugMessage(string2, string3);
            }
            if (iOR != null && !iOR.isBootstrap() && (object = this.orb.IORToObject(iOR)) != null) {
                string4 = object.getClass().getName();
            }
            if (string4 != null) {
                classNames.put(string, string4);
                if (classNames.size() > 100) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Clearing className hashtable (size > 100).";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    classNames.clear();
                }
            } else {
                string4 = "<unknown>";
            }
        }
        return string4;
    }

    static {
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            prefer_iiop_to_local = JAVAtoCPPUtilities.getNativeBooleanVariable((String)"private_bboc_prefer_iiop_to_local", (boolean)false);
        }
    }
}

