/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.extObjectInputStream;

public class SealedObject
implements Serializable {
    static final long serialVersionUID = 4482838265551344752L;
    private byte[] encryptedContent = null;
    private String sealAlg = null;
    private String paramsAlg = null;
    protected byte[] encodedParams = null;
    private static String[] z;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            objectOutputStream.close();
        }
        try {
            this.encryptedContent = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        if (cipher.getParameters() != null) {
            this.encodedParams = cipher.getParameters().getEncoded();
            this.paramsAlg = cipher.getParameters().getAlgorithm();
        }
        this.sealAlg = cipher.getAlgorithm();
    }

    protected SealedObject(SealedObject sealedObject) {
        this.encryptedContent = (byte[])sealedObject.encryptedContent.clone();
        this.sealAlg = sealedObject.sealAlg;
        this.paramsAlg = sealedObject.paramsAlg;
        this.encodedParams = (byte[])(sealedObject.encodedParams != null ? (byte[])sealedObject.encodedParams.clone() : null);
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            return this.a(key, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(z[0]);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);
        try {
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
        finally {
            extObjectInputStream2.close();
        }
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(z[3]);
        }
        try {
            return this.a(key, string);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object a(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            try {
                algorithmParameters = string != null ? AlgorithmParameters.getInstance(this.paramsAlg, string) : AlgorithmParameters.getInstance(this.paramsAlg);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (string == null) {
                    throw new NoSuchAlgorithmException(this.paramsAlg + z[1]);
                }
                throw new NoSuchProviderException(noSuchProviderException.getMessage());
            }
            algorithmParameters.init(this.encodedParams);
        }
        try {
            cipher = string != null ? Cipher.getInstance(this.sealAlg, string) : Cipher.getInstance(this.sealAlg);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(z[2]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (string == null) {
                throw new NoSuchAlgorithmException(this.sealAlg + z[1]);
            }
            throw new NoSuchProviderException(noSuchProviderException.getMessage());
        }
        try {
            if (algorithmParameters != null) {
                cipher.init(2, key, algorithmParameters);
            } else {
                cipher.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);
        try {
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
        finally {
            extObjectInputStream2.close();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.encryptedContent != null) {
            this.encryptedContent = (byte[])this.encryptedContent.clone();
        }
        if (this.encodedParams != null) {
            this.encodedParams = (byte[])this.encodedParams.clone();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block43: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block42: {
                char[] cArray3;
                Object var0;
                block41: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block40: {
                        char[] cArray5;
                        block39: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block38: {
                                char[] cArray7;
                                block37: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block36: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray9 = "wwpcV\u007fo\u007fa\u0004xtc,Bynyh".toCharArray();
                                        n3 = 0;
                                        int n10 = cArray9.length;
                                        cArray8 = cArray9;
                                        n9 = n10;
                                        if (n10 <= 1) break block36;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block37;
                                    }
                                    do {
                                        char[] cArray10 = cArray8;
                                        char[] cArray11 = cArray8;
                                        int n11 = n3;
                                        while (true) {
                                            int n12;
                                            char c2 = cArray10[n11];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n12 = 22;
                                                    break;
                                                }
                                                case 1: {
                                                    n12 = 27;
                                                    break;
                                                }
                                                case 2: {
                                                    n12 = 23;
                                                    break;
                                                }
                                                case 3: {
                                                    n12 = 12;
                                                    break;
                                                }
                                                default: {
                                                    n12 = 36;
                                                }
                                            }
                                            cArray10[n11] = (char)(c2 ^ n12);
                                            ++n3;
                                            cArray8 = cArray11;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray11 = cArray8;
                                            n8 = n9;
                                            n11 = n9;
                                            cArray10 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[0] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray12 = "6uxx\u0004ptbb@".toCharArray();
                                n3 = 0;
                                int n13 = cArray12.length;
                                cArray6 = cArray12;
                                n7 = n13;
                                if (n13 <= 1) break block38;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block39;
                            }
                            do {
                                char[] cArray13 = cArray6;
                                char[] cArray14 = cArray6;
                                int n14 = n3;
                                while (true) {
                                    int n15;
                                    char c3 = cArray13[n14];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n15 = 22;
                                            break;
                                        }
                                        case 1: {
                                            n15 = 27;
                                            break;
                                        }
                                        case 2: {
                                            n15 = 23;
                                            break;
                                        }
                                        case 3: {
                                            n15 = 12;
                                            break;
                                        }
                                        default: {
                                            n15 = 36;
                                        }
                                    }
                                    cArray13[n14] = (char)(c3 ^ n15);
                                    ++n3;
                                    cArray6 = cArray14;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray14 = cArray6;
                                    n6 = n7;
                                    n14 = n7;
                                    cArray13 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[1] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray15 = "FzshMx|7xLwo7{Ee;b\u007fAr;~b\u0004e~v`Mx|7cTsivxMyu7bKb;vzE\u007fwvnHs".toCharArray();
                        n3 = 0;
                        int n16 = cArray15.length;
                        cArray4 = cArray15;
                        n5 = n16;
                        if (n16 <= 1) break block40;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block41;
                    }
                    do {
                        char[] cArray16 = cArray4;
                        char[] cArray17 = cArray4;
                        int n17 = n3;
                        while (true) {
                            int n18;
                            char c4 = cArray16[n17];
                            switch (n3 % 5) {
                                case 0: {
                                    n18 = 22;
                                    break;
                                }
                                case 1: {
                                    n18 = 27;
                                    break;
                                }
                                case 2: {
                                    n18 = 23;
                                    break;
                                }
                                case 3: {
                                    n18 = 12;
                                    break;
                                }
                                default: {
                                    n18 = 36;
                                }
                            }
                            cArray16[n17] = (char)(c4 ^ n18);
                            ++n3;
                            cArray4 = cArray17;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray17 = cArray4;
                            n4 = n5;
                            n17 = n5;
                            cArray16 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[2] = new String(cArray3).intern();
                var0 = null;
                char[] cArray18 = "{rd\u007fMx|7|Vym~hAd".toCharArray();
                n3 = 0;
                int n19 = cArray18.length;
                cArray2 = cArray18;
                n2 = n19;
                if (n19 <= 1) break block42;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block43;
            }
            do {
                char[] cArray19 = cArray2;
                char[] cArray20 = cArray2;
                int n20 = n3;
                while (true) {
                    int n21;
                    char c5 = cArray19[n20];
                    switch (n3 % 5) {
                        case 0: {
                            n21 = 22;
                            break;
                        }
                        case 1: {
                            n21 = 27;
                            break;
                        }
                        case 2: {
                            n21 = 23;
                            break;
                        }
                        case 3: {
                            n21 = 12;
                            break;
                        }
                        default: {
                            n21 = 36;
                        }
                    }
                    cArray19[n20] = (char)(c5 ^ n21);
                    ++n3;
                    cArray2 = cArray20;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray20 = cArray2;
                    n = n2;
                    n20 = n2;
                    cArray19 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
    }
}

