/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;

public class JavaStaticField
extends JavaField {
    private String _value;

    public JavaStaticField(JavaRuntime javaRuntime, String string, String string2, int n, String string3, long l) {
        super(javaRuntime, string, string2, n, l);
        if (null == javaRuntime) {
            throw new IllegalArgumentException("A Java static field cannot exist in a null Java VM");
        }
        this._value = string3;
    }

    protected Object getReferenceType(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        String string = this.getSignature();
        if (string.startsWith("L") || string.startsWith("[")) {
            try {
                ImagePointer imagePointer = this.getDeclaringClass().getID().getAddressSpace().getPointer(Long.parseLong(this._value, 16));
                return JavaObject.createJavaObject(this._javaVM, imagePointer);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            catch (DataUnavailable dataUnavailable) {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean getBoolean(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        return this._value.charAt(0) != '0';
    }

    public byte getByte(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        return (byte)this.parse(2);
    }

    public char getChar(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        return (char)this.parse(4);
    }

    public double getDouble(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        long l = this.parse(16);
        return Double.longBitsToDouble(l);
    }

    public float getFloat(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        int n = (int)this.parse(8);
        return Float.intBitsToFloat(n);
    }

    public int getInt(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        return (int)this.parse(8);
    }

    public long getLong(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        return this.parse(16);
    }

    public short getShort(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        return (short)this.parse(4);
    }

    private long parse(int n) throws CorruptDataException {
        if (null == this._value || this._value.length() > n) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("parse error", null));
        }
        if (16 == this._value.length()) {
            String string = this._value.substring(0, 8);
            String string2 = this._value.substring(8, 16);
            long l = Long.parseLong(string, 16);
            long l2 = Long.parseLong(string2, 16);
            return l << 32 | l2;
        }
        return Long.parseLong(this._value, 16);
    }
}

