/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class JavaHeap
implements com.ibm.dtfj.java.JavaHeap {
    private JavaRuntime _javaVM;
    private String _name;
    private int _alignment;
    private int _minimumObjectSize;
    private HeapSection _section;
    private Vector _extents = new Vector();

    public JavaHeap(JavaRuntime javaRuntime, String string, int n, int n2, ImagePointer imagePointer, long l) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for a heap cannot be null");
        }
        this._javaVM = javaRuntime;
        this._name = string;
        this._alignment = n;
        this._minimumObjectSize = n2;
        this._section = new HeapSection(imagePointer, l);
    }

    public Iterator getSections() {
        return Collections.singletonList(this._section).iterator();
    }

    public String getName() {
        return this._name;
    }

    public Iterator getObjects() {
        return new ExtentWalker(this._javaVM, this._extents.iterator(), this._alignment, this._minimumObjectSize);
    }

    public void addExtent(ImagePointer imagePointer, int n, int n2) {
        this._extents.add(new HeapExtent(imagePointer, n, n2));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (null != this._name && object instanceof JavaHeap) {
            JavaHeap javaHeap = (JavaHeap)object;
            boolean bl2 = bl = this._extents.size() == javaHeap._extents.size();
            if (bl) {
                boolean bl3 = bl = this._javaVM.equals(javaHeap._javaVM) && this._name.equals(javaHeap._name);
                if (bl && this._extents.size() > 0) {
                    Iterator iterator = this._extents.iterator();
                    Iterator iterator2 = javaHeap._extents.iterator();
                    while (bl && iterator.hasNext()) {
                        bl = iterator.next().equals(iterator2.next());
                    }
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this._extents.size() > 0 ? this._extents.get(0).hashCode() : 0;
        int n2 = null == this._name ? 0 : this._name.hashCode();
        return this._javaVM.hashCode() ^ n2 ^ n;
    }

    class ExtentWalker
    implements Iterator {
        private JavaRuntime _javaVM;
        private Iterator _extentIterator;
        private HeapExtent _currentExtent;
        private int _objectsRemainingInExtent;
        private long _nextOffsetInExtent;
        private int _alignment;
        private int _minimumObjectSize;

        public ExtentWalker(JavaRuntime javaRuntime, Iterator iterator, int n, int n2) {
            this._javaVM = javaRuntime;
            this._extentIterator = iterator;
            this._alignment = n;
            this._minimumObjectSize = n2;
            this._advanceExtentMarker();
        }

        private void _advanceExtentMarker() {
            if (this._extentIterator.hasNext()) {
                this._currentExtent = (HeapExtent)this._extentIterator.next();
                this._nextOffsetInExtent = 0L;
                this._objectsRemainingInExtent = this._currentExtent.objectsInExtent();
            } else {
                this._currentExtent = null;
            }
        }

        public boolean hasNext() {
            boolean bl = false;
            if (null != this._currentExtent) {
                if (this._objectsRemainingInExtent > 0) {
                    bl = true;
                } else {
                    this._advanceExtentMarker();
                    bl = null != this._currentExtent;
                }
            }
            return bl;
        }

        public Object next() {
            try {
                ImagePointer imagePointer = this._currentExtent.getBaseAddress().add(this._nextOffsetInExtent);
                JavaObject javaObject = JavaObject.createJavaObject(this._javaVM, imagePointer);
                JavaAbstractClass javaAbstractClass = (JavaAbstractClass)javaObject.getJavaClass();
                int n = javaAbstractClass.getInstanceSize(javaObject);
                int n2 = n % this._alignment;
                int n3 = 0 == n2 ? 0 : this._alignment - n2;
                int n4 = Math.max(n + n3, this._minimumObjectSize);
                this._nextOffsetInExtent += (long)n4;
                --this._objectsRemainingInExtent;
                return javaObject;
            }
            catch (CorruptDataException corruptDataException) {
                this._advanceExtentMarker();
                return corruptDataException.getCorruptData();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeapExtent
    extends HeapSection {
        private int _residentObjectCount;

        public HeapExtent(ImagePointer imagePointer, long l, int n) {
            super(imagePointer, l);
            this._residentObjectCount = n;
        }

        public String getName() {
            return "Heap Extent at " + Long.toHexString(this.getBaseAddress().getAddress()) + " (" + this.getSize() + " bytes long)";
        }

        public int objectsInExtent() {
            return this._residentObjectCount;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof HeapExtent) {
                HeapExtent heapExtent = (HeapExtent)object;
                bl = super.equals(heapExtent) && this._residentObjectCount == heapExtent._residentObjectCount;
            }
            return bl;
        }

        public int hashCode() {
            return super.hashCode() ^ this._residentObjectCount;
        }
    }

    class HeapSection
    implements ImageSection {
        private ImagePointer _base;
        private long _size;

        public HeapSection(ImagePointer imagePointer, long l) {
            if (null == imagePointer) {
                throw new IllegalArgumentException("Heap extents cannot have null base pointers");
            }
            this._base = imagePointer;
            this._size = l;
        }

        public ImagePointer getBaseAddress() {
            return this._base;
        }

        public long getSize() {
            return this._size;
        }

        public String getName() {
            return "Contiguous heap extent at 0x" + Long.toHexString(this._base.getAddress()) + " (0x" + Long.toHexString(this._size) + " bytes)";
        }

        public boolean isExecutable() throws DataUnavailable {
            return this._base.isExecutable();
        }

        public boolean isReadOnly() throws DataUnavailable {
            return this._base.isReadOnly();
        }

        public boolean isShared() throws DataUnavailable {
            return this._base.isShared();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof HeapSection) {
                HeapSection heapSection = (HeapSection)object;
                bl = this._base.equals(heapSection._base) && this._size == heapSection._size;
            }
            return bl;
        }

        public int hashCode() {
            return (int)((long)this._base.hashCode() ^ this._size);
        }
    }
}

