/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaClassLoader
implements com.ibm.dtfj.java.JavaClassLoader {
    private JavaRuntime _javaVM;
    private ImagePointer _id;
    private ImagePointer _objectID;
    private Vector _classIDs = new Vector();

    public JavaClassLoader(JavaRuntime javaRuntime, ImagePointer imagePointer, ImagePointer imagePointer2) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for class loader must not be null");
        }
        if (null == imagePointer) {
            throw new IllegalArgumentException("Class loader id must not be null");
        }
        this._javaVM = javaRuntime;
        this._id = imagePointer;
        this._objectID = imagePointer2;
    }

    public Iterator getDefinedClasses() {
        Iterator iterator = this.getCachedClasses();
        long l = this._id.getAddress();
        Vector<JavaClass> vector = new Vector<JavaClass>();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            try {
                if (l != ((JavaClassLoader)javaClass.getClassLoader())._id.getAddress()) continue;
                vector.add(javaClass);
            }
            catch (CorruptDataException corruptDataException) {}
        }
        return vector.iterator();
    }

    public Iterator getCachedClasses() {
        Iterator iterator = this._classIDs.iterator();
        Vector<JavaClass> vector = new Vector<JavaClass>();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            JavaClass javaClass = this._javaVM.getClassForID(l);
            vector.add(javaClass);
        }
        return vector.iterator();
    }

    public JavaClass findClass(String string) throws CorruptDataException {
        Iterator iterator = this.getDefinedClasses();
        JavaClass javaClass = null;
        while (iterator.hasNext() && null == javaClass) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (!javaClass2.getName().equals(string)) continue;
            javaClass = javaClass2;
        }
        return javaClass;
    }

    public com.ibm.dtfj.java.JavaObject getObject() throws CorruptDataException {
        return JavaObject.createJavaObject(this._javaVM, this._objectID);
    }

    public long getID() {
        return this._id.getAddress();
    }

    public void addClassID(long l) {
        this._classIDs.add(new Long(l));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaClassLoader) {
            JavaClassLoader javaClassLoader = (JavaClassLoader)object;
            bl = this._javaVM.equals(javaClassLoader._javaVM) && this._id.equals(javaClassLoader._id);
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._id.hashCode();
    }
}

