/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public abstract class JavaAbstractClass
implements JavaClass {
    protected ImagePointer _classPointer;
    protected JavaRuntime _javaVM;
    private int _modifiers;
    private Vector _interfaceNames = new Vector();
    private long _classLoaderID;

    protected JavaAbstractClass(JavaRuntime javaRuntime, ImagePointer imagePointer, int n, long l) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("Java class pointer must be non-null");
        }
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for a class must not be null");
        }
        this._javaVM = javaRuntime;
        this._classPointer = imagePointer;
        this._modifiers = n;
        this._classLoaderID = l;
    }

    public JavaClassLoader getClassLoader() throws CorruptDataException {
        return this._javaVM.getClassLoaderForID(this._classLoaderID);
    }

    public com.ibm.dtfj.java.JavaObject getObject() throws CorruptDataException {
        return JavaObject.createJavaObject(this._javaVM, this._classPointer);
    }

    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    public ImagePointer getID() {
        return this._classPointer;
    }

    public Iterator getInterfaces() {
        return this._interfaceNames.iterator();
    }

    public void addInterfaceName(String string) {
        this._interfaceNames.add(string);
    }

    public abstract int getInstanceSize(com.ibm.dtfj.java.JavaObject var1);

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaAbstractClass) {
            JavaAbstractClass javaAbstractClass = (JavaAbstractClass)object;
            bl = this.getClass().equals(javaAbstractClass.getClass()) && this._javaVM.equals(javaAbstractClass._javaVM) && this._classPointer.equals(javaAbstractClass._classPointer);
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._classPointer.hashCode();
    }
}

